<?php

###############################################################################
# french_france_utf-8.php
#
# This is a french language version for Geeklog!
# Updated by ::Ben http::geeklog.fr 2010 05 10 
#
# Copyright (C) 2000 Jason Whittenburg
# jwhitten AT securitygeeks DOT com
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
#
###############################################################################

$LANG_CHARSET = 'utf-8';

###############################################################################
# Array Format:
# $LANGXX[YY]:  $LANG - variable name
#               XX    - file id number
#               YY    - phrase id number
###############################################################################

###############################################################################
# USER PHRASES - These are file phrases used in end user scripts
###############################################################################

###############################################################################
# lib-common.php

$LANG01 = array(
    1 => 'Par',
    2 => 'Lire la suite...',
    3 => 'commentaires',
    4 => 'Modifier',
    5 => '',
    6 => '',
    7 => '',
    8 => '',
    9 => 'Fonctions Admin:',
    10 => 'Propositions',
    11 => 'Articles',
    12 => 'Blocks',
    13 => 'Catégories',
    14 => '',
    15 => '',
    16 => '',
    17 => 'Membres',
    18 => 'Requête SQL',
    19 => 'Se déconnecter',
    20 => 'Infos personnelles:',
    21 => 'Nom d\'utilisateur',
    22 => 'ID d\'utilisateur',
    23 => 'Niveau de sécurité',
    24 => 'Anonyme',
    25 => 'Répondre',
    26 => 'Les commentaires permettent à chacun d\'enrichir le web.',
    27 => 'Commentaire le plus récent',
    28 => 'Effacer',
    29 => 'Aucun commentaire.',
    30 => 'Anciens articles',
    31 => 'Balises HTML autorisées :',
    32 => 'Erreur: Nom d\'utilisateur erroné',
    33 => 'Erreur: Impossibilité d\'enregistrer dans le fichier log',
    34 => 'Erreur',
    35 => 'Se déconnecter',
    36 => 'Le',
    37 => 'Aucun article d\'utilisateur',
    38 => 'Syndication',
    39 => 'Rafraîchir',
    40 => '',
    41 => 'Visiteurs',
    42 => 'par',
    43 => 'Répondre',
    44 => 'Parent',
    45 => 'Numéro d\'erreur MySQL',
    46 => 'Message d\'erreur MySQL',
    47 => 'Espace Membre',
    48 => 'Mon compte',
    49 => 'Préférences d\'affichage',
    50 => 'Erreur dans la requête SQL',
    51 => 'aide',
    52 => 'Nouveau',
    53 => 'Centre administratif',
    54 => 'Fichier impossible à ouvrir.',
    55 => 'Erreur à',
    56 => 'Voter',
    57 => 'Mot de passe',
    58 => 'Connexion',
    59 => "Devenir membre<br" . XHTML . "> <a href=\"{$_CONF['site_url']}/users.php?mode=new\">Enregistrez-vous</a>",
    60 => 'Ajouter votre commentaire',
    61 => 'Créer un nouveau compte',
    62 => 'mots supplémentaires',
    63 => 'Commentaires préférés',
    64 => 'Envoyer cet article à un ami',
    65 => 'Version imprimable',
    66 => '',
    67 => 'Bienvenue sur',
    68 => 'Accueil',
    69 => 'Contact',
    70 => 'Chercher',
    71 => 'Contribuer',
    72 => 'Web Resources',
    73 => '',
    74 => '',
    75 => 'Recherche',
    76 => 'Statistiques',
    77 => 'Plugins',
    78 => '',
    79 => 'Quoi de neuf ?',
    80 => 'derniers articles',
    81 => 'dernier article',
    82 => 'heures',
    83 => 'COMMENTAIRES',
    84 => '',
    85 => 'dernières 48 heures',
    86 => 'Aucun',
    87 => '2 dernières semaines',
    88 => '',
    89 => '',
    90 => 'Accueil',
    91 => 'Page générée en',
    92 => 'secondes',
    93 => 'Tous droits réservés',
    94 => 'Toutes les marques citées appartiennent à leurs propriétaires respectifs.',
    95 => 'Propulsé par',
    96 => 'Groupes',
    97 => 'Liste de mots',
    98 => 'Plugins',
    99 => 'ARTICLES',
    100 => 'Pas de nouvel article',
    101 => '',
    102 => '',
    103 => 'Sauvegarde de la BDD',
    104 => 'par',
    105 => 'Email aux membres',
    106 => 'Lu',
    107 => 'Version GL',
    108 => 'Vider le cache',
    109 => 'Signaler un abus',
    110 => 'Signaler ce message à l\'administrateur',
    111 => '',
    112 => 'Membres',
    113 => 'Documentation',
    114 => 'Trackbacks',
    115 => 'Pas de nouveau Trackback',
    116 => 'Trackback',
    117 => 'Archives',
    118 => 'Please continue reading on the next page:',
    119 => "<a href=\"{$_CONF['site_url']}/users.php?mode=getpassword\">Mot de passe oublié</a> ?",
    120 => 'Lien permanent vers ce commentaire',
    121 => 'Commentaires (%d)',
    122 => 'Trackbacks (%d)',
    123 => 'Tout code HTML accepté',
    124 => 'Cliquez pour effacer tous les articles sélectionnés',
    125 => 'Etes-vous certain de vouloir effacer tous les articles sélectionnés ?',
    126 => 'Sélectionnez ou désélectionnez tous les articles',
    127 => 'Permalink',
    128 => 'Login avec OpenID:',
    129 => 'Configuration',
    130 => 'Webservices',
    131 => 'No HTML is allowed',
    132 => 'Information',
    133 => 'Critical',
    134 => 'Help',
    135 => 'Warning',
    136 => 'Warning: Javascript recommended for enhanced functionality',
    137 => 'Warning: Javascript required to enable functionality',
    138 => "Click <a href=\"{$_CONF['site_url']}/usersettings.php\" rel=\"nofollow\">here</a> to disable the advanced editor and use the default editor which does not require JavaScript",
    139 => "Click <a href=\"{$_CONF['site_url']}/\" rel=\"nofollow\">here</a> to return to the homepage"
);

###############################################################################
# comment.php

$LANG03 = array(
    1 => 'Ajoutez un commentaire',
    2 => 'Format',
    3 => 'Se déconnecter',
    4 => 'Créez un compte',
    5 => 'Nom',
    6 => 'L\'envoi d\'un commentaire requiers que vous soyez enregistré et connecté. Si vous n\'avez pas encore de compte, vous pouvez vous inscrire à l\'aide du formulaire ci-dessous.',
    7 => 'Votre dernier commentaire était il y a ',
    8 => " secondes. Vous devez attendre {$_CONF['commentspeedlimit']} secondes entre chaque commentaire.",
    9 => 'Commentaire',
    10 => 'Envoyer un rapport',
    11 => 'Envoyer le commentaire',
    12 => 'Vous devez compléter les champs Titre et Commentaire.',
    13 => 'Vos infos',
    14 => 'Aperçu',
    15 => 'Rapportez ce commentaire',
    16 => 'Titre',
    17 => 'Erreur',
    18 => 'Remarques',
    19 => 'Vous pouvez choisir le titre de votre commentaire.',
    20 => 'Si besoin vous pouvez utiliser les [tags]. N\'hésitez pas à contacter l\'admin pour plus de détails.',
    21 => 'Pensez à vérifier l\'orthographe, votre contribution sera publique pour longtemps.',
    22 => 'N\'hésitez pas à répondre aux commentaires des autres, ou à lancer de nouveaux débats.',
    23 => 'Votre adresse email ne sera jamais rendue publique sauf si vous l\'insérez dans le corps du commentaire.',
    24 => 'Utilisateur anonyme',
    25 => 'Etes-vous certain de vouloir signaler cet abus à l\'administrateur du site ?',
    26 => '%s à rapporté ce message abusif :',
    27 => 'Signaler un abus',
    28 => 'Previsualiser les changements',
    29 => 'Soumettre les changements',
    30 => 'Edité le',
    31 => 'par',
    32 => 'Editer un commentaire',
    33 => 'Editer un commentaire soumis',
    34 => 'Previsualiser les changement de la soumission',
    35 => 'Souvegarder les changements dans la file d\'attente',
    36 => 'Signalez moi les nouvelles réponses',
    37 => 'Nouvelle commentaire en réponse',
    38 => 'Une réponse à été faite à votre commentaire \'%s\'.',
    39 => 'Vous pouvez voir le commentaire à l\'adresse  suivante :',
    40 => 'Si vous ne souhaitez plus recevoir de notifications de réponse, cliquez sur le lien suivant :',
    41 => 'Hello %s,',
    42 => 'Se désabonner',
    43 => 'Se désabonner des notifications',
    44 => 'Votre nom'
);

###############################################################################
# users.php

$LANG04 = array(
    1 => 'Profil de',
    2 => 'Nom d\'utilisateur',
    3 => 'Nom complet (facultatif)',
    4 => 'Mot de passe',
    5 => 'Email',
    6 => 'Site Internet',
    7 => 'Biographie',
    8 => 'Clé PGP',
    9 => 'Mettre à jour',
    10 => 'Les 10 derniers commentaires de ',
    11 => 'Aucun commentaire',
    12 => 'Préférences d\'utilisation de',
    13 => 'email temporisé la nuit',
    14 => 'Ce mot de passe a ete genere automatiquement. Il est recommende que vous le changiez immediatement. Pour ce faire, connectez-vous et cliquez sur Mon compte dans le menu membre.',
    15 => "Votre compte, sur le site {$_CONF['site_name']}, a ete cree avec succes. Vous devez utiliser les informations ci-dessous pour vous connecter. Veuillez sauvegarder ce message pour vous y referer.",
    16 => 'Informations sur votre compte',
    17 => 'Ce compte n\'existe pas',
    18 => 'L\'adresse email semble ne pas tre valide.',
    19 => 'Le nom d\'utilisateur ou l\'adresse email fournie est déjà utilisée par un autre membre.',
    20 => 'L\'adresse email fournie ne semble pas tre valide.',
    21 => 'Erreur',
    22 => 'Devenir membre du site',
    23 => 'Après avoir créé votre compte vous pourrez utilisez toutes les fonctions réservées aux membres. Votre adresse email ne sera jamais publiée sur ce site ni cédée à un tiers.',
    24 => 'Un mot de passe vous permettant de vous identifer vous sera envoyé par email à l\'adresse saisie ci-dessus.<br/> Par la suite, vous pourrez si besoin modifier ce mot de passe ainsi que votre adresse email.',
    25 => 'Avez-vous oublié votre mot de passe?',
    26 => 'Saisissez <em>soit</em> votre nom d\'utilisateur <em>soit</em> l\'adresse email enregistrée à ce compte, et cliquez &laquo;Envoi du mot de passe&raquo;. Des instructions à suivre concernant l\'enregistrement d\'un nouveau mot de passe vous seront adressées par email.',
    27 => 'Enregistrez-vous maintenant!',
    28 => 'Envoi du mot de passe',
    29 => 'déconnecté de',
    30 => 'connecté à',
    31 => 'Vous devez tre connecté pour exécuter cette fonction',
    32 => 'Signature',
    33 => 'Jamais affichée publiquement',
    34 => 'Votre nom véritable',
    35 => 'Entrez votre mot de passe afin de le changer',
    36 => 'Commence par http://',
    37 => 'Appliquer à vos commentaires',
    38 => 'Tout sur vous! Accessible par tous',
    39 => 'Votre clé puplique PGP à partager',
    40 => 'Pas d\'icon de catégorie',
    41 => 'En attente d\'autorisation',
    42 => 'Format de date',
    43 => 'Nombre maximum d\'articles',
    44 => 'Pas de blocks',
    45 => 'Préférences d\'affichage pour',
    46 => 'Eléments à exclure pour',
    47 => 'Configuration de la boîte des Nouvelles pour',
    48 => 'Catégories',
    49 => 'Pas d\'icon dans les articles',
    50 => 'Décocher les cases si vous n\'tes pas interéssé',
    51 => 'Seulement les articles de Nouvelles',
    52 => 'Par défaut',
    53 => 'Recevoir les articles du jour chaque nuit',
    54 => 'Cocher les cases pour les catégories et les articles que vous ne souhaitez pas voir apparaître',
    55 => 'Si vous laissez toutes les cases décochées, cela signifie que vous souhaitez la sélection par défaut. Si vous sélectionnez au moins une case, n\'oubliez pas de sélectionner toutes celles qui vous intéressent car les autres seront ignorées. Les cases sélectionnées par défaut apparaissent en gras.',
    56 => 'Auteur',
    57 => 'Format',
    58 => 'Ordre de tri',
    59 => 'Nombre maximum de commentaires',
    60 => 'Comment souhaitez vous que vos commentaires apparaîssent?',
    61 => 'Les plus récents ou les plus anciens en premier?',
    62 => '100 par défaut',
    63 => "Votre mot de passe vous a été envoyé par email et ne devrait pas tarder. Merci de suivre les instructions du message pour vous connecter & agrave; l'espace membre de {$_CONF['site_name']}",
    64 => 'Préférences des commentaires pour',
    65 => 'Essayez de vous connecter',
    66 => 'Veuillez saisir votre nom d\'utilisateur et votre mot de passe correspondant dans le formulaire ci-dessous.',
    67 => 'Membre depuis',
    68 => 'Auto login',
    69 => 'Combien de temps devrions-nous garder votre connexion active?',
    70 => "Personnaliser l'aspect et le contenu de {$_CONF['site_name']}",
    71 => "Une fonctionnalité intéressante du site {$_CONF['site_name']} est que vous pouvez en personnaliser l'aspect et le contenu. Afin de pouvoir utiliser ces fonctionnalités vous devez vous <a href=\"{$_CONF['site_url']}/users.php?mode=new\">enregistrer</a> au près du site {$_CONF['site_name']}.  Vous êtes déjà membre?  Alors utilisez la passerelle de connexion dans la barre latérale pour vous connecter!",
    72 => 'Thème',
    73 => 'Langue',
    74 => 'Changez l\'aspect de ce site!',
    75 => 'Envoyez des email à ces sujets',
    76 => 'Si vous sélectionnez une ou plusieurs catégories parmi celles ci-dessous, vous recevrez par email un avis de publication des nouveaux articles publiés dans cette catégorie.',
    77 => 'Photo',
    78 => 'Ajouter votre propre photo!',
    79 => 'Cochez ici pour effacer cette photo',
    80 => 'Connexion',
    81 => 'Envoyer un email',
    82 => 'Les 10 derniers articles de',
    83 => 'Statistiques concernant',
    84 => 'Nombre total d\'articles:',
    85 => 'Nombre total de commentaires:',
    86 => 'Chercher tous les articles de',
    87 => 'Votre nom de membre',
    88 => "Quelqu'un a demandé un nouveau mot de passe pour le compte '%s' sur le site {$_CONF['site_name']}, <{$_CONF['site_url']}>.\n\nSi vous désirez réellement que cette action soit entreprise, cliquez sur ce lien:\n\n",
    89 => "Pour refuser d\'entreprendre cette action, vous n\'avez simplement qu\'a ignorer ce message, ainsi votre mot de passe demeurera inchange.\n\n",
    90 => 'Vous pouvez choisir un nouveau mot de passe pour le compte ci-dessous. Prière de noter que l\'ancien mot de passe demeurera actif jusqu\'à ce que vous soumettiez ce formulaire.',
    91 => 'Réglez le nouveau mot de passe',
    92 => 'Entrez le nouveau mot de passe',
    93 => 'Votre dernière requte pour l\'obtention d\'un nouveau mot de passe était il y a %d secondes de cela. Ce site requiers que s\'écoule au moins %d secondes entre les requtes de nouveaux mots de passe.',
    94 => 'Effacer le compte "%s"',
    95 => 'Cliquez sur "Effacer le compte" ci-dessous pour effacer votre compte de notre banque de données. Notez que toutes vos interventions sur ce site seront conservées, étant attribuées à un utilisateur &laquo;Anonyme&raquo; en remplacement de votre nom de membre.',
    96 => 'Effacer le compte',
    97 => 'Confirmez l\'effacement de votre compte',
    98 => 'Etes-vous certain de vouloir effacer ce compte? Car ce faisant, vous ne pourrez alors plus accéder aux fonctions de ce site (sauf en créant un nouveau compte). Si vous en tes certain, cliquez alors sur "effacer le compte" une dernière fois ci-dessous.',
    99 => 'Options de sécurité pour',
    100 => 'Emails de l\'administrateur du site',
    101 => 'Autorisez les emails provenant de l\'administrateur du site',
    102 => 'Emails des membres',
    103 => 'Allouez la réception de emails provenant d\'autre membres',
    104 => 'Affichez votre présence en ligne',
    105 => 'Affichez ma présence dans le block &laquo;En ligne&raquo;',
    106 => 'Localisation',
    107 => 'Affiché dans votre profil',
    108 => 'Confirmez le nouveau mot de passe',
    109 => 'Ré-inscrivez votre nouveau mot de passe',
    110 => 'Mot de passe actuel',
    111 => 'Ré-inscrivez votre nouveau mot de passe actuel',
    112 => 'Vous ne semblez pas être celui ou celle que vous prétendez être. Merci de créer un nouveau compte ou de ré-essayer plus tard.',
    113 => 'Tentative avortée',
    114 => 'Compte désactivé',
    115 => 'Votre compte à été désactivé, il vous est donc impossible de vous connecter. Merci de contacter un des administrateurs du site.',
    116 => 'Votre compte est en attente d\'activation',
    117 => 'Votre compte est en attente d\'activation, il doit être approuvé par un admistrateur. Vous ne pourrez y accéder avant son activation.',
    118 => "Votre compte {$_CONF['site_name']} est désormais activé. Vous pourrez y accéder en utilisant votre nom de membre (<username>) et votre mot de passe, tel que reçu par email.",
    119 => 'En cas d\'oubli de votre mot de passe, vous pourrez en créer un nouveau à cette adresse :',
    120 => 'Compte activé',
    121 => 'Service',
    122 => 'Désolé, mais nous n\'acceptons pas de nouveaux membres en ce moment.',
    123 => "Vous pouvez aussi <a href=\"{$_CONF['site_url']}/users.php?mode=new\" rel=\"nofollow\">créer un nouveau compte</a>.",
    124 => 'Confirmez votre email',
    125 => 'Vous avez inscrit la même adresse couriel dans les deux champs !',
    126 => 'Prière de répéter pour confirmer',
    127 => 'Mot de passe requis pour effectuer des changements.',
    128 => 'Votre nom',
    129 => 'Mot de passe et email',
    130 => 'A propos de vous',
    131 => 'Options du résumé quotidien',
    132 => 'Fonction de résumé quotidien',
    133 => 'Affichage des commentaires',
    134 => 'Options des commentaires',
    135 => '<li>Mode d\'affichage des commentaires par défaut</li><li>Ordre d\'affichage des commentaires par défaut</li><li>Réglage du maximum de commentaires à afficher - 100 par défaut</li>',
    136 => 'Exclure les catégories et leurs auteurs',
    137 => 'Filtrez le contenu',
    138 => 'Autres réglages',
    139 => 'Thèmes et langues',
    140 => '<li>N\'affiche pas les icons des catégories si coché</li><li>N\'affiche pas les blocks si coché - seulement le menu admin, le menu utilisateur et les catégories<li>Sélectionnez le nombre maximum d\'articles à afficher</li><li>Sélectionnez votre thème et l\'affichage de la date préférés.</li>',
    141 => 'Vie privée',
    142 => 'Par défaut, les utilisateurs et les administrateurs peuvent vous envoyer des emails et voir si vous êtes en ligne. Déselectionnez ces options si vous préférez.',
    143 => 'Filtrez le contenu des blocks',
    144 => 'Cachez ou montrez des blocks',
    145 => 'Votre profil public',
    146 => 'Mot de passe et email',
    147 => 'Editez votre mot de passe, votre email ou la fonction auto login. Vous devrez inscrire votre mot de passe ou votre email deux fois pour le confirmer.',
    148 => 'Informations d\'utilisateur',
    149 => 'Modifiez les informations personnelles que les autres pourront voir.<li>La signature sera ajoutée à toutes vos interventions sur ce site.</li><li>La BIO est une courte description de vous-même que vous désirez partager avec les autres.</li><li>Partage de votre clé PGP</li>',
    150 => '',
    156 => 'Effacer mon compte',
    157 => 'Suppression du compte (Attention fonction irréversible)',
    158 => 'Time Zone',
    159 => 'Cet email à été généré automatiquement. Merci de ne pas y répondre.',
    160 => '(max. %d x %d pixels, %d bytes; %s)',
    161 => 'sera réduite',
    162 => 'ne sera pas réduite',
    163 => 'La réauthentification a échouée',
    164 => 'Vous avez dépassé le nombre maximum de réauthentification. Désolé, l\'opération a été annulée et votre modifications ont été perdues.',
    165 => 'Utiliser l\éditeur avancé',
    166 => 'Re-synch Remote Account'
);

###############################################################################
# Customize if need to modify the Tabbed navbar MyAccount panels used.
# Array index key matches preference div id

$LANG_MYACCOUNT = array(
    'pe_preview' => 'Aperçu',
    'pe_namepass' => 'Nom &amp; mot de passe',
    'pe_userinfo' => 'Bio',
    'pe_layout' => 'Thème &amp; Langue',
    'pe_content' => 'Contenu',
    'pe_privacy' => 'Vie privée'
);

###############################################################################
# index.php

$LANG05 = array(
    1 => 'Aucun article à afficher',
    2 => 'Il n\'y a pas de nouveaux articles à afficher. Il n\'y a peut-être pas de nouveautés pour cette catégorie ou alors vos préférences sont trop restrictives.',
    3 => ' pour la catégorie %s',
    4 => 'Article du jour',
    5 => 'Suivant',
    6 => 'Précédent',
    7 => 'Premier',
    8 => 'Dernier'
);

###############################################################################
# profiles.php

$LANG08 = array(
    1 => 'Une erreur s\'est produite lors de l\'envoi de votre message. Veuillez réessayer.',
    2 => 'Message a été envoyé avec succès.',
    3 => 'Vérifiez que l\'adresse du champ &laquo;répondre à&raquo; est valide.',
    4 => 'Veuillez compléter les champs: &laquo;Votre nom&raquo;, &laquo;réponse à&raquo;, &laquo;sujet&raquo; et &laquo;message&raquo;',
    5 => 'Erreur: membre inconnu.',
    6 => 'Il y a eu une erreur.',
    7 => 'Profil membre de ',
    8 => 'Nom de connexion',
    9 => 'URL membre',
    10 => 'Envoyer un email à',
    11 => 'Votre nom :',
    12 => 'Votre email :',
    13 => 'Sujet :',
    14 => 'Message :',
    15 => 'Les balises HTML ne seront pas traduites.',
    16 => 'Envoyer Message',
    17 => 'Envoyer cet article à un ami',
    18 => 'Pour',
    19 => 'Adresse email',
    20 => 'De',
    21 => 'Adresse email',
    22 => 'Tous les champs sont obligatoires',
    23 => "Ce email vous a été envoyé de la part de %s at %s car il pensait que vous pourriez tre intéressé par {$_CONF['site_url']}. Ce n'est pas un SPAM et l'adresse email utilisée n'est pas stokée dans une liste d'envoi.",
    24 => 'Commentaire sur cet article à',
    25 => 'Vous devez tre connecté pour utiliser cette fonction. Votre identification permettra de contrôler tout abus du système',
    26 => 'Ce formulaire vous permet d\'envoyer un email. Tous les champs sont obligatoires.',
    27 => 'Message court',
    28 => '%s a écrit: ',
    29 => "Bonjour. Voici le(s) dernier(s) article(s) publié(s) sur {$_CONF['site_name']} le ",
    30 => ' Lettre d\'information du ',
    31 => 'Titre',
    32 => 'Date',
    33 => 'Lire l\'article complet : ',
    34 => 'Fin du message',
    35 => 'Désolé, ce membre ne désire pas recevoir de messages.',
    36 => 'Copie :',
    37 => 'Envoyez moi un double de cet email',
    38 => "Ceci est une copie du message que vous avez envoyé à %s du site <{$_CONF['site_url']}> :",
    39 => 'Your last message was ',
    40 => " seconds ago.  This site requires at least {$_CONF['speedlimit']} seconds between sending messages"
);

###############################################################################
# search.php

$LANG09 = array(
    1 => 'Recherche avancée',
    2 => 'Mots clés',
    3 => 'Sujet',
    4 => 'Tous',
    5 => 'Type',
    6 => 'Articles',
    7 => 'Commentaires',
    8 => 'Auteurs',
    9 => 'Tous',
    10 => 'Recherche',
    11 => 'Résultats de recherche',
    12 => 'sélections',
    13 => 'Aucun résultats n\'a été trouvé',
    14 => 'Aucun résultat ne correspond à vos critères',
    15 => 'Veuillez réessayer.',
    16 => 'Titre',
    17 => 'Date',
    18 => 'Auteur',
    19 => "Chercher dans toute la base de données de {$_CONF['site_name']}.",
    20 => 'Date',
    21 => 'à',
    22 => '(Format des dates AAAA-MM-JJ)',
    23 => 'Actions',
    24 => 'Trouvé %d items',
    25 => 'Résultats pour',
    26 => 'Items',
    27 => 'secondes',
    28 => 'Il n\'y a pas d\'articles ou de commentaires correspondant à vos critères',
    29 => 'Articles et commentaires trouvés',
    30 => '',
    31 => 'Aucun lien trouvé pour ce plugin',
    32 => '',
    33 => 'URL',
    34 => 'Localisation',
    35 => 'Tous les jours',
    36 => '',
    37 => '',
    38 => '',
    39 => '',
    40 => '',
    41 => 'Votre sujet de recherche devrait comporter au moins 3 caractères.',
    42 => 'Prière d\'utiliser une date exprimée comme suit: AAAA-MM-JJ (année-mois-jour).',
    43 => 'Phrase exacte',
    44 => 'Tous ces mots',
    45 => 'N\'importe quel mot',
    46 => 'Suivant',
    47 => 'Précédant',
    48 => 'Auteur',
    49 => 'Date',
    50 => 'Clics',
    51 => '',
    52 => 'Localisation',
    53 => 'Résultats d\'articles',
    54 => 'Résultats de commentaires',
    55 => 'la phrase',
    56 => 'ET',
    57 => 'OU',
    58 => 'Plus de résultats &gt;&gt;',
    59 => 'Résultats',
    60 => 'par page',
    61 => 'Recherche étendue',
    62 => '#',
    63 => 'Description',
    64 => 'Liste %1$d - %2$d de %3$d résultats',
    65 => 'Article',
    66 => 'Commentaire',
    67 => 'Montrez %d résultats',
    68 => 'Ordonnés par',
    69 => 'Titres uniquement',
    70 => 'Information non disponible...',
    71 => 'asc',
    72 => 'desc'
);

###############################################################################
# stats.php

$LANG10 = array(
    1 => 'Statistiques du site',
    2 => 'Nombre de hits sur le site',
    3 => 'Nombre d\'articles (et commentaires)',
    4 => '',
    5 => '',
    6 => '',
    7 => 'Top-10 des articles les plus regardés',
    8 => 'Titre d\'article',
    9 => 'Pages regardées',
    10 => 'Soit il n\'y a pas d\'article sur ce site, soit ils n\'ont pas été regardés',
    11 => 'Top-10 des articles les plus commentés',
    12 => 'Commentaires',
    13 => 'Soit il n\'y a pas d\'article sur ce site, soit aucun commentaires n\'a encore été fait.',
    14 => '',
    15 => '',
    16 => '',
    17 => '',
    18 => '',
    19 => '',
    20 => '',
    21 => '',
    22 => 'Top-10 des articles les plus envoyés par email',
    23 => 'emails',
    24 => 'Personne n\'a encore envoyé d\'article par email',
    25 => 'Top-10 des meilleurs Trackbacks commentés',
    26 => 'Personne n\'a encore commenté un Trackback',
    27 => 'Nombre d\'utilisateurs actifs',
    28 => '',
    29 => '',
    30 => 'Clics',
    31 => ''
);

###############################################################################
# article.php

$LANG11 = array(
    1 => 'Ressources',
    2 => 'Envoyer cet article à un ami',
    3 => 'Version imprimable',
    4 => 'Options',
    5 => '',
    6 => 'Souscrire à \'%s\''
);

###############################################################################
# submit.php

$LANG12 = array(
    1 => 'Pour envoyer un %s vous devez vous identifier comme membre.',
    2 => 'Vous connectez',
    3 => 'Nouveau membre',
    4 => '',
    5 => '',
    6 => 'Soumettre un article',
    7 => 'Identification requise',
    8 => 'Envoyer',
    9 => 'Merci de compléter tous les champs et de vérifier votre saisie avant d\'envoyer votre proposition.',
    10 => 'Titre',
    11 => '',
    12 => 'Début',
    13 => 'Fin',
    14 => 'Localisation',
    15 => 'Description',
    16 => '',
    17 => '',
    18 => '',
    19 => 'Note d\'information',
    20 => '',
    21 => '',
    22 => 'Erreur: champs manquants',
    23 => 'Veuillez compléter tous les champs du formulaire. Ils sont tous obligatoires.',
    24 => 'Proposition enregistrée',
    25 => 'Vos propositions %s ont été sauvegardées avec succès.',
    26 => 'Limitation',
    27 => 'Membre',
    28 => 'Sujet',
    29 => 'Article',
    30 => 'Votre dernière proposition était il y a',
    31 => " secondes. Vous devez attendre au moins {$_CONF['speedlimit']} secondes entre chaque propositions",
    32 => 'Aperçu',
    33 => 'Aperçu de l\'article',
    34 => 'Se déconnecter',
    35 => 'Les balises HTML ne sont pas acceptées',
    36 => 'Format',
    37 => '',
    38 => '',
    39 => '',
    40 => '',
    41 => '',
    42 => '',
    43 => '',
    44 => 'Adresse (ligne 1)',
    45 => 'Adresse (ligne 2)',
    46 => 'Ville',
    47 => 'Région',
    48 => 'Code postal',
    49 => '',
    50 => '',
    51 => 'Localisation',
    52 => 'Supprimer',
    53 => 'Créer un compte',
    54 => 'Introduction',
    55 => 'Corps'
);

###############################################################################
# ADMIN PHRASES - These are file phrases used in admin scripts
###############################################################################

###############################################################################
# admin/auth.inc.php

$LANG20 = array(
    1 => 'Identification requise',
    2 => 'Utilisateur ou mot de passe incorrect',
    3 => 'Mot de passe incorrect',
    4 => 'Nom de membre:',
    5 => 'Mot de passe:',
    6 => 'Cette page est réservée aux membres du site. Merci de vous identifier pour continuer.',
    7 => 'Connexion'
);

###############################################################################
# admin/block.php

$LANG21 = array(
    1 => 'Droits insuffisants',
    2 => 'Vous n\'avez pas les droits nécessaires pour modifier ce block',
    3 => 'Editeur de block',
    4 => 'Un problème est survenu à la lecture de cet envoi. Voir error.log.',
    5 => '',
    6 => '',
    7 => 'Tous',
    8 => 'niveau de sécurité du block',
    9 => 'Ordre du block',
    10 => '',
    11 => 'Block Portail',
    12 => 'Block Normal',
    13 => 'Block portail d\'option',
    14 => 'URL RDF',
    15 => 'Dernière MAJ RDF',
    16 => 'Block normal d\'option',
    17 => 'Contenu du block',
    18 => 'Veuillez remplir les champs: titre, niveau de sécurité et contenu du block',
    19 => 'Contrôleur de block',
    20 => '',
    21 => 'Block niv. sec.',
    22 => '',
    23 => 'Block ordre',
    24 => '',
    25 => 'Cliquez sur le lien ci-dessous pour modifier ou supprimer un block.  Cliquez sur le lien "Ajouter" pour créer un nouveau block.',
    26 => 'Block d\'affichage',
    27 => 'Block PHP',
    28 => 'Option du block PHP',
    29 => 'Block fonction',
    30 => 'Si vous voulez que l\'un de vos blocks utilise du PHP, saisissez le nom de la fonction à utiliser.  Le nom de la fonction doit commencer par \'phpblock_\' (ex: phpblock_getweather).  Si ce n\'est pas le cas, votre fonction NE SERA PAS appellée, ceci pour des raisons de sécurité.  Ne mettez pas de parenthèses vides \'()\' après le nom de votre fonction.  Enfin, nous vous recommandons de mettre tout le code des block PHP dans /path/to/geeklog/system/lib-custom.php.  Cela permettera de garder votre code même après une mise à jour du système.',
    31 => 'Erreur dans le block PHP.  La fonction, %s, n\'existe pas.',
    32 => 'Erreur: champs manquant',
    33 => 'Vous devez mettre l\'URL dans le fichier .rdf pour le block portail.',
    34 => 'Vous devez renseigner le titre et la fonction du block PHP.',
    35 => 'Vous devez entrer le titre et le contenu du block normal.',
    36 => 'Vous devez entrer le contenu pour le block d\'affichage.',
    37 => 'Nom erroné dans la fonction du block PHP',
    38 => 'Les fonctions des blocks PHP doivent commencer par "phpblock_" (ex: phpblock_getweather).  Le préfixe "phpblock_" est nécessaire pour des raisons de sécurité qui empche l\'exécution de code arbitraire.',
    39 => 'Côté',
    40 => 'Gauche',
    41 => 'Droit',
    42 => 'Vous devez saisir l\'ordre et le niveau de sécurité pour les blocks par défaut du système',
    43 => 'Accueil seulement',
    44 => '',
    45 => "Vous essayez d'accéder à un block auquel vous n'avez pas droit.  Cette tentative est enregistrée. Veuillez <a href=\'{$_CONF['site_admin_url']}/block.php\'>retourner à la page de contrôle des blocks</a>.",
    46 => 'Position',
    47 => '',
    48 => 'Nom du block',
    49 => ' (Pas d\'espace et doit être unique)',
    50 => 'The Block Name can not be empty',
    51 => 'inclure http:// ',
    52 => 'Laisser vide pour ne pas afficher l\'icone d\'aide',
    53 => 'Activé',
    54 => 'enregistrer',
    55 => 'annuler',
    56 => 'supprimer',
    57 => 'Bougez le block vers le bas',
    58 => 'Bougez le block vers le haut',
    59 => 'Bougez le block vers la droite',
    60 => 'Bougez le block vers la gauche',
    61 => 'Sans titre',
    62 => 'Article limité à',
    63 => 'Nom de block non-valide',
    64 => 'Il doit y avoir un titre. Le code HTML est interdit!',
    65 => 'Ordre',
    66 => 'Autotags',
    67 => 'Vérifiez si vous acceptez les autotags',
    68 => 'Le flux de ce site est trop long. Merci de préciser un nombre d\'articles maximum à importer (règlage du block ou configuration principale).'
);

###############################################################################
# admin/story.php

$LANG24 = array(
    1 => 'Articles précédents',
    2 => 'Articles suivants',
    3 => 'Mode',
    4 => 'Format',
    5 => 'Editeur d\'articles',
    6 => 'Il n\'y a pas d\'articles dans le système',
    7 => 'Auteur',
    8 => 'Enregistrer',
    9 => 'Pré-visualisation',
    10 => 'Annuler',
    11 => 'Supprimer',
    12 => 'Numéro',
    13 => '',
    14 => '',
    15 => 'Date',
    16 => 'Texte d\'intro',
    17 => 'Corps',
    18 => 'Clics',
    19 => 'Commentaires',
    20 => 'Ping',
    21 => 'Envoyez un ping',
    22 => 'Liste des articles',
    23 => 'Pour modifier ou supprimer un article, cliquez sur son numéro. Pour visionner un article, cliquez sur le titre de l\'article. Pour créer un nouvel article, cliquez sur le bouton "Ajouter".',
    24 => 'Le numéro choisi pour cet article est déjà utilisé. Merci d\'en choisir un autre.',
    25 => 'Une erreur s\'est produite lors de la sauvegarde',
    26 => 'Aperçu de l\'article',
    27 => 'Si vous utilisez [unscaledX] au lieu de [imageX], votre image apparaîtra dans ses dimensions originales.',
    28 => '<p><b>Pré-visualisation</b>: La pré-visualisation d\'un article pourvu d\'images est possible si on le sauvegarde comme brouillon AU LIEU DE le pré-visualiser. Ne pré-visualisez qu\'en absence d\'image.',
    29 => 'Trackback',
    30 => 'Erreur de sauvegarde',
    31 => 'Veuillez inscrire le titre et le texte d\'introduction.',
    32 => 'En vedette',
    33 => 'Il ne peut y avoir qu\'un seul article mis en vedette',
    34 => 'Brouillon',
    35 => 'Oui',
    36 => 'Non',
    37 => 'Autres articles de',
    38 => 'Autres articles sur',
    39 => 'emails',
    40 => '',
    41 => "Vous essayez d'accéder à un article auqule vous n'avez pas droit.  Cette tentative est enregistrée.  Vous pouvez voir cet article en lecture seule uniquement. Veuillez <a href=\'{$_CONF['site_admin_url']}/story.php\'>retourner sur la page de contrôle des article</a> lorsque vous aurez fini.",
    42 => "Vous essayez d'accéder à un article auquel vous n'avez pas droit.  Cette tentative est enregistrée.  Veuillez <a href=\'{$_CONF['site_admin_url']}/story.php\'>retourner à la page de contrôle des articles</a>.",
    43 => '',
    44 => '',
    45 => '',
    46 => '<b>REMARQUE:</b> si vous indiquez une date future, cet article n\'apparaîtra qu\'à partir de cette date. Cela signifie aussi que l\'article sera ignoré des recherches et des statistiques.',
    47 => 'Images',
    48 => 'image',
    49 => 'droite',
    50 => 'gauche',
    51 => 'Pour ajouter une des images que vous avez fournies vous devez insérer un texte spécial dans votre article. Vous devez insérer [imageX], [imageX_right] ou [imageX_left] o&ugrave; X est le numéro de l\'image que vous avez fournie.  REMARQUE: vous devez utiliser toutes les images fournies.  Si vous ne le faites pas vous ne pourrez pas enregistrer votre article.<BR><P><B>APERCU</B>: lors de l\'utilisation d\'images il est préférables de faire un brouillon plutôt que d\'utiliser la fonction d\'apercu.  Utilisez le bouton d\'apercu uniquement lorsqu\'il n\'y a pas d\'image.',
    52 => '',
    53 => 'n\'est pas utilisée.  Vous devez insérer l\'image dans le texte de votre article avant de l\'enregistrer.',
    54 => 'Image fournie non utilisée',
    55 => 'L\'erreur suivante est apparue lors de l\'enregistrement de votre article.  Veuillez corriger ces erreurs et réessayer',
    56 => 'Montrer l\'icon',
    57 => 'Montrer l\'image originale',
    58 => 'Gestion des articles',
    59 => 'Option',
    60 => '',
    61 => 'Auto-archivé',
    62 => 'Auto-effacé',
    63 => 'Désactiver les commentaires',
    64 => '',
    65 => '',
    66 => '',
    67 => 'Augmentez le contenu en révisant la taille de l\'article',
    68 => 'Réduisez le contenu en révisant la taille de l\'article',
    69 => 'Date de l\'article',
    70 => 'Sélectionnez une barre d\'outils',
    71 => 'Barre d\'outils de base',
    72 => 'Barre d\'outils normale',
    73 => 'Barre d\'outils avancée',
    74 => 'Barre d\'outils experte',
    75 => 'Toutes les options',
    76 => 'Options de publication',
    77 => 'L\'option Javascript est nécessaire pour que cet éditeur fonctionne. Cette option peut-tre désactivée dans config.php',
    78 => 'Cliquez <a href="%s/story.php?mode=edit&amp;sid=%s&amp;editopt=default">ici</a> pour utiliser l\'éditeur par défaut',
    79 => 'Prévision',
    80 => 'Edition',
    81 => 'Options de publication',
    82 => 'Images',
    83 => 'Options d\'archive',
    84 => 'Permissions',
    85 => 'Montrez tout',
    86 => 'Edition avancée',
    87 => 'Statistiques',
    88 => 'Format Wiki-style',
    89 => 'Meta Description',
    90 => 'Meta Keywords',
    91 => 'Vous pouvez toujours utiliser le "Preview" pour prolonger le délai de péremption.',
    'autotag_desc_story' => '[story: id alternate title] - Displays a link to a Story using the Story Title as the title. An alternate title may be specified but is not required.'
);

###############################################################################
# admin/topic.php

$LANG27 = array(
    1 => 'Editeur de catégories',
    2 => 'Numéro',
    3 => 'Nom',
    4 => 'Image',
    5 => '(Ne pas utiliser d\'espaces)',
    6 => 'Supprimer une catégorie supprimera tous les articles et blocks en relations avec celle-ci',
    7 => 'Veuillez renseigner le numéro et le nom de la catégorie.',
    8 => 'Contrôleur de catégorie',
    9 => 'Cliquez sur une catégorie pour la modifier ou la supprimer.  Cliquez sur &laquo;Ajouter&raquo; pour créer une nouvelle catégorie. Vos droits d\'accès concernant toutes les catégories apparaissant entre parenthèses.',
    10 => 'Ordre de tri',
    11 => 'Articles/Page',
    12 => 'Accès réservé',
    13 => "Vous ne pouvez pas éditer cette catégorie. Veuillez <a href=\"{$_CONF['site_admin_url']}/topic.php\">retourner à la page de contrôle des catégories</a>.",
    14 => 'Méthode de tri',
    15 => 'alphabétique',
    16 => 'par défaut:',
    17 => 'Nouvelle catégorie',
    18 => 'Accueil Admin',
    19 => 'Enregistrer',
    20 => 'Annuler',
    21 => 'Supprimer',
    22 => 'Par défaut',
    23 => 'Faites de cette catégorie le choix par défaut pour la création de nouveaux articles',
    24 => '(*)',
    25 => 'Archivez la catégorie',
    26 => 'Faites-en la catégorie par défaut pour vos archives. Une seule catégorie est admise',
    27 => 'Ou alors téléchargez votre icon pour cette catégorie',
    28 => 'Maximum',
    29 => 'Erreur de téléchargement',
    30 => 'Articles dans la catégorie'
);

###############################################################################
# admin/user.php

$LANG28 = array(
    1 => 'Edition des données du membre',
    2 => 'ID',
    3 => 'Nom de connexion',
    4 => 'Nom complet',
    5 => 'Mot de passe',
    6 => 'Niveau de sécurité',
    7 => 'Adresse email',
    8 => 'Page d\'accueil',
    9 => '(Ne pas utiliser d\'espaces)',
    10 => 'Veuillez renseigner le nom de connexion, le nom complet, le nom complet et l\'adresse email.',
    11 => 'Contrôleur des membres',
    12 => 'Cliquez sur un membre pour le modifier ou le supprimer.  Cliquez sur Ajouter pour créer un compte. Vous pouvez faire des recherches simple en entrant une partie du nom de connexion, du nom complet ou de l\'adresse email dans le formulaire ci-dessous.',
    13 => 'Niv. Sec.',
    14 => 'Date d\'enregistrement',
    15 => '',
    16 => '',
    17 => '',
    18 => '',
    19 => '',
    20 => 'Enregistrer',
    21 => 'Le nom de connexion est déjà utilisé.',
    22 => 'Erreur',
    23 => 'Ajout par lot',
    24 => 'Importation par lot d\'utilisateurs',
    25 => 'Vous pouvez importer un lot d\'utilisateur dans le système.  Les champ du fichier d\'import doivent tre séparés par une tabulation. Ils doivent apparaître dans l\'ordre suivant: Nom complet, nom de connexion, adresse email.  Chaque utilisateur importé sera averti par email et aura un mot de passe auto-généré.  Il ne doit y avoir qu\'un seul utilisateur par ligne.  Ne pas respecter ces consignes peut entraîner des dégat qui ne seront réparables que manuellement, alors redoublez de vigilance!',
    26 => '',
    27 => '',
    28 => 'Cocher la case pour supprimer la photo',
    29 => 'Chemin',
    30 => 'Importer',
    31 => 'Nouveaux membres',
    32 => 'Traitement terminé. %d membres ont été importés et il y a %d erreurs',
    33 => 'envoyer',
    34 => 'Erreur: Vous devez préciser un fichier à télécharger.',
    35 => 'Dernier accès',
    36 => '(jamais)',
    37 => 'UID',
    38 => 'Liste groupée',
    39 => 'Mot de passe (encore)',
    40 => 'Date d\'enregistrement',
    41 => 'Date du dernier accès',
    42 => 'Banni',
    43 => 'En attente d\'activation',
    44 => 'En attente d\'autorisation',
    45 => 'Activé',
    46 => 'Statut du membre',
    47 => 'éditez',
    48 => 'Montrez les groupes Admin',
    49 => 'Groupe Admin',
    50 => 'Check to allow filtering this group as an Admin Use Group',
    51 => 'Jours en ligne',
    52 => '<br' . XHTML . '>Note: Les "jours en ligne", c\'est le total de jours entre la création du compte et le dernier accès.',
    53 => 'enregistré',
    54 => 'Batch delete',
    55 => 'ça ne fonctionnera seulement que si vous avez le code <code>$_CONF[\'lastlogin\'] = true;</code> dans config.php',
    56 => 'Prière de sélectionner le type d\'utilisateur que vous désirez effacer et cliquez sur "Mise à jour de la liste". Ensuite, déselectionnez les utilisateurs que vous ne désirez pas effacer et cliquez sur "Effacer". Merci de noter que si la liste s\'étend sur plusieurs pages, vous n\'effacerez que les noms présents sur la page actuelle. Répétez pour les autres pages.',
    57 => 'Membres fantôme',
    58 => 'Membres de courte durée',
    59 => 'Anciens utilisateurs',
    60 => 'Membres il y a plus de ',
    61 => ' mois, mais qui n\'ont jamais accédé au service.',
    62 => 'Membres il y a plus de ',
    63 => ' mois, qui ont ensuite accédé au système dans les 24 heures, mais qui n\'ont jamais accédé au service par la suite.',
    64 => 'Membres qui n\'ont pas accédé au service depuis ',
    65 => ' mois.',
    66 => 'Mise à jour de la liste',
    67 => 'Mois depuis enregistrement',
    68 => 'Mois en ligne',
    69 => 'Mois hors-ligne',
    70 => 'n\'ont pu tre effacés',
    71 => 'effacés avec succès',
    72 => 'Aucun utilisateur sélectionné',
    73 => 'tes-vous certain de vouloir effacer TOUS ces utilisateurs ?',
    74 => 'Membres récents',
    75 => 'Membres lors des derniers ',
    76 => ' mois',
    77 => 'Email un rappel de connexion aux membres sélectionnés',
    78 => 'Envoyez un rappel',
    79 => 'Aucun membre sélectinnés pour les rappels',
    80 => 'Les rappels ont bien été envoyés',
    81 => 'Message pour vérifier votre compte sur %s',
    82 => "Vous n'avez pas accédez à votre compte sur le site {$_CONF['site_name']} depuis %s. Il sera désactivé si vous ne vous connectez pas dans les prochains 30 jours.",
    83 => "Votre compte sur le site {$_CONF['site_name']} n'a jamais été utilisé depuis sa création et sera supprimé prochainement si vous ne l'utilisez pas.",
    84 => "Votre nom de login est : %s  pour le site : {$_CONF['site_url']}",
    85 => 'Si vous avez oublié votre mot de passe, utilisez le lien suivant : %s',
    86 => 'Inclure',
    87 => 'Rappels',
    88 => 'Groupe par défaut',
    89 => 'Cochez pour que les nouveaux membres fassent partie de ce groupe par défaut',
    90 => 'Cochez pour placer aussi tous les anciens membres dans ce groupe',
    'autotag_desc_user' => '[user: id alternate title] - Displays a link to a User using the Username as the title. An alternate title may be specified but is not required.'
);

###############################################################################
# admin/moderation.php

$LANG29 = array(
    1 => 'Valider',
    2 => 'Supprimer',
    3 => 'Modifier',
    4 => 'Profil',
    10 => 'Titre',
    11 => 'Début',
    12 => 'URL',
    13 => 'Catégorie',
    14 => 'Date',
    15 => 'Sujet',
    16 => 'Membre',
    17 => 'Nom Complet',
    18 => 'email',
    34 => 'Commandes et Contrôles',
    35 => 'Soumissions d\'articles',
    36 => 'Soumission de liens',
    37 => '',
    38 => 'Envoyer',
    39 => 'Il n\'y a aucune soumission à administrer pour le moment',
    40 => 'Soumissions des membres',
    41 => 'Soumission des commentaires',
    42 => 'Nom du membre',
    43 => 'Auto-publier les commentaires?'
);

###############################################################################
# admin/mail.php

$LANG31 = array(
    1 => "Envoyer un mail aux membres de {$_CONF['site_name']}",
    2 => 'De',
    3 => 'Adresse de réponse',
    4 => 'Sujet',
    5 => 'Message',
    6 => 'à:',
    7 => 'Tous les membres',
    8 => 'Admin',
    9 => 'Options',
    10 => 'HTML',
    11 => 'Message urgent!',
    12 => 'Envoyer',
    13 => 'Effacer',
    14 => 'Ignorer les préférences des membres',
    15 => 'Erreur lors de l\'envoi d\'un message à: ',
    16 => 'Message envoyé avec succès à: ',
    17 => "<a href=\"{$_CONF['site_admin_url']}/mail.php\">Envoyer un autre message</a>",
    18 => 'A',
    19 => 'Remarque: si vous voulez envoyer un message à tous les membres, utilisez le groupe Logged-in Users dans le champ A.',
    20 => "<successcount> messages ont été envoyés avec succès et <failcount> n'ont pas pu tre envoyés.  Vous trouverez le détail de chaque tentative ci-dessous.  Vous pouvez également <a href=\"{$_CONF['site_admin_url']}/mail.php\">envoyer un autre message</a> ou <a href=\"{$_CONF['site_admin_url']}/moderation.php\">revenir à la page d'administration</a>.",
    21 => 'échecs',
    22 => 'Succès',
    23 => 'Pas d\'échecs',
    24 => 'Pas de succès',
    25 => '-- Choisir un groupe --',
    26 => 'Remplissez tous les champs et choisissez un groupe parmi la liste.'
);

###############################################################################
# admin/plugins.php

$LANG32 = array(
    1 => 'L\'installation de plugins peut endommager le système.  Il est important de n\'installer que des plugins approuvés par <a href=\'http://www.geeklog.net\' target=\'_blank\'>le système</a> car nous les testons sur plusieurs systèmes. Installer des plugins requiert l\'exécution de plusieurs commandes systèmes qui peuvent poser des problèmes de sécurité, particulièrement si vous utilisez des plugins de provenances inconnues. Vous tes averti des domages que peut causer l\'installation d\'un plugin. En d\'autres termes, vous installez des plugins à vos propres risques. Les instructions d\'installation des plugins sont incluses dans chaque plugin.',
    2 => 'Instructions d\'installation d\'un plugin',
    3 => 'Formulaire d\'installation d\'un plugin',
    4 => 'Fichier du plugin',
    5 => 'Liste des plugins',
    6 => 'Attention: plugin déjà installé!',
    7 => 'Le plugin que vous essayez d\'installer existe déjà.  Veuillez supprimer le plugin avant de le réinstaller.',
    8 => 'Test de compatibilité du plugin échoué',
    9 => 'Ce plugin requiert une version plus récente du système. Vous pouvez mettre à jour votre <a href=\'http://www.geeklog.net\'>système</a> ou obtenir une autre version du plugin.',
    10 => '<br' . XHTML . '><b>Aucun plugin n\'est actuellement installé.</b><br' . XHTML . '><br' . XHTML . '>',
    11 => 'Cliquez sur le numéro du plugin pour le modifier ou le supprimer. Pour en savoir d\'avantage sur les plugins, cliquez sur le nom du plugin et vous serez redirigé vers le site web du plugin. Pour installer ou mettre à jour un plugin veuillez vous référer à la documentation du plugin.',
    12 => 'Aucun nom de plugin n\'a été passé à plugineditor()',
    13 => 'Editeur de plugin',
    14 => 'Nouveau plugin',
    15 => 'Accueil Admin',
    16 => 'Nom du plugin',
    17 => 'Version du plugin',
    18 => 'Version de GL',
    19 => 'Activé',
    20 => 'Oui',
    21 => 'Non',
    22 => 'Installer',
    23 => 'Enregistrer',
    24 => 'Annuler',
    25 => 'Supprimer',
    26 => 'Nom du plugin',
    27 => 'Site web du plugin',
    28 => 'Version du plugin',
    29 => 'Version de GL',
    30 => 'Supprimer le plugin ?',
    31 => 'Etes-vous sûr de vouloir supprimer ce plugin? Toutes les données, fiches et structures utilisés par ce plugin seront détruites.  Si vous tes certain de vouloir supprimer le plugin, cliquez sur le bouton &laquo;Supprimer&raquo;.',
    32 => '<p><b>Erreur de format du lien automatique</b></p>',
    33 => 'Version du code',
    34 => 'Mise à jour',
    35 => 'Edition',
    36 => 'Code',
    37 => 'Données',
    38 => 'Mettre à jour!',
    39 => 'Upload un plugin',
    40 => 'Vous pouvez uploader une archive d\'un plugin (.tar.gz, .tgz, .zip) directement ici :',
    41 => 'Upload',
    42 => 'Cliquer pour mettre à jour',
    43 => 'Load Order',
    44 => 'Move plugin up the load order',
    45 => 'Move plugin down the load order',
    46 => 'Click to Delete this Plugin',
    47 => 'Really Delete %s Plugin?',
    48 => 'Click to Enable this Plugin',
    49 => 'Click to Disable this Plugin',
    50 => 'Dependencies',
    51 => 'OK',
    52 => 'Unresolved',
    53 => 'Disabled',
    54 => 'Unavailable',
    55 => 'Uninstalled',
    56 => 'Wrong Version',
    57 => 'Unknown',
    58 => 'The load order of one or more plugins has been altered in order to resolve dependencies',
    59 => 'Info',
    60 => 'Close',
    61 => 'Status',
    62 => 'Click to Install this Plugin',
    63 => 'This Plugin Cannot be Installed',
    64 => 'This Plugin Cannot be Enabled',
    65 => 'The plugin upload function has been disabled due to the following errors:',
    66 => 'File uploads are disabled in your PHP configuration.',
    67 => 'The directory "%s" is not writable.',
    68 => 'You do not have the required permissions to install plugins.',
    69 => 'You do not have the required permissions to upload plugins.',
    99 => 'Une erreur inconue s\'est produite',
    100 => 'Ok.',
    101 => 'Le fichier uploadé excéde la valeur upload_max_filesize du php.ini.',
    102 => 'Le fichier uploadé excéde la valeur MAX_FILE_SIZE spécifiée dans le formulaire HTML.',
    103 => 'Le fichier n\'a été que partiellement uploadé.',
    104 => 'Aucun fichier n\'a été uploadé.',
    105 => '(erreur indéfinie)',
    106 => 'Un dossier temporaire est mamnquant.',
    107 => 'Impossible de copier le fichier sur le disque.',
    108 => 'L\'upload du fichier à été intérrompu.'
);

###############################################################################
# admin/syndication.php

$LANG33 = array(
    1 => 'créez un flux',
    2 => 'sauvegardez',
    3 => 'effacez',
    4 => 'annulez',
    10 => 'Flux du contenu',
    11 => 'Nouveau flux',
    12 => 'Contrôles de l\'administration',
    13 => 'Cliquez sur le titre d\'un flux pour l\'effacer ou le modifier. Cliquez sur Ajouter pour en créer un nouveau.',
    14 => 'Titre',
    15 => 'Type',
    16 => 'Nom du fichier',
    17 => 'Format',
    18 => 'dernière mise à jour',
    19 => 'Activé',
    20 => 'Oui',
    21 => 'Non',
    22 => '<i>(pas de flux)</i>',
    23 => 'Toutes les catégories',
    24 => 'éditeur de flux',
    25 => 'Titre du flux',
    26 => 'Limite',
    27 => 'Taille des entrées',
    28 => '(0 = sans texte, 1 = plein texte, autre = limite du nombre de caractères.)',
    29 => 'Description',
    30 => 'Mise à jour',
    31 => 'Jeu de caractères',
    32 => 'Langue',
    33 => 'Contenu',
    34 => 'Entrées',
    35 => 'Heures',
    36 => 'Sélectionnez le type de flux',
    37 => '',
    38 => 'Erreur : champs incomplets',
    39 => 'Merci d\'inscrire le titre du flux, sa description, et son nom de fichier.',
    40 => 'Merci d\.inscrire un nombre d\'entrés ou un nombre d\'heures.',
    41 => 'Liens',
    42 => '',
    43 => 'Tout',
    44 => 'Rien',
    45 => 'Lien d\'entête dans le sujet',
    46 => 'Limite des résultats',
    47 => 'Recherche',
    48 => 'Edition',
    49 => 'Logo du flux',
    50 => "URL du site ({$_CONF['site_url']})",
    51 => 'Le nom de fichier choisi est présentement utilisé par un autre flux. Merci de choisir un nom différent.',
    52 => 'Erreur: nom de fichier existant',
    53 => 'All Frontpage Stories',
    54 => 'Please select the type of feed to create.',
    55 => 'Articles'
);

###############################################################################
# confirmation and error messages

$MESSAGE = array(
    1 => "Votre mot de passe a été envoyé par email et devrait vous parvenir sous peu. Suivez les instructions incluses dans le message pour vous connecter à l'espace membre de {$_CONF['site_name']}",
    2 => "Merci de proposer un article à {$_CONF['site_name']}.  Il a été envoyé à notre équipe qui en disposera. Votre article sera publié s'il est retenu.",
    3 => '',
    4 => '',
    5 => 'Vos informations ont été mises à jour avec succès.',
    6 => 'Vos préférences d\'affichage ont été mises à jour avec succès.',
    7 => 'Vos préférences de commentaire ont été mises à jour avec succès.',
    8 => 'Vous avez été déconnecté avec succès.',
    9 => 'Votre article a été enregistré avec succès.',
    10 => 'L\'article a été supprimé avec succès.',
    11 => 'Votre block a été enregistré avec succès.',
    12 => 'Le block a été supprimé avec succès.',
    13 => 'Votre catégorie a été enregistrée avec succès.',
    14 => 'La catégorie et tous ses articles ainsi que ses blocks ont été supprimés avec succès.',
    15 => 'Votre commentaire à été soumis et sera publié après validation par un modérateur.',
    16 => 'Vous avez été désabonné. Vous ne serez donc plus averti des nouvelles réponses.',
    17 => '',
    18 => '',
    19 => '',
    20 => '',
    21 => 'Le nouveau membre a été enregistré avec succès.',
    22 => 'L\'utilisateur a été supprimé avec succès.',
    23 => '',
    24 => '',
    25 => '',
    26 => '',
    27 => 'Message envoyé avec succès.',
    28 => 'Le plugin a été sauvegardé avec succès.',
    29 => 'Désolé, vous n\'avez pas accès à cette page d\'administration. Pour information, toutes les tentatives pour accéder aux fonctions non autorisées sont enregistrées.',
    30 => 'Accès réservé',
    31 => '',
    32 => '',
    33 => '',
    34 => '',
    35 => '',
    36 => '',
    37 => '',
    38 => '',
    39 => '',
    40 => 'Message',
    41 => '',
    42 => '',
    43 => '',
    44 => 'Le plugin a été installé avec succès!',
    45 => 'Le plugin a été supprimé avec succès.',
    46 => '',
    47 => '',
    48 => "Merci d'avoir demandé un compte membre sur {$_CONF['site_name']}. La demande a été envoyée à notre équipe qui en disposera. Lorsque la demande sera acceptée, votre mot de passe vous sera envoyé par email à l'adresse que vous avez fournie.",
    49 => 'Votre groupe a été enregistré avec succès.',
    50 => 'Le groupe a été supprimé avec succès.',
    51 => 'Ce nom de membre existe déjà. Prière d\'en choisir un nouveau.',
    52 => 'L\'email fourni ne paraît pas être valide.',
    53 => 'Votre nouveau mot de passe à été accepté. Prière de l\'inscrire ci-dessous pour accéder au site.',
    54 => 'Votre requte pour l\'obtention d\'un nouveau mot de passe est expirée. Prière d\'essayer de nouveau ci-dessous.',
    55 => 'Un email qui vient de vous être envoyé devrait vous parvenir sous peu. Merci de suivre les instructions du message et de procéder à l\'enregistrement de votre nouveau mot de passe.',
    56 => 'L\'adresse email fournie est déjà utilisée par un autre compte.',
    57 => 'Votre compte à été effacé avec succès.',
    58 => 'Votre flux a été enregistré avec succès.',
    59 => 'Votre flux a été effacé avec succès.',
    60 => 'La mise à jour de ce plugin est un succès',
    61 => 'Plugin %s: coordonnées de ce message inconnues',
    62 => 'Le commentaire du Trackback à été effacé.',
    63 => 'Une erreur est survenue et le commentaire du Trackback n\'à pas été effacé.',
    64 => 'Le commentaire du Trackback à été envoyé.',
    65 => 'Le directoire Weblog a bien été sauvegardé.',
    66 => 'Le directoire Weblog a bien été effacé.',
    67 => 'Le nouveau mot de passe semble différent de celui confirmé!',
    68 => 'Vous avez correctement inscrit le mot de passe actuel.',
    69 => 'Votre compte à été bloqué!',
    70 => 'Votre compte est en attente d\'activation',
    71 => 'Votre compte est en attente d\'activation, il doit tre approuvé par un admistrateur.',
    72 => 'Une erreur s\'est produite lors de l\'installation de ce plugin. Voyez error.log pour les détails.',
    73 => 'Une erreur s\'est produite lors de de la désinstallation de ce plugin. Voyez error.log pour les détails.',
    74 => 'Le Pingback à été envoyé avec succès.',
    75 => 'Les Trackbacks doivent tre envoyés suivant une requte POST.',
    76 => 'Désirez-vous vraiment effacer cet article ?',
    77 => 'ATTENTION:<br' . XHTML . '>Vous avez choisi UTF-8 comme encodage par défaut, malgré le fait que vos serveurs ne supportent pas un encodage multi-bit. Prière d\'installer les fonctions mbstring pour PHP ou choisissez une langue différente.',
    78 => 'Prière de vous assurer que l\'adresse email et l\'email de confirmation soient identiques.',
    79 => 'La page que vous tentez d\'ouvrir réfère à une fonctionalité désinstallée de ce site.',
    80 => 'Le plugin qui a créé ce lien a été désinstallé. Merci de réinstaller le plugin avant toute chose.',
    81 => 'Votre code d\'accès est erroné. Merci de réessayer.',
    82 => 'ACCèS REFUSé. Merci d\'attendre quelques temps avant de réessayer.',
    83 => 'Merci d\'utiliser votre mot de passe actuel si vous désirez changer votre profil.',
    84 => 'Merci d\'utiliser votre mot de passe actuel si vous désirez fermer votre compte.',
    85 => 'There was a problem sending the email.',
    86 => 'The OpenID server invalidated your login attempt.',
    87 => 'OpenID login operation cancelled by user.',
    88 => 'The OpenID server returned an error.',
    89 => 'Unable to find an OpenID server for the given identity URL.',
    90 => 'OpenID identification cancelled.',
    91 => 'You specified an invalid identity URL.',
    92 => "Please <a href=\"{$_CONF['site_admin_url']}/sectest.php\">check the security of your site</a> before using it!",
    93 => 'Database back up was successful.',
    94 => 'Backup Failed: Filesize less than 1kb',
    95 => 'Il y a eu une erreur.',
    96 => '',
    97 => '',
    98 => 'Le plugin à bien été uploadé.',
    99 => 'Le plugin existe déjà.',
    100 => 'Le fichier du plugin que vous avez uploadé n\'ést pas une archive compressée au format GZip ou Zip.',
    101 => 'Il n\'y a pas de catégorie à laquelle vous puissiez accéder. Vous avez besoin au moins d\'une catégorie pour pouvoir soumettre un article.',
    110 => 'Can not get URL for authentication.',
    111 => 'Authentication error.',
    112 => 'Certification has been canceled.',
    113 => 'Your account has been created successfully. {site_url}',
    114 => 'Your re-synch with your remote account has failed but your other account information has been successfully saved.',
    115 => 'Remote service has been disabled.',
    400 => 'Tous les champs nécessaires n\'ont pas passés la validation',
    401 => 'Saisir votre nom complet'
);

###############################################################################

$LANG_ACCESS = array(
    'access' => 'Accès',
    'ownerroot' => 'Propriétaire/Admin',
    'group' => 'Groupe',
    'readonly' => 'Lecture seule',
    'accessrights' => 'Droits d\'accès',
    'owner' => 'Propriétaire',
    'grantgrouplabel' => 'Autorisation au delà du groupe d\'édition',
    'permmsg' => 'REMARQUE : Les membres sont tous les utilisateurs identifiés et les anonymes sont tous les autres.',
    'securitygroups' => 'Groupe de sécurité',
    'editrootmsg' => "Vous pouvez modifier tous les utilisateurs exceptés les administrateurs. Toutes les tentatives de modifications d'un administrateur sont enregistrées. Retournez sur la <a href=\"{$_CONF['site_admin_url']}/user.php\">page d'administration</a>.",
    'securitygroupsmsg' => 'Sélectionner les cases des groupes auxquels l\'utilisateur appartient',
    'groupeditor' => 'Editeur de groupe',
    'description' => 'Description',
    'name' => 'Nom',
    'rights' => 'Droits',
    'missingfields' => 'Champs manquants',
    'missingfieldsmsg' => 'Vous devez saisir un nom et une description',
    'groupmanager' => 'Administrateur de groupe',
    'newgroupmsg' => 'Pour modifier ou supprimer un groupe, cliquez sur le groupe ci-dessous. Pour créer un nouveu groupe, cliquez sur Nouveau Groupe. Les groupes natifs ne peuvent pas tre supprimés car ils sont utilisés par le système.',
    'groupname' => 'Nom du groupe',
    'coregroup' => 'Groupe système',
    'yes' => 'Oui',
    'no' => 'Non',
    'corerightsdescr' => "Ce groupe est un groupe système de {$_CONF['site_name']}.  Les droits de ce groupe ne peuvent pas tre modifiés.  La liste ci-dessous des droits d'accès du groupe n'est pas modifiable.",
    'groupmsg' => 'Les droits des groupes sont hiérarchiques.  En ajoutant un groupe à un autre vous ajoutez tous les droits de ce groupe à l\'autre.  Lorsque c\'est possible, utilisez les groupes déja définis.  Si vous avez besoin de droits spécifiques, vous pouvez les choisir dans la liste ci-dessous.  Pour Ajouter un groupe à celui-ci cliquez sur la case du groupe à ajouter.',
    'coregroupmsg' => "Ce groupe est un groupe système de {$_CONF['site_name']}.  Les droits de ce groupe ne peuvent pas tre modifiés. La liste ci-dessous des groupes inclus de ce groupe n'est pas modifiable.",
    'rightsdescr' => 'Les droits suivants peuvent tre donnés directement au groupe OU provenir d\'un groupe inclus. Les droits sans case à cocher proviennent de groupe inclus. Les droits qui ont des cases à cocher sont donnés directement au groupe.',
    'lock' => 'Bloquer',
    'members' => 'Membres',
    'anonymous' => 'Anonymes',
    'permissions' => 'Permissions',
    'permissionskey' => 'R = lecture, E = modification, le droit de modification implique le droit de lecture',
    'edit' => 'Modifier',
    'none' => 'Rien',
    'accessdenied' => 'Accès réservé',
    'storydenialmsg' => "vous n'avez pas le droit de lire cette article. Peut-tre que vous n'tes pas membre de {$_CONF['site_name']}.  Vous pouvez <a href=\"{$_CONF['site_url']}/users.php?mode=new\">vous enregistrer</a> sur {$_CONF['site_name']} pour obtenir un compte membre!",
    'nogroupsforcoregroup' => 'Le groupe n\'inclue aucun autre groupe',
    'grouphasnorights' => 'Le groupe n\'a pas accès aux fonctions administratives',
    'newgroup' => 'Nouveau Groupe',
    'adminhome' => 'Accueil Admin',
    'save' => 'enregistrer',
    'cancel' => 'annuler',
    'delete' => 'supprimer',
    'canteditroot' => 'Vous avez essayé de modifier le groupe administrateur mais vous n\'en faites pas partie. Vous n\'avez pas accès à ce groupe. Veuillez contacter l\'administrateur si vous pensez que c\'est une erreur.',
    'listusers' => 'Liste des utilisateurs',
    'listthem' => 'liste',
    'usersingroup' => 'Utilisateurs dans le groupe "%s"',
    'usergroupadmin' => 'Administration du groupe des utilisateurs',
    'add' => 'Ajoutez',
    'remove' => 'Enlevez',
    'availmembers' => 'Membres disponibles',
    'groupmembers' => 'Membres du groupe',
    'canteditgroup' => 'Vous devez tre un membre de ce groupe pour l\'éditer.',
    'cantlistgroup' => 'Vous devez tre un membre de ce groupe pour en voir les autres membres.',
    'editgroupmsg' => 'Cliquez sur le nom des membres et sur <b>Ajouter</b> ou <b>Enlevez</b> pour modifier le membership du groupe. Si le membre est un membre du groupe, son nom apparaîtra sur le côté droit seulement. Une fois le processus terminé, cliquez sur <b>enregister</b> pour mettre à jour et revenir au début.',
    'listgroupmsg' => 'Liste des membres actuels du groupe : <b>%s</b>',
    'search' => 'Recherche',
    'submit' => 'Soumettre',
    'limitresults' => 'Limite des resultats',
    'group_id' => 'Groupe ID',
    'plugin_access_denied_msg' => 'Tentative illégale d\'accès aux données!  Toutes les tentatives sont prise en note.',
    'groupexists' => 'Nom de groupe déjà existant',
    'groupexistsmsg' => 'Il y a déjà un groupe portant ce nom. Merci d\'en choisir un autre.'
);

###############################################################################
# admin/database.php

$LANG_DB_BACKUP = array(
    'last_ten_backups' => '10 dernieres sauvegardes',
    'do_backup' => 'Faire une sauvegarde',
    'backup_successful' => 'Sauvegarde de la base de donnée effectuée avec succès',
    'db_explanation' => 'Cliquez sur le bouton ci-dessous pour effectuer une sauvegarde de votre système',
    'not_found' => "Chemin incorrect ou le fichier mysqldump n'est pas exécutable.<br'\n                    . XHTML . '>Vérifiez le paramètre <strong>mysqldump_path</strong> sur la page de configuration.<br" . XHTML . "> Vérifiez le règlage <a href=\"http://www.php.net/manual/en/features.safe-mode.php#ini.open-basedir\">open_basedir</a> dans PHP.<br" . XHTML . ">Ce paramètre est actuellement positionné à : <var>{$_DB_mysqldump_path}</var>",
    'zero_size' => 'Sauvegarde échouée: la taille du fichier était de 0 octets.',
    'path_not_found' => "{$_CONF['backup_path']} n'existe pas ou n'est pas un répertoire.",
    'no_access' => "Erreur: le répertoire {$_CONF['backup_path']} n'est pas accessible.",
    'backup_file' => 'Fichier de sauvegarde',
    'size' => 'Taille',
    'bytes' => 'Octets',
    'total_number' => 'Nombre total de sauvegardes : %d',
    'download' => 'Cliquez pour télécharger ce fichier',
    'new_backup' => 'Nouvelle sauvegarde',
    'delete_failure' => 'One or more backup files could not be deleted.',
    'delete_success' => 'Backup file(s) successfully deleted.',
    'convert_menu' => 'Convert to InnoDB',
    'convert_title' => 'Convert to InnoDB tables',
    'convert_button' => 'Convert',
    'sorry_no_innodb' => 'Sorry, your version of MySQL does not support InnoDB tables.',
    'innodb_explain' => 'InnoDB tables provide better performance on <em>really</em> large databases but make the backup process more complicated. Please <a href="http://dev.mysql.com/doc/mysql/en/innodb.html">read up</a> on the pros and cons of InnoDB tables before you perform this operation.',
    'already_converted' => 'Note: It appears that all of the tables have already been converted to InnoDB.',
    'conversion_patience' => 'Note: Conversion may take some time - please be patient.',
    'innodb_success' => 'Successfully converted tables to InnoDB.',
    'table_issues' => 'There may have been problems with some tables, though. Please check error.log for details.',
    'optimize_menu' => 'Optimize Tables',
    'optimize_title' => 'Optimize Tables',
    'optimize_button' => 'Optimize',
    'optimize_explain' => 'Optimizing tables may help to improve the performance of your site. The actual impact depends on the table usage and some tables may benefit from it more than others. Do no expect to see a huge difference in performance. The <a href="http://dev.mysql.com/doc/mysql/en/optimize-table.html">MySQL manual</a> states: <q>it is not likely that you need to do this more than once a week or month</q>.',
    'last_optimization' => 'Last optimization',
    'optimization_patience' => 'Note: Optimization may take some time - please be patient.',
    'optimize_success' => 'Successfully optimized database tables.'
);

###############################################################################

$LANG_BUTTONS = array(
    1 => 'Home',
    2 => 'Contact',
    3 => 'Ecrire un article',
    4 => '',
    5 => '',
    6 => '',
    7 => 'Statistiques du site',
    8 => 'Personnaliser',
    9 => 'Chercher',
    10 => 'Recherche',
    11 => 'Archives'
);

###############################################################################
# 404.php

$LANG_404 = array(
    1 => 'Erreur 404',
    2 => 'Le système ne trouve pas <b>http://</b>.',
    3 => "<p>Le fichier que vous demandez n'existe pas. Allez à la <a href=\'{$_CONF['site_url']}\'>page principale</a> ou la <a href=\'{$_CONF['site_url']}/search.php\'>page de recherche</a> afin de retrouver ce que vous avez perdu."
);

###############################################################################
# login form

$LANG_LOGIN = array(
    1 => 'Vous devez vous connecter',
    2 => 'Vous devez vous identifier à l\'aide de l\'espace membre pour accéder à cette partie du site.',
    3 => 'Accueil',
    4 => 'Nouveau membre'
);

###############################################################################
# trackback.php

$LANG_TRB = array(
    'trackback' => 'Trackback',
    'from' => 'de',
    'tracked_on' => 'Pisté sur',
    'read_more' => '[lire la suite]',
    'intro_text' => 'Voici ce que les autres ont à dire de \'%s\':',
    'no_comments' => 'Aucun Trackback pour l\'instant.',
    'this_trackback_url' => 'URL de Trackback :',
    'num_comments' => '%d Trackbacks',
    'send_trackback' => 'Envoyez un ping',
    'preview' => 'Pré-visualisez',
    'editor_title' => 'Envoyez un commentaire au sujet du Trackback',
    'trackback_url' => 'URL de Trackback',
    'entry_url' => 'URL de la soumission',
    'entry_title' => 'Titre de la soumission',
    'blog_name' => 'Nom du site',
    'excerpt' => 'Extrait',
    'truncate_warning' => 'Note: le site récepteur peut raccoucir votre extrait',
    'button_send' => 'Envoyez',
    'button_preview' => 'Pré-visualisez',
    'send_error' => 'Erreur',
    'send_error_details' => 'Erreur dans l\'envoi du commentaire de ce Trackback :',
    'url_missing' => 'Pas d\'URL de soumission',
    'url_required' => 'Merci d\'inscrire un URL pour cette soumission.',
    'target_missing' => 'Pas d\'URL de Trackback',
    'target_required' => 'Merci d\'inscrire un URL pour ce Trackback',
    'error_socket' => 'N\'a pu accédé aux données.',
    'error_response' => 'Réponse incomprise.',
    'error_unspecified' => 'Erreur non spécifique.',
    'select_url' => 'Sélectionnez un URL pour ce Trackback',
    'not_found' => 'L\'URL de ce Trackback est inconnu',
    'autodetect_failed' => 'Le système n\'a pu détecter l\'URL du Trackback que vous désirez commenter. Merci de l\'inscrire manuellement.',
    'trackback_explain' => 'Merci de sélectionner l\'URL vers lequel vous souhaitez envoyer votre Trackback à partir des liens ci-dessous, ou alors inscrivez-le manuellement <a href="%s"> en cliquant ici</a> s\'il ne s\'y trouve pas.',
    'no_links_trackback' => 'Aucun lien trouvé. Vous ne pouvez commenter le Trackback lié à cette soumission.',
    'pingback' => 'Pingback',
    'pingback_results' => 'Résultat des Pingbacks',
    'send_pings' => 'Envoyez un ping',
    'send_pings_for' => 'Envoyez un ping pour "%s"',
    'no_links_pingback' => 'Aucun lien trouvé. Vous ne pouvez envoyer un Pingback lié à cette soumission.',
    'pingback_success' => 'Pingback envoyé.',
    'no_pingback_url' => 'Aucun URL lié à ce Pingback n\'a été identifié.',
    'resend' => 'Renvoi',
    'ping_all_explain' => 'Vous pouvez maintenant avertir les sites dont vous donné un lien (<a href="http://en.wikipedia.org/wiki/Pingback">Pingback</a>), ou avertir que votre site à été modifié en lançant un ping aux répertoires de blog, ou encore envoyer un <a href="http://en.wikipedia.org/wiki/Trackback">Trackback</a> au cas o&ugrave; vous ayez commenté les propos trouvés sur un autre site.',
    'pingback_button' => 'Envoyez un Pingback',
    'pingback_short' => 'Envoyez un Pingback à tous les sites liés à cette soumission.',
    'pingback_disabled' => '(Pingbacks désactivés)',
    'ping_button' => 'Envoyez un ping',
    'ping_short' => 'Envoyez un ping aux répertoires de blog.',
    'ping_disabled' => '(Pings désactivés)',
    'trackback_button' => 'Envoyez un Trackback',
    'trackback_short' => 'Envoyez un commentaire de Trackback.',
    'trackback_disabled' => '(Trackbacks désactivés)',
    'may_take_a_while' => 'Merci de noter que l\'envoi de pings et de Pingbacks peut prendre un certain temps.',
    'ping_results' => 'Résultats des pings',
    'unknown_method' => 'Méthode de ping inconnue',
    'ping_success' => 'Ping envoyé.',
    'error_site_name' => 'Inscrire le nom du site.',
    'error_site_url' => 'Inscrire l\'URL du site.',
    'error_ping_url' => 'Inscrire un URL de ping valide.',
    'no_services' => 'Aucun répertoire de blog n\'a été configuré.',
    'services_headline' => 'Répertoire de blog',
    'service_explain' => 'Cliquez sur l\'icone correspondant au répertoire de blog que vous souhaitez modifier ou effacer. Cliquez sur Ajouter pour paramétrer un nouveau répertoire de blog.',
    'service' => 'Service',
    'ping_method' => 'Méthode de ping',
    'service_website' => 'Site web',
    'service_ping_url' => 'Je ping cet URL',
    'ping_standard' => 'Ping standard',
    'ping_extended' => 'Ping étendu',
    'ping_unknown' => '(méthode inconnue)',
    'edit_service' => 'éditez les répertoires de blog',
    'trackbacks' => 'Trackbacks',
    'editor_intro' => 'Préparez vos commentaires de Trackback pour <a href="%s">%s</a>.',
    'editor_intro_none' => 'Préparez vos commentaires de Trackback.',
    'trackback_note' => 'Si vous désirez envoyer un Trackback, voyez la liste des articles et cliquez sur "Envoyez un ping" correspondant à l\'article que vous souhaitez commenter. <a href="%s">Cliquez ici</a> pour envoyer un Trackback qui n\'est lié à aucun article.',
    'pingback_explain' => 'Inscrivez l\'URL à qui il faudra envoyer le Pingback. Le Pingback pointera en direction de la page d\'accueil de votre site.',
    'pingback_url' => 'URL du Pingback',
    'site_url' => 'URL du site',
    'pingback_note' => 'Si vous désirez envoyer un Pingback, consultez la liste des articles et cliquez sur "Envoyez un ping" correspondant à l\'article que vous souhaitez commenter. <a href="%s">Cliquez ici</a> pour envoyer un Pingback qui n\'est lié à aucun article.',
    'pbtarget_missing' => 'Aucun URL pour ce Pingback',
    'pbtarget_required' => 'Merci d\'inscrire un URL pour ce Pingback',
    'pb_error_details' => 'Une erreur est survenue dans l\'envoi de ce Pingback :',
    'delete_trackback' => 'Cliquez pour effacer ce Trackback: '
);

###############################################################################
# directory.php

$LANG_DIR = array(
    'title' => 'Liste des articles',
    'title_year' => 'Liste des articles en %d',
    'title_month_year' => 'Liste des articles en %s %d',
    'nav_top' => 'Retour à la liste des articles',
    'no_articles' => 'Pas d\'articles.'
);

###############################################################################
# admin/sectest.php

$LANG_SECTEST = array(
    'sectest' => 'Geeklog vérification de la sécurité',
    'results' => 'Resultats de la vérification de la sécurité',
    'okay' => 'Tout semble être en ordre.',
    'please_fix' => 'Merci de corriger les problèmes ci-dessus avant d\'utiliser votre site!',
    'please_note' => 'Notez qu\'aucun site n\'est sécurisé à 100%. Ce script teste uniquement les problème évidents.',
    'stay_informed' => 'Pour rester informé des nouvelles versions de Geeklog et des possibles problèmes de sécurité, nous vous suggérons de vous abonner (petit trafic) à la %s mailing list et/ou utiliser l\'option %s de l\'interface d\'administration de temps en temps pour vérifier les mises à jour disponibles.',
    'public_html' => '"public_html" ne devrait jamais faire partie de l\'URL de votre site.  Merci de lire le paragraphe a propos du public_html dans les %s et de changer votre paramètrage avant de continuer.',
    'installation' => 'Instructions d\'installation',
    'directory' => 'directory',
    'failed_tmp' => 'Failed to create a temporary file in your data directory. Check your directory permissions!',
    'fix_it' => 'This is a security risk and should be fixed!',
    'reachable' => 'Your %s is reachable from the web.',
    'not_reachable' => 'Good! Your %s is not reachable from the web.',
    'not_sure' => 'Got an HTTP result code %s when trying to test your %s. Not sure what to make of it ...',
    'remove_inst' => 'You should really remove the install directory %s once you have your site up and running without any errors.',
    'remove_inst2' => 'Keeping it around would allow malicious users the ability to destroy your current install, take over your site, or retrieve sensitive information.',
    'inst_removed' => 'Good! You seem to have removed the install directory already.',
    'fix_password' => 'You still have not changed the <strong>default password</strong> from "password" on %s Root user account(s).',
    'password_okay' => 'Good! You seem to have changed the default account password already.'
);

###############################################################################
# "What's New" Time Strings
# 
# For the first two strings, you can use the following placeholders.
# Order them so it makes sense in your language:
# %i    item, "Stories"
# %n    amount, "2", "20" etc.
# %t    time, "2" (weeks)
# %s    scale, "hrs", "weeks"

$LANG_WHATSNEW = array(
    'new_string' => '%n %i',
    'new_last' => 'last %t %s',
    'minutes' => 'minutes',
    'hours' => 'heures',
    'days' => 'jours',
    'weeks' => 'semaines',
    'months' => 'mois',
    'years' => 'years',
    'minute' => 'minute',
    'hour' => 'heure',
    'day' => 'jour',
    'week' => 'semaine',
    'month' => 'mois',
    'year' => 'year'
);

###############################################################################
# Month names

$LANG_MONTH = array(
    1 => 'Janvier',
    2 => 'Février',
    3 => 'Mars',
    4 => 'Avril',
    5 => 'Mai',
    6 => 'Juin',
    7 => 'Juillet',
    8 => 'Ao&ucirc;t',
    9 => 'Septembre',
    10 => 'Octobre',
    11 => 'Novembre',
    12 => 'Décembre'
);

###############################################################################
# Weekdays

$LANG_WEEK = array(
    1 => 'Dimanche',
    2 => 'Lundi',
    3 => 'Mardi',
    4 => 'Mercredi',
    5 => 'Jeudi',
    6 => 'Vendredi',
    7 => 'Samedi'
);

###############################################################################
# Admin - Strings
# 
# These are some standard strings used by core functions as well as plugins to
# display administration lists and edit pages

$LANG_ADMIN = array(
    'search' => 'Recherche',
    'limit_results' => 'Limite des résultats',
    'submit' => 'Soumettre',
    'edit' => 'Editer',
    'edit_adv' => 'Adv. Edit',
    'admin_home' => 'Menu administratif',
    'create_new' => 'Ajouter',
    'create_new_adv' => 'Nouveau (Avencé)',
    'enabled' => 'Activer',
    'disabled' => 'Disabled',
    'title' => 'Titre',
    'page_title' => 'Titre de la page',
    'type' => 'Type',
    'topic' => 'Sujet',
    'info' => 'Info',
    'help_url' => 'URL d\'aide',
    'save' => 'Sauvegarder',
    'cancel' => 'Annuler',
    'install' => 'Install',
    'delete' => 'Effacer',
    'deleteitem' => 'Delete',
    'delete_sel' => 'Delete selected',
    'copy' => 'Copier',
    'no_results' => '- Aucune entrée -',
    'data_error' => 'Il y a eu erreur dans le traitement des données. Merci d\'en vérifier la source.',
    'preview' => 'Preview',
    'records_found' => 'Records found',
    'addchild' => 'Add child',
    'list' => 'list',
    'list_all' => 'List all',
    'meta_description' => 'Meta Description',
    'meta_keywords' => 'Meta Keywords',
    'na' => 'N/A',
    'unavailable' => 'N/A',
    'warning' => '!!!',
    'token_expiry' => 'Vous avez jusque %s pour saisir vos informations. Passé ce délais et pour des raisons de sécurité, vous perdrez votre saisie.',
    'token_expired' => 'Le délais de sécurité pour cette opératiton à expiré. Merci de vous identifier à nouveau pour continuer.',
    'reauth_msg' => 'Le délais de sécurité pour cette opératiton à expiré. Si vous souhaitez poursuivre l\'opération, merci de vous identifier à nouveau ci-dessous. Cela permettra de conserver vos dernières modifications.',
    'authenticate' => 'Authenticate'
);

# Localisation of the texts for the various drop-down menus that are actually
# stored in the database. If these exist, they override the texts from the
# database.

$LANG_commentcodes = array(
    0 => 'Autoriser les commentaires',
    -1 => 'Interdire les commentaires',
    1 => 'Suspendre les commentaires'
);

$LANG_commentmodes = array(
    'flat' => 'A plat',
    'nested' => 'Nichés',
    'threaded' => 'Regroupés',
    'nocomment' => 'Non affichés'
);

$LANG_cookiecodes = array(
    0 => 'Non',
    3600 => '1 heure',
    7200 => '2 heures',
    10800 => '3 heures',
    28800 => '8 heures',
    86400 => '1 jour',
    604800 => '1 semaine',
    2678400 => '1 mois'
);

$LANG_dateformats = array(
    0 => 'Défaut du système'
);

$LANG_featurecodes = array(
    0 => 'Pas en vedette',
    1 => 'En vedette'
);

$LANG_frontpagecodes = array(
    0 => 'Afficher avec le sujet seulement',
    1 => 'Afficher en page d\'accueil'
);

$LANG_postmodes = array(
    'plaintext' => 'Texte seul',
    'html' => 'Format HTML'
);

$LANG_sortcodes = array(
    'ASC' => 'Anciens en premier',
    'DESC' => 'Nouveaux en premier'
);

$LANG_trackbackcodes = array(
    0 => 'Trackback activé',
    -1 => 'Trackback désactivé'
);

###############################################################################
# Localization of the Admin Configuration UI

$LANG_CONFIG = array(
    'home' => 'Accueil',
    'admin_home' => 'Administration du site',
    'sections' => 'Configuration',
    'restore' => 'Restaurer',
    'add_element' => 'Ajouter un élément',
    'save_changes' => 'Sauvegarder les changements',
    'reset_form' => 'Remise à zéro',
    'changes_made' => 'Les changements suivants ont été effectués',
    'title' => 'Panneau de Configuration',
    'disable' => 'Cliquer pour mettre hors de service',
    'enable' => 'Mettre en service',
    'default_tab_name' => 'Main',
    'search_configuration_label' => 'Search Configuration',
    'error_validation_occurs' => 'There are invalid configuration values. Please correct these fields (just click the config variable to point you to the error field)'
);

$LANG_configsections['Core'] = array(
    'label' => 'Geeklog',
    'title' => 'Configuration de Geeklog'
);

$LANG_confignames['Core'] = array(
    'path_html' => 'Chemin vers HTML',
    'site_url' => 'URL du site',
    'site_admin_url' => 'URL de l\'administration',
    'site_mail' => 'Email du site',
    'noreply_mail' => 'Email No-Reply',
    'site_name' => 'Nom du site',
    'site_slogan' => 'Slogan du site (optionnel)',
    'owner_name' => 'Owner Name',
    'microsummary_short' => 'Microsummary',
    'path_log' => 'Logs',
    'path_language' => 'Langages',
    'backup_path' => 'Backups',
    'path_data' => 'Datas',
    'path_images' => 'Images',
    'path_pear' => 'Chemin vers Pear',
    'have_pear' => 'Avez vous Pear',
    'mail_settings' => 'Mail ',
    'allow_mysqldump' => 'Permettre le dump MySQL',
    'mysqldump_path' => 'Chemin vers l\'exécutable',
    'mysqldump_options' => 'Options de MySQL Dump',
    'mysqldump_filename_mask' => 'Backup File Name Mask',
    'theme' => 'Thème',
    'doctype' => 'DOCTYPE Déclaration',
    'menu_elements' => 'Eléments de navigation',
    'path_themes' => 'Chemin vers les Thèmes',
    'disable_new_user_registration' => 'Mettre hors service les nouvelles inscriptions',
    'allow_user_themes' => 'Permettre aux utilisateurs de choisir le thème',
    'allow_user_language' => 'Permettre aux utilisateurs de choisir la langue',
    'allow_user_photo' => 'Permettre aux utilisateurs d\'utiliser une photo',
    'allow_username_change' => 'Permettre aux utilisateurs de changer de login',
    'allow_account_delete' => 'Permettre aux utilisateurs de supprimer leur compte',
    'hide_author_exclusion' => 'Permettre aux utilisateur de cacher un auteur',
    'show_fullname' => 'Montrer le nom complet des membres',
    'show_servicename' => 'Montrer le nom du service',
    'custom_registration' => 'Permettre l\'enregistrement personnalisé',
    'user_login_method' => 'Autoriser la connexion',
    'facebook_login' => 'Enable OAuth Login Method Facebook',
    'facebook_consumer_key' => 'Facebook OAuth Application ID',
    'facebook_consumer_secret' => 'Facebook OAuth Application Secret',
    'linkedin_login' => 'Enable OAuth Login Method LinkedIn',
    'linkedin_consumer_key' => 'LinkedIn OAuth API Key',
    'linkedin_consumer_secret' => 'LinkedIn OAuth Secret Key',
    'twitter_login' => 'Enable OAuth Login Method Twitter',
    'twitter_consumer_key' => 'Twitter OAuth Consumer Key',
    'twitter_consumer_secret' => 'Twitter OAuth Consumer Secret',
    'spamx' => 'Actions Spam-X',
    'sort_admin' => 'Tri des liens',
    'language' => 'Langage',
    'locale' => 'Locale',
    'date' => 'Format de la date',
    'daytime' => 'Format Jour et heure',
    'shortdate' => 'Format date courte',
    'dateonly' => 'Format date uniquement',
    'timeonly' => 'Format heure uniquement',
    'week_start' => 'Début de semaine',
    'hour_mode' => 'Mode des heures',
    'thousand_separator' => 'Séparateur des centaines',
    'decimal_separator' => 'Séparateur décimal',
    'decimal_count' => 'Nombre de décimal',
    'language_files' => 'Fichiers langage',
    'languages' => 'Langages',
    'timezone' => 'Fuseau horaire',
    'site_disabled_msg' => 'Message du site hors service ou URL',
    'rootdebug' => 'Root Debugging (toujours faux pour un site en production)',
    'cookie_session' => 'Nom du cookie Session',
    'cookie_name' => 'Nom du cookie Permanent',
    'cookie_password' => 'Nom du cookie Password',
    'cookie_theme' => 'Nom du cookie Theme',
    'cookie_language' => 'Nom du cookie Language',
    'cookie_tzid' => 'Nom du cookie Timezone',
    'cookie_anon_name' => 'Anon. Username Cookie Name',
    'cookie_ip' => 'Ajouter l\'IP au Cookies',
    'default_perm_cookie_timeout' => 'Permanent Timeout',
    'session_cookie_timeout' => 'Session Timeout',
    'cookie_path' => 'Cookie Path',
    'cookiedomain' => 'Cookie Domain',
    'cookiesecure' => 'Cookie Secure',
    'lastlogin' => 'Enregistrer la dernière connexion',
    'num_search_results' => 'Nombre de résultats des recherches',
    'loginrequired' => 'Connexion nécessaire',
    'submitloginrequired' => 'Connexion nécessaire pour les soumissions',
    'commentsloginrequired' => 'Connexion nécessaire pour ajouter un commentaire',
    'statsloginrequired' => 'Connexion nécessaire pour consulter les statistiques',
    'searchloginrequired' => 'Connexion nécessaire pour effectuer une recherche',
    'profileloginrequired' => 'Connexion nécessaire pour consulter un profil',
    'emailuserloginrequired' => 'Connexion nécessaire pour expédier un email aux membres',
    'emailstoryloginrequired' => 'Connexion nécessaire pour expédier un article par email',
    'directoryloginrequired' => 'Connexion nécessaire pour consulter la liste des archives',
    'storysubmission' => 'Mise en attente des soumissions d\'articles',
    'usersubmission' => 'Mise en attente des soumission de membres',
    'listdraftstories' => 'Liste des articles brouillons',
    'notification' => 'Notifications',
    'postmode' => 'Mode de publication par défault',
    'speedlimit' => 'Limitation entre les publications',
    'skip_preview' => 'Donner la possibilité d\'éviter la prévisualisation',
    'advanced_editor' => 'Activer l\'editeur avancé',
    'wikitext_editor' => 'Activer l\'éditeur Wikitext',
    'cron_schedule_interval' => 'Intervalle du Cron interne',
    'sortmethod' => 'Classement des catégories',
    'showstorycount' => 'Afficher le nombre d\'article dans chaque catégorie',
    'showsubmissioncount' => 'Afficher le nombre de soumissions dans chaque catégories',
    'hide_home_link' => 'Cacher le lien Accueil',
    'whosonline_threshold' => 'Intervalle pour le calcul du nombre de visiteurs en ligne',
    'whosonline_anonymous' => 'Cacher le nom des membres aux visiteurs anonymes',
    'whosonline_photo' => 'Display Thumbnail Photo?',
    'emailstories' => 'Activer le résumé quotidien',
    'emailstorieslength' => 'Longueur des articles',
    'emailstoriesperdefault' => 'Activer le résumé quotidien par défault à tous les nouveaux membres',
    'allow_domains' => 'Autoriser automatiquement les domaines',
    'disallow_domains' => 'Interdire automatiquement les domaines',
    'newstoriesinterval' => 'Intervalle nouveaux articles',
    'newcommentsinterval' => 'Intervalle nouveaux commentaires',
    'newtrackbackinterval' => 'Intervalle nouveaux trackbacks',
    'hidenewstories' => 'Cacher les nouveaux articles',
    'hidenewcomments' => 'Cacher les nouveaux commentaires',
    'hidenewtrackbacks' => 'Cacher les nouveaux trackbacks',
    'hidenewplugins' => 'Cacher les nouvelles entrées des plugins',
    'title_trim_length' => 'Ajuster la longueur des titres',
    'trackback_enabled' => 'Activer la function Trackback',
    'pingback_enabled' => 'Activer la function Pingback',
    'ping_enabled' => 'Activer la function Ping',
    'trackback_code' => 'Trackback - Paramètres par défaut',
    'multiple_trackbacks' => 'Trackbacks multiples',
    'trackbackspeedlimit' => 'Intervalle minimum entre trackbacks',
    'check_trackback_link' => 'Vérification des trackbacks',
    'pingback_self' => 'Permettre des auto Pingback',
    'pingback_excerpt' => 'Créer des exception Pingback',
    'link_documentation' => 'Afficher un lien vers la documentation',
    'link_versionchecker' => 'Afficher un lien de vérification de la version de geeklog',
    'maximagesperarticle' => 'Maximum d\'images par article',
    'limitnews' => 'Nombre d\'article(s) par page',
    'minnews' => 'Minimum d\'article(s) par page',
    'contributedbyline' => 'Afficher dans les articles le nom de l\'auteur',
    'hideviewscount' => 'Masquer le nombre de lectures',
    'hideemailicon' => 'Masquer le lien ou l\'icon Email',
    'hideprintericon' => 'Masquer le lien l\'icon Imprimer',
    'allow_page_breaks' => 'Permettre la multi-pagination',
    'page_break_comments' => 'Où afficher les commentaires des articles multi-pages',
    'article_image_align' => 'Placer l\'icon de la catégorie',
    'show_topic_icon' => 'Par défaut afficher l\'icon de la catégorie',
    'draft_flag' => 'Article enregisté en brouillon par défaut',
    'frontpage' => 'Article publié sur la page principale par défaut',
    'hide_no_news_msg' => 'Masquer le message "Pas d\'article"',
    'hide_main_page_navigation' => 'Masque la navigation de la page principale',
    'onlyrootfeatures' => 'Uniquement le Root peut "Featuré"',
    'aftersave_story' => 'Après la sauvegarde d\'un article',
    'aftersave_user' => 'Après la sauvegarde d\'un membre',
    'show_right_blocks' => 'Toujours afficher les blocks de gauche',
    'showfirstasfeatured' => 'Afficher le premier article "Featuré"',
    'backend' => 'Activer les Flux',
    'rdf_file' => 'Chemin et fichier principal de syndication',
    'rdf_limit' => 'Limiter le nombre d\'articles du flux à',
    'rdf_storytext' => 'Longueur des articles du flux',
    'rdf_language' => 'Langue du flux',
    'syndication_max_headlines' => 'Maximum de titres pour un block portal',
    'copyrightyear' => 'Année(s) du Copyright',
    'image_lib' => 'Librairie image',
    'path_to_mogrify' => 'Chemin vers Mogrify',
    'path_to_netpbm' => 'Chemin vers Netpbm',
    'debug_image_upload' => 'Debuggage au télélchargement des images',
    'keep_unscaled_image' => 'Conserver l\'image non redimentionnée',
    'allow_user_scaling' => 'Permettre aux membres de redimensionner',
    'jpeg_quality' => 'Qualitée JPEG',
    'max_image_width' => 'Largeur maxi de l\'image',
    'max_image_height' => 'Hauteur maxi de l\'image',
    'max_image_size' => 'Taille maxi de l\'image',
    'max_topicicon_width' => 'Largeur maxi de l\'icon des catégories',
    'max_topicicon_height' => 'Hauteur maxi de l\'icon des catégories',
    'max_topicicon_size' => 'Taille maxi de l\'icon des catégories',
    'max_photo_width' => 'Largeur maxi des photos',
    'max_photo_height' => 'Hauteur maxi des photos',
    'max_photo_size' => 'Taille maxi des photos',
    'use_gravatar' => 'Utiliser Gravatar.com',
    'gravatar_rating' => 'Evaluation Gravatar permise',
    'force_photo_width' => 'Imposer la largeur des photos',
    'default_photo' => 'Photo par défaut',
    'commentspeedlimit' => 'Intervalle minimum entre les commentaires',
    'comment_limit' => 'Limiter le nombre de commentaires',
    'comment_mode' => 'Affichage des commentaires par défaut',
    'comment_code' => 'Valeur par défaut pour les nouveaux articles',
    'comment_edit' => 'Permettre l\'édition des commentaires',
    'comment_edittime' => 'Durée pendant laquelle un commentaire peut être édité (secondes)',
    'commentsubmission' => 'File d\'attente des soumissions des commentaires',
    'passwordspeedlimit' => 'Intervalle minimum entre les requète d\'un nouveau mot de passe',
    'login_attempts' => 'Nombre maximum de tentatives de connexions',
    'login_speedlimit' => 'Intervalle minimum entre tentavives de connexions echouées',
    'user_html' => 'HTML pour les membres',
    'admin_html' => 'HTML pour l\'administrateur',
    'advanced_html' => 'HTML additionnel pour l\'éditeur avancé',
    'skip_html_filter_for_root' => 'Contourner le filtre HTML pour l\'administrateur principal (root)',
    'allowed_protocols' => 'Protocoles autorisés',
    'disable_autolinks' => 'Désactiver les Autolinks',
    'clickable_links' => 'Rendre les URLs cliquables',
    'compressed_output' => 'Envoyer l\'output compréssé',
    'frame_options' => 'Protection contre "clickjacking"',
    'censormode' => 'Mode censure',
    'censorreplace' => 'Texte de remplacement',
    'censorlist' => 'Liste des termes censurés',
    'ip_lookup' => 'Recherche IP',
    'url_rewrite' => 'Activer la réécriture des URL',
    'cdn_hosted' => 'Use CDN-hosted copy of jQuery',
    'meta_tags' => 'Meta Tags',
    'meta_description' => 'Meta Description par défaut',
    'meta_keywords' => 'Meta Keywords par défaut',
    'default_permissions_block' => 'Permissions par défaut des Blocks',
    'default_permissions_story' => 'Permissions par défaut des articles',
    'default_permissions_topic' => 'Permissions par défaut des catégories',
    'atom_max_stories' => 'Nombre maxi d\'articles dans les flux des Webservices',
    'disable_webservices' => 'Désactiver les Webservices',
    'restrict_webservices' => 'Restreindre les Webservices',
    'article_comment_close_enabled' => 'Clôturer automatiquement les commentaires (par défaut)',
    'article_comment_close_days' => 'Nombre de jours pour clore les commenataires (par défaut)',
    'comment_close_rec_stories' => 'Nombre des articles les plus récents pour lesquels activer les commentaires',
    'allow_reply_notifications' => 'Permettre les notifications de réponse aux commentaires',
    'search_style' => 'Style de résultats',
    'search_limits' => 'Limites du nombre de pages',
    'search_show_num' => 'Montrer le nombre de résultats',
    'search_show_type' => 'Montrer le type de résultats',
    'search_show_sort' => 'Permettre aux utilisateurs de classer les résultats',
    'search_show_limit' => 'Montrer les limites',
    'search_separator' => 'Séparateur des groupes',
    'search_def_keytype' => 'Méthode de recherche par défaut',
    'search_def_sort' => 'Ordre de recherche par défaut',
    'autotag_permissions_story' => '[story: ] Permissions',
    'autotag_permissions_user' => '[user: ] Permissions'
);

$LANG_configsubgroups['Core'] = array(
    'sg_site' => 'Site',
    'sg_stories' => 'Articles et Trackbacks',
    'sg_theme' => 'Thème',
    'sg_blocks' => 'Blocks',
    'sg_users' => 'Membres et contributions',
    'sg_images' => 'Images',
    'sg_locale' => 'Langages et Locale',
    'sg_misc' => 'Divers'
);

$LANG_fs['Core'] = array(
    'fs_site' => 'Site',
    'fs_paths' => 'Chemins',
    'fs_theme' => 'Thème',
    'fs_mail' => 'Mail',
    'fs_pear' => 'Pear',
    'fs_mysql' => 'MySQL',
    'fs_users' => 'Membres',
    'fs_misc' => 'Divers',
    'fs_spamx' => 'Spam-X',
    'fs_admin_block' => 'Admin Block',
    'fs_locale' => 'Locale',
    'fs_language' => 'Langage',
    'fs_debug' => 'Debug',
    'fs_cookies' => 'Cookies',
    'fs_login' => 'Paramètres de connexion',
    'fs_search' => 'Recherche',
    'fs_user_submission' => 'Contribution des membres',
    'fs_submission' => 'Paramètres des contributions',
    'fs_topics_block' => 'Block des catégories',
    'fs_whosonline_block' => 'Block En ligne',
    'fs_daily_digest' => 'Résumé quotidien',
    'fs_whatsnew_block' => 'Block Quoi de neuf',
    'fs_trackback' => 'Trackback',
    'fs_pingback' => 'Pingback',
    'fs_story' => 'Article',
    'fs_theme_advanced' => 'Paramètres avancés',
    'fs_syndication' => 'Syndication',
    'fs_imagelib' => 'Image Library',
    'fs_upload' => 'Upload',
    'fs_articleimg' => 'Images dans les articles',
    'fs_topicicon' => 'Icons de catégorie',
    'fs_userphoto' => 'Photos',
    'fs_gravatar' => 'Gravatar',
    'fs_comments' => 'Commentaires',
    'fs_htmlfilter' => 'HTML Filtering',
    'fs_censoring' => 'Censoring',
    'fs_iplookup' => 'IP Lookup',
    'fs_perm_story' => 'Story Default Permission',
    'fs_perm_topic' => 'Topic Default Permission',
    'fs_perm_block' => 'Block Default Permission',
    'fs_webservices' => 'Webservices',
    'fs_autotag_permissions' => 'Autotag Usage Permissions'
);

$LANG_tab['Core'] = array(
    'tab_site' => 'Site',
    'tab_paths' => 'Paths',
    'tab_theme' => 'Theme',
    'tab_mail' => 'Mail',
    'tab_pear' => 'Pear',
    'tab_mysql' => 'MySQL',
    'tab_users' => 'Users',
    'tab_misc' => 'Miscellaneous',
    'tab_spamx' => 'Spam-X',
    'tab_admin_block' => 'Admin Block',
    'tab_locale' => 'Locale',
    'tab_language' => 'Language',
    'tab_debug' => 'Debug',
    'tab_cookies' => 'Cookies',
    'tab_login' => 'Login Settings',
    'tab_search' => 'Search',
    'tab_user_submission' => 'User Submission',
    'tab_submission' => 'Submission Settings',
    'tab_topics_block' => 'Topics Block',
    'tab_whosonline_block' => 'Who\'s Online Block',
    'tab_daily_digest' => 'Daily Digest',
    'tab_whatsnew_block' => 'What\'s New Block',
    'tab_trackback' => 'Trackback',
    'tab_pingback' => 'Pingback',
    'tab_story' => 'Story',
    'tab_theme_advanced' => 'Advanced Settings',
    'tab_syndication' => 'Syndication',
    'tab_imagelib' => 'Image Library',
    'tab_upload' => 'Upload',
    'tab_articleimg' => 'Images in Articles',
    'tab_topicicon' => 'Topic Icons',
    'tab_userphoto' => 'Photos',
    'tab_gravatar' => 'Gravatar',
    'tab_comments' => 'Comments',
    'tab_htmlfilter' => 'HTML Filtering',
    'tab_censoring' => 'Censoring',
    'tab_iplookup' => 'IP Lookup',
    'tab_permissions' => 'Permissions',
    'tab_webservices' => 'Webservices'
);

$LANG_configselects['Core'] = array(
    0 => array('Oui' => 1, 'Non' => 0),
    1 => array('Oui' => true, 'Non' => false),
    2 => array('Rejeté' => 0, 'Conserver le dernier' => 1, 'Permettre les posts multiples' => 2),
    3 => array('Trackback activé' => 0, 'Trackback désactivé' => -1),
    4 => array('Ne rien vérifier' => 0, 'Vérifier l\'URL du site' => 1, 'Vérifier l\'URL complète' => 2, 'Vérifier l\'URL du site et l\'URL complète' => 3, 'Comparer l\'IP et l\'IP du site' => 4, 'Véricier l\'IP et l\'URL du site' => 5, 'Vérifier l\'IP et l\'URL complète' => 6, 'Vérifier l\'IP, l\'UR complète et l\'URL du site' => 7),
    5 => array('Texte seul' => 'plaintext', 'Format HTML' => 'html'),
    6 => array('12' => 12, '24' => 24),
    7 => array('Dernière page' => 'last', 'Première page' => 'first', 'Toutes les pages' => 'all'),
    8 => array('Droite' => 'right', 'Gauche' => 'left'),
    9 => array('Retour à la page' => 'item', 'Liste articles' => 'list', 'Page d\'accueil' => 'home', 'Page administration' => 'admin'),
    10 => array('Aucune' => '', 'Netpbm' => 'netpbm', 'ImageMagick' => 'imagemagick', 'gdLib' => 'gdlib'),
    11 => array('A plat' => 'flat', 'Nichés' => 'nested', 'Regroupés' => 'threaded', 'Non affichés' => 'nocomment'),
    12 => array('Pas d\'accès' => 0, 'Lecture seule' => 2, 'Lecture-Ecriture' => 3),
    13 => array('Contourner' => 0, 'Permettre avec limitation' => 1, 'Permettre, pas de limitation' => 2),
    14 => array('Dimanche' => 'Sun', 'Lundi' => 'Mon'),
    15 => array('Numérique' => 'sortnum', 'Alphabétique' => 'alpha'),
    16 => array('Connexion non requise' => 0, 'Uniquement la recherche avancée' => 1, 'Recherche simple + avancée' => 2),
    17 => array('Commentaires autorisés' => 0, 'Commentaires non autorisés' => -1),
    18 => array('Non autorisé' => 0, 'Autorisé (Exact Match)' => 1, 'Autorisé (Word Beginning)' => 2, 'Autorisé (Word Fragment)' => 3),
    19 => array('Google' => 'google', 'Table' => 'table'),
    20 => array('Phrase exacte' => 'phrase', 'Tous les mots' => 'all', 'Un de ces mots' => 'any'),
    21 => array('HTML 4.01 Transitional' => 'html401transitional', 'HTML 4.01 Strict' => 'html401strict', 'XHTML 1.0 Transitional' => 'xhtml10transitional', 'XHTML 1.0 Strict' => 'xhtml10strict'),
    22 => array('Strict' => 'DENY', 'Same Origin' => 'SAMEORIGIN', '(disabled)' => ''),
    23 => array('Désactivé' => 0, 'Activé' => 1, 'Activé (Par défaut pour la page principale seulement)' => 2),
    24 => array('Contribute' => 'contribute', 'Home' => 'home', 'Advanced Search' => 'search', 'Directory' => 'directory', 'My Account' => 'prefs', 'Plugin Entries' => 'plugins', 'Custom Entries' => 'custom', 'Site Statistics' => 'stats'),
    25 => array('Nouveaux articles' => 'story', 'Nouveaux commentaires' => 'comment', 'Nouveaux Trackbacks' => 'trackback', 'Nouveaux Pingbacks' => 'pingback', 'Nouveaux membres' => 'user'),
    26 => array('G (General Audiences)' => 'G', 'PG (Parental Guidance)' => 'PG', 'R (Restricted)' => 'R', 'X (Explicit)' => 'X'),
    27 => array('Hits (asc)' => 'hits|asc', 'Hits (desc)' => 'hits|desc', 'Date (asc)' => 'date|asc', 'Date (desc)' => 'date|desc', 'Titre (asc)' => 'title|asc', 'Titre (desc)' => 'title|desc', 'Auteur (asc)' => 'uid|asc', 'Auteur (desc)' => 'uid|desc'),
    28 => array('No access' => 0, 'Use' => 2)
);

###############################################################################
# Localization of validation error messages

$LANG_VALIDATION = array(
    'default' => 'This field contains an invalid value',
    'notEmpty' => 'This field cannot be empty',
    'alphaNumeric' => 'This field must be in alpha numeric',
    'between' => 'This field must be in specified range',
    'blank' => 'This field must be blank',
    'comparison' => 'This field does not match the comparison operation',
    'date' => 'This field must be in date format',
    'year' => 'This field must be in year format such as 2010',
    'time' => 'This field must be in time format',
    'datetime' => 'This field must be in datetime format',
    'boolean' => 'This field must be in boolean',
    'decimal' => 'This field must be in decimal',
    'email' => 'This field must contains valid email address',
    'equalTo' => 'This field does not equal',
    'extension' => 'This field only accept allowable file extension',
    'ip' => 'This field must be in valid IP format',
    'minLength' => 'This field is too short',
    'maxLength' => 'This field is too long',
    'numeric' => 'This field must be a numeric',
    'phone' => 'This field must contains valid phone number',
    'range' => 'This field must be in specified range',
    'url' => 'This field must contains valid URL',
    'inList' => 'This field must contain specified list',
    'mail_settings_backend' => 'This field must be one of \'smtp\', \'sendmail\', or \'mail\'',
    'mail_settings_sendmail_path' => 'This field must contains valid path to sendmail binary',
    'mail_settings_host' => 'This field must contain valid hostname',
    'mail_settings_port' => 'This field must be between 0 - 65535',
    'rdf_limit' => 'This field must in numeric or hour such as 24h',
    'path' => 'Path does not exist',
    'file' => 'File does not exist',
    'search_limits' => 'This field must be numeric separated with a comma',
    'num_search_results' => 'This field must be numeric and from \'search_limits\' above',
    'theme' => 'Theme directory does not exist',
    'path_themes' => 'Theme path must be in absolute path and make sure the last character contains directory separator',
    'path_to_mogrify' => 'You must set image library to imagemagick and fill this field with complete path to the mogrify executable',
    'path_to_netpbm' => 'You must set image library to netpbm and fill this field with directory where the binaries from the Netpbm package are kept',
    'language' => 'Language file does not exist',
    'timezone' => 'Invalid timezone',
    'single_char' => 'This field must be a single character'
);


?>
