<?php

###############################################################################
# japanese_utf-8.php
#
# This is the Japanese language file for Geeklog
# Special thanks to Mischa Polivanov for his work on this project
#
# Copyright (C) 2000 Jason Whittenburg
# jwhitten AT securitygeeks DOT com
# Copyright (C) 2002,2003,2004,2005,2006 SAKATA Yusuke
# sakata AT ecofirm.com
# Copyright (C) 2008 Takahiro Kambe
# taca AT back-street DOT net
# Copyright (C) 2006,2007,2008 Tetsuko Komma
# ivy AT geeklog DOT jp
# Copyright (C) 2006,2007,2008 Geeklog.jp group
# info AT geeklog DOT jp
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
#
###############################################################################

$LANG_CHARSET = 'utf-8';

###############################################################################
# Array Format:
# $LANGXX[YY]:  $LANG - variable name
#               XX    - file id number
#               YY    - phrase id number
###############################################################################

###############################################################################
# USER PHRASES - These are file phrases used in end user scripts
###############################################################################

###############################################################################
# lib-common.php

$LANG01 = array(
    1 => '投稿者:',
    2 => '続きを読む',
    3 => 'コメント',
    4 => '編集',
    5 => '',
    6 => '',
    7 => '',
    8 => '',
    9 => '管理機能:',
    10 => '投稿',
    11 => '記事',
    12 => 'ブロック',
    13 => '話題',
    14 => '',
    15 => '',
    16 => '',
    17 => 'ユーザー',
    18 => 'SQL Query',
    19 => 'ログアウト',
    20 => 'ユーザー情報:',
    21 => 'ユーザー名',
    22 => 'ユーザーID',
    23 => '管理レベル',
    24 => 'ゲストユーザー',
    25 => 'コメントを追加',
    26 => '以下のコメントは、その投稿者が所有するものでサイト管理者はコメントに関する責任を負いません。',
    27 => '最新の投稿',
    28 => '削除',
    29 => '-',
    30 => '過去の記事',
    31 => '使用できるHTMLタグ:',
    32 => 'エラーです、ユーザー名を入力していません。',
    33 => 'エラーです、ログファイルに書き込めません。',
    34 => 'エラー',
    35 => 'ログアウト',
    36 => 'on',
    37 => '-',
    38 => 'フィード',
    39 => '更新',
    40 => '',
    41 => 'ゲストユーザー',
    42 => '投稿者:',
    43 => 'コメントを追加',
    44 => '元の記事',
    45 => 'MySQLのエラー番号は、',
    46 => 'MySQLのエラーメッセージは、',
    47 => 'ユーザー機能',
    48 => 'マイアカウント',
    49 => '設定',
    50 => 'SQL文にエラーがあります。',
    51 => 'ヘルプ',
    52 => '新規',
    53 => '管理画面',
    54 => 'ファイルを開けません。',
    55 => 'エラーが発生 ',
    56 => '投票',
    57 => 'パスワード',
    58 => 'ログイン',
    59 => "<a href=\"{$_CONF['site_url']}/users.php?mode=new\" rel=\"nofollow\">新規登録</a>",
    60 => 'コメントの投稿',
    61 => 'アカウントの登録',
    62 => 'ワード',
    63 => 'コメントの設定',
    64 => '記事を友だちにメール',
    65 => '印刷用ページ',
    66 => '',
    67 => 'ようこそ! ',
    68 => 'ホーム',
    69 => '連絡先',
    70 => '検索',
    71 => '記事投稿',
    72 => 'リンク',
    73 => '',
    74 => '',
    75 => '検索オプション',
    76 => 'サイト情報',
    77 => 'プラグイン',
    78 => '',
    79 => '新着情報',
    80 => '件の記事(',
    81 => '件の記事(',
    82 => '時間以内)',
    83 => 'コメント',
    84 => '',
    85 => '(48時間以内)',
    86 => '  -',
    87 => '(最近2週間)',
    88 => '',
    89 => '',
    90 => 'ホーム',
    91 => 'ページ作成時間',
    92 => '秒',
    93 => 'Copyright',
    94 => '本ページのすべての商標と著作権はそれぞれの所有者に帰属します。',
    95 => 'Powered by',
    96 => 'グループ',
    97 => 'ワードリスト',
    98 => 'プラグイン',
    99 => '記事',
    100 => '-',
    101 => '',
    102 => '',
    103 => 'データベース',
    104 => ':',
    105 => 'メール',
    106 => '表示回数',
    107 => 'GLバージョン確認',
    108 => 'キャッシュをクリア',
    109 => '不正報告',
    110 => '投稿をサイト管理者に報告',
    111 => '',
    112 => '登録ユーザー数',
    113 => 'ドキュメント',
    114 => 'トラックバック',
    115 => '-',
    116 => 'トラックバック',
    117 => '記事一覧',
    118 => '続きのページへ:',
    119 => "<a href=\"{$_CONF['site_url']}/users.php?mode=getpassword\" rel=\"nofollow\">パスワード再設定</a>",
    120 => 'このコメントへのパーマリンク',
    121 => 'コメント (%d件)',
    122 => 'トラックバック (%d件)',
    123 => 'すべてのHTMLを許可。',
    124 => '選択したアイテムを削除するならここをクリック',
    125 => '選択したアイテムを削除してよいですか?',
    126 => 'すべて選択または選択を解除',
    127 => 'パーマリンク',
    128 => 'OpenIDログイン',
    129 => 'コンフィギュレーション',
    130 => 'Webサービス',
    131 => 'HTMLは使えません',
    132 => 'インフォメーション',
    133 => '重要',
    134 => 'ヘルプ',
    135 => '警告',
    136 => '警告: 強化した機能のためにJavaScriptの使用の許可を推奨します',
    137 => '警告: 機能を有効とするにはJavaScriptの使用の許可が必要です',
    138 => "アドバンストエディターを無効にして、JavaScriptが不要なノーマルエディターを有効にするには<a href=\"{$_CONF['site_url']}/usersettings.php\" rel=\"nofollow\">こちら</a>をクリックしてください。",
    139 => "ホームページへは<a href=\"{$_CONF['site_url']}/\" rel=\"nofollow\">こちら</a>をクリック",
    'facebook' => 'Facebookでログイン',
    'twitter' => 'Twitterでログイン',
    'linkedin' => 'LinkedInでログイン'
);

###############################################################################
# comment.php

$LANG03 = array(
    1 => 'コメントの投稿',
    2 => '投稿方法',
    3 => 'ログアウト',
    4 => 'アカウントを作成',
    5 => 'ユーザー名',
    6 => 'コメントの投稿の前にログインしてください。アカウントを登録していなければ、下のフォームで登録してください。',
    7 => 'あなたは',
    8 => " 秒前にコメントしています。投稿と投稿の間は {$_CONF['commentspeedlimit']} 秒以上あけてください。",
    9 => 'コメント',
    10 => '報告',
    11 => 'コメントの投稿',
    12 => '投稿するにはタイトルと本文が必要です。',
    13 => 'あなたの情報',
    14 => 'プレビュー',
    15 => 'この投稿を報告',
    16 => 'タイトル',
    17 => 'エラーです',
    18 => '注意事項',
    19 => '内容にそった話題で投稿してください。',
    20 => 'できるだけ新しいスレッドを立てず、コメントを追加してください。',
    21 => '他の人のコメントをよく読んで同じようなコメントを投稿しないようにしてください。',
    22 => '内容がよくわかるタイトルをつけてください。',
    23 => 'あなたのメールアドレスは公開しません!',
    24 => 'ゲストユーザー',
    25 => 'この投稿をサイト管理者に不正な投稿として報告してよいですか?',
    26 => '%s さんが以下を不正なコメントの投稿と報告しています:',
    27 => '不正の報告',
    28 => '変更をプレビュー',
    29 => '変更を投稿',
    30 => '編集:',
    31 => 'by',
    32 => 'コメントを編集中',
    33 => 'コメントの投稿を編集中',
    34 => '投稿の変更をプレビュー',
    35 => '変更をキューに保存',
    36 => '新しい返信をメールで通知',
    37 => '新しいコメント',
    38 => 'あなたのコメント\'%s\'に返信がありました。',
    39 => '次のアドレスでコメントのスレッドを見ることができます:',
    40 => '返信の通知が不要な場合は、次のリンクを参照してください:',
    41 => 'こんにちは %s,',
    42 => '通知を解除',
    43 => '返信の通知を解除',
    44 => 'あなたの名前',
    45 => "コメントをありがとうございます。 新たなコメント投稿のために {$_CONF['commentspeedlimit']} 秒以上お待ちください。"
);

###############################################################################
# users.php

$LANG04 = array(
    1 => 'アカウント情報',
    2 => 'ユーザー名',
    3 => '氏名',
    4 => 'パスワード',
    5 => 'メール',
    6 => 'ホームページ',
    7 => '自己紹介',
    8 => 'PGP鍵',
    9 => '保存',
    10 => '最新コメント(10件)',
    11 => '-',
    12 => 'ユーザー情報',
    13 => 'メールでダイジェストを読む',
    14 => "なお、パスワードの変更をおすすめします。\nサイトにログインして、「マイアカウント」をクリックすると、\nパスワードを変更できます。",
    15 => "{$_CONF['site_name']}からのお知らせです。\n\n{$_CONF['site_name']} であなたのアカウントを作成しました。\n下記のユーザー名とパスワードでログインしてください。\nこのメールは念のため保存してください。",
    16 => 'ユーザー情報',
    17 => 'アカウントがありません',
    18 => 'このメールアドレスは有効なアドレスではないようです',
    19 => 'ユーザー名かメールアドレスは既に使用しています。',
    20 => 'このメールアドレスは有効なアドレスではないようです',
    21 => 'エラー',
    22 => "{$_CONF['site_name']}に新規登録",
    23 => "{$_CONF['site_name']}にユーザーアカウントを登録すると、コメントや記事の投稿をあなたの名前で投稿できます。そうでなければゲストユーザーとしてしか投稿できません。なお、サイト上でメールアドレスを表示することはありません。",
    24 => 'パスワードをここに入力したメールアドレス宛てに送信します。',
    25 => 'パスワードの再設定',
    26 => 'ご登録頂いているユーザー名、またはメールアドレスの<strong>どちらかを入力</strong>して「送信」ボタンを押してください。ご登録のメールアドレス宛にパスワード再設定用のURLを記載したメールを送信します。',
    27 => '新規登録',
    28 => '送信',
    29 => 'ログアウトしました:',
    30 => 'ログインしました:',
    31 => 'ログインが必要です。',
    32 => '署名',
    33 => '公開しません',
    34 => '本名',
    35 => '変更後のパスワード',
    36 => 'http://から始めてください',
    37 => 'あなたのコメントに使用します。',
    38 => 'あなたの紹介文です。公開します。',
    39 => 'あなたの公開PGP鍵',
    40 => '話題アイコンを表示しない',
    41 => '修正を受け入れる',
    42 => '日時のフォーマット',
    43 => '記事の表示最大数',
    44 => 'ブロックを表示しない',
    45 => '表示設定',
    46 => '次のアイテムを除外',
    47 => 'ニュースボックスの設定',
    48 => '話題',
    49 => '記事に話題アイコンを表示しない',
    50 => '興味がなければチェックをはずしてください',
    51 => 'メインコンテンツだけを表示する',
    52 => 'デフォルト:',
    53 => 'その日の記事を毎晩メールで受け取る。',
    54 => '読みたくない投稿者名と話題をチェックしてください。',
    55 => 'すべてのチェックをはずした場合は、デフォルトを選択したことになります。1つでもチェックすると、このデフォルトの選択は関係なくなりますので、読みたいものを全部チェックするようにしてください。 デフォルトの話題は強調表示しています。',
    56 => '投稿者',
    57 => '表示モード',
    58 => '並べ替えの順序',
    59 => 'コメントの最大数',
    60 => 'コメントの表示方法',
    61 => '順番',
    62 => 'デフォルトは100件です',
    63 => "パスワードをメールで送信しました。メッセージにログイン方法をご案内しています。{$_CONF['site_name']}のご利用をお待ちしています。",
    64 => 'コメントの設定:',
    65 => '再度ログインしてください',
    66 => 'ログインに失敗しました。再度ログインしてください。',
    67 => '登録日時',
    68 => '認証の保存期間',
    69 => 'いったんログインした後、どのくらい認証情報を残しますか?',
    70 => "{$_CONF['site_name']}の表示と内容を設定",
    71 => "{$_CONF['site_name']}では、レイアウトを自由に変えることができます。そのためには、{$_CONF['site_name']}に<a href=\"{$_CONF['site_url']}/users.php?mode=new\" rel=\"nofollow\">登録</a>する必要があります。もし、既に登録済みなら左のフォームを利用してログインしてください。",
    72 => 'テーマ',
    73 => '言語',
    74 => 'このサイトのデザインを変更',
    75 => '記事をメールで送信しました。送信先:',
    76 => '下記のリストから話題を選択すると、毎晩その話題の記事をメールで受け取ることができます。興味のある話題だけ選択してください。',
    77 => '写真',
    78 => '写真を追加',
    79 => '写真を削除する場合、ここをチェックしてください',
    80 => 'ログイン',
    81 => 'メール送信',
    82 => '最新投稿(10件)',
    83 => '投稿状況',
    84 => '投稿記事の総数:',
    85 => 'コメントの総数:',
    86 => 'すべての投稿を検索:',
    87 => 'あなたのログイン名',
    88 => "%s さん、こんにちは。\n\n{$_CONF['site_name']}よりお知らせします。\n\n以下のページよりパスワード再設定の手続きを行って、そのパスワードで\n今後はログインするようにしてください。\n\nなお、このメールに覚えがない場合、他の方がメールアドレスを間違えて\n入力した可能性があります。パスワードを変更することはありませんので\n安心してください。\n\n",
    89 => "パスワードを変えたくない場合はこのメッセージを無視してください。\n(パスワードは変わりません。)\n\n",
    90 => '新しいパスワードを入力して「再設定」ボタンを押してください。',
    91 => '再設定',
    92 => 'パスワードの再設定',
    93 => 'パスワード再設定は%d秒前に行われています。このサイトでは、パスワードの再設定のリクエストには少なくとも%d秒の時間をおく必要があります。',
    94 => 'アカウント("%s")を削除',
    95 => 'あなたのアカウントを削除するには、下の「アカウント削除」ボタンをクリックしてください。ただし、あなたのアカウント名で投稿した記事やコメントの<strong>削除はしません</strong>。これらの記事やコメントは「ゲストユーザー」の投稿として表示するようになります。',
    96 => 'アカウント削除',
    97 => 'アカウント削除の確認',
    98 => '本当にアカウントを削除しますか。削除すると、このサイトに新しいアカウントを作らない限り、ログインできなくなります。よろしければ、もう一度「アカウント削除」ボタンをクリックしてください。',
    99 => 'プライバシーオプション:',
    100 => '管理者からのメール',
    101 => 'サイト管理者からのメールを受け取る',
    102 => '他のユーザーからのメール',
    103 => '他のユーザーからのメールを受け取る',
    104 => 'オンラインの状態を表示',
    105 => '「オンラインユーザー」ブロックにアカウントを表示',
    106 => '居住地',
    107 => '公開プロフィールで表示',
    108 => 'パスワード(再入力)',
    109 => '新しいパスワードを再入力',
    110 => '現在のパスワード',
    111 => '現在のパスワードを入力してください',
    112 => 'ログインの試行回数を超えました。後ほどまたログインしてください。',
    113 => 'ログインできませんでした',
    114 => 'アカウントが無効です',
    115 => 'アカウントが無効になりましたのでログインできません。管理者に連絡してください。',
    116 => 'アカウントが有効になるのを待機しています',
    117 => 'あなたのアカウントは管理者が有効にするのを待っています。管理者が承認するまでログインできません。',
    118 => "{$_CONF['site_name']} のあなたのアカウントを有効にしました。以下のリンクから、あなたのユーザー名(<username>)とメールで送られてきたパスワードでログインできます。",
    119 => 'パスワードを紛失した場合、以下のリンクから新しいパスワードを再設定できます。',
    120 => 'アカウントを有効にしました。',
    121 => 'サービス',
    122 => 'ユーザーの新規登録はただ今停止中です。',
    123 => "<a href=\"{$_CONF['site_url']}/users.php?mode=new\" rel=\"nofollow\">新規登録</a>",
    124 => '(確認)メールアドレス',
    125 => '両方の入力欄に同じメールアドレスを入力してください。',
    126 => '確認のために同じものを繰り返し入力してください。',
    127 => '設定を変更するには、現在のパスワードを入力する必要があります。',
    128 => 'お名前',
    129 => 'パスワードとメールアドレス',
    130 => '個人情報',
    131 => '毎日のダイジェスト版オプション',
    132 => '毎日のダイジェスト版機能',
    133 => 'コメントを表示',
    134 => 'コメントオプション',
    135 => '<li>表示モードのデフォルトを設定してください。</li><li>コメントを表示する際の並べ替えの順序のデフォルトを設定してください。</li><li>表示するコメントの最大数を設定してください。デフォルトは100件です。</li>',
    136 => '話題と投稿者の除外',
    137 => '記事のフィルタリング',
    138 => 'その他の設定',
    139 => 'レイアウトと言語',
    140 => '<li>「話題アイコンを表示しない」をチェックすると、記事に話題アイコンを表示しなくなります。</li><li>「ブロックを表示しない」をチェックすると、管理者メニューブロック・ユーザーメニューブロック・話題ブロックのみの表示とします。</li><li>1ページに表示する記事の最大数を設定してください。</li><li>テーマと好みの日時のフォーマットを設定してください。</li>',
    141 => 'プライバシーの設定',
    142 => 'デフォルトでは、他のユーザーや管理者があなたにメールを送ることができ、オンラインかどうかを表示するようになっています。プライバシーを保護するには、対応するオプションのチェックを外してください。',
    143 => 'ブロックのフィルタリング',
    144 => 'ボックスの表示の設定',
    145 => '公開プロフィール',
    146 => 'パスワードとメールアドレス',
    147 => 'パスワード、メールアドレス、自動ログイン機能を編集します。パスワードとメールアドレスは確認のため、2回入力する必要があります。',
    148 => '個人情報',
    149 => '他のユーザーに表示する個人情報を編集します。<ul><li>「署名」はコメントや掲示板の投稿に付加します。</li><li>「自己紹介」は他のユーザーにも読める短い自己紹介です。</li><li>「PGP公開鍵」を共有しましょう。</li></ul>',
    150 => '',
    156 => 'アカウントを削除',
    157 => 'アカウントの削除オプション',
    158 => 'タイムゾーン',
    159 => 'このメールは自動的に送信したものです。このメールに返信しないように\nお願いします。',
    160 => '(最大. %d X %d ピクセル, %d バイト; %s)',
    161 => 'リサイズ',
    162 => 'リサイズなし',
    163 => '再認証のエラー',
    164 => '再認証の回数を超えました。操作は中断して、今回の編集内容は失われました。',
    165 => 'アドバンストエディターの使用',
    166 => 'リモートアカウントの再同期',
    167 => 'リモートログイン',
    168 => 'リモート認証サービスによるログインも可能です。'
);

###############################################################################
# Customize if need to modify the Tabbed navbar MyAccount panels used.
# Array index key matches preference div id

$LANG_MYACCOUNT = array(
    'pe_preview' => 'プレビュー',
    'pe_namepass' => 'ユーザー名とパスワード',
    'pe_userinfo' => '個人情報',
    'pe_layout' => 'レイアウトと言語',
    'pe_content' => 'コンテンツ',
    'pe_privacy' => 'プライバシー'
);

###############################################################################
# index.php

$LANG05 = array(
    1 => '表示する記事がありません',
    2 => '表示する記事がありません。この話題の記事がないか表示設定を絞り過ぎなのかのどちらかです。',
    3 => '<br' . XHTML . '>この話題 %s の記事についてです。',
    4 => '今日の注目記事',
    5 => '次へ',
    6 => '前へ',
    7 => '最初',
    8 => '最後'
);

###############################################################################
# profiles.php

$LANG08 = array(
    1 => 'メッセージを送信する際にエラーが発生しました。もう一度試してください。',
    2 => 'メッセージを送信しました。',
    3 => 'メールアドレスを正しく入力してください。',
    4 => '名前、メールアドレス、件名、内容をすべて入力してください',
    5 => 'エラー: 該当するユーザーはいません。',
    6 => 'エラーが発生しました。',
    7 => 'ユーザー情報',
    8 => '氏名',
    9 => 'URL',
    10 => 'メールの宛先',
    11 => '名前:',
    12 => 'メールアドレス:',
    13 => '件名:',
    14 => '本文:',
    15 => 'HTMLタグは使えません。',
    16 => '送信',
    17 => '友だちに記事を送信する',
    18 => '宛先の名前',
    19 => '宛先のアドレス',
    20 => '発信元の名前',
    21 => '発信元のEmail',
    22 => 'すべての項目を入力してから、送信ボタンをクリックしてください',
    23 => "こんにちは!  {$_CONF['site_name']}よりお知らせします。\n\n%s さんが\n{$_CONF['site_url']}\nの記事をあなたに知らせるため、\n%s のアドレスから送信しました。\nこれは迷惑メール(いわゆるspamメール)ではなく、\nこのメールの送信に使用した\n宛先のメールアドレスは、この場限りの使用です。リストに保存したり、他の目的に\n使用することはありません。",
    24 => 'この記事に関するコメントは次の場所でできます。',
    25 => 'この機能を使用するためにはログインしてください。',
    26 => 'このフォームでメールを送ります。',
    27 => 'メッセージ',
    28 => '%s さんからのメッセージ: ',
    29 => "今日の{$_CONF['site_name']} に関するダイジェストです。宛先:",
    30 => ' 今日のニュースレターです。宛先: ',
    31 => 'タイトル',
    32 => '日付',
    33 => '以下の場所で記事全体を読むことができます。',
    34 => 'メッセージは以上です',
    35 => 'このユーザーはメールを受け付けていません。',
    36 => 'コピー:',
    37 => '自分宛にコピーを送信',
    38 => "これはあなたが<{$_CONF['site_url']}>から %s へ送信したメールのコピーです:",
    39 => 'あなたはメッセージを ',
    40 => " 秒前に送信しています。少なくとも{$_CONF['speedlimit']}秒待って、次のメッセージを送信してください。"
);

###############################################################################
# search.php

$LANG09 = array(
    1 => '検索オプション',
    2 => 'キーワード',
    3 => '話題',
    4 => 'すべて',
    5 => 'タイプ',
    6 => '記事',
    7 => 'コメント',
    8 => '投稿者',
    9 => 'すべて',
    10 => '検索',
    11 => '検索結果',
    12 => '件が該当',
    13 => '記事の検索結果: 該当なし',
    14 => '該当するものはありませんでした',
    15 => '他のキーワードで検索してください。',
    16 => 'タイトル',
    17 => '日付',
    18 => '投稿者',
    19 => " {$_CONF['site_name']} サイト内を検索します。",
    20 => '日付',
    21 => ' - ',
    22 => '(書式は YYYY-MM-DD)',
    23 => 'Views',
    24 => '%d件、見つかりました',
    25 => '次のキーワードについて検索:',
    26 => '件',
    27 => '秒',
    28 => '該当する記事・コメントは見つかりませんでした',
    29 => '記事・コメントの検索結果:',
    30 => '',
    31 => 'プラグインからは該当するものを見つかりませんでした',
    32 => '',
    33 => 'URL',
    34 => '場所',
    35 => '一日中',
    36 => '',
    37 => '',
    38 => '',
    39 => '',
    40 => '',
    41 => '検索文字列は3文字以上必要です。',
    42 => '日付の書式は、YYYY-MM-DD(年-月-日)としてください。',
    43 => '完全一致',
    44 => 'すべて含む',
    45 => 'いずれか含む',
    46 => '次',
    47 => '前',
    48 => '投稿者',
    49 => '日付',
    50 => '表示数',
    51 => '',
    52 => '場所',
    53 => '記事の検索結果',
    54 => 'コメントの検索結果',
    55 => '検索文字列',
    56 => 'AND',
    57 => 'OR',
    58 => '次の検索結果へ &gt;&gt;',
    59 => '1ページあたりの件数',
    60 => '件',
    61 => '検索条件の修正',
    62 => '#',
    63 => '詳細',
    64 => '検索結果 %1$d - %2$d / %3$d 件',
    65 => '記事',
    66 => 'コメント',
    67 => '検索結果 %d 件',
    68 => '並べ替え',
    69 => 'タイトルのみ',
    70 => 'ありません ...',
    71 => '昇順',
    72 => '降順'
);

###############################################################################
# stats.php

$LANG10 = array(
    1 => 'サイトに関する統計',
    2 => 'システム全体のアクセス数',
    3 => '記事数(コメント数)',
    4 => '',
    5 => '',
    6 => '',
    7 => '記事(上位10件)',
    8 => '記事のタイトル',
    9 => '件',
    10 => 'このサイトには記事の投稿がないか、記事を表示した人がいません。',
    11 => 'コメントのあった記事(上位10件)',
    12 => '件',
    13 => 'このサイトには記事の投稿がないか、コメントした人がいません。',
    14 => '',
    15 => '',
    16 => '',
    17 => '',
    18 => '',
    19 => '',
    20 => '',
    21 => '',
    22 => 'メールで紹介された記事(上位10件)',
    23 => 'メールアドレス',
    24 => 'メールで紹介された記事はありません。',
    25 => 'トラックバックのあった記事(上位10件)',
    26 => 'トラックバックはありません。',
    27 => 'アクティブユーザー数',
    28 => '',
    29 => '',
    30 => '表示回数',
    31 => ''
);

###############################################################################
# article.php

$LANG11 = array(
    1 => '関連情報',
    2 => '友だちに記事をメールする',
    3 => '印刷用ページ',
    4 => '記事のオプション',
    5 => '',
    6 => '\'%s\'を購読する'
);

###############################################################################
# submit.php

$LANG12 = array(
    1 => ' %s を投稿する前にログインしてください。',
    2 => 'ログイン',
    3 => '新規登録',
    4 => '',
    5 => '',
    6 => '記事の投稿',
    7 => 'ログインが必要です',
    8 => '投稿',
    9 => 'このサイトに情報を投稿する際には、次のルールを守ってください。<ul><li>必要なすべての項目を入力してください。</li><li>正確かつ必要十分な情報を提供してください。</li><li>URLについては特に注意して確認してください。</li></ul>',
    10 => 'タイトル',
    11 => '',
    12 => '開始日',
    13 => '終了日',
    14 => '場所',
    15 => '詳細',
    16 => '',
    17 => '',
    18 => '',
    19 => 'はじめにお読みください',
    20 => '',
    21 => '',
    22 => '入力に不備があります',
    23 => 'すべてのフィールドに入力してください。',
    24 => '投稿を受け付けました',
    25 => '%s に関する投稿を受け付けました。',
    26 => '投稿間隔の制限',
    27 => 'ユーザー名',
    28 => '話題',
    29 => '記事',
    30 => '前回、あなたは、',
    31 => "秒前に投稿しています。投稿間隔を{$_CONF['speedlimit']}秒以上にしてください。",
    32 => 'プレビュー',
    33 => '記事のプレビュー',
    34 => 'ログアウト',
    35 => 'HTMLタグは使用できません',
    36 => '投稿モード',
    37 => '',
    38 => '',
    39 => '',
    40 => '',
    41 => '',
    42 => '',
    43 => '',
    44 => '住所1',
    45 => '住所2',
    46 => '市町村名',
    47 => '都道府県',
    48 => '郵便番号',
    49 => '',
    50 => '',
    51 => '場所',
    52 => '削除',
    53 => 'アカウント作成',
    54 => '記事冒頭文',
    55 => '記事本文'
);

###############################################################################
# ADMIN PHRASES - These are file phrases used in admin scripts
###############################################################################

###############################################################################
# admin/auth.inc.php

$LANG20 = array(
    1 => '管理権限が必要です',
    2 => 'ログインできません。もう一度入力してください',
    3 => 'パスワードが違います。ユーザー名:',
    4 => 'ユーザー名:',
    5 => 'パスワード:',
    6 => '管理ツールの使用はすべて記録しています。<br' . XHTML . '>このページは管理者のみ使用できます。',
    7 => 'ログイン'
);

###############################################################################
# admin/block.php

$LANG21 = array(
    1 => 'ここを管理する権限がない',
    2 => 'このブロックを編集する権限がありません。',
    3 => 'ブロックの編集',
    4 => 'フィードの読み込みでエラーが発生しました。(error.logを参照してください。)',
    5 => 'Yes',
    6 => 'No',
    7 => 'すべて',
    8 => 'ブロックのセキュリティレベル',
    9 => '順序',
    10 => '',
    11 => 'ポータルブロック',
    12 => 'ノーマルブロック',
    13 => 'ポータルブロックのオプション',
    14 => 'フィードURL',
    15 => 'フィード更新日時',
    16 => 'ノーマルブロックのオプション',
    17 => 'コンテンツ',
    18 => 'ブロックのタイトル・セキュリティレベル・コンテンツを入力してください。',
    19 => 'ブロック管理',
    20 => '標準ブロック',
    21 => 'セキュリティ',
    22 => 'ダイナミックブロック',
    23 => '順序',
    24 => 'ダイナミック',
    25 => 'ブロックの編集・削除は編集アイコンを、ブロックの作成は上の「新規作成」をクリックしてください。ブロックの移動は、[↑][↓][R][L]をクリックしてください。 ',
    26 => 'レイアウト用ブロック',
    27 => 'PHPブロック',
    28 => 'PHPブロックのオプション',
    29 => '関数',
    30 => 'PHPを使用したブロックを使う場合に、その関数名を上に入力してください。関数名は"phpblock_"で始まる名前(例えば、phpblock_themetester)でなければなりません。この条件に合わない関数を呼び出すことは*ありません*。これは、Geeklogに不正侵入しようとする悪者が、システムに有害となるかもしれない好き勝手な関数の呼び出しを避けるためです。関数名の後に"()"を付けると、2つの引数と共に呼び出しします。第一引数は gl_blocksテーブルの配列です。第二引数は、2つの括弧の間に記述した、どのようなテキストであれ、それが文字列として渡ります。最後に、すべてのPHPブロックのコードは/path/to/geeklog/system/lib-custom.phpに記述することを推奨します。そうすることで、新しいバージョンのGeeklogにアップグレードしたときでも、コードを維持できるようになります。(訳注: 日本語版では、フォルダー system/customを作成し、その中にカスタム関数を入れて、よりアップグレードしやすい構成にしています。)',
    31 => 'PHPブロックにエラーがあります。関数%sが存在しません。',
    32 => 'エラー。未入力の項目があります',
    33 => 'ポータルブロックのフィードURLを入力してください',
    34 => 'PHPブロックにはタイトルと関数名を入力してください',
    35 => 'ノーマルブロックにはタイトルと内容を入力してください',
    36 => 'レイアウト用ブロックには内容を入力してください',
    37 => 'PHPブロックの関数名が不適切です',
    38 => 'PHPブロックの関数名は\'phpblock_\'で始まる名前(例: phpblock_themetester)でなければなりません。この条件は任意のコードの実行を防ぐセキュリティ上の理由で必要となっています。',
    39 => '表示場所',
    40 => '左',
    41 => '右',
    42 => 'ブロックのタイトルと表示順序を入力してください。',
    43 => 'ホームページのみ',
    44 => 'マルチプル',
    45 => "管理権限のないブロックを編集しようとしました。このアクセスを記録しました。<a href=\"{$_CONF['site_admin_url']}/block.php\">ブロックの編集</a>画面に戻ってください.",
    46 => '移動',
    47 => 'なし',
    48 => 'ブロックID',
    49 => '(スペース不可)',
    50 => 'ブロックIDを入力してください。',
    51 => 'http://を含む',
    52 => '空欄のままにすると、このブロックにヘルプのアイコンを表示しません',
    53 => '有効',
    54 => '保存',
    55 => 'キャンセル',
    56 => '削除',
    57 => 'ブロックを下に',
    58 => 'ブロックを上に',
    59 => 'ブロックを右側に',
    60 => 'ブロックを左側に',
    61 => 'タイトルなし',
    62 => '表示件数',
    63 => 'ブロックのタイトルが不適切です',
    64 => 'タイトルは空欄にはできず、HTMLを含めてはなりません!',
    65 => '順番',
    66 => '自動タグ',
    67 => '自動タグの使用を許可',
    68 => 'このポータルブロックのフィードは長すぎて表示できません。ブロック設定画面でブロックに表示する記事の最大数を設定するか、コンフィギュレーションで標準の最大数を設定してください。',
    69 => 'プラグイン名'
);

###############################################################################
# admin/story.php

$LANG24 = array(
    1 => '前の記事',
    2 => '後の記事',
    3 => 'モード',
    4 => '投稿モード',
    5 => '記事の編集',
    6 => '記事がありません',
    7 => '投稿者',
    8 => '保存',
    9 => 'プレビュー',
    10 => 'キャンセル',
    11 => '削除',
    12 => '記事ID',
    13 => '',
    14 => '',
    15 => '日時',
    16 => '冒頭文',
    17 => '本文',
    18 => '表示回数',
    19 => 'コメント数',
    20 => 'ピング',
    21 => 'トラックバック・ピングを送る',
    22 => '記事の一覧',
    23 => '記事の編集や削除をするには編集アイコンを、記事を表示するには記事のタイトルを、記事の作成は上の「新規作成」をクリックしてください。',
    24 => '指定した記事IDは既に使われています。別の記事IDを入力してください。',
    25 => '記事の登録中にエラーが発生しました',
    26 => '記事のプレビュー',
    27 => '<p>自動タグ[imageX]のかわりに[unscaledX]を使うと、画像をオリジナルのサイズで表示します。</p>',
    28 => '<p><strong>プレビュー</strong>: 画像付きの記事をプレビューする場合はプレビューボタンをクリック*しないで*、一旦ドラフトモードで保存してください。プレビューボタンは画像を含まない場合だけクリックしてください。</p>',
    29 => 'トラックバック数',
    30 => 'ファイルのアップロード時にエラーが発生しました',
    31 => 'タイトルと冒頭文を入力し、話題を少なくとも1つ選択してください',
    32 => '注目記事',
    33 => '注目記事は最後に指定した1つだけとなります',
    34 => 'ドラフト',
    35 => '○',
    36 => '－',
    37 => '同じ投稿者からの投稿:',
    38 => '同じ話題:',
    39 => 'メール紹介',
    40 => '',
    41 => "管理権限のない記事を編集しようとしました。このアクセスを記録しました。下記の記事は読み取り専用で見ることができます。読み終わったら、<a href=\"{$_CONF['site_admin_url']}/story.php\">記事の編集画面</a>に戻ってください。",
    42 => "管理権限のない記事を編集しようとしました。このアクセスを記録しました。<a href=\"{$_CONF['site_admin_url']}/story.php\">記事の編集画面</a>に戻ってください",
    43 => '',
    44 => '',
    45 => '',
    46 => '<strong>注意:</strong> 記事の日時を将来の日時に変更すると、その日まで記事を公開しません。これはフィードにも含めず、検索と統計情報にも反映しないことを意味します。',
    47 => '画像',
    48 => '画像',
    49 => '右',
    50 => '左',
    51 => '<p>記事に添付した画像は、自動タグで記述してください。書式は、[imageX]、[imageX_right]、[imageX_left](Xは添付した画像の番号)(例 [image1])。注意: 添付した画像は記事内ですべて使用しなければ記事を保存できません。<br' . XHTML . '><strong>プレビュー</strong>: 画像付きの記事の確認は一旦ドラフト(下書き)として保存して表示してください。プレビューの機能は画像が無いときにのみ利用できます。</p>',
    52 => '',
    53 => 'を使用していません。保存する前に冒頭文または本文で、この画像を使用しなければなりません。',
    54 => '添付した画像を使用していません。',
    55 => '記事を保存する際に下記のエラーが発生しました。保存する前に修正してください。',
    56 => '話題アイコンの表示',
    57 => '元のサイズの画像を表示',
    58 => 'アーカイブ',
    59 => 'オプション',
    60 => '',
    61 => '自動アーカイブ',
    62 => '自動削除',
    63 => 'コメントの設定',
    64 => '',
    65 => '',
    66 => '',
    67 => '編集エリアの拡大',
    68 => '編集エリアの縮小',
    69 => '投稿日時と公開モードの設定',
    70 => 'ツールバーの選択',
    71 => '基本的なツールバー',
    72 => '一般的なツールバー',
    73 => '拡張ツールバー',
    74 => '拡張ツールバーその2',
    75 => '全機能',
    76 => '公開オプション',
    77 => 'アドバンストエディターを有効にするには、ブラウザーでJavaScriptが使える環境としなければなりません。このオプションはコンフィギュレーションの管理パネルで無効にできます。',
    78 => '<a href="%s/story.php?mode=edit&amp;sid=%s&amp;editopt=default">ノーマルエディターを使う場合</a>',
    79 => 'プレビュー',
    80 => 'エディター',
    81 => '公開オプション',
    82 => '画像',
    83 => 'アーカイブ',
    84 => 'パーミッション',
    85 => 'すべて表示',
    86 => 'アドバンストエディター',
    87 => '記事の情報',
    88 => 'Wikiスタイル',
    89 => '説明文のメタタグ',
    90 => 'キーワードのメタタグ',
    91 => '「プレビュー」ボタンをクリックすれば、いつでも有効期限を延長できます。',
    'autotag_desc_story' => '[story: id alternate title] - 記事タイトルを記事へのリンクの表示にします。別のリンクのタイトルを指定できますが、必須ではありません。'
);

###############################################################################
# admin/topic.php

$LANG27 = array(
    1 => '話題の編集',
    2 => '話題ID',
    3 => '話題名',
    4 => '話題アイコンのファイルを指定',
    5 => '(半角英数字とハイフン)',
    6 => '話題を削除すると、(削除する話題にだけ関連付けしている)記事、投稿、ブロックもすべて削除します。',
    7 => '話題IDと話題名を入力してください',
    8 => '話題の管理',
    9 => '話題の編集や削除をするには、以下の話題のアイコンをクリックしてください。新しい話題を作成するには上の「新規作成」をクリックしてください。括弧内はあなたの話題のアクセスレベルです。アスタリスク(*)題はデフォルトの話題を示します。',
    10 => '順序',
    11 => '1ページあたりの記事数',
    12 => 'アクセスできません',
    13 => "管理権限のない話題を編集しようとしました。このアクセスを記録しました。<a href=\"{$_CONF['site_admin_url']}/topic.php\">話題の編集画面</a>に戻ってください",
    14 => '並べ替え方法',
    15 => 'アルファベット順',
    16 => '記事数のデフォルト:',
    17 => '新規話題',
    18 => '管理画面',
    19 => '保存',
    20 => 'キャンセル',
    21 => '削除',
    22 => 'デフォルト',
    23 => 'この話題を新しい項目と記事投稿の際のデフォルトに設定できます。',
    24 => '(*)',
    25 => 'アーカイブ',
    26 => 'この話題をアーカイブ記事用の話題にします。アーカイブ記事用の話題に設定できるのは1つだけです。',
    27 => '話題アイコンをアップロード',
    28 => '最大',
    29 => 'ファイルアップロード時にエラー発生しました',
    30 => 'この話題の記事数',
    31 => '制限しているトピックIDを使用しました。別のIDにしてください。',
    32 => '親の話題',
    33 => '継承',
    34 => '子の話題を継承',
    35 => '隠す',
    36 => '話題を隠して、直接には表示できないようにします。話題は継承だけに使用します。',
    37 => 'ルート',
    38 => 'すべて',
    39 => 'ホームページのみ',
    40 => '1つ以上の話題を割り当ててください。',
    41 => '"すべて" を選ぶと、そのアイテムはすべての話題に表示します。"ホームページのみ"を選ぶと、ホームページだけに表示します。それ以外の場合は少なくとも1つ以上の話題を選択してください。 ',
    42 => '継承の欄は割り当てられている話題のリストを含んでいます。話題を選択すると、その話題の親の話題に継承されます。継承の欄に表示するには、先にアイテムを保存またはプレビューしなければなりません。',
    43 => 'デフォルトは、割り当てた話題のリストを含んでいます。これは、ユーザーが実際の話題をみつけられないときに、アイテムを表示する時に使用するデフォルトの話題です。',
    44 => '継承',
    45 => 'デフォルト',
    46 => '親の話題に、アーカイブの話題は設定できません。異なる親の話題を選んでください。',
    47 => 'アーカイブの話題には、子の話題を設定できません。アーカイブの話題に設定する前に子の話題を取り除いてください。',
    48 => '親の話題IDが見つかりません。',
    49 => 'この話題IDは既に使用しています。別の話題IDを使用してください。',
    50 => 'はい',
    51 => 'いいえ',
    52 => '話題',
    53 => '画像',
    'breadcrumb_separator' => '>',
    'breadcrumb_root' => 'ホーム'
);

###############################################################################
# admin/user.php

$LANG28 = array(
    1 => 'ユーザーの編集',
    2 => 'ユーザーID',
    3 => 'ユーザー名',
    4 => '氏名',
    5 => 'パスワード',
    6 => 'セキュリティレベル',
    7 => 'メールアドレス',
    8 => 'ホームページ',
    9 => '(半角英数字とハイフン)',
    10 => 'ユーザー名・メールアドレスを入力してください。',
    11 => 'ユーザー管理',
    12 => 'ユーザーの編集や削除は、ユーザーの編集アイコンをクリックしてください。、ユーザーを表示するには、表示したいユーザー名をクリックしてください。ユーザーを作成するには、上の「新規作成」をクリックしてください。(訳註: ユーザーの一括登録(インポート)は「一括登録」をクリック、ユーザーの一括削除は「一括削除」をクリックしてください。)',
    13 => 'セキュリティ',
    14 => '登録日',
    15 => '',
    16 => '',
    17 => '',
    18 => '',
    19 => '',
    20 => '保存',
    21 => '登録しようとしたユーザー名は既に存在します。',
    22 => 'エラー',
    23 => '一括登録',
    24 => 'ユーザーの一括登録',
    25 => 'ユーザーをGeeklogに一括登録できます。一括登録するファイルはタブ区切りのテキストファイルで、「氏名、ユーザー名、メールアドレス」の順序のフィールドでなければなりません。一括登録したユーザーには、無作為に選択したパスワードを含んだメールを送信します。1行に1ユーザーとしなければなりません。この手順で何らかのエラーを起こすと手作業による作業が必要となりますから、二重に各項目を検査してください!  (訳註: ファイルはかならず本サイトと同じ文字コードのテキスト形式で保存してください。)',
    26 => '',
    27 => '',
    28 => 'チェックした画像を削除します',
    29 => 'パス',
    30 => '実行',
    31 => '新規ユーザー',
    32 => '処理を完了しました。登録成功: %d 件 エラー: %d 件',
    33 => '検索',
    34 => 'エラー: 登録するファイルを指定してください。',
    35 => '最後のログイン日時',
    36 => '未',
    37 => 'ユーザーID',
    38 => 'グループ一覧',
    39 => 'パスワード(再入力)',
    40 => '登録日',
    41 => '最終ログイン',
    42 => '禁止',
    43 => '有効となるのを待機中',
    44 => '承認が通るのを待機中',
    45 => '有効',
    46 => 'ユーザーの状態',
    47 => '編集',
    48 => '管理者グループを表示',
    49 => '管理者グループ',
    50 => 'このグループを管理者グループとしてフィルタリングするには、チェックしてください。',
    51 => 'オンライン期間',
    52 => '<br' . XHTML . '>注: 「オンライン期間」とは、最初にアカウントを登録してから前回ログインした時までの日数です。',
    53 => '登録済み',
    54 => '一括削除',
    55 => 'この機能はコンフィギュレーションの管理パネルで「最終ログインを記録する」を有効に設定している場合にのみ動作します。',
    56 => '削除したいユーザーの種類を選択して「リスト更新」をクリックしてください。次に、削除したくないユーザーのチェックを外して、削除アイコンをクリックしてください。このリストがページをまたがっている場合、現在表示しているユーザーだけ削除しますので注意してください。',
    57 => '幽霊ユーザー',
    58 => '一時的ユーザー',
    59 => '過去のユーザー',
    60 => '一度もログインしていない、',
    61 => 'ヶ月以前に登録したユーザーです。',
    62 => '登録して24時間以内にログインした後で一度もログインしていない、',
    63 => 'ヶ月以前に登録したユーザーです。',
    64 => '通常のユーザーでサイトを、',
    65 => 'ヶ月間、訪問していないユーザーです。',
    66 => 'リストを更新',
    67 => '登録して月数',
    68 => 'オンライン時間',
    69 => 'オフライン月数',
    70 => '削除できませんでした',
    71 => '削除しました',
    72 => '削除するユーザーを選択していません',
    73 => '削除すると元に戻せませんが、選択したユーザーをすべて削除してよいですか?',
    74 => '最近のユーザー',
    75 => '最近',
    76 => 'ヶ月に登録したユーザーです。',
    77 => '選択したユーザーにログインのリマインダーをメールで送信',
    78 => 'リマインダーを送信',
    79 => 'リマインダーを送信するユーザーを選択していません',
    80 => 'リマインダーを送信しました',
    81 => '%sのアカウントを検証するためのリマインダー',
    82 => "あなたの{$_CONF['site_name']}のアカウントは%sからアクセスしていません。今後30日以内にアクセスしないと無効になりますのでご注意ください。",
    83 => "あなたの{$_CONF['site_name']}のアカウントは作成後使用していません。このままアクセスしないと近日中に削除しますのでご注意ください。",
    84 => "あなたのログイン名: %s  サイト名: {$_CONF['site_url']}",
    85 => 'パスワードを紛失した場合には、以下のリンクをクリックしてください: %s',
    86 => '含む',
    87 => 'リマインダー',
    88 => 'デフォルトグループ',
    89 => '新規登録ユーザーのデフォルトグループをチェック',
    90 => '登録済みユーザーアカウントにデフォルトグループを追加する',
    'autotag_desc_user' => '[user: name alternate title] - ユーザー名をタイトルとしてユーザーへのリンクを表示します。別のタイトルを指定できますが、必須ではありません。'
);

###############################################################################
# admin/moderation.php

$LANG29 = array(
    1 => '承認',
    2 => '削除',
    3 => '編集',
    4 => 'プロフィール',
    10 => 'タイトル',
    11 => '開始日',
    12 => 'URL',
    13 => '投稿',
    14 => '日付',
    15 => '話題',
    16 => 'ユーザー名',
    17 => '氏名',
    18 => 'メールアドレス',
    34 => '投稿の管理',
    35 => '記事の投稿申請',
    36 => 'コメントの親',
    37 => '',
    38 => '実行',
    39 => '現在のところ申請はありません',
    40 => 'ユーザーの登録申請',
    41 => 'コメントの投稿申請',
    42 => 'ユーザー名',
    43 => 'コメントを自動的に公開?'
);

###############################################################################
# admin/mail.php

$LANG31 = array(
    1 => 'メール送信',
    2 => '送信者名',
    3 => '返信先',
    4 => '件名',
    5 => '内容',
    6 => '送信先:',
    7 => 'すべてのユーザー',
    8 => '管理者',
    9 => 'オプション',
    10 => 'HTML',
    11 => '緊急!',
    12 => 'メールを送信する',
    13 => '入力しなおす',
    14 => 'ユーザーの受信許可設定を無視して送る',
    15 => '送信中にエラーが発生。宛先: ',
    16 => 'メッセージの送信を完了しました。宛先: ',
    17 => "<a href={$_CONF['site_admin_url']}/mail.php>別のメッセージを送る</a>",
    18 => '送信先',
    19 => '補足: 登録者全員に送信するには、送信先のドロップダウンメニューから「Logged-in Users」を選択してください。',
    20 => "<successcount> 件のメッセージの送信に成功し、<failcount> 件のメッセージの送信には失敗しました。個別のメッセージの送信状態は次のとおりです。<a href=\"{$_CONF['site_admin_url']}/mail.php\">別のメッセージを送信</a>するか、<a href=\"{$_CONF['site_admin_url']}/moderation.php\">管理画面に戻る</a>ことができます",
    21 => '送信に失敗',
    22 => '送信に成功',
    23 => '失敗した送信先はありません',
    24 => '成功した送信先はありません',
    25 => '-- グループを選択 --',
    26 => 'すべてのフィールドに入力してください。また、グループはドロップダウンメニューから選択してください。'
);

###############################################################################
# admin/plugins.php

$LANG32 = array(
    1 => 'プラグインのインストールはGeeklogに、最悪の場合はシステムに悪影響を与える可能性があります。Geeklogの公式サイトに登録してある、すべてのプラグインは様々なオペレーティングシステムで十分にテストしていますから、<a href="http://www.geeklog.net">Geeklogのホームページ</a>からダウンロードしたプラグインだけをインストールすることが重要です。プラグインのインストールの処理ではファイルシステムのコマンドの実行が必要となることを理解することが重要です。特に公式サイト以外が提供しているプラグインを使用する場合にセキュリティの問題を招く可能性があります。これらの警告をしていますが、Geeklogのプラグインのインストールできることを保証しませんし、プラグインをインストールしたことによる損傷に責任は持てません。言い換えれば、自己責任でインストールしてください。プラグインを手作業でインストールする方法の説明は各プラグインのパッケージに含まれています。',
    2 => 'プラグインのインストールに関する注意',
    3 => 'プラグインのインストールのフォーム',
    4 => 'プラグインのファイル',
    5 => 'プラグインの一覧',
    6 => '警告: プラグインは既にインストール済みです。',
    7 => 'インストールしようとしているプラグインは既に存在します。再インストールする前にいったん削除してください。',
    8 => 'プラグインの互換性チェックに失敗しました。',
    9 => 'このプラグインは、より新しいバージョンのGeeklogに対応しています。<a href=http://www.geeklog.jp>Geeklog</a>をアップグレードしてください。(訳註: または、Geeklogに対応しているバージョンのプラグインを入手してください。)',
    10 => '<br' . XHTML . '><strong>インストールしているプラグインはありません。</strong><br' . XHTML . '><br' . XHTML . '>',
    11 => 'プラグインを編集や削除するには、プラグインの編集アイコンをクリックしてください。すると、プラグイン作者のWebサイトを含んだ詳細を表示します。インストールしているバージョンとプラグインのコードから得られたバージョンの両方を表示します。これはプラグインのアップグレードが必要かどうかを知るのに役立ちます。プラグインのインストールやアップグレードについては、そのドキュメントをご覧ください。',
    12 => 'plugineditor()にプラグイン名が渡されませんでした',
    13 => 'プラグイン情報センター',
    14 => 'インストールしていないプラグイン',
    15 => '管理画面',
    16 => 'プラグイン名',
    17 => 'プラグインのバージョン',
    18 => 'Geeklogのバージョン',
    19 => '有効',
    20 => 'はい',
    21 => 'いいえ',
    22 => 'インストール',
    23 => '保存',
    24 => 'キャンセル',
    25 => '削除',
    26 => 'プラグイン名',
    27 => 'プラグインWebページ',
    28 => 'インストールしているバージョン',
    29 => 'Geeklogのバージョン',
    30 => 'このプラグインを削除しますか?',
    31 => 'このプラグインを本当に削除しますか?  削除するとプラグインが使用しているデータやデータ構造をすべて削除します。削除する場合は下の「削除」ボタンをもう一度クリックしてください。',
    32 => '<p><strong>自動タグのフォーマットエラーです。</strong></p>',
    33 => 'コードのバージョン',
    34 => 'アップデート',
    35 => '編集',
    36 => 'コード',
    37 => 'データ',
    38 => 'アップデートを実行!',
    39 => 'プラグインのアップロード',
    40 => 'プラグインの圧縮ファイル (.tar.gz, .tgz, .zip) を直接ここにアップロードできます:',
    41 => 'アップロード',
    42 => 'アップデート',
    43 => 'ロードの順番',
    44 => 'ロードの順番を上げる',
    45 => 'ロードの順番を下げる',
    46 => 'プラグインを削除する',
    47 => '%s プラグインを本当に削除してよいですか?',
    48 => 'プラグインを有効にする',
    49 => 'プラグインを無効にする',
    50 => '依存関係',
    51 => 'OK',
    52 => '未解決',
    53 => '無効',
    54 => '利用不可',
    55 => 'インストールしていない',
    56 => '誤ったバージョン',
    57 => '不明',
    58 => '依存関係を解決するため、プラグインをロードする順番を変更しました。',
    59 => '情報',
    60 => '閉じる',
    61 => '状態',
    62 => 'プラグインをインストールする',
    63 => 'プラグインをインストールできませんでした',
    64 => 'プラグインを有効にできませんでした',
    65 => 'プラグインアップロードの機能は以下のエラーのため無効にしています。:',
    66 => 'PHPの設定でファイルアップロードは無効となっています。',
    67 => 'ディレクトリ "%s" は書き込みできません。',
    68 => 'あなたにはプラグインをインストールする権限はありません。',
    69 => 'あなたにはプラグインをアップロードする権限はありません。',
    99 => '不明なエラーが発生しました。',
    100 => 'Ok.',
    101 => 'アップロードしようとしたファイルのサイズが php.ini 内の upload_max_filesize の値を超えています。',
    102 => 'アップロードファイルのサイズがHTMLのフォームで指定していた MAX_FILE_SIZE の値を超えています。',
    103 => 'アップロードしたファイルは一部分だけでした。',
    104 => 'アップロードできませんでした。',
    105 => '(未定義のエラー)',
    106 => '一時フォルダーがありません。',
    107 => 'ディスクにファイルを書き込みできませんでした。',
    108 => 'ファイルの拡張子の制限のためアップロードを中止しました。'
);

###############################################################################
# admin/syndication.php

$LANG33 = array(
    1 => 'フィードの作成',
    2 => '保存',
    3 => '削除',
    4 => 'キャンセル',
    10 => 'フィード',
    11 => '新しいフィード',
    12 => '管理画面',
    13 => 'フィードを編集や削除するには下の編集アイコンをクリックしてください。フィードを作成するには上の「新規作成」をクリックしてください。',
    14 => 'タイトル',
    15 => 'タイプ',
    16 => 'ファイル名',
    17 => 'フォーマット',
    18 => '更新日',
    19 => '有効',
    20 => 'はい',
    21 => 'いいえ',
    22 => '<i>(フィードはありません)</i>',
    23 => 'すべての話題',
    24 => 'フィードの編集',
    25 => 'フィードタイトル',
    26 => '制限',
    27 => 'エントリの長さ',
    28 => '(0 = 本文なし, 1 = 本文すべて, その他 = 指定した文字数に制限)',
    29 => '説明',
    30 => '更新日時',
    31 => '文字セット',
    32 => '言語',
    33 => 'コンテンツ',
    34 => 'エントリ数',
    35 => '時間',
    36 => 'フィードのタイプを選択してください。',
    37 => '',
    38 => 'エラー: 入力していない項目があります。',
    39 => 'フィードのタイトル、詳細、ファイル名を入力してください。',
    40 => 'エントリ数または、取得する時間を入力してください。',
    41 => 'リンク',
    42 => '',
    43 => 'すべて',
    44 => 'なし',
    45 => '話題にヘッダーリンク',
    46 => '表示件数',
    47 => '検索',
    48 => '編集',
    49 => 'フィードロゴ',
    50 => "本サイト({$_CONF['site_url']})からの相対URL",
    51 => '選択したフィード名は他のフィードで使用しています。異なる名前にしてください。',
    52 => 'エラー: このファイル名を既に使用しています',
    53 => 'トップページのすべての記事',
    54 => '新規作成するフィードのタイプを選んでください。',
    55 => '記事'
);

###############################################################################
# confirmation and error messages

$MESSAGE = array(
    1 => "パスワードをメールで送信しましたので確認してください。利用方法はメールを参照してください。{$_CONF['site_name']}",
    2 => "{$_CONF['site_name']} に記事を投稿していただきありがとうございます。記事はスタッフによる承認待ちとなっています。承認が済むと、記事はサイトに公開します。",
    3 => '',
    4 => '',
    5 => 'アカウント情報を保存しました。',
    6 => '表示を設定しました。',
    7 => 'コメントを設定しました。',
    8 => 'ログアウトしました。',
    9 => '記事を保存しました。',
    10 => '記事を削除しました。',
    11 => 'ブロックを保存しました。',
    12 => 'ブロックを削除しました。',
    13 => '話題を保存しました。',
    14 => '話題とその話題に属するすべての記事とブロックを削除しました',
    15 => 'あなたのコメントは投稿済みです。管理者の承認後に公開されます。',
    16 => 'あなたは登録を解除しました。今後、新たな通知を受けることはありません。',
    17 => '',
    18 => '',
    19 => '',
    20 => '',
    21 => 'ユーザー情報を保存しました。',
    22 => 'ユーザー情報を削除しました。',
    23 => '',
    24 => '',
    25 => '',
    26 => '',
    27 => 'メッセージを送信しました。',
    28 => 'プラグインを保存しました',
    29 => 'あなたはこの管理ページにアクセスできません。権限のない機能へのアクセスはすべて記録しています。',
    30 => 'アクセスできません',
    31 => '',
    32 => '',
    33 => '',
    34 => '',
    35 => '',
    36 => '',
    37 => '',
    38 => '',
    39 => '',
    40 => 'システムからのメッセージ',
    41 => '',
    42 => '',
    43 => '',
    44 => 'プラグインをインストールしました!',
    45 => 'プラグインを削除しました。',
    46 => '',
    47 => '',
    48 => "{$_CONF['site_name']}にご登録ありがとうございます。管理者の間で審査します。登録を承認すると、あなたの入力したメールアドレスにパスワードを送信します。",
    49 => 'グループを保存しました。',
    50 => 'グループを削除しました。',
    51 => '既に使用しているユーザー名です。別の名前を指定してください。',
    52 => '入力したメールアドレスは有効なメールアドレスではないようです。',
    53 => '新しいパスワードを登録しました。この新しいパスワードを使ってログインしてください。',
    54 => 'あなたの新規パスワード発行申請は期限が切れています。下のフォームから再申請してください。',
    55 => 'メールを送信しました。届いたメールの指示にしたがって新しいパスワードを設定してください。',
    56 => 'メールアドレスは別のアカウントが既に使用しています。',
    57 => 'アカウントの削除を完了しました。',
    58 => 'フィードを保存しました。',
    59 => 'フィードを削除しました。',
    60 => 'プラグインをアップデートしました。',
    61 => '%sプラグイン: メッセージのプレイスホルダーが不明です。',
    62 => 'トラックバックのコメントを削除しれました。',
    63 => 'トラックバックのコメントを削除するときにエラーが発生しました。',
    64 => 'トラックバックのコメントを送信しました。',
    65 => 'Weblog ディレクトリサービスを保存しました。',
    66 => 'Weblog ディレクトリサービスを削除しました。',
    67 => '新しいパスワードと確認用パスワードが一致しません。',
    68 => '正しい現在のパスワードを入力してください。',
    69 => 'アカウントを封鎖しました。',
    70 => 'アカウントは管理者の承認待ちです。',
    71 => 'アカウントの確認をしました、そして管理者の承認待ちです。',
    72 => 'プラグインのインストールしてる間にエラーが起きました。error.logを確認してください。',
    73 => 'プラグインのアンインストールしている間にエラーが起きました。error.logを確認してください。',
    74 => 'ピングバックが送信しました。',
    75 => 'トラックバックはPOSTリクエストを雌黄して送信すしなければなりません。',
    76 => 'この項目を削除してもよいですか?',
    77 => '警告:<br' . XHTML . '>エンコーディングのデフォルトをUTF-8に設定していますが、サーバーがマルチバイトのエンコーディングをサポートしていません。PHPにmbstringモジュールをインストールするか、UTF-8ではない文字セットや言語に変更してください。',
    78 => 'メールアドレスと確認用メールアドレスには同じものを入力してください。',
    79 => '開こうしたページは、このサイトにもはや存在していない機能を参照しています。',
    80 => 'このフィードを作成したプラグインは現在無効となっています。そのプラグインを再び有効にするまで、フィードの編集はできません。',
    81 => 'ログイン情報の入力が不正確だったようです。もう一度、ログインし直してください。',
    82 => 'ログインの試行回数を超えました。後ほどまたログインしてください。',
    83 => 'パスワード、メールアドレス、認証の保存期間を変更するには現在のパスワードを入力してください。',
    84 => 'アカウントを削除するには現在のパスワードを入力してください。',
    85 => 'メールの送信に問題がありました。',
    86 => 'OpenIDのサーバがログインを受け付けませんでした。',
    87 => 'OpenIDのログイン処理をユーザーが取り消しました。',
    88 => 'OpenIDのサーバがエラーを返しました。',
    89 => '指定した識別のURLに対するOpenIDのサーバのURLが見つかりません。',
    90 => 'OpenIDの識別を取り消しました。',
    91 => '無効な識別のURLを指定しました。',
    92 => "使用する前に<a href=\"{$_CONF['site_admin_url']}/sectest.php\">Webサイトのセキュリティチェックを行ってください</a>!",
    93 => 'データベースのバックアップしました。',
    94 => 'バックアップのエラー: ファイルサイズが1Kバイト未満です。',
    95 => 'エラーが発生しました。',
    96 => '',
    97 => '',
    98 => 'プラグインをアップロードしました。',
    99 => 'プラグインは既に存在します。',
    100 => 'アップロードしたファイルは GZip または Zip で圧縮したアーカイブではありませんでした。',
    101 => '(アクセスできる)話題はありません。記事を投稿するには少なくとも1つの話題が必要です。',
    110 => '認証用のURLを取得できません。',
    111 => '認証のエラーが発生しました。',
    112 => '証明書は取り消されています。',
    113 => 'アカウントをTwitter経由で作成しました。 {site_url}',
    114 => 'リモートアカウントの再同期に失敗しましたが、他のアカウント情報を保存しました。',
    115 => 'リモートサービスは無効となりました。',
    400 => '検証に通っていない必須のフィールドがあります。',
    401 => '氏名を入力してください。'
);

###############################################################################

$LANG_ACCESS = array(
    'access' => 'アクセス',
    'ownerroot' => '所有者/Root',
    'group' => 'グループ',
    'readonly' => '読み取り専用',
    'accessrights' => 'アクセス権',
    'owner' => '所有者',
    'grantgrouplabel' => '上記のグループに編集権限を付与',
    'permmsg' => '注意: メンバーとはすべてのログインしているサイトのメンバーで、ゲストユーザーはログインせずにアクセスしているすべての利用者です。',
    'securitygroups' => 'セキュリティグループ',
    'editrootmsg' => "管理権限を持っていても、rootユーザーにならずにrootユーザーの編集はできません。rootを除いた他のすべてのユーザーを編集できます。不正にrootユーザーを編集しようする試みはすべて記録していることに注意してください。<a href=\"{$_CONF['site_admin_url']}/user.php\">ユーザー管理ページ</a>に戻る",
    'securitygroupsmsg' => 'このユーザーを所属させたいグループをチェックしてください。',
    'groupeditor' => 'グループの編集',
    'description' => '説明',
    'name' => '名前',
    'rights' => '権限',
    'missingfields' => '未入力の項目',
    'missingfieldsmsg' => '名前と説明を入力してください。',
    'groupmanager' => 'グループの管理',
    'newgroupmsg' => 'グループの編集や削除は下の編集アイコンをクリックしてください。新しいグループの作成は上の「新規作成」をクリックしてください。ただし、「コア(中核)グループ」はシステムで使用するため削除できません。',
    'groupname' => 'グループ名',
    'coregroup' => 'コアグループ',
    'yes' => 'はい',
    'no' => 'いいえ',
    'corerightsdescr' => "このグループは、{$_CONF['site_name']}の「コア(中核)グループ」です。そのため、このグループの権限を編集することはできません。このグループの権限リストを読み取り専用で以下に表示しています。",
    'groupmsg' => '本サイトのセキュリティグループは階層的になっています。本グループを以下のグループに追加すると、そのグループの持つ権限と同じ権限を本グループにも与えます。可能であれば、本グループに権限を与える場合、以下のグループの権限を継承させることを推奨します。本グループに個別に権限を与える場合は、以下の「権限」の部分から様々な機能に関する権限を選択できます。本グループを追加するには以下のグループの横にあるボックスをチェックするだけです。',
    'coregroupmsg' => "本グループは{$_CONF['site_name']}の「コア(中核)グループ」です。そのため、本グループの所属するグループは編集できません。このグループの権限リストを読み取り専用で以下に表示しています。",
    'rightsdescr' => 'グループのアクセス権は以下の権限で直接指定するか、グループが所属する異なるグループの権限を継承します。以下でチェックのない権限はこのグループが所属するグループから継承した権限です。チェックのある権限はこのグループに直接指定している権限です。',
    'lock' => 'ロック',
    'members' => 'メンバー',
    'anonymous' => 'ゲストユーザー',
    'permissions' => 'パーミッション',
    'permissionskey' => 'R = 表示, E = 編集, (編集権は表示権を含む)',
    'edit' => '編集',
    'none' => 'なし',
    'accessdenied' => 'アクセスできません',
    'storydenialmsg' => "この記事を表示する権限がありません。これは、あなたが{$_CONF['site_name']}のメンバーでないためだと思われます。メンバーとしてのアクセスを得るには{$_CONF['site_name']} の<a href=\"{$_CONF['site_url']}/users.php?mode=new\" rel=\"nofollow\">メンバーになる</a>を使用してください。",
    'nogroupsforcoregroup' => 'このグループは他のどのグループにも所属していません',
    'grouphasnorights' => 'このグループにはサイトを管理する機能のどれにも権限はありません。',
    'newgroup' => '新しいグループ',
    'adminhome' => '管理画面',
    'save' => '保存',
    'cancel' => 'キャンセル',
    'delete' => '削除',
    'canteditroot' => 'Rootグループに所属していないのにRootグループを編集しようとしたため、グループにアクセスできませんでした。これがエラーだと思う場合はシステムの管理者に連絡してください。',
    'listusers' => 'ユーザーの表示と編集',
    'listthem' => 'リスト',
    'usersingroup' => '"%s"に含まれるユーザーの一覧',
    'usergroupadmin' => 'グループ管理',
    'add' => '追加',
    'remove' => '削除',
    'availmembers' => 'ユーザー一覧',
    'groupmembers' => 'グループメンバー',
    'canteditgroup' => 'グループを編集するためには、グループのメンバーでなければなりません。これがエラーだと思う場合はシステムの管理者に連絡してください。',
    'cantlistgroup' => 'メンバーリストを見るには、グループのメンバーでなければなりません。これがエラーだと思う場合はシステムの管理者に連絡してください。',
    'editgroupmsg' => 'グループメンバーを変更するには、メンバー名をクリックして「追加」または「削除」ボタンをクリックしてください。ユーザーがグループメンバーの場合は、名前を右側にだけ表示します。作業を終えましたら、「保存」ボタンをクリックすると管理画面に戻ります。',
    'listgroupmsg' => 'グループ<strong>%s</strong>に含まれるユーザー:',
    'search' => '検索',
    'submit' => '実行',
    'limitresults' => '件数',
    'group_id' => 'グループID',
    'plugin_access_denied_msg' => 'このプラグインの管理権限がないのに管理画面にアクセスしようとしました。不正にこのページにアクセスする試みはすべて記録していることに注意してください。',
    'groupexists' => 'このグループ名は既に存在しています。',
    'groupexistsmsg' => '同じグループ名があります。グループ名は重複してはいけません。'
);

###############################################################################
# admin/database.php

$LANG_DB_BACKUP = array(
    'last_ten_backups' => 'データベースバックアップ',
    'do_backup' => 'バックアップの実行',
    'backup_successful' => 'データベースのバックアップを完了しました。',
    'db_explanation' => 'サイトのデータベースのバックアップを新しく作成するには「新規作成」をクリックしてください。',
    'not_found' => "正しくないパス、セキュリティ上の制限が適用、mysqldumpの実行ができない、といった状況です。<br" . XHTML . "> コンフィギュレーションで<strong>mysqldump_path</strong>の設定を確認してください。<br" . XHTML . "> PHPの<a href=\"http://www.php.net/manual/en/features.safe-mode.php#ini.open-basedir\">open_basedir</a>の設定を確認してください。<br" . XHTML . "> 現在のパスは<var>{$_DB_mysqldump_path}</var>に設定しています。",
    'zero_size' => 'バックアップに失敗: ファイルの大きさが0バイトです。',
    'path_not_found' => "{$_CONF['backup_path']} は存在しないか、ディレクトリではありません。",
    'no_access' => "エラー: {$_CONF['backup_path']} にアクセスできません。",
    'backup_file' => 'バックアップファイル',
    'size' => 'サイズ',
    'bytes' => 'バイト',
    'total_number' => 'バックアップの総数は %d です。',
    'download' => 'ファイルダウンロード',
    'new_backup' => '新規バックアップ',
    'delete_failure' => '1つ以上のバックアップのファイルを削除できませんでした。',
    'delete_success' => 'バックアップファイルを削除しました。',
    'convert_menu' => 'InnoDBへの変換',
    'convert_title' => 'InnoDBテーブルへの変換',
    'convert_button' => '変換',
    'sorry_no_innodb' => 'あなたのMySQLのバージョンはInnoDBテーブルをサポートしていません。',
    'innodb_explain' => 'InnoDBテーブルは <em>真に</em> 大きなデータベースではより良い性能を提供しますが、バックアップ作業をより複雑にします。この操作を実行する前に、InnoDBテーブルの長所と短所について<a href="http://dev.mysql.com/doc/mysql/en/innodb.html">調べて</a>ください。',
    'already_converted' => '注意: すべてのテーブルは既にInnoDBに変換してあるようです。',
    'conversion_patience' => '注意: 変換には少々の時間が必要です。今しばらく、お待ちください。',
    'innodb_success' => 'InnoDBテーブルへの変換を完了しました。',
    'table_issues' => 'いくつかのテーブルで問題が発生した可能性があります。詳細については、error.logを確認してください。',
    'optimize_menu' => 'テーブルの最適化',
    'optimize_title' => 'テーブルの最適化',
    'optimize_button' => '最適化',
    'optimize_explain' => 'テーブルの最適化はサイトの性能を改善することに役立つかもしれません。実際の効果はテーブルの利用状況に依存し、テーブルによっては比較的大きな効果が得られるかもしれません。性能に非常に大きな差が出ると期待しないでください。<a href="http://dev.mysql.com/doc/mysql/en/optimize-table.html">MySQLマニュアル</a>サイトは次のように述べています: <q>1週間または1ヶ月のうちに何回もこれを行う必要はないでしょう。</q>',
    'last_optimization' => '最新の最適化',
    'optimization_patience' => '注意: 最適化には少々の時間を必要とします。今しばらく、お待ちください。',
    'optimize_success' => 'データベースのテーブルの最適化を完了しました。'
);

###############################################################################

$LANG_BUTTONS = array(
    1 => 'ホーム',
    2 => 'メールを送る',
    3 => '記事公開',
    4 => '',
    5 => '',
    6 => '',
    7 => 'サイトの統計情報',
    8 => '個人設定',
    9 => '検索',
    10 => '検索オプション',
    11 => '記事管理'
);

###############################################################################
# 404.php

$LANG_404 = array(
    1 => '404 Error',
    2 => '<strong>%s</strong>はどこにも見つかりませんでした。',
    3 => "<p>指定したファイルは存在しません。<a href=\"{$_CONF['site_url']}\">メインページ</a>をチェックしたり、<a href=\"{$_CONF['site_url']}/search.php\">検索ページ</a>で探してみてください。"
);

###############################################################################
# login form

$LANG_LOGIN = array(
    1 => 'ログインしてください',
    2 => '先にログインしてください。',
    3 => 'ログイン',
    4 => '新規登録'
);

###############################################################################
# trackback.php

$LANG_TRB = array(
    'trackback' => 'トラックバック',
    'from' => 'from',
    'tracked_on' => 'トラックバック オン',
    'read_more' => '続きを読む',
    'intro_text' => '\'%s\'について他のサイトでは次のように言及しています:',
    'no_comments' => 'この記事にはトラックバック・コメントがありません。',
    'this_trackback_url' => 'このエントリのトラックバックURL:',
    'num_comments' => '%d件のトラックバック',
    'send_trackback' => 'トラックバック・ピングを送信',
    'preview' => 'プレビュー',
    'editor_title' => 'トラックバック・コメントを送信',
    'trackback_url' => 'トラックバックURL',
    'entry_url' => 'エントリのURL',
    'entry_title' => 'エントリのタイトル',
    'blog_name' => 'サイト名',
    'excerpt' => '概要',
    'truncate_warning' => '注: 受信したサイト側で概要を切り詰めることがあります',
    'button_send' => '送信',
    'button_preview' => 'プレビュー',
    'send_error' => 'エラー',
    'send_error_details' => 'トラックバックの送信中にエラーが発生しました:',
    'url_missing' => 'エントリのURL',
    'url_required' => '少なくともエントリのURLを入力してください。',
    'target_missing' => 'トラックバックURLがありません',
    'target_required' => 'トラックバックURLを入力してください',
    'error_socket' => 'ソケットをオープンできませんでした。',
    'error_response' => '理解できない応答です。',
    'error_unspecified' => '詳細不目なエラーです。',
    'select_url' => 'トラックバックURLを選択してください',
    'not_found' => 'トラックバックURLが見つかりません',
    'autodetect_failed' => 'コメントを送ろうとした記事のトラックバックURLが見つかりませんでした。URLを下に入力してください。',
    'trackback_explain' => '以下のリンクからトラックバックを送りたいURLを選択してください。その記事の正しいトラックバックURLをGeeklogは見つけようとします。URLがわかっているなら<a href="%s">手作業で入力</a>もできます。',
    'no_links_trackback' => 'リンクが見つかりません。このエントリにトラックバック・コメントを送信できません。',
    'pingback' => 'ピングバック',
    'pingback_results' => 'ピングバックの結果',
    'send_pings' => 'ピングを送信',
    'send_pings_for' => '"%s"にトラックバック・ピングを送信',
    'no_links_pingback' => 'リンクが見つかりません。このエントリへのピングバックを送信できませんでした。',
    'pingback_success' => 'ピングバックを送信しました。',
    'no_pingback_url' => 'ピングバックURLが見つかりません。',
    'resend' => '再送信',
    'ping_all_explain' => 'あなたがリンクしたことを相手のサイトに知らせたり(<a href="http://en.wikipedia.org/wiki/Pingback">ピングバック</a>)、Webログディレクトリサービスにピングを送ってサイトの更新を知らせたり、誰かのサイトの記事について書いたときに<a href="http://ja.wikipedia.org/wiki/%E3%83%88%E3%83%A9%E3%83%83%E3%82%AF%E3%83%90%E3%83%83%E3%82%AF">トラックバック</a>を送ったり、といったことをできます。',
    'pingback_button' => 'ピングバック送信',
    'pingback_short' => '記事のすべてのリンク先にピングバックを送信します。',
    'pingback_disabled' => '(ピングバックは無効です)',
    'ping_button' => 'ピング送信',
    'ping_short' => '登録したWebログサイトにピングを一斉送信します。',
    'ping_disabled' => '(ピングは無効です)',
    'trackback_button' => 'トラックバック送信',
    'trackback_short' => '記事のリンク先にトラックバックを送信します。',
    'trackback_disabled' => '(トラックバックは無効です)',
    'may_take_a_while' => 'ピングバックやピングの送信には時間がかかることがあります。',
    'ping_results' => 'ピングの結果',
    'unknown_method' => '不明なピングメソッドです。',
    'ping_success' => 'ピングを送信しました。',
    'error_site_name' => 'サイト名を入力してください。',
    'error_site_url' => 'サイトのURLを入力してください。',
    'error_ping_url' => '正しいピングURLを入力してください。',
    'no_services' => 'Webログディレクトリサービスを設定していません。',
    'services_headline' => 'トラックバック管理',
    'service_explain' => 'ピング送信先のWebログディレクトリサービスの編集や削除をするには下の編集アイコンをクリックしてください。新しいWebログディレクトリサービスを追加する場合は「新規作成」をクリックしてください。',
    'service' => 'サービス',
    'ping_method' => 'ピングメソッド',
    'service_website' => 'Webサイト',
    'service_ping_url' => 'ピングのURL',
    'ping_standard' => '標準ピング',
    'ping_extended' => '拡張ピング',
    'ping_unknown' => '(不明なメソッド)',
    'edit_service' => 'Webログディレクトリサービスの編集',
    'trackbacks' => 'トラックバック',
    'editor_intro' => '<a href="%s">%s</a>へのトラックバック・コメントを準備してください。',
    'editor_intro_none' => 'トラックバック・コメントを準備してください。',
    'trackback_note' => '記事にトラックバック・コメントを送るには、記事一覧でその記事の"トラックバック・ピングを送る"をクリックしてください。 記事に関係のないトラックバックを送るには <a href="%s">ここをクリック</a>してください。',
    'pingback_explain' => 'ピングバックするURLを入力してください。ピングバックはサイトのホームページを指し示します。',
    'pingback_url' => 'ピングバックURL',
    'site_url' => 'このサイトのURL',
    'pingback_note' => '記事へのピングバックを送るには、記事の一覧で、記事の行の「' . $LANG24[21] . '」をクリックしてください。記事に関係しないピングバックを送るには、<a href="%s">ここをクリック</a>してください。',
    'pbtarget_missing' => 'ピングバックURLではありません。',
    'pbtarget_required' => 'ピングバックURLを入力してください',
    'pb_error_details' => '次のピングバックの送信中にエラー:',
    'delete_trackback' => 'このトラックバックを削除: '
);

###############################################################################
# directory.php

$LANG_DIR = array(
    'title' => '記事一覧',
    'title_year' => '%d年の記事一覧',
    'title_month_year' => '%d年%s月の記事一覧',
    'nav_top' => '記事一覧のトップに戻る',
    'no_articles' => '記事がありません。'
);

###############################################################################
# admin/sectest.php

$LANG_SECTEST = array(
    'sectest' => 'Geeklog セキュリティチェック',
    'results' => 'セキュリティチェックの結果',
    'okay' => 'すべて適正です。',
    'please_fix' => 'サイトを使用する前に上記の問題を修正してください!',
    'please_note' => '100% セキュアなサイトはありません。このスクリプトは明白なセキュリティの問題だけ検証します。',
    'stay_informed' => 'Geeklogの新しい公開情報やセキュリティ問題の情報を継続してお知らせできるようにするために、(トラフィックの低い) %s メーリングリストに参加と、アップデート可能かどうかを確認するために時々の管理メニューの%sを実施、これらの両方または一方を行うことをお勧めします。',
    'public_html' => '"public_html"はあなたのサイトURLの一部に含めないようにしてください。もう一度 %s 内のpublic_htmlに関する部分を読んで、設定を変更してから次に進んでください。',
    'installation' => 'インストールの手順',
    'directory' => 'ディレクトリ',
    'failed_tmp' => '%sディレクトリに一時ファイルを作成できませんでした。ディレクトリのパーミッションを確認してください!',
    'fix_it' => 'これはセキュリティリスクで、修正すべきです!',
    'reachable' => 'あなたの %s はWebからアクセス可能です。',
    'not_reachable' => 'Good! あなたの %s はWebからアクセス不可能です。',
    'not_sure' => 'HTTPの応答コード%sを(%sのテストの実行時に)受信しました。この意味するところは不明です ...',
    'remove_inst' => '一旦サイトが立ち上って正常に動き始めましたら、必ずinstallディレクトリ%sを削除してください。',
    'remove_inst2' => 'そのままにしておくとインストールしたGeeklogを破壊、サイトの乗っ取っとり、重要な情報を読み出すといったことを悪意のあるユーザーに許してしまいます。',
    'inst_removed' => 'Good! あなたは既にinstallディレクトリを削除しています。',
    'fix_password' => 'あなたはまだ %s の Rootユーザーアカウントの<strong>パスワード</strong>をデフォルトの"password"から変更していません。',
    'password_okay' => 'Good! Rootユーザーアカウントのパスワードをデフォルトから変更しています。'
);

###############################################################################
# "What's New" Time Strings
# 
# For the first two strings, you can use the following placeholders.
# Order them so it makes sense in your language:
# %i    item, "Stories"
# %n    amount, "2", "20" etc.
# %t    time, "2" (weeks)
# %s    scale, "hrs", "weeks"

$LANG_WHATSNEW = array(
    'new_string' => '新着%i %n件(%t%s)',
    'new_last' => '新着(%t%s)',
    'minutes' => '分',
    'hours' => '時間',
    'days' => '日',
    'weeks' => '週',
    'months' => 'ヶ月',
    'years' => '年',
    'minute' => '分',
    'hour' => '時',
    'day' => '日',
    'week' => '週',
    'month' => '月',
    'year' => '年'
);

###############################################################################
# Month names

$LANG_MONTH = array(
    1 => ' 1',
    2 => ' 2',
    3 => ' 3',
    4 => ' 4',
    5 => ' 5',
    6 => ' 6',
    7 => ' 7',
    8 => ' 8',
    9 => ' 9',
    10 => '10',
    11 => '11',
    12 => '12'
);

###############################################################################
# Weekdays

$LANG_WEEK = array(
    1 => '日',
    2 => '月',
    3 => '火',
    4 => '水',
    5 => '木',
    6 => '金',
    7 => '土'
);

###############################################################################
# Admin - Strings
# 
# These are some standard strings used by core functions as well as plugins to
# display administration lists and edit pages

$LANG_ADMIN = array(
    'search' => '検索',
    'limit_results' => '件数',
    'submit' => '実行',
    'edit' => '編集',
    'edit_adv' => 'アドバンストエディター',
    'admin_home' => '管理画面',
    'create_new' => '新規作成',
    'create_new_adv' => '新規作成(アドバンスト)',
    'enabled' => '有効',
    'disabled' => '無効',
    'title' => 'タイトル',
    'page_title' => 'ページタイトル',
    'type' => 'タイプ',
    'topic' => '話題',
    'info' => 'インフォメーション',
    'help_url' => 'ヘルプURL',
    'save' => '保存',
    'cancel' => 'キャンセル',
    'install' => 'インストール',
    'delete' => '削除',
    'deleteitem' => 'Delete',
    'delete_sel' => '削除選択',
    'copy' => 'コピー',
    'no_results' => '- 見つかりませんでした -',
    'data_error' => '送信データに問題があります。データをチェックしてください',
    'preview' => 'プレビュー',
    'records_found' => '件数',
    'addchild' => '子を追加',
    'list' => 'リスト',
    'list_all' => 'すべてのリスト',
    'meta_description' => '説明文のメタタグ',
    'meta_keywords' => 'キーワードのメタタグ',
    'na' => 'N/A',
    'unavailable' => 'N/A',
    'warning' => '!!!',
    'token_expiry' => '%s までに編集してください。その時刻を過ぎると、このページに埋め込まれたセキュリティトークンは期限切れとなって、編集内容を失うことになります。',
    'token_expired' => 'この操作のセキュリティトークンは期限切れになりました。続けるには再度認証してください。',
    'reauth_msg' => 'この操作のセキュリティトークンは期限切れになりました。続けるには下の認証を行ってください。そうすれば今回の編集作業を失うことはありません。',
    'authenticate' => '認証する'
);

# Localisation of the texts for the various drop-down menus that are actually
# stored in the database. If these exist, they override the texts from the
# database.

$LANG_commentcodes = array(
    0 => 'コメントを有効',
    -1 => 'コメントを無効',
    1 => 'コメントを停止'
);

$LANG_commentmodes = array(
    'flat' => '一覧',
    'nested' => '入れ子',
    'threaded' => 'ツリー',
    'nocomment' => '表示しない'
);

$LANG_cookiecodes = array(
    0 => '受け付けない',
    3600 => '1時間',
    7200 => '2時間',
    10800 => '3時間',
    28800 => '8時間',
    86400 => '1日',
    604800 => '1週間',
    2678400 => '1ヶ月'
);

$LANG_dateformats = array(
    0 => 'システムのデフォルト'
);

$LANG_featurecodes = array(
    0 => '通常の記事',
    1 => '注目記事'
);

$LANG_frontpagecodes = array(
    0 => '該当する話題にのみ表示',
    1 => 'トップページに表示'
);

$LANG_postmodes = array(
    'plaintext' => 'テキスト',
    'html' => 'HTML'
);

$LANG_sortcodes = array(
    'ASC' => '古い順に',
    'DESC' => '新しい順に'
);

$LANG_trackbackcodes = array(
    0 => 'トラックバックを有効',
    -1 => 'トラックバックを停止'
);

###############################################################################
# Localization of the Admin Configuration UI

$LANG_CONFIG = array(
    'home' => 'ホーム',
    'admin_home' => 'サイト管理',
    'sections' => 'コンフィギュレーション',
    'restore' => '復元',
    'add_element' => '要素を追加',
    'save_changes' => '変更を保存',
    'reset_form' => 'リセット',
    'changes_made' => '変更が完了しました',
    'title' => 'コンフィギュレーション管理',
    'disable' => 'クリックしてこのオプションを無効にする',
    'enable' => '有効にする',
    'default_tab_name' => 'メイン',
    'search_configuration_label' => 'コンフィギュレーションの検索',
    'error_validation_occurs' => '正しくない設定値があります。これらのフィールドを修正してください。' . '(エラーの欄を示す設定変数をクリックしてください)'
);

$LANG_configsections['Core'] = array(
    'label' => 'Geeklog',
    'title' => 'Geeklogの設定'
);

$LANG_confignames['Core'] = array(
    'path_html' => 'HTMLパス',
    'site_url' => 'サイトのURL',
    'site_admin_url' => '管理画面のURL',
    'site_mail' => 'サイトのメールアドレス',
    'noreply_mail' => 'No-Replyメールアドレス',
    'mail_cc_enabled' => 'CC(カーボンコピー)を許可',
    'mail_cc_default' => 'CC(カーボンコピー)をデフォルトで使用',
    'site_name' => 'サイト名',
    'site_slogan' => 'スローガン',
    'owner_name' => '管理者名',
    'microsummary_short' => 'マイクロサマリ接頭子',
    'path_log' => 'ログ',
    'path_language' => '言語',
    'backup_path' => 'バックアップ',
    'path_data' => 'データ',
    'path_images' => '画像',
    'path_pear' => 'PEARのパス',
    'have_pear' => 'PEARをインストールしている',
    'mail_settings' => 'メール設定',
    'allow_mysqldump' => 'MySQLのダンプを許可',
    'mysqldump_path' => 'mysqldumpのパス',
    'mysqldump_options' => 'mysqldumpのオプション',
    'mysqldump_filename_mask' => 'バックアップファイル名',
    'theme' => 'テーマ',
    'doctype' => 'DOCTYPE宣言',
    'menu_elements' => 'メニュー項目',
    'path_themes' => 'テーマのパス',
    'disable_new_user_registration' => '新規ユーザー登録を停止する',
    'allow_user_themes' => 'テーマ選択を許可する',
    'allow_user_language' => '言語選択を許可する',
    'allow_user_photo' => '写真登録を許可する',
    'allow_username_change' => 'ユーザー名変更を許可する',
    'allow_account_delete' => 'アカウント削除を許可する',
    'hide_author_exclusion' => '所有者の非表示を許可する',
    'show_fullname' => 'ユーザー名の代わりに氏名を表示する',
    'show_servicename' => 'サービス名を表示する',
    'custom_registration' => 'カスタム登録を有効にする',
    'user_login_method' => 'ログイン方法',
    'facebook_login' => 'FacebookのOAuthを有効にする',
    'facebook_consumer_key' => 'Facebook OAuth Application ID',
    'facebook_consumer_secret' => 'Facebook OAuth Application Secret',
    'linkedin_login' => ' LinkedInのOAuthを有効にする',
    'linkedin_consumer_key' => 'LinkedIn OAuth API Key',
    'linkedin_consumer_secret' => 'LinkedIn OAuth Secret Key',
    'twitter_login' => 'TwitterのOAuthを有効にする',
    'twitter_consumer_key' => 'Twitter OAuth Consumer Key',
    'twitter_consumer_secret' => 'Twitter OAuth Consumer Secret',
    'spamx' => 'Spam-X',
    'sort_admin' => 'リンクを並べ替える',
    'language' => '言語',
    'locale' => 'ロケール',
    'date' => '日時のフォーマット',
    'daytime' => '日時の短縮フォーマット',
    'shortdate' => '日付の短縮フォーマット',
    'dateonly' => '月日だけのフォーマット',
    'timeonly' => '時刻だけのフォーマット',
    'week_start' => '週の開始',
    'hour_mode' => '時間制',
    'thousand_separator' => '千単位の区切り文字',
    'decimal_separator' => '小数点',
    'decimal_count' => '小数点以下の桁数',
    'language_files' => '言語ファイル[多言語モード]',
    'languages' => '言語名[多言語モード]',
    'timezone' => 'タイムゾーン',
    'site_disabled_msg' => 'サイト停止のメッセージまたはURL',
    'rootdebug' => 'Rootデバッグ',
    'cookie_session' => 'セッションのクッキー名',
    'cookie_name' => '永続的なクッキー名',
    'cookie_password' => 'パスワードのクッキー名',
    'cookie_theme' => 'テーマのクッキー名',
    'cookie_language' => '言語のクッキー名',
    'cookie_tzid' => 'タイムゾーンのクッキー名',
    'cookie_anon_name' => 'ゲストユーザー名のクッキー名',
    'cookie_ip' => 'クッキーにIPの埋め込み',
    'default_perm_cookie_timeout' => '永続的なクッキーの有効期限',
    'session_cookie_timeout' => 'セッションの有効期限',
    'cookie_path' => 'クッキーのパス',
    'cookiedomain' => 'クッキーのドメイン',
    'cookiesecure' => 'セキュア(HTTPS)なクッキー',
    'lastlogin' => '最終のログインを記録する',
    'num_search_results' => '検索結果表示件数のデフォルト',
    'loginrequired' => 'すべてにログインを必要とする',
    'submitloginrequired' => '投稿にログインを必要とする',
    'commentsloginrequired' => 'コメント投稿にログインを必要とする',
    'statsloginrequired' => '統計の参照にログインを必要とする',
    'searchloginrequired' => '検索にログインを必要とする',
    'profileloginrequired' => 'プロフィールの表示にログインを必要とする',
    'emailuserloginrequired' => 'メールの送信にログインを必要とする',
    'emailstoryloginrequired' => '記事のメール送信にログインを必要とする',
    'directoryloginrequired' => '記事の一覧表示にログインを必要とする',
    'storysubmission' => '記事の投稿を審査する',
    'usersubmission' => 'ユーザーの登録を審査',
    'listdraftstories' => 'ドラフトの記事を一覧に表示する',
    'notification' => '通知',
    'postmode' => '投稿モードのデフォルト',
    'speedlimit' => '投稿間隔の制限',
    'skip_preview' => 'プレビューしないで投稿する',
    'advanced_editor' => 'アドバンストエディターを使用する',
    'wikitext_editor' => 'Wikiテキストエディターを使用する',
    'cron_schedule_interval' => 'Cronのスケジュール間隔',
    'sortmethod' => '話題の並べ替え',
    'showstorycount' => '記事数を表示する',
    'showsubmissioncount' => '記事の投稿数を表示する',
    'hide_home_link' => 'Homeへのリンクを表示しない',
    'whosonline_threshold' => 'セッションのしきい値',
    'whosonline_anonymous' => 'ゲストユーザーに表示しない',
    'whosonline_photo' => '写真のサムネイルを表示する',
    'emailstories' => 'デイリーダイジェストの送信する',
    'emailstorieslength' => '記事の長さ',
    'emailstoriesperdefault' => 'ユーザー新規登録で有効をデフォルトにする',
    'allow_domains' => '自動的に許可するドメイン',
    'disallow_domains' => '自動的に拒否するドメイン',
    'newstoriesinterval' => '記事を"新着"とする期間',
    'newcommentsinterval' => 'コメントを"新着"とする期間',
    'newtrackbackinterval' => 'トラックバックを"新着"とする期間',
    'hidenewstories' => '記事の新着表示をしない',
    'hidenewcomments' => 'コメントの新着表示をしない',
    'hidenewtrackbacks' => 'トラックバックの新着表示をしない',
    'hidenewplugins' => 'プラグインの新着表示をしない',
    'title_trim_length' => 'タイトル最大長',
    'trackback_enabled' => 'トラックバックを有効にする',
    'pingback_enabled' => 'ピングバックを有効にする',
    'ping_enabled' => 'ピングを有効',
    'trackback_code' => 'トラックバックのデフォルト',
    'multiple_trackbacks' => 'マルチプルトラックバック',
    'trackbackspeedlimit' => 'トラックバックの間隔の制限',
    'check_trackback_link' => 'トラックバックの検査',
    'pingback_self' => '自身へピングバックする',
    'pingback_excerpt' => 'ピングバックを要約する',
    'link_documentation' => 'ドキュメントのリンクを表示する',
    'link_versionchecker' => 'バージョン検査のリンクを表示する',
    'maximagesperarticle' => '記事に配置する画像の最大数',
    'limitnews' => '1ページあたりの記事の表示数',
    'minnews' => '最小の記事の表示数',
    'contributedbyline' => '所有者を表示する',
    'hideviewscount' => '表示回数を表示しない',
    'hideemailicon' => 'メールアイコンを表示しない',
    'hideprintericon' => '印刷アイコンを表示しない',
    'allow_page_breaks' => '改ページの使用を許可する',
    'page_break_comments' => '改ページ時のコメント表示位置',
    'article_image_align' => '話題アイコンの表示位置',
    'show_topic_icon' => '話題アイコンをデフォルトで表示する',
    'draft_flag' => 'ドラフトモードをデフォルトにする',
    'frontpage' => 'トップページ配置をデフォルトにする',
    'hide_no_news_msg' => '記事がない場合のメッセージを表示しない',
    'hide_main_page_navigation' => 'ページナビゲーションを表示しない',
    'onlyrootfeatures' => 'Rootユーザーだけが注目記事を設定する',
    'aftersave_story' => '記事保存後の画面遷移',
    'aftersave_user' => 'ユーザー保存後の画面遷移',
    'show_right_blocks' => '右ブロックを常に表示する',
    'showfirstasfeatured' => '最初の記事を注目記事として表示する',
    'backend' => 'フィードを有効にする',
    'rdf_file' => 'フィードの出力ファイル',
    'rdf_limit' => 'フィードの最大数',
    'rdf_storytext' => 'フィードに含める話題の長さ',
    'rdf_language' => 'フィードの言語',
    'syndication_max_headlines' => 'インポートする見出しの数(ポータルブロック)',
    'comment_feeds_article_tag' => '記事のタグ',
    'comment_feeds_article_tag_position' => '記事のタグの位置',
    'comment_feeds_article_author_tag' => '記事の投稿者のタグ',
    'comment_feeds_comment_author_tag' => 'コメントの投稿者のタグ', 
    'copyrightyear' => 'Copyrightの年の設定',
    'image_lib' => '画像処理ライブラリ',
    'path_to_mogrify' => 'mogrifyのパス',
    'path_to_netpbm' => 'netpbmのパス',
    'debug_image_upload' => '画像のアップロードをデバッグする',
    'keep_unscaled_image' => '元の画像を保持する',
    'allow_user_scaling' => 'ユーザーに画像のサイズ変更を許可する',
    'jpeg_quality' => 'JPEGの画質',
    'max_image_width' => '幅の最大値',
    'max_image_height' => '高さの最大値',
    'max_image_size' => 'ファイルサイズの最大値',
    'max_topicicon_width' => '幅の最大値',
    'max_topicicon_height' => '高さの最大値',
    'max_topicicon_size' => 'ファイルサイズの最大値',
    'max_photo_width' => '幅の最大値',
    'max_photo_height' => '高さの最大値',
    'max_photo_size' => 'ファイルサイズの最大値',
    'use_gravatar' => 'Gravatarを使用する',
    'gravatar_rating' => 'Gravatarの評価',
    'force_photo_width' => '写真の幅を固定',
    'default_photo' => '写真のデフォルト',
    'commentspeedlimit' => 'コメントの投稿間隔の制限',
    'comment_limit' => '表示件数',
    'comment_mode' => '表示モード',
    'comment_code' => '新規作成時のデフォルト',
    'comment_edit' => 'コメントの編集を許可する',
    'comment_edittime' => 'コメントの編集時間(秒)',
    'commentsubmission' => '承認待ちリストに入れる',
    'passwordspeedlimit' => 'パスワードの取得制限間隔',
    'login_attempts' => 'ログイン試行最大回数',
    'login_speedlimit' => 'ログイン試行制限間隔',
    'pass_alg' => 'パスワードのハッシュアルゴリズム',
    'pass_stretch' => 'ハッシュストレッチカウント',
    'user_html' => 'ユーザーHTML',
    'admin_html' => '管理者HTML',
    'advanced_html' => 'アドバンストエディター用に追加のHTML',
    'skip_html_filter_for_root' => 'RootユーザーにHTMLフィルターを非適用',
    'allowed_protocols' => '許可するプロトコル',
    'disable_autolinks' => '自動タグを無効にする',
    'clickable_links' => 'URLをクリッカブルにする',
    'linktext_maxlen' => 'クリッカブルURLの長さ',
    'compressed_output' => 'HTMLの出力を圧縮して送信する',
    'frame_options' => '"クリックジャッキング"を防止',
    'page_navigation_max_pages' => 'ページナビゲーションの最大ページ数',
    'censormode' => '語句の検査',
    'censorreplace' => '置き換える単語',
    'censorlist' => 'バッドワード',
    'ip_lookup' => 'IPアドレス検索',
    'url_rewrite' => 'URLリライト',
    'cdn_hosted' => 'CDNのjQueryを使用する',
    'meta_tags' => 'メタタグ',
    'meta_description' => 'サイトの説明文のメタタグ',
    'meta_keywords' => 'キーワードのメタタグ',
    'default_permissions_block' => 'パーミッション',
    'default_permissions_story' => 'パーミッション',
    'default_permissions_topic' => 'パーミッション',
    'atom_max_stories' => 'フィードの最大記事数',
    'disable_webservices' => 'Webサービスを無効にする',
    'restrict_webservices' => 'Webサービスを制限する',
    'article_comment_close_enabled' => '自動的にコメントの受付を停止(デフォルト)',
    'article_comment_close_days' => '停止までの日数(デフォルト)',
    'comment_close_rec_stories' => 'コメント可能な記事の最大数',
    'allow_reply_notifications' => '返信のメール通知を許可する',
    'comment_on_same_page' => '同じページでコメントを投稿する',
    'show_comments_at_replying' => '返信時にコメントリストを表示する',
    'search_style' => '検索結果の表示スタイル',
    'search_limits' => '表示件数の選択肢',
    'search_show_num' => '検索順の番号を表示',
    'search_show_type' => '検索のタイプを表示',
    'search_show_sort' => 'ユーザーに並べ替えを許可',
    'search_show_limit' => '表示件数の選択肢を表示',
    'search_separator' => 'グループのセパレータ',
    'search_def_keytype' => '検索条件のデフォルト',
    'search_def_sort' => '並べ替えの順序のデフォルト',
    'autotag_permissions_story' => '[story: ] パーミッション',
    'autotag_permissions_user' => '[user: ] パーミッション',
    'multiple_breadcrumbs' => 'マルチプルパンくずリストを有効にする',
    'disable_breadcrumbs_topics' => '話題のパンくずリストを無効にする',
    'disable_breadcrumbs_articles' => '記事のパンくずリストを無効にする',
    'disable_breadcrumbs_plugins' => 'プラグインのパンくずリストを無効にする',
    'breadcrumb_root_site_name' => 'サイト名をパンくずリストのルートにする'
);

$LANG_configsubgroups['Core'] = array(
    'sg_site' => 'サイト',
    'sg_stories' => '記事とトラックバック',
    'sg_theme' => 'テーマ',
    'sg_blocks' => 'ブロック',
    'sg_users' => 'ユーザーと投稿',
    'sg_images' => '画像',
    'sg_locale' => '言語とロケール',
    'sg_misc' => 'その他'
);

$LANG_fs['Core'] = array(
    'fs_site' => 'サイト',
    'fs_paths' => 'パス',
    'fs_theme' => 'テーマ',
    'fs_mail' => 'メール',
    'fs_pear' => 'PEAR',
    'fs_mysql' => 'MySQL',
    'fs_users' => 'ユーザー',
    'fs_misc' => 'その他',
    'fs_spamx' => 'Spam-X',
    'fs_admin_block' => '管理者ブロック',
    'fs_locale' => 'ロケール',
    'fs_language' => '言語',
    'fs_debug' => 'デバッグ',
    'fs_cookies' => 'クッキー',
    'fs_login' => 'ログイン',
    'fs_search' => '検索',
    'fs_user_submission' => 'ユーザー登録',
    'fs_submission' => '投稿',
    'fs_topics_block' => '話題ブロック',
    'fs_whosonline_block' => 'オンラインユーザーブロック',
    'fs_daily_digest' => 'デイリーダイジェスト',
    'fs_whatsnew_block' => '新着情報ブロック',
    'fs_trackback' => 'トラックバック',
    'fs_pingback' => 'ピングバック',
    'fs_story' => '記事',
    'fs_theme_advanced' => 'テーマの拡張設定',
    'fs_syndication' => 'フィード',
    'fs_syndication_comment' => 'コメントのフィード',
    'fs_imagelib' => '画像処理ライブラリ',
    'fs_upload' => 'アップロード',
    'fs_articleimg' => '記事の画像',
    'fs_topicicon' => '話題アイコン',
    'fs_userphoto' => 'ユーザーの写真',
    'fs_gravatar' => 'Gravatar',
    'fs_comments' => 'コメント',
    'fs_htmlfilter' => 'HTMLフィルター',
    'fs_censoring' => 'バッドワードチェック',
    'fs_iplookup' => 'IP検索',
    'fs_perm_story' => '記事のパーミッションのデフォルト([0]所有者 [1]グループ [2]メンバー [3]ゲスト)',
    'fs_perm_topic' => '話題のパーミッションのデフォルト([0]所有者 [1]グループ [2]メンバー [3]ゲスト)',
    'fs_perm_block' => 'ブロックのパーミッションのデフォルト([0]所有者 [1]グループ [2]メンバー [3]ゲスト)',
    'fs_webservices' => 'Webサービス',
    'fs_autotag_permissions' => '自動タグのパーミッション ([0]所有者 [1]グループ [2]メンバー [3]ゲスト)',
    'fs_breadcrumbs' => 'パンくずリスト',
    'fs_pass' => 'パスワード設定'
);

$LANG_tab['Core'] = array(
    'tab_site' => 'サイト',
    'tab_paths' => 'パス',
    'tab_theme' => 'テーマ',
    'tab_mail' => 'メール',
    'tab_pear' => 'PEAR',
    'tab_mysql' => 'MySQL',
    'tab_users' => 'ユーザー',
    'tab_misc' => 'その他',
    'tab_spamx' => 'Spam-X',
    'tab_admin_block' => '管理者ブロック',
    'tab_locale' => 'ロケール',
    'tab_language' => '言語',
    'tab_debug' => 'デバッグ',
    'tab_cookies' => 'クッキー',
    'tab_login' => 'ログイン',
    'tab_search' => '検索',
    'tab_user_submission' => 'ユーザー登録',
    'tab_submission' => '投稿',
    'tab_topics_block' => '話題ブロック',
    'tab_whosonline_block' => 'オンラインユーザーブロック',
    'tab_daily_digest' => 'デイリーダイジェスト',
    'tab_whatsnew_block' => '新着ブロック',
    'tab_trackback' => 'トラックバック',
    'tab_pingback' => 'ピングバック',
    'tab_story' => '記事',
    'tab_theme_advanced' => '拡張設定',
    'tab_syndication' => 'フィード',
    'tab_imagelib' => '画像処理ライブラリ',
    'tab_upload' => 'アップロード',
    'tab_articleimg' => '記事の画像',
    'tab_topicicon' => '話題アイコン',
    'tab_userphoto' => 'ユーザーの写真',
    'tab_gravatar' => 'Gravatar',
    'tab_comments' => 'コメント',
    'tab_htmlfilter' => 'HTMLフィルター',
    'tab_censoring' => 'バッドワードチェック',
    'tab_iplookup' => 'IP検索',
    'tab_permissions' => 'パーミッション',
    'tab_webservices' => 'Webサービス',
    'tab_topics' => 'パンくずリスト'
);

$LANG_configselects['Core'] = array(
    0 => array('はい' => 1, 'いいえ' => 0),
    1 => array('はい' => true, 'いいえ' => false),
    2 => array('拒否' => 0, '最新ポストのみ保持' => 1, 'マルチポストを許可' => 2),
    3 => array('トラックバックを有効' => 0, 'トラックバックを停止' => -1),
    4 => array('何も検査しない' => 0,
               'サイトのURLリンクを検査' => 1,
               '完全なURLを検査' => 2,
               'サイトのURLと完全なURLを検査' => 3,
               'IPアドレスとサイトのIPアドレスを検査' => 4,
               'IPアドレスとサイトのURLリンクを検査' => 5,
               'IPアドレスと完全なURLを検査' => 6,
               'IPアドレス、完全なURL、サイトのURLを検査' => 7),
    5 => array('テキスト' => 'plaintext', 'HTML' => 'html'),
    6 => array('12' => 12, '24' => 24),
    7 => array('最後のページ' => 'last', '最初のページ' => 'first', '各ページ' => 'all'),
    8 => array('右' => 'right', '左' => 'left'),
    9 => array('ページを表示' => 'item', 'リストを表示' => 'list', 'ホームを表示' => 'home', '管理画面のトップを表示' => 'admin'),
    10 => array('なし' => '', 'Netpbm' => 'netpbm', 'ImageMagick' => 'imagemagick', 'GDライブラリ' => 'gdlib'),
    11 => array('一覧' => 'flat', '入れ子' => 'nested', 'ツリー' => 'threaded', '表示しない' => 'nocomment'),
    12 => array('アクセス不可' => 0, '表示' => 2, '表示・編集' => 3),
    13 => array('スキップする' => 0, '許可する(間隔制限あり)' => 1, '許可する(間隔制限なし)' => 2),
    14 => array('日曜日' => 'Sun', '月曜日' => 'Mon'),
    15 => array('番号順' => 'sortnum', 'アルファベット順' => 'alpha'),
    16 => array('いいえ' => 0, '検索オプションのみ要求' => 1, 'すべての検索機能で要求' => 2),
    17 => array('許可する' => 0, '許可しない' => -1),
    18 => array('チェックしない' => 0, 'チェックする(完全一致)' => 1, 'チェックする(前方一致)' => 2, 'チェックする(部分一致)' => 3),
    19 => array('Google' => 'google', 'Table' => 'table'),
    20 => array('完全一致' => 'phrase', 'すべてのキーワードを含む' => 'all', 'いずれかのキーワードを含む' => 'any'),
    21 => array('HTML 4.01 Transitional' => 'html401transitional', 'HTML 4.01 Strict' => 'html401strict', 'XHTML 1.0 Transitional' => 'xhtml10transitional', 'XHTML 1.0 Strict' => 'xhtml10strict', 'HTML5' => 'html5', 'HTML5 with XHTML syntax' => 'xhtml5'),
    22 => array('Strict' => 'DENY', 'Same Origin' => 'SAMEORIGIN', '(disabled)' => ''),
    23 => array('無効にする' => 0, '有効にする' => 1, '有効にする(トップページにのみデフォルトを使用する)' => 2),
    24 => array('記事投稿' => 'contribute', 'ホーム' => 'home', '検索オプション' => 'search', '記事一覧' => 'directory', 'マイアカウント' => 'prefs', 'プラグインエントリ' => 'plugins', 'カスタムエントリ' => 'custom', 'サイト情報' => 'stats'),
    25 => array('新着記事' => 'story', '新着コメント' => 'comment', '新着トラックバック' => 'trackback', '新着ピングバック' => 'pingback', '新着ユーザー' => 'user'),
    26 => array('G (一般向け)' => 'G', 'PG (保護者の指導が望ましい)' => 'PG', 'R (保護者同伴制限付き' => 'R', 'X (17歳未満利用禁止)' => 'X'),
    27 => array('表示回数 (昇順)' => 'hits|asc', '表示回数 (降順)' => 'hits|desc', '日付 (昇順)' => 'date|asc', '日付 (降順)' => 'date|desc', 'タイトル (昇順)' => 'title|asc', 'タイトル (降順)' => 'title|desc', '所有者 (昇順)' => 'uid|asc', '所有者 (降順)' => 'uid|desc'),
    28 => array('アクセス不可' => 0, '利用する' => 2),
    29 => array('md5' => 0, 'sha1' => 1, 'sha256' => 2, 'sha512' => 3, 'blowfish' => 4),
    30 => array('開始' => 'start', '終了' => 'end', 'なし' => 'none')
);

###############################################################################
# Localization of validation error messages

$LANG_VALIDATION = array(
    'default' => 'このフィールドは許可していない値を含んでいます',
    'notEmpty' => 'このフィールドの入力は必須です',
    'alphaNumeric' => 'このフィールドは半角英数です。',
    'between' => 'このフィールドは特定の範囲内の値を入れなければなりません',
    'blank' => 'このフィールドは空でなければなりません',
    'comparison' => 'このフィールドは比較操作に適合していません',
    'date' => 'このフィールドはdateフォーマットで入力してください',
    'year' => 'このフィールドはyearフォーマットで入力してください',
    'yearOrRange' => 'このフィールドは年のフォーマットで入力してください。(例: 2010 または 2010 - 2012)',
    'time' => 'このフィールドはdateフォーマットで入力してください',
    'datetime' => 'このフィールドはdatetimeフォーマットで入力してください',
    'boolean' => 'このフィールドはbooleanフォーマットで入力してください',
    'decimal' => 'このフィールドはdecimalフォーマットで入力してください',
    'email' => 'このフィールドにはemailアドレスフォーマットで入力してください',
    'equalTo' => 'このフィールドは同じではありません',
    'extension' => 'このフィールドには許可している拡張子のファイルのみ入力できます',
    'ip' => '正しいフォーマットでIPアドレスを入力してください',
    'minLength' => 'このフィールドは短すぎます',
    'maxLength' => 'このフィールドは長すぎます',
    'numeric' => 'このフィールドには数値を入力してください',
    'phone' => 'このフィールドは電話番号のフォーマットで入力してください',
    'range' => 'このフィールドは特定範囲内の数値を入力してください',
    'url' => 'このフィールドは正しいURのフォーマットを入力してください',
    'inList' => 'このフィールドは特定のリストを含まなければなりません',
    'mail_settings_backend' => 'このフィールドは \'smtp\', \'sendmail\', or \'mail\'のどれか1つだけです',
    'mail_settings_sendmail_path' => 'このフィールドにはsendmail binaryへのパスを入力してください',
    'mail_settings_host' => 'このフィールドには正しいホスト名を入力してください',
    'mail_settings_port' => 'このフィールドには0から65535の数値を入力してください',
    'rdf_limit' => 'このフィールドには数値で入力してください',
    'path' => 'パスがありません',
    'file' => 'ファイルがありません',
    'search_limits' => 'このフィールドにはコンマで区切られた数値を入力してください',
    'num_search_results' => 'このフィールドには下の\'search_limits\'の数値を入力してください',
    'theme' => 'テーマディレクトリがありません',
    'path_themes' => 'テーマパスは絶対パスでなければならず、最後にディレクトリセパレータの\'/\'が必要です',
    'path_to_mogrify' => '画像処理ライブラリimagemagickのセットアップを行い、このフィールドにmogrifyの実行ファイルのパスを入力してください',
    'path_to_netpbm' => '画像処理ライブラリnetpbmのセットアップを行い、このフィールドにnetpbmのパッケージのバイナリのあるディレクトリのパスを入力してください',
    'language' => '言語ファイルがありません',
    'timezone' => '無効なタイムゾーンです',
    'single_char' => 'このフィールドには半角1文字を入力してください',
    'page_navigation_max_pages' => 'このフィールドには2から21の数値を入力してください',
    'hash' => 'このフィールドにはあなたの使用しているPHPのバージョンでサポートしているhash関数を入力しなければなりません'
);


?>
