<?php

###############################################################################
# romanian.php 
# This is the romanian language page for Geeklog!
#
# Copyright (C) 2003 dan gheorghitza
# dangk12@yahoo.com
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
#
###############################################################################

$LANG_CHARSET = 'utf-8';

###############################################################################
# Array Format:
# $LANGXX[YY]:  $LANG - variable name
#               XX    - file id number
#               YY    - phrase id number
###############################################################################

###############################################################################
# USER PHRASES - These are file phrases used in end user scripts
###############################################################################

###############################################################################
# lib-common.php

$LANG01 = array(
    1 => 'Scris de:',
    2 => 'Citeste mai multe ...',
    3 => 'comentarii',
    4 => 'Editeaza',
    5 => '',
    6 => '',
    7 => '',
    8 => '',
    9 => 'Admin:',
    10 => 'Trimiteri',
    11 => 'Stiri',
    12 => 'Block-uri',
    13 => 'Sectiuni',
    14 => 'Command &amp; Control',
    15 => '',
    16 => '',
    17 => 'Membri',
    18 => 'Interogare SQL',
    19 => 'Iesire/Deconectare',
    20 => 'Membru Info:',
    21 => 'Nume',
    22 => 'Membru ID',
    23 => 'Nivel Securitate',
    24 => 'Anonim',
    25 => 'Raspunde',
    26 => 'Urmatoarele comentarii apartin celor care le-au trimis pe sit. Acest sit nu raspunde pentru continutul acestora.',
    27 => 'Cel mai recent',
    28 => 'Sterge',
    29 => 'Nu sunt comentarii.',
    30 => 'Stiri Vechi',
    31 => 'Tag-uri HTML permise:',
    32 => 'Eroare, nume Membru/username invalid',
    33 => 'Eroare, nu se poate scrie in fisierul de log',
    34 => 'Eroare',
    35 => 'Iesire/Deconectare',
    36 => 'pe',
    37 => 'Nu sunt stiri ale vizitatorilor',
    38 => 'Content Syndication',
    39 => 'Actualizeaza',
    40 => 'Error in password request, invalid username',
    41 => 'Vizitatori',
    42 => 'Scris de:',
    43 => 'Raspunde la',
    44 => 'Parinte',
    45 => 'MySQL Eroare Numar',
    46 => 'MySQL Eroare Mesaj',
    47 => 'Membru Info',
    48 => 'Informatii Cont',
    49 => 'Preferinte',
    50 => 'Eroare in codul SQL',
    51 => 'ajutor',
    52 => 'Nou',
    53 => 'Admin Home',
    54 => 'Nu se poate deschide fisierul.',
    55 => 'Eroare la',
    56 => 'Voteaza',
    57 => 'Parola',
    58 => 'Intra/Login',
    59 => "Nu ai un cont inca? Inregistreaza-te ca <a href=\"{$_CONF['site_url']}/users.php?mode=new\" rel=\"nofollow\">Nou Membru</a>",
    60 => 'Adauga un comentariu',
    61 => 'Creaza Nou Cont',
    62 => 'cuvinte',
    63 => 'Preferinte Comentarii',
    64 => 'Trimite stirea unui prieten',
    65 => 'Vezi Versiunea pentru Imprimanta',
    66 => '',
    67 => 'Bine ati venit ',
    68 => 'home',
    69 => 'contact',
    70 => 'cauta',
    71 => 'contribuie',
    72 => 'resurse web',
    73 => '',
    74 => '',
    75 => 'cautare avansata',
    76 => 'statistici sit',
    77 => 'Plugin-uri',
    78 => '',
    79 => 'Ce mai e Nou',
    80 => 'stiri in ultimele',
    81 => 'stire in ultimele',
    82 => 'ore',
    83 => 'COMENTARII',
    84 => '',
    85 => 'ultimele 48 ore',
    86 => 'Nu sunt comentarii noi',
    87 => 'ultimele 2 saptamani',
    88 => '',
    89 => '',
    90 => 'Home',
    91 => 'Pagina creata in',
    92 => 'secunde',
    93 => 'Copyright',
    94 => 'All trademarks and copyrights on this page are owned by their respective owners.',
    95 => 'Powered by',
    96 => 'Grupuri',
    97 => 'Lista Cuvinte',
    98 => 'Plugin-uri',
    99 => 'STIRI',
    100 => 'Nu sunt stiri noi',
    101 => '',
    102 => '',
    103 => 'DB Backup',
    104 => 'de',
    105 => 'Mail Membri',
    106 => 'Vizualizari',
    107 => 'GL Version Test',
    108 => 'Sterge Cache',
    109 => 'Report abuse',
    110 => 'Report this post to the site admin',
    111 => '',
    112 => 'Registered Users',
    113 => 'Documentation',
    114 => 'TRACKBACKS',
    115 => 'No new trackback comments',
    116 => 'Trackback',
    117 => 'Directory',
    118 => 'Please continue reading on the next page:',
    119 => "Lost your <a href=\"{$_CONF['site_url']}/users.php?mode=getpassword\" rel=\"nofollow\">password</a>?",
    120 => 'Permanent link to this comment',
    121 => 'Comments (%d)',
    122 => 'Trackbacks (%d)',
    123 => 'All HTML is allowed',
    124 => 'Click to delete all checked items',
    125 => 'Are you sure you want to Delete all checked items?',
    126 => 'Select or de-select all items',
    127 => 'Permalink',
    128 => 'Login with OpenID:',
    129 => 'Configuration',
    130 => 'Webservices',
    131 => 'No HTML is allowed',
    132 => 'Information',
    133 => 'Critical',
    134 => 'Help',
    135 => 'Warning',
    136 => 'Warning: Javascript recommended for enhanced functionality',
    137 => 'Warning: Javascript required to enable functionality',
    138 => "Click <a href=\"{$_CONF['site_url']}/usersettings.php\" rel=\"nofollow\">here</a> to disable the advanced editor and use the default editor which does not require JavaScript",
    139 => "Click <a href=\"{$_CONF['site_url']}/\" rel=\"nofollow\">here</a> to return to the homepage",
    140 => 'Allowed Autotags:',
    'facebook' => 'Login with Facebook',
    'twitter' => 'Login with Twitter',
    'linkedin' => 'Login with LinkedIn',
    'google' => 'Login with Google',
    'microsoft' => 'Login with Microsoft',
    'yahoo' => 'Login with Yahoo',
    'ctl' => 'Clear Cache',
    'filemanager' => 'File Manager'
);

###############################################################################
# comment.php

$LANG03 = array(
    1 => 'Trimite un Comentariu',
    2 => 'Mod trimitere',
    3 => 'Iesire',
    4 => 'Inregistrare',
    5 => 'Membru',
    6 => 'Intrati ca membru/utilizator inregistrat pentru a trimite comentarii. Pentru inregistrare completati miniformularul de mai jos.',
    7 => 'Ultimul tau comentariu a fost acum',
    8 => " secunde in urma.  Asteptati cel putin {$_CONF['commentspeedlimit']} secunde pentru a introduce un nou comentariu",
    9 => 'Comentariu',
    10 => 'Send Report',
    11 => 'Trimite Comentariu',
    12 => 'E necesar sa completati in Titlu si Comentariu pentru a putea trimite comentariul.',
    13 => 'Informatia ta',
    14 => 'Previzualizeaza',
    15 => 'Report this post',
    16 => 'Titlu',
    17 => 'Eroare',
    18 => 'Material Important',
    19 => 'Va rugam sa continuati a trimite pe acest subiect.',
    20 => 'Incearca sa raspunzi la comentariile altora in loc de a introduce comentarii noi.',
    21 => 'Citeste mesajele altora inainte de a trimite pentru a evita dublarea unui mesaj',
    22 => 'Alege sectiunea potrivita pentru mesajul tau.',
    23 => 'Adresa ta email nu va fi facuta publica.',
    24 => 'Vizitator Anonim',
    25 => 'Are you sure you want to report this post to the site admin?',
    26 => '%s reported the following abusive comment post:',
    27 => 'Abuse report',
    28 => 'Preview Changes',
    29 => 'Submit Changes',
    30 => 'Edited on',
    31 => 'by',
    32 => 'Editing a Comment',
    33 => 'Editing a Comment Submission',
    34 => 'Preview Submission Changes',
    35 => 'Save Changes to Queue',
    36 => 'Notify me of new replies',
    37 => 'New Comment Reply',
    38 => 'A reply has been made to your comment \'%s\'.',
    39 => 'You may view the comment thread at the following address:',
    40 => 'If you wish to receive no further notifications of replies, visit the following link:',
    41 => 'Hello %s,',
    42 => 'Unsubscribe',
    43 => 'Unsubscribe from reply notifications',
    44 => 'Your Name',
    45 => "Thank you for your comment. You must wait {$_CONF['commentspeedlimit']} seconds to post a new comment."
);

###############################################################################
# users.php

$LANG04 = array(
    1 => 'Profil Membru pentru',
    2 => 'Nume membru',
    3 => 'Nume',
    4 => 'Parola',
    5 => 'Email',
    6 => 'Pagina web',
    7 => 'Bio',
    8 => 'Cheie PGP',
    9 => 'Salveaza modificarile',
    10 => 'Ultimele 10 comentarii pentru utilizatorul',
    11 => 'Nu sunt comentarii',
    12 => 'Preferinte membru pentru',
    13 => 'Email Nightly Digest',
    14 => 'Aceasta parola este generata aleatoriu. Este recomandat sa schimbi parola imediat. Pentru aceasta va logati si dati clic pe Informatii Cont din meniul Membru Info',
    15 => "Contul tau {$_CONF['site_name']} a fost creat cu succes. Pentru a-l utiliza e necesar sa va logati utilizand informatiile de mai jos.  Este indicat sa va salvati acest mail.",
    16 => 'Informatii Cont',
    17 => 'Contul nu exista',
    18 => 'Adresa email introdusa nu pare a vi valida (nume@server.com)',
    19 => 'Nume Membru sau adresa email introduse exista deja.',
    20 => 'Adresa email introdusa nu pare a vi valida (nume@server.com)',
    21 => 'Eroare',
    22 => "Inregistrare la {$_CONF['site_name']}!",
    23 => "Crearea unui cont membru prin inregistrare va ofera toate beneficiile unui membru la {$_CONF['site_name']} si va permite sa trimiteti comentarii sau stiri/texte cu numele ales. Daca nu aveti un cont creat, puteti trimite texte doar ca anonim. Va reamintim ca adresa email nu va fi disponibila <b><i>niciodata</i></b> spre vizualizare publica.",
    24 => 'Parola ta va fi trimisa la adresa de email introdusa.',
    25 => 'Ati uitat parola?',
    26 => 'Introduceti numele de utilizator/membru si dati clic pe Trimite Parola si o parola generata aleatoriu va fi trimisa la adresa de email introdusa.',
    27 => 'Inregistrati-va!',
    28 => 'Trimite Parola',
    29 => 'iesit din',
    30 => 'intrat din',
    31 => 'Optiunea aleasa cere sa intrati ca membru/utilizator inregistrat',
    32 => 'Semnatura',
    33 => 'Niciodata disponibil spre vizualizare publica',
    34 => 'Acesta este numele tau adevarat',
    35 => 'Introduceti parola pentru modificare',
    36 => 'Incepe cu http://',
    37 => 'Aplicat la comentariile tale',
    38 => 'Este despre tine! Oricine poate citi aceasta',
    39 => 'Cheia publica PGP pentru date private',
    40 => 'Nu exista iconite pentru subiecte',
    41 => 'Moderati!',
    42 => 'Format Data',
    43 => 'Maxim stiri',
    44 => 'Fara casute',
    45 => 'Arata preferinte pentru',
    46 => 'Exclude obiecte pentru',
    47 => 'Configurare Casuta stiri pentru',
    48 => 'Subiecte',
    49 => 'Nu sunt iconite in stiri',
    50 => 'Deselecteaza aceasta daca nu sunteti interesat',
    51 => 'Doar stiri',
    52 => 'Implicit este',
    53 => 'Primiti inainte stirile zilei urmatoare',
    54 => 'Selectati casutele pentru subiectele si autorii pe care nu-i vreti.',
    55 => 'Daca nu selectati nimic, inseamna ca sunteti de acord cu selectarea implicita (optiunile ingrosate). Sau selectati doar optiunile dorite si selectarea implicita va fi ignorata.',
    56 => 'Autori',
    57 => 'Mod vizualizare',
    58 => 'Ordine Sortare',
    59 => 'Limita Comentariu',
    60 => 'Cum doriti sa fie vizualizate comentariile?',
    61 => 'Primul - cel mai nou sau cel mai vechi?',
    62 => 'Implicit este 100',
    63 => "Parola a fost trimisa prin e-mail si trebuie sa o primiti imediat. Va rugam sa urmati indicatiile din mesaj si va multumim pentru utilizarea {$_CONF['site_name']}",
    64 => 'Preferinte Comentarii pentru',
    65 => 'Intrare/Login din nou ca membru ',
    66 => "Probabil ati introdus gresit datele. Va rugam sa le reintroduceti din nou mai jos. Sunteti un <a href=\"{$_CONF['site_url']}/users.php?mode=new\" rel=\"nofollow\">nou utilizator</a>?",
    67 => 'Membru din',
    68 => 'Salvati-mi datele pentru',
    69 => 'Pentru cat timp doriti sa fie salvate datele personale dupa intrare/login?',
    70 => "Personalizati design-ul si continutul {$_CONF['site_name']}",
    71 => "Una din optiunile paginii {$_CONF['site_name']} este este ca puteti sa va alegeti ce va contine cum va arata pagina aceasta.  Pentru a beneficia de acestea e necesar, mai intai, sa va <a href=\"{$_CONF['site_url']}/users.php?mode=new\" rel=\"nofollow\">inregistrati</a> with {$_CONF['site_name']}.  Sunteti deja membru/utilizator inregistrat? Atunci folositi modulul din stanga pentru a va loga/intra ca membru!",
    72 => 'Model pagina',
    73 => 'Limba',
    74 => 'Schimba modelul paginii dupa preferinte!',
    75 => 'Subiect de trimis prin email pentru',
    76 => 'Daca selectati un subiect din lista de mai jos veti primi fiecare stire/text cu subiectul respectiv la sfarsitul fiecarei zile. Alegeti doar subiectele ce va intereseaza!',
    77 => 'Poza',
    78 => 'Adauga o poza personala!',
    79 => 'Sterge imaginea',
    80 => 'Intra',
    81 => 'Trimite Email',
    82 => 'Ultimele 10 stiri pentru utilizatorul',
    83 => 'Statistici texte trimise de utilizatorul',
    84 => 'Total numar de articole:',
    85 => 'Total numar de comentarii:',
    86 => 'Cauta toate textele trimise de',
    87 => 'Your login name',
    88 => "Someone (possibly you) has requested a new password for your account \"%s\" on {$_CONF['site_name']}, <{$_CONF['site_url']}>.\n\nIf you really want this action to be taken, please click on the following link:\n\n",
    89 => "If you do not want this action to be taken, simply ignore this message and the request will be disregarded (your password will remain unchanged).\n\n",
    90 => 'You can enter a new password for your account below. Please note that your old password is still valid until you submit this form.',
    91 => 'Set New Password',
    92 => 'Enter New Password',
    93 => 'Your last request for a new password was %d seconds ago. This site requires at least %d seconds between password requests.',
    94 => 'Delete Account "%s"',
    95 => 'Click the "delete account" button below to remove your account from our database. Please note that any stories and comments you posted under this account will <strong>not</strong> be deleted but show up as being posted by "Anonymous".',
    96 => 'delete account',
    97 => 'Confirm Account Deletion',
    98 => 'Are you sure you want to delete your account? By doing so, you will not be able to log into this site again (unless you create a new account). If you are sure, click "delete account" again on the form below.',
    99 => 'Privacy Options for',
    100 => 'Email from Admin',
    101 => 'Allow email from Site Admins',
    102 => 'Email from Users',
    103 => 'Allow email from other users',
    104 => 'Show Online Status',
    105 => 'Show up in Who\'s Online block',
    106 => 'Location',
    107 => 'Shown in your public profile',
    108 => 'Confirm new password',
    109 => 'Enter the New password again here',
    110 => 'Current Password',
    111 => 'Please enter your Current password',
    112 => 'You have exceeded the number of allowed login attempts.  Please try again later.',
    113 => 'Login Attempt Failed',
    114 => 'Account Disabled',
    115 => 'Your account has been disabled, you may not login. Please contact an Administrator.',
    116 => 'Account Awaiting Activation',
    117 => 'Your account is currently awaiting activation by an administrator. You will not be able to login until your account has been approved.',
    118 => "Your {$_CONF['site_name']} account has now been activated by an administrator. You may now login to the site at the url below using your username (<username>) and password as previously emailed to you.",
    119 => 'If you have forgotten your password, you may request a new one at this url:',
    120 => 'Account Activated',
    121 => 'Service',
    122 => 'Sorry, new user registration is disabled',
    123 => "Are you a <a href=\"{$_CONF['site_url']}/users.php?mode=new\" rel=\"nofollow\">new user</a>?",
    124 => 'Confirm Email',
    125 => 'You have to enter the same email address in both fields!',
    126 => 'Please repeat for confirmation',
    127 => 'To change any of these settings, you will have to enter your current password.',
    128 => 'Your Name',
    129 => 'Password &amp; Email',
    130 => 'About You',
    131 => 'Daily Digest Options',
    132 => 'Daily Digest Feature',
    133 => 'Comment Display',
    134 => 'Comment Options',
    135 => '<li>Default mode for how comments will be displayed</li><li>Default order to display comments</li><li>Set maximum number of comments to show - default is 100</li>',
    136 => 'Exclude Topics and Authors',
    137 => 'Filter Story Content',
    138 => 'Misc Settings',
    139 => 'Layout and Language',
    140 => '<li>No Topic Icons if checked will not display the story topic icons</li><li>No boxes if checked will only show the Admin Menu, User Menu and Topics</li><li>Set the maximum number of stories to show per page</li><li>Set your theme, timezone and preferred date format</li>',
    141 => 'Privacy Settings',
    142 => 'The default setting is to allow users & admins to email fellow site members and show your status as online. Un-check these options to protect your privacy.',
    143 => 'Filter Block Content',
    144 => 'Show & hide boxes',
    145 => 'Your Public Profile',
    146 => 'Password and email',
    147 => 'Edit your account password, email and autologin feature. You will need to enter the same password or email address twice as a confirmation.',
    148 => 'User Information',
    149 => 'Modify your user information that will be shown to other users.<li>The signature will be added to any comments or forum posts you made</li><li>The BIO is a brief summary of yourself to share</li><li>Share your PGP Key</li>',
    150 => '',
    156 => 'Delete Account',
    157 => 'Delete Option',
    158 => 'Time Zone',
    159 => 'This email was generated automatically. Please do not reply to this email.',
    160 => '(max. %d x %d pixels, %d bytes; %s)',
    161 => 'will be scaled down',
    162 => 'will not be scaled',
    163 => 'Re-Authentication Failed',
    164 => 'You have exceeded the number of allowed attempts for re-authentication. The operation has been aborted and your recent changes were lost, sorry.',
    165 => 'Use Advanced Editor',
    166 => 'Re-synch Remote Account',
    167 => 'Remote login',
    168 => 'You may also login with one on of the below remote authentication services',
    'user_login' => 'User Login',
    'user_login_message' => 'Please login below. You must enter both a username and password.',
    'user_logged_in_message' => "You are already logged in. Whould you like to <a href=\"{$_CONF['site_url']}/users.php?mode=logout\" rel=\"nofollow\">logout</a>?"
);

###############################################################################
# Customize if need to modify the Tabbed navbar MyAccount panels used.
# Array index key matches preference div id

$LANG_MYACCOUNT = array(
    'pe_preview' => 'Preview',
    'pe_namepass' => 'Username &amp; Password',
    'pe_userinfo' => 'About You',
    'pe_layout' => 'Layout &amp; Language',
    'pe_content' => 'Content',
    'pe_privacy' => 'Privacy'
);

###############################################################################
# index.php

$LANG05 = array(
    1 => 'Nu sunt stiri de vizualizat.',
    2 => 'Nu sunt stiri de vizualizat. Pentru ca nu exista stiri noi sau preferintele tale sunt prea restrictive.',
    3 => '',
    4 => 'Stirea zilei',
    5 => 'Inainte',
    6 => 'Inapoi',
    7 => 'First',
    8 => 'Last'
);

###############################################################################
# profiles.php

$LANG08 = array(
    1 => 'A fost o eroare la trimiterea mesajului. Va rugam sa incercati din nou.',
    2 => 'Mesajul a fost trimis cu succes.',
    3 => 'Verificati daca adresa de email introdusa in campul Raspunde este valida.',
    4 => 'Va rugam sa introduceti datele pentru campurile Numele tau, Raspunde, Subiect si Mesaj.',
    5 => 'Eroare. Nu exista utilizatorul respectiv.',
    6 => 'A fost o eroare.',
    7 => 'Profil membru pentru',
    8 => 'Nume membru',
    9 => 'Membru URL/adresa web',
    10 => 'Trimite email la',
    11 => 'Numele tau:',
    12 => 'Raspunde:',
    13 => 'Subiect:',
    14 => 'Mesaj:',
    15 => 'HTML nu va fi interpretat.',
    16 => 'Trimite Mesaj',
    17 => 'Trimite unui prieten',
    18 => 'Nume prieten',
    19 => 'Adresa Email prieten',
    20 => 'Numele tau',
    21 => 'Adresa ta de Email',
    22 => 'Toate campurile sunt obligatorii',
    23 => "Acest mesaj a fost trimis de %s la %s deoarece a crezut ca ai putea fi interesat de acest text de la {$_CONF['site_url']}.  Acesta nu este SPAM si adresa dvs. de email nu a fost salvata sau stocata pentru folosire ulterioara.",
    24 => 'Comentariu pentru aceasta stire la',
    25 => 'Trebuie sa fiti membru/utilizator inregistrat pentru a folosi aceasta facilitate.  E nevoie de inregistrare pentru a preveni o folosire incorecta a sistemului',
    26 => 'Acest formular va permite sa trimiteti un email unui membru selectat.   Toate campurile trebuie completate.',
    27 => 'Mesaj scurt',
    28 => '%s a scris: ',
    29 => "Acesta este sumarul zilnic de la {$_CONF['site_name']} pentru ",
    30 => ' Buletin informativ zilnic pentru ',
    31 => 'Titlu',
    32 => 'Data',
    33 => 'Citeste tot textul la',
    34 => 'Final mesaj',
    35 => 'Sorry, this user prefers not to receive any emails.',
    36 => 'Copy:',
    37 => 'Send me a copy of this email',
    38 => "This is a copy of the email that you sent to %s from <{$_CONF['site_url']}>:",
    39 => 'Your last message was ',
    40 => " seconds ago.  This site requires at least {$_CONF['speedlimit']} seconds between sending messages"
);

###############################################################################
# search.php

$LANG09 = array(
    1 => 'Cautare avansata',
    2 => 'Cuvinte cheie',
    3 => 'Subiect',
    4 => 'Toate',
    5 => 'Tip',
    6 => 'stiri',
    7 => 'comentarii',
    8 => 'Autori',
    9 => 'Toate',
    10 => 'Cauta',
    11 => 'Rezultat cautare',
    12 => 'rezultate',
    13 => 'Rezultate cautare: Niciun rezultat',
    14 => 'Niciun rezultat pentru cautarea ta dupa',
    15 => 'Incercati din nou.',
    16 => 'Titlu',
    17 => 'Data',
    18 => 'Autor',
    19 => "Cauta in toata baza de date a {$_CONF['site_name']} prin stirile curente sau vechi",
    20 => 'Data',
    21 => 'la',
    22 => '(Format pentru Data AAAA-LL-ZZ)',
    23 => 'Accesari',
    24 => 'Gasit',
    25 => 'rezultate pentru',
    26 => 'subiecte/items in',
    27 => 'secunde',
    28 => 'Nici o stire sau comentariu rezultate in urma cautarii',
    29 => 'Rezultat Stiri si Comentarii',
    30 => '',
    31 => 'Acest plug-in nu are rezultate',
    32 => '',
    33 => 'URL',
    34 => 'Loc',
    35 => 'Fiecare zi',
    36 => '',
    37 => '',
    38 => '',
    39 => '',
    40 => '',
    41 => 'Cuvantul cautat trebuia sa aiba cel putin 3 litere.',
    42 => 'Va rugam folositi un format pentru data de tipul AAAA-LL-ZZ (an-luna-zi).',
    43 => 'exact phrase',
    44 => 'all of these words',
    45 => 'any of these words',
    46 => 'Next',
    47 => 'Previous',
    48 => 'Author',
    49 => 'Date',
    50 => 'Hits',
    51 => '',
    52 => 'Location',
    53 => 'Story Results',
    54 => 'Comment Results',
    55 => 'the phrase',
    56 => 'AND',
    57 => 'OR',
    58 => 'More results &gt;&gt;',
    59 => 'Results',
    60 => 'per page',
    61 => 'Refine search',
    62 => '#',
    63 => 'Description',
    64 => 'Showing %1$d - %2$d of %3$d results',
    65 => 'Story',
    66 => 'Comment',
    67 => 'Show %d Results',
    68 => 'Sort By',
    69 => 'Titles Only',
    70 => 'Not available ...',
    71 => 'asc',
    72 => 'desc'
);

###############################################################################
# stats.php

$LANG10 = array(
    1 => 'Statistici Site',
    2 => 'Total Accesari Sistem',
    3 => 'Stiri(comentarii) in Sistem',
    4 => '',
    5 => '',
    6 => '',
    7 => 'Top 10 Stiri vizualizate',
    8 => 'Stire Titlu',
    9 => 'Vizualizari',
    10 => 'Nu sunt siri pe sit sau nu au fost vizualizate.',
    11 => 'Top 10 stiri comentate',
    12 => 'comentarii',
    13 => 'Nu sunt siri pe sit sau nu exista comentarii trimise pentru acestea.',
    14 => '',
    15 => '',
    16 => '',
    17 => '',
    18 => '',
    19 => '',
    20 => '',
    21 => '',
    22 => 'Top 10 stiri trimise altora prin email',
    23 => 'Adrese Email',
    24 => 'Nu sunt stiri trimise altora prin email.',
    25 => 'Top Ten Trackback Commented Stories',
    26 => 'No trackback comments found.',
    27 => 'Number of active users',
    28 => '',
    29 => '',
    30 => 'Hits',
    31 => ''
);

###############################################################################
# article.php

$LANG11 = array(
    1 => 'Link-uri inrudite',
    2 => 'Trimite unui prieten',
    3 => 'Pagina in format pentru imprimanta',
    4 => 'Optiuni Stire',
    5 => '',
    6 => 'Subscribe to \'%s\''
);

###############################################################################
# submit.php

$LANG12 = array(
    1 => 'Pentru a trimite o %s e necesar sa intri ca membru/utilizator inregistrat.',
    2 => 'Intra/Login',
    3 => 'Nou membru',
    4 => '',
    5 => '',
    6 => 'Trimite o stire',
    7 => 'Inregistrarea e necesara',
    8 => 'Trimite',
    9 => 'Cand trimiteti un text pentru a fi introdus in aceasta pagina web, va rugam sa urmati sugestiile de mai jos: <ul><li>Completati toate campurile care sunt obligatorii<li>Introduceti informatii complete si corecte<li>Verificati adresele web/URL</ul>',
    10 => 'Titlu',
    11 => '',
    12 => 'Data incepere',
    13 => 'Data terminare',
    14 => 'Loc',
    15 => 'Descriere',
    16 => '',
    17 => '',
    18 => '',
    19 => 'Citeste mai inainte',
    20 => '',
    21 => '',
    22 => 'Eroare: Date necompletate',
    23 => 'Va rugam sa completati toate datele in formular. Sunt necesare toate.',
    24 => 'Datele au fost salvate',
    25 => '%s de inregistrare a fost salvat cu succes.',
    26 => 'Limita Viteza',
    27 => 'Membru',
    28 => 'Subiect',
    29 => 'Stire',
    30 => 'Ultima trimitere a fost acum ',
    31 => " secunde.  Asteptati {$_CONF['speedlimit']} secunde pentru a trimite iar.",
    32 => 'Previzualizeaza',
    33 => 'Previzualizare Stire',
    34 => 'Iesire/Logout',
    35 => 'Tag-uri HTML nu sunt permise',
    36 => 'Mod trimitere',
    37 => '',
    38 => '',
    39 => '',
    40 => '',
    41 => '',
    42 => '',
    43 => '',
    44 => 'Adresa 1',
    45 => 'Adresa 2',
    46 => 'Oras',
    47 => 'Stat',
    48 => 'Zip Cod',
    49 => '',
    50 => '',
    51 => 'Locul',
    52 => 'Sterge',
    53 => 'Inregistrare',
    54 => 'Story Introduction',
    55 => 'Story Body'
);

###############################################################################
# ADMIN PHRASES - These are file phrases used in admin scripts
###############################################################################

###############################################################################
# admin/logviewer.php

$LANG_LOGVIEW = array(
    'log_viewer' => 'Log Viewer',
    'info' => 'Geeklog log file administration.',
    'logs' => 'Logs',
    'view' => 'View Log File',
    'clear' => 'Clear Log File',
    'log_file' => 'Log File'
);

###############################################################################
# admin/envcheck.php - distribution integrity checker

$LANG_ENVCHECK = array(
    'correct_perms' => 'Please correct the issues identified below. Once they have been corrected, use the <b>Recheck</b> button to validate the environment.',
    'current' => 'Current',
    'current_php_settings' => 'Current PHP Settings',
    'directory_permissions' => 'Directory Permissions',
    'enabled' => 'Enabled',
    'env_check' => 'Environment Check',
    'file_permissions' => 'File Permissions',
    'file_uploads' => 'Many features of Geeklog require the ability to upload files, this should be enabled.',
    'filesystem_check' => 'Directory / File Permissions',
    'gd_lib' => 'GD Libraries',
    'gd_not_found' => 'Unable to locate the GD library functions.  Please ensure that the GD libraries were compiled into PHP or select an alternate graphics library.',
    'gd_ok' => 'GD Libraries v2 are installed.',
    'gd_v1' => 'GD Libraries v1 is installed - This version does not fully support JPG image processing so there may be some quality issues.',
    'graphics' => 'Graphics Library',
    'libraries' => 'Libraries',
    'hosting_env' => 'Hosting Environment Check',
    'imagemagick' => 'ImageMagick Programs',
    'im_not_found' => 'Unable to locate the <strong>convert</strong> executable for ImageMagick.',
    'im_ok' => 'The <strong>convert</strong> executable appears to be valid.',
    'memory_limit' => 'It is recommended that you have at least 48M of memory enabled on your site.',
    'not_writable' => 'NOT WRITABLE',
    'notes' => 'Notes',
    'not_found' => 'Not Found',
    'netpbm' => 'NetPBM Library',
    'np_ok' => 'The NetPBM library is installed',
    'np_not_found' => 'The NetPBM executables were not found.',
    'openssl_library' => 'OpenSSL Library',
    'openssl_ok' => 'The OpenSSL library is loaded. This library is required if you wish to use the OAuth user login method with Geeklog.',
    'openssl_not_found' => 'The OpenSSL library is not loaded. This is required <strong>only</strong> if you wish to use the OAuth user login method with Geeklog.',
    'off' => 'Off',
    'ok' => 'OK',
    'on' => 'On',
    'open_basedir' => 'If <strong>open_basedir</strong> restrictions are enabled on your site, it may cause permission problems during the install. The File System Check below should point out any issues.',
    'php_req_version' => 'Geeklog requires PHP version 5.2.0 or newer.',
    'php_settings' => 'PHP Settings',
    'php_version' => 'PHP Version',
    'php_warning' => 'If any of the items below are marked in <span class="no">red</span>, you may encounter problems with your Geeklog site.  Check with your hosting provider for information on changing any of these PHP settings.',
    'post_max_size' => 'Geeklog allows you to upload plugins, images, and files. You should allow at least 8M for the maximum post size.',
    'recheck' => 'Recheck Environment',
    'recommended' => 'Recommended',
    'register_globals' => 'If PHP\'s <strong>register_globals</strong> is enabled, it can create security issues.',
    'safe_mode' => 'If PHP\'s <strong>safe_mode</strong> is enabled, some functions of Geeklog may not work correctly. Specifically the Media Gallery plugin.',
    'setting' => 'Setting',
    'unable_mkdir' => 'Unable to create directory',
    'upload_max_filesize' => 'Geeklog allows you to upload plugins, images, and files. You should allow at least 8M for the upload size.',
    'not_checked' => 'Skipped',
    'bypass_note' => 'Since either Safe Mode or open_basedir restrictions were detected, the check for graphic libraries were skipped.',
    'not_used_note' => 'No graphic libraries are set to be used by Geeklog.',
    'location' => 'Location',
    'status' => 'Status',
    'item' => 'Item',
    'jhead' => 'jhead Program',
    'jhead_not_found' => 'Unable to locate the jhead executable.',
    'jhead_ok' => 'The jhead executable is installed.',
    'jpegtran' => 'jpegtran Program',
    'jpegtran_not_found' => 'Unable to locate the jpegtran executable.',
    'jpegtran_ok' => 'The jpegtran executable is installed.',
    'showhide_phpinfo' => 'Show/Hide Full PHP Info',
    'view_online' => 'Click here %s to view online',
    'no_new_items' => 'No New Items',
    'max_execution_time' => 'Geeklog recommends the PHP default value of 30 seconds as a minimum, but plugin uploads and other operations may take longer than this depending upon your hosting environment.  If safe_mode (above) is Off, you may be able to increase this by modifying the value of <b>max_execution_time</b> in your php.ini file.'
);

###############################################################################
# admin/auth.inc.php

$LANG20 = array(
    1 => 'Autenficarea necesara',
    2 => 'Acces refuzat! Informatii introduse incorect',
    3 => 'Parola gresita pentru utilizator',
    4 => 'Membru:',
    5 => 'Parola:',
    6 => 'Accesul la zona de administrare a sit-ului este inregistrat si verificat periodic.<br' . XHTML . '>Aceasta zona este doar pentru persoanele autorizate.',
    7 => 'intra/login'
);

###############################################################################
# admin/block.php

$LANG21 = array(
    1 => 'Insufficient Admin Rights',
    2 => 'You do not have the necessary rights to edit this block.',
    3 => 'Block Editor',
    4 => 'There was a problem reading this feed (see error.log for details).',
    5 => 'Yes',
    6 => 'No',
    7 => 'Toate',
    8 => 'Block Security Level',
    9 => 'Block Order',
    10 => '',
    11 => 'Portal Block',
    12 => 'Normal Block',
    13 => 'Portal Block Options',
    14 => 'RDF URL',
    15 => 'Ultimul RDF Update',
    16 => 'Normal Block Options',
    17 => 'Block Content',
    18 => 'Please fill in the Block Titlu, Security Level and Content fields',
    19 => 'Block Manager',
    20 => 'Regular Blocks',
    21 => 'Block SecLev',
    22 => 'Dynamic Blocks',
    23 => 'Block Order',
    24 => 'Dynamic',
    25 => 'To modify or sterge a block, click on that block below.  To create a new block click on new block above.',
    26 => 'Layout Block',
    27 => 'PHP Block',
    28 => 'PHP Block Options',
    29 => 'Block Function',
    30 => 'If you would like to have one of your blocks use PHP code, enter the name of the function above.  Your function name must start with the prefix "phpblock_" (e.g. phpblock_getweather).  If it does not have this prefix, your function will NOT be called.  We do this to keep people who may have hacked your Geeklog installation from putting arbitrary function calls that may be harmful to your system.  Be sure not to put empty parenthisis "()" after your function name.  Finally, it is recommended that you put all your PHP Block code in /path/to/geeklog/system/lib-custom.php.  That will allow the code to stay with you even when you upgrade to a newer version of Geeklog.',
    31 => 'Error in PHP Block.  Function, %s, does not exist.',
    32 => 'Error Missing Field(s)',
    33 => 'You must enter the URL to the .rdf file for portal blocks',
    34 => 'You must enter the Titlu and the function for PHP blocks',
    35 => 'You must enter the Titlu and the content for normal blocks',
    36 => 'You must enter the content for layout blocks',
    37 => 'Bad PHP block function name',
    38 => 'Functions for PHP Blocks must have the prefix \'phpblock_\' (e.g. phpblock_getweather).  The \'phpblock_\' prefix is required for security reasons to prevent the execution of arbitrary code.',
    39 => 'Side',
    40 => 'Stanga',
    41 => 'Dreapta',
    42 => 'You must enter the blockorder and security level for Geeklog default blocks',
    43 => 'Homepage Only',
    44 => 'Multiple',
    45 => "You are trying to access a block that you don't have rights to.  This attempt has been logged. Please <a href=\"{$_CONF['site_admin_url']}/block.php\">go back to the block administration screen</a>.",
    46 => 'Bloc nou',
    47 => 'None',
    48 => 'Nume Bloc',
    49 => ' (no spaces and must be unique)',
    50 => 'The Block Name can not be empty',
    51 => 'include http://',
    52 => 'If you leave this blank the help icon for this block will not be displayed',
    53 => 'Enabled',
    54 => 'salveaza',
    55 => 'anuleaza',
    56 => 'sterge',
    57 => 'Move Block Down',
    58 => 'Move Block Up',
    59 => 'Move block to the right side',
    60 => 'Move block to the left side',
    61 => 'No Title',
    62 => 'Article Limit',
    63 => 'Bad Block Title',
    64 => 'Your Title must not be empty and cannot contain HTML!',
    65 => 'Order',
    66 => 'Autotags',
    67 => 'Check to allow autotags',
    68 => 'The feed for this portal block is too long to display. Please set a maximum number of articles to import for the block in the block setup screen, or a global maximum in Geeklog Configuration.',
    69 => 'Plugin Name',
    'cache_time' => 'Cache Time',
    'cache_time_desc' => 'This block will be cached for no longer than this many seconds. If 0 caching is disabled. (3600 = 1 hour,  86400 = 1 day)'
);

###############################################################################
# admin/story.php

$LANG24 = array(
    1 => 'Stiri precedente',
    2 => 'Stiri urmatoare',
    3 => 'Mod',
    4 => 'Mod trimitere',
    5 => 'Editor Stiri',
    6 => 'Nu sunt stiri in sistem',
    7 => 'Autor',
    8 => 'salveaza',
    9 => 'previzualizeaza',
    10 => 'anuleaza',
    11 => 'sterge',
    12 => 'ID',
    13 => '',
    14 => '',
    15 => 'Data',
    16 => 'Intro Text',
    17 => 'Body Text',
    18 => 'Accesari',
    19 => 'comentarii',
    20 => 'Ping',
    21 => 'Send Ping',
    22 => 'Stire List',
    23 => 'To modify or sterge o stire, click on that Stire\'s number below. To view o stire, click on the Titlu of the Stire you wish to view. To create a new Stire click on new Stire above.',
    24 => 'The ID you chose for this story is already in use. Please use another ID.',
    25 => 'Error when saving story',
    26 => 'Previzualizare Stire',
    27 => 'If you use [unscaledX] instead of [imageX], the image will be inserted at its original dimensions.',
    28 => '<p><b>PREVIEWING</b>: Previewing a story with images attached is best done by saving the article as a draft INSTEAD OF hitting the preview button.  Use the preview button only when images are not attached.',
    29 => 'Trackbacks',
    30 => 'File Upload Errors',
    31 => 'Please fill in the Author, Titlu and Intro Text fields',
    32 => 'Featured',
    33 => 'There can only be one featured stire',
    34 => 'Draft',
    35 => 'Da',
    36 => 'Nu',
    37 => 'Scrise de',
    38 => 'Mai mult despre',
    39 => 'Emails',
    40 => '',
    41 => "You are trying to access o stire that you don't have rights to.  This attempt has been logged.  You may view the article in read-only below. Please <a href=\"{$_CONF['site_admin_url']}/story.php\">go back to the stire administration screen</a> when you are done.",
    42 => "You are trying to access o stire that you don't have rights to.  This attempt has been logged.  Please <a href=\"{$_CONF['site_admin_url']}/story.php\">go back to the stire administration screen</a>.",
    43 => '',
    44 => '',
    45 => '',
    46 => '<b>NOTE:</b> if you modify this date to be in the future, this article will not be published until that date.  That also means the stire will not be included in your RDF headline feed and it will be ignored by the search and statistics pages.',
    47 => 'Images',
    48 => 'image',
    49 => 'dreapta',
    50 => 'stanga',
    51 => 'To add one of the images you are attaching to this article you need to insert specially formatted text.  The specially formatted text is [imageX], [imageX_right] or [imageX_left] where X is the number of the image you have attached.  NOTE: You must use the images you attach.  If you do not you will be unable to save your stire.<BR><P><B>PREVIEWING</B>: Previewing o stire with images attached is best done by saving the article as a draft INSTEAD OF hitting the preview button.  Use the preview button only when images are not attached.',
    52 => '',
    53 => 'was not used.  You must include this image in the intro or body before you can save your changes',
    54 => 'Attached Images Not Used',
    55 => 'The following errors occured while trying to save your stire.  Please correct these errors before saving',
    56 => 'Show Topic Icon',
    57 => 'View unscaled image',
    58 => 'Story Management',
    59 => 'Option',
    60 => '',
    61 => 'Auto Archive',
    62 => 'Auto Delete',
    63 => 'Disable Comments',
    64 => '',
    65 => '',
    66 => '',
    67 => 'Expand the Content Edit Area size',
    68 => 'Reduce the Content Edit Area size',
    69 => 'Publish Story Date',
    70 => 'Toolbar Selection',
    71 => 'Basic Toolbar',
    72 => 'Common Toolbar',
    73 => 'Advanced Toolbar',
    74 => 'Advanced II Toolbar',
    75 => 'Full Featured',
    76 => 'Publish Options',
    77 => 'Javascript needs to be enabled for Advanced Editor. Option can be disabled in the main site config.php',
    78 => 'Click <a href="%s/story.php?mode=edit&amp;sid=%s&amp;editopt=default">here</a> to use default editor',
    79 => 'Preview',
    80 => 'Editor',
    81 => 'Publish Options',
    82 => 'Images',
    83 => 'Archive Options',
    84 => 'Permissions',
    85 => 'Show All',
    86 => 'Advanced Editor',
    87 => 'Story Stats',
    88 => 'Wiki-style format',
    89 => 'Meta Description',
    90 => 'Meta Keywords',
    91 => 'You can always hit "Preview" to extend the expiry time.',
    'autotag_desc_story' => '[story: id alternate title] - Displays a link to a Story using the Story Title as the title. An alternate title may be specified but is not required.',
    'cache_time' => 'Cache Time',
    'cache_time_desc' => 'This article will be cached for no longer than this many seconds. If 0 caching is disabled. If -1 cached until article is edited again. (3600 = 1 hour,  86400 = 1 day)'
);

###############################################################################
# admin/topic.php

$LANG27 = array(
    1 => 'Topic Editor',
    2 => 'Topic ID',
    3 => 'Topic Name',
    4 => 'Topic Image',
    5 => '(do not use spaces)',
    6 => 'Deleting a topic sterges all stiri and blocks associated with it',
    7 => 'Please fill in the Topic ID and Topic Name fields',
    8 => 'Topic Manager',
    9 => 'To modify or delete a topic, click on that topic.  To create a new topic click the new topic button to the left. You will find your access level for each topic in parenthesis',
    10 => 'Sort Order',
    11 => 'Stiri/Page',
    12 => 'Access Denied',
    13 => "You are trying to access a topic that you don't have rights to.  This attempt has been logged. Please <a href=\"{$_CONF['site_admin_url']}/topic.php\">go back to the topic administration screen</a>.",
    14 => 'Sort Method',
    15 => 'alphabetical',
    16 => 'default is',
    17 => 'New Topic',
    18 => 'Admin Home',
    19 => 'save',
    20 => 'anuleaza',
    21 => 'sterge',
    22 => 'Default',
    23 => 'make this the default topic for new story submissions',
    24 => '(*)',
    25 => 'Archive Topic',
    26 => 'make this the default topic for archived stories. Only one topic allowed.',
    27 => 'Or Upload Topic Icon',
    28 => 'Maximum',
    29 => 'File Upload Errors',
    30 => 'Stories in Topic',
    31 => 'You have used a restricted Topic ID. Please choose another one.',
    32 => 'Parent Topic',
    33 => 'Inherit',
    34 => 'Items of child topic are inherited',
    35 => 'Hidden',
    36 => 'Topic will be hidden and cannot be viewed directly, only inherited',
    37 => 'Root',
    38 => 'All',
    39 => 'Homepage Only',
    40 => 'Assign one or more topics. ',
    41 => 'If "All" is selected then the item will appear for all topics. If "Homepage Only" is selected then item will appear just on the homepage. Else you must select at least one topic to assign the item to. ',
    42 => 'Inherit contains the list of assigned topics. If the topic is selected then the item will be inherited by the parent topic. You must save your item first before anything is listed in the inherit box. ',
    43 => 'Default contains the list of assigned topics. This is the default topic that will be used when displaying the item if the actual topic the user is in is not found. ',
    44 => 'Inherit',
    45 => 'Default',
    46 => 'Your parent topic cannot be the Archive topic. Please choose a different Parent Topic.',
    47 => 'An Archive Topic cannot have any child topics. Please remove any child topics before making a topic the Archive Topic.',
    48 => 'Parent Topic Id not found.',
    49 => 'This Topic ID is already being used. Please choose another one.',
    50 => 'Yes',
    51 => 'No',
    52 => 'Story',
    53 => 'Image',
    54 => 'Selected',
    55 => 'Assigned',
    'breadcrumb_separator' => '>',
    'breadcrumb_root' => 'Home',
    'autotag_desc_topic' => '[topic: id alternate title] - Displays a link to a topic using the ID as the title. An alternate title may be specified but is not required.',
    'autotag_desc_related_topics' => '[related_topics:id type:plugin max:max_items_listed] - Creates a clickable horizontal list of related topics based on the item id and type.',
    'autotag_desc_related_items' => '[related_items:id type:plugin max:max_items_listed trim:max_length include:plugin] - Create a clickable list of related items based on the item id and type.',
    'no_related_items' => 'No related items found.',
    'topics:' => 'Topics:',
    'filed_under:' => 'Filed under:'
);

###############################################################################
# admin/user.php

$LANG28 = array(
    1 => 'Editor Utilizatori',
    2 => 'Membru ID',
    3 => 'Nume membru',
    4 => 'Nume',
    5 => 'Parola',
    6 => 'Nivel Securitate',
    7 => 'Adresa Email',
    8 => 'Pagina principala',
    9 => '(nu utilizati spatii)',
    10 => 'Va rugam, completati campurile Membru, Nume, Nivel Securitate si  Adresa Email',
    11 => 'Administrare Ulilizatori',
    12 => 'Pentru a modifica sau sterge un membru, dati clic pe un utilizator de mai jos.  Pentru a crea un nou utilizator dati clic pe butonul de creare nou utilizator din stanga. Puteti realiza cautari simple introducand utilizator, adresa de email sau nume (ex. *ion*, *.it sau *.ro) in formularul urmator.',
    13 => 'SecLev',
    14 => 'Reg. Data',
    15 => '',
    16 => '',
    17 => '',
    18 => '',
    19 => '',
    20 => 'salveaza',
    21 => 'Numele Membru ales exista deja.',
    22 => 'Eroare',
    23 => 'Batch Add',
    24 => 'Batch Import of Users',
    25 => 'You can import a batch of users into Geeklog.  The import file must a tab-delimited text file and must have the fields in the following order: full name, Membru, email address.  Each user you import will be emailed with a random password.  You must have one user entered per line.  Failure to follow these instructions will cause problems that may require manual work so double check your entries!',
    26 => '',
    27 => '',
    28 => 'Check here to sterge this picture',
    29 => 'Cale',
    30 => 'Importa',
    31 => 'Membri noi',
    32 => 'Done processing. Imported %d and encountered %d failures',
    33 => 'trimite',
    34 => 'Eroare: trebuie specificat un fisieer pentru incarcat pe server/upload.',
    35 => 'Last Login',
    36 => '(never)',
    37 => 'UID',
    38 => 'Group Listing',
    39 => 'Password (again)',
    40 => 'Registration Date',
    41 => 'Last login Date',
    42 => 'Banned',
    43 => 'Awaiting Activation',
    44 => 'Awaiting Authorization',
    45 => 'Active',
    46 => 'User Status',
    47 => 'Edit',
    48 => 'Show Admin Groups',
    49 => 'Admin Group',
    50 => 'Check to allow filtering this group as an Admin Use Group',
    51 => 'Online Days',
    52 => '<br' . XHTML . '>Note: "Online Days" is the number of days between the first registration and the last login.',
    53 => 'registered',
    54 => 'Batch Delete',
    55 => 'This only works if you have <code>$_CONF[\'lastlogin\'] = true;</code> in your config.php',
    56 => 'Please choose the type of user you want to delete and press "Update List". Then, uncheck those from the list you do not want to delete and press "Delete". Please note that you will only delete those that are currently visible in case the list spans over several pages.',
    57 => 'Phantom users',
    58 => 'Short-Time Users',
    59 => 'Old Users',
    60 => 'Users that registered more than ',
    61 => ' months ago, but never logged in.',
    62 => 'Users that registered more than ',
    63 => ' months ago, then logged in within 24 hours, but since then never came back to your site.',
    64 => 'Normal users, who simply did not visit your site since ',
    65 => ' months.',
    66 => 'Update List',
    67 => 'Months since registration',
    68 => 'Online Hours',
    69 => 'Offline Months',
    70 => 'could not be deleted',
    71 => 'sucessfully deleted',
    72 => 'No User selected for deletion',
    73 => 'Are You sure you want to permanently delete ALL selected users?',
    74 => 'Recent Users',
    75 => 'Users that registered in the last ',
    76 => ' months',
    77 => 'Email site login reminder to selected users',
    78 => 'Send Reminder',
    79 => 'No User selected for reminders',
    80 => 'Successfully sent Reminders',
    81 => 'Reminder to verify account for %s',
    82 => "Your account on {$_CONF['site_name']} has not been accesssed since %s and will be disabled if not accessed in the 30 days.",
    83 => "Your account on {$_CONF['site_name']} has not been used since it was created and will deleted soon if not accessed.",
    84 => "Your login name is: %s  for our site: {$_CONF['site_url']}",
    85 => 'If you have forgotten the password use the following link: %s',
    86 => 'Include',
    87 => 'Reminders',
    88 => 'Default Group',
    89 => 'Check to make this a default group for new users',
    90 => 'Apply "Default Group" change to existing user accounts',
    'autotag_desc_user' => '[user: id alternate title] - Displays a link to a User using the Username as the title. An alternate title may be specified but is not required.'
);

###############################################################################
# admin/moderation.php

$LANG29 = array(
    1 => 'Approve',
    2 => 'sterge',
    3 => 'Edit',
    4 => 'Profile',
    10 => 'Titlu',
    11 => 'Start Date',
    12 => 'URL',
    13 => 'Category',
    14 => 'Date',
    15 => 'Topic',
    16 => 'Username',
    17 => 'Full name',
    18 => 'Email',
    34 => 'Command and Control',
    35 => 'Stire Submissions',
    36 => 'Parent or Comment',
    37 => 'Author',
    38 => 'Trimite',
    39 => 'There are no submissions to moderate at this time',
    40 => 'User Submissions',
    41 => 'Comment Submissions',
    42 => 'Username',
    43 => 'Auto-publish Comments?',
    'core' => 'Core',
    'plugins' => 'Plugins',
    'tools' => 'Tools',
    'users' => 'Users',
    'submissions_desc' => 'To modify or delete a user submssion, click on that item\'s edit icon below. To approve and delete multiple submissions use the radio options in the lists and then click submit.'
);

###############################################################################
# admin/mail.php

$LANG31 = array(
    1 => "{$_CONF['site_name']} Mail Utility",
    2 => 'From',
    3 => 'Reply-to',
    4 => 'Subject',
    5 => 'Body',
    6 => 'Send to:',
    7 => 'All users',
    8 => 'Admin',
    9 => 'Options',
    10 => 'HTML',
    11 => 'Urgent message!',
    12 => 'Send',
    13 => 'Reset',
    14 => 'Ignore user settings',
    15 => 'Error when sending to: ',
    16 => 'Successfully sent messages to: ',
    17 => "<a href={$_CONF['site_admin_url']}/mail.php>Send another message</a>",
    18 => 'To',
    19 => 'NOTE: if you wish to send a message to all site members, select the Logged-in Users group from the drop down.',
    20 => "Successfully sent <successcount> messages and unsuccessfully sent <failcount> messages.  If you need them, the details of each message attempts is below.  Otherwise you can <a href=\"{$_CONF['site_admin_url']}/mail.php\">Send another message</a> or you can <a href=\"{$_CONF['site_admin_url']}/moderation.php\">go back to the administration page</a>.",
    21 => 'Failures',
    22 => 'Successes',
    23 => 'No failures',
    24 => 'No successes',
    25 => '-- Select Group --',
    26 => 'Please fill in all the fields on the form and select a group of users from the drop down.'
);

###############################################################################
# admin/plugins.php

$LANG32 = array(
    1 => 'Installing plugins could possibly cause damage to your Geeklog installation and, possibly, to your system.  It is important that you only install plugins downloaded from the <a href="http://www.geeklog.net" target="_blank">Geeklog Homepage</a> as we thoroughly test all plugins submitted to our site on a variety of operating systems.  It is important that you understand that the plugin installation process will require the execution of a few filesystem commands which could lead to security problems particularly if you use plugins from third party sites.  Even with this warning you are getting, we do not gaurantee the success of any installation nor are we liable for damage caused by installing a Geeklog plugin.  In other words, install at your own risk.  For the wary, directions on how to manually install a plugin is included with each plugin package.',
    2 => 'Plug-in Installation Disclaimer',
    3 => 'Plug-in Installation Form',
    4 => 'Plug-in File',
    5 => 'Plug-in List',
    6 => 'Warning: Plug-in Already Installed!',
    7 => 'The plug-in you are trying to install already exists.  Please sterge the plugin before re-installing it',
    8 => 'Plugin Compatibility Check Failed',
    9 => 'This plugin requires a newer version of Geeklog. Either upgrade your copy of <a href="http://www.geeklog.net">Geeklog</a> or get a newer version of the plug-in.',
    10 => '<br' . XHTML . '><b>There are no plugins currently installed.</b><br' . XHTML . '><br' . XHTML . '>',
    11 => 'To modify or sterge a plug-in, click on that plug-in\'s number below. To learn more about a plug-in, click the plug-in name and you will be directed to that plug-in\'s website. To install or upgrade a plug-in please consult it\'s documentation.',
    12 => 'no plugin name provided to plugineditor()',
    13 => 'Plugin Editor',
    14 => 'New Plug-in',
    15 => 'Admin Home',
    16 => 'Plug-in Name',
    17 => 'Plug-in Version',
    18 => 'Geeklog Version',
    19 => 'Enabled',
    20 => 'Yes',
    21 => 'No',
    22 => 'Install',
    23 => 'Salveaza',
    24 => 'anuleaza',
    25 => 'Sterge',
    26 => 'Plug-in Name',
    27 => 'Plug-in Homepage',
    28 => 'Plug-in Version',
    29 => 'Versiune Geeklog ',
    30 => 'Sterge Plug-in?',
    31 => 'Are you sure you want to sterge this plug-in?  By doing so you will remove all the data and data structures that this plug-in uses.  If you are sure, click sterge again on the form below.',
    32 => '<p><b>Error AutoLink tag not correct format</b></p>',
    33 => 'Code Version',
    34 => 'Update',
    35 => 'Edit',
    36 => 'Code',
    37 => 'Data',
    38 => 'Update!',
    39 => 'Upload a plugin',
    40 => 'You can upload a plugin archive (.tar.gz, .tgz, .zip) directly here:',
    41 => 'Upload',
    42 => 'Click to update',
    43 => 'Load Order',
    44 => 'Move plugin up the load order',
    45 => 'Move plugin down the load order',
    46 => 'Click to Delete this Plugin',
    47 => 'Really Delete %s Plugin?',
    48 => 'Click to Enable this Plugin',
    49 => 'Click to Disable this Plugin',
    50 => 'Dependencies',
    51 => 'OK',
    52 => 'Unresolved',
    53 => 'Disabled',
    54 => 'Unavailable',
    55 => 'Uninstalled',
    56 => 'Wrong Version',
    57 => 'Unknown',
    58 => 'The load order of one or more plugins has been altered in order to resolve dependencies',
    59 => 'Info',
    60 => 'Close',
    61 => 'Status',
    62 => 'Click to Install this Plugin',
    63 => 'This Plugin Cannot be Installed',
    64 => 'This Plugin Cannot be Enabled',
    65 => 'The plugin upload function has been disabled due to the following errors:',
    66 => 'File uploads are disabled in your PHP configuration.',
    67 => 'The directory "%s" is not writable.',
    68 => 'You do not have the required permissions to install plugins.',
    69 => 'You do not have the required permissions to upload plugins.',
    99 => 'An unknown error occured',
    100 => 'Ok.',
    101 => 'The uploaded file exceeds the upload_max_filesize directive in php.ini.',
    102 => 'The uploaded file exceeds the MAX_FILE_SIZE directive that was specified in the HTML form.',
    103 => 'The uploaded file was only partially uploaded.',
    104 => 'No file was uploaded.',
    105 => '(undefined error)',
    106 => 'Missing a temporary folder.',
    107 => 'Failed to write file to disk.',
    108 => 'File upload stopped by extension.'
);

###############################################################################
# admin/syndication.php

$LANG33 = array(
    1 => 'create feed',
    2 => 'save',
    3 => 'delete',
    4 => 'cancel',
    10 => 'Content Syndication',
    11 => 'New Feed',
    12 => 'Admin Home',
    13 => 'To modify or delete a feed, click on the feed\'s title below. To create a new feed, click on New Feed above.',
    14 => 'Title',
    15 => 'Type',
    16 => 'Filename',
    17 => 'Format',
    18 => 'last updated',
    19 => 'Enabled',
    20 => 'Yes',
    21 => 'No',
    22 => '<i>(no feeds)</i>',
    23 => 'all Stories',
    24 => 'Feed Editor',
    25 => 'Feed Title',
    26 => 'Limit',
    27 => 'Length of entries',
    28 => '(0 = no text, 1 = full text, other = limit to that number of chars.)',
    29 => 'Description',
    30 => 'Last Update',
    31 => 'Character Set',
    32 => 'Language',
    33 => 'Contents',
    34 => 'Entries',
    35 => 'Hours',
    36 => 'Select type of feed',
    37 => '',
    38 => 'Error: Missing Fields',
    39 => 'Please fill in the Feed Title, Description, and Filename.',
    40 => 'Please enter a  number of entries or number of hours.',
    41 => 'Links',
    42 => '',
    43 => 'All',
    44 => 'None',
    45 => 'Header-link in topic',
    46 => 'Limit Results',
    47 => 'Search',
    48 => 'Edit',
    49 => 'Feed Logo',
    50 => "Relative to site url ({$_CONF['site_url']})",
    51 => 'The filename you have chosen is already used by another feed. Please choose a different one.',
    52 => 'Error: existing Filename',
    53 => 'All Frontpage Stories',
    54 => 'Please select the type of feed to create.',
    55 => 'Articles'
);

###############################################################################
# confirmation and error messages

$MESSAGE = array(
    1 => "Parola a fost trimisa prin e-mail si trebuie sa o primiti imediat. Va rugam sa urmati indicatiile din mesaj si va multumim pentru utilizarea {$_CONF['site_name']}",
    2 => "Va multumim pentru stirea/textul trimis la {$_CONF['site_name']}.  A fost trimisa pentru aprobare. Daca va fi aprobata, stirea dvs. va fi disponibila pe sit pentru vizualizare.",
    3 => '',
    4 => '',
    5 => 'Informatiile tale au fost salvate cu succes.',
    6 => 'Preferintele tale au fost salvate cu succes.',
    7 => 'Preferintele tale pentru comentarii au fost salvate cu succes.',
    8 => 'Ai iesit cu succes din aria utilizatori inregistrati/membri.',
    9 => 'Stirea a fost salvata cu succes.',
    10 => 'Stirea a fost stearsa cu succes.',
    11 => 'Blocul a fost salvat cu succes.',
    12 => 'Blocul a fost sters cu succes.',
    13 => 'Subiectul tau a fost salvat cu succes.',
    14 => 'The topic and all it\'s stiri and blocks have been successfully sters.',
    15 => 'Your comment has been submitted for review and will be published when approved by a moderator.',
    16 => 'You have been unsubscribed. You will no longer be notified of new replies.',
    17 => '',
    18 => '',
    19 => '',
    20 => '',
    21 => 'Noul membru a fost salvat cu succes.',
    22 => 'Ulilizatorul a fost sters cu succes',
    23 => '',
    24 => '',
    25 => '',
    26 => '',
    27 => 'Mesaj trimis cu succes.',
    28 => 'The plug-in has been successfully saved',
    29 => 'Sorry, you do not have access to this administration page.  Please note that all attempts to access unauthorized features are logged',
    30 => 'Access interzis',
    31 => '',
    32 => '',
    33 => '',
    34 => '',
    35 => '',
    36 => '',
    37 => '',
    38 => '',
    39 => '',
    40 => 'Mesaj sistem',
    41 => '',
    42 => '',
    43 => '',
    44 => 'The plug-in was successfully installed!',
    45 => 'The plug-in was successfully sters.',
    46 => '',
    47 => '',
    48 => "Va multumim pentru inregistrarea la {$_CONF['site_name']}. Vom revedea  inscrierea dvs. si daca va fi aprobata, parola dvs. va fi trimisa la adresa de e-mail pe care ati introdus-o.",
    49 => 'Your group has been successfully saved.',
    50 => 'The group has been successfully sters.',
    51 => 'This username is already in use. Please choose another one.',
    52 => 'The email address provided does not appear to be a valid email address.',
    53 => 'Your new password has been accepted. Please use your new password below to log in now.',
    54 => 'Your request for a new password has expired. Please try again below.',
    55 => 'An email has been sent to you and should arrive momentarily. Please follow the directions in the message to set a new password for your account.',
    56 => 'The email address provided is already in use for another account.',
    57 => 'Your account has been successfully deleted.',
    58 => 'Your feed has been successfully saved.',
    59 => 'The feed has been successfully deleted.',
    60 => 'The plugin was successfully updated',
    61 => 'Plugin %s: Unknown message placeholder',
    62 => 'The trackback comment has been deleted.',
    63 => 'An error occurred when deleting the trackback comment.',
    64 => 'Your trackback comment has been successfully sent.',
    65 => 'Weblog directory service successfully saved.',
    66 => 'The weblog directory service has been deleted.',
    67 => 'The new password does not match the confirmation password!',
    68 => 'You have to enter the correct current password.',
    69 => 'Your account has been blocked!',
    70 => 'Your account is awaiting administrator approval.',
    71 => 'Your account has now been confirmed and is awaiting administrator approval.',
    72 => 'An error occured while attempting to install the plugin. See error.log for details.',
    73 => 'An error occured while attempting to uninstall the plugin. See error.log for details.',
    74 => 'The pingback has been successfully sent.',
    75 => 'Trackbacks must be sent using a POST request.',
    76 => 'Do you really want to delete this item?',
    77 => 'WARNING:<br' . XHTML . '>You have set your default encoding to UTF-8. However, your server does not support multibyte encodings. Please install mbstring functions for PHP or choose a different character set/language.',
    78 => 'Please make sure that the email address and the confirmation email address are the same.',
    79 => 'The page you have been trying to open refers to a function that no longer exists on this site.',
    80 => 'The plugin that created this feed is currently disabled. You will not be able to edit this feed until you re-enable the parent plugin.',
    81 => 'You may have mistyped your login credentials.  Please try logging in again below.',
    82 => 'You have exceeded the number of allowed login attempts.  Please try again later.',
    83 => 'To change your password, email address, or for how long to remember you, please enter your current password.',
    84 => 'To delete your account, please enter your current password.',
    85 => 'There was a problem sending the email.',
    86 => 'The OpenID server invalidated your login attempt.',
    87 => 'OpenID login operation cancelled by user.',
    88 => 'The OpenID server returned an error.',
    89 => 'Unable to find an OpenID server for the given identity URL.',
    90 => 'OpenID identification cancelled.',
    91 => 'You specified an invalid identity URL.',
    92 => "Please <a href=\"{$_CONF['site_admin_url']}/sectest.php\">check the security of your site</a> before using it!",
    93 => 'Database back up was successful.',
    94 => 'Backup Failed: Filesize less than 1kb',
    95 => 'There was an error.',
    96 => '',
    97 => '',
    98 => 'The plugin was successfully uploaded.',
    99 => 'The plugin already exists.',
    100 => 'The plugin file you uploaded was not a GZip or Zip compressed archive.',
    101 => 'There are no topics (that you have access to). You need at least one topic to be able to submit stories.',
    110 => 'Can not get URL for authentication.',
    111 => 'Authentication error.',
    112 => 'Certification has been canceled.',
    113 => 'Your account has been created successfully. {site_url}',
    114 => 'Your re-synch with your remote account has failed but your other account information has been successfully saved.',
    115 => 'Remote service has been disabled.',
    116 => 'Loading...',
    117 => 'Help page is not found.',
    118 => 'Click to select a date',
    119 => 'More..',
    120 => 'Send this?',
    400 => 'Not all required fields have been passed validation',
    401 => 'Please enter Fullname',
    500 => 'The Template Cache has been successfully cleared.'
);

###############################################################################

$LANG_ACCESS = array(
    'access' => 'Access',
    'ownerroot' => 'Owner/Root',
    'group' => 'Group',
    'readonly' => 'Read-Only',
    'accessrights' => 'Access Rights',
    'owner' => 'Owner',
    'grantgrouplabel' => 'Grant Above Group Edit Rights',
    'permmsg' => 'NOTE: members is all logged in members of the site and anonymous is all users browsing the site that aren\'t logged in.',
    'securitygroups' => 'Security Groups',
    'editrootmsg' => "Even though you are a User Administrator, you can't edit a root user without first being a root user yourself.  You can edit all other users except root users. Please note that all attempts to illegally edit root users are logged.  Please go back to the <a href=\"{$_CONF['site_admin_url']}/user.php\">User Administration page</a>.",
    'securitygroupsmsg' => 'Select the checkboxes for the groups you want the user to belong to.',
    'groupeditor' => 'Group Editor',
    'description' => 'Descriere',
    'name' => 'Name',
    'rights' => 'Rights',
    'missingfields' => 'Missing Fields',
    'missingfieldsmsg' => 'You must supply the name and a descriere for a group',
    'groupmanager' => 'Group Manager',
    'newgroupmsg' => 'To modify or sterge a group, click on that group below. To create a new group click new group above. Please note that core groups cannot be sters because they are used in the system.',
    'groupname' => 'Group Name',
    'coregroup' => 'Core Group',
    'yes' => 'Yes',
    'no' => 'No',
    'corerightsdescr' => "This group is a core {$_CONF['site_name']} Group.  Therefore the rights for this group cannot be edited.  Below is a read-only list of the rights this group has access to.",
    'groupmsg' => 'Security Groups on this site are hierarchical.  By adding this group to any of the groups below you will giving this group the same rights that those groups have.  Where possible it is encouraged you use the groups below to give rights to a group.  If you need this group to have custom rights then you can select the rights to various site features in the section below called \'Rights\'.  To add this group to any of the ones below simply check the box next to the group(s) that you want.',
    'coregroupmsg' => "This group is a core {$_CONF['site_name']} Group.  Therefore the groups that this group belongs to cannot be edited.  Below is a read-only list of the groups this group belongs to.",
    'rightsdescr' => 'A groups access to a certain right below can be given directly to the group OR to a different group that this group is a part of.  The ones you see below without a checkbox are the rights that have been given to this group because it belongs to another group with that right.  The rights with checkboxes below are rights that can be given directly to this group.',
    'lock' => 'Lock',
    'members' => 'Members',
    'anonymous' => 'Anonymous',
    'permissions' => 'Permissions',
    'permissionskey' => 'R = read, E = edit, edit rights assume read rights',
    'edit' => 'Edit',
    'none' => 'None',
    'accessdenied' => 'Access Denied',
    'storydenialmsg' => "You do not have access to view this stire.  This could be because you aren't a member of {$_CONF['site_name']}.  Please <a href=\"{$_CONF['site_url']}/users.php?mode=new\" rel=\"nofollow\"> become a member</a> of {$_CONF['site_name']} to receive full membership access!",
    'nogroupsforcoregroup' => 'This group doesn\'t belong to any of the other groups',
    'grouphasnorights' => 'This group doesn\'t have access to any of the administrative features of this site',
    'newgroup' => 'New Group',
    'adminhome' => 'Admin Home',
    'save' => 'save',
    'cancel' => 'anuleaza',
    'delete' => 'sterge',
    'canteditroot' => 'You have tried to edit the Root group but you are not in the Root group yourself therefore your access to this group is denied.  Please contact the system administrator if you feel this is an error',
    'listusers' => 'List Users',
    'listthem' => 'list',
    'usersingroup' => 'Users in group "%s"',
    'usergroupadmin' => 'User Group Administration',
    'add' => 'Add',
    'remove' => 'Remove',
    'availmembers' => 'Available Members',
    'groupmembers' => 'Group Members',
    'canteditgroup' => 'To edit this group, you have to be a member of the group. Please contact the system administrator if you feel this is an error.',
    'cantlistgroup' => 'To see the members of this group, you have to be a member yourself. Please contact the system administrator if you feel this is an error.',
    'editgroupmsg' => 'To modify the group membership, click on the member names(s) and use the add or remove buttons. If the member is a member of the group, their name will appear on the right side only. Once you are complete - press <b>Save</b> to update the group and return to the main group admin page.',
    'listgroupmsg' => 'Listing of all current members in the group: <b>%s</b>',
    'search' => 'Search',
    'submit' => 'Submit',
    'limitresults' => 'Limit Results',
    'group_id' => 'Group ID',
    'plugin_access_denied_msg' => 'You are illegally trying access a plugin administration page.  Please note that all attempts to illegally access this page are logged.',
    'groupexists' => 'Group name already exists',
    'groupexistsmsg' => 'There is already a group with this name. Group names must be unique.'
);

###############################################################################
# admin/database.php

$LANG_DB_BACKUP = array(
    'last_ten_backups' => 'Ultimele 10 Backup-uri',
    'do_backup' => 'Backup',
    'backup_successful' => 'Database back up was successful.',
    'db_explanation' => 'To create a new backup of your Geeklog system, hit the button below',
    'not_found' => "Incorrect path or mysqldump utility not executable.<br" . XHTML . ">Check <strong>\$_DB_mysqldump_path</strong> definition in config.php.<br" . XHTML . ">Variable currently defined as: <var>{$_DB_mysqldump_path}</var>",
    'zero_size' => 'Backup Failed: Filesize was 0 bytes',
    'path_not_found' => "{$_CONF['backup_path']} does not exist or is not a directory",
    'no_access' => "ERROR: Directory {$_CONF['backup_path']} is not accessible.",
    'backup_file' => 'Backup file',
    'size' => 'Size',
    'bytes' => 'Bytes',
    'total_number' => 'Total number of backups: %d',
    'download' => 'Click to download this file',
    'new_backup' => 'New Backup',
    'delete_failure' => 'One or more backup files could not be deleted.',
    'delete_success' => 'Backup file(s) successfully deleted.',
    'convert_menu' => 'Convert to InnoDB',
    'convert_title' => 'Convert to InnoDB tables',
    'convert_button' => 'Convert',
    'sorry_no_innodb' => 'Sorry, your version of MySQL does not support InnoDB tables.',
    'innodb_explain' => 'InnoDB tables provide better performance on <em>really</em> large databases but make the backup process more complicated. Please <a href="http://dev.mysql.com/doc/mysql/en/innodb.html">read up</a> on the pros and cons of InnoDB tables before you perform this operation.',
    'already_converted' => 'Note: It appears that all of the tables have already been converted to InnoDB.',
    'conversion_patience' => 'Note: Conversion may take some time - please be patient.',
    'innodb_success' => 'Successfully converted tables to InnoDB.',
    'table_issues' => 'There may have been problems with some tables, though. Please check error.log for details.',
    'optimize_menu' => 'Optimize Tables',
    'optimize_title' => 'Optimize Tables',
    'optimize_button' => 'Optimize',
    'optimize_explain' => 'Optimizing tables may help to improve the performance of your site. The actual impact depends on the table usage and some tables may benefit from it more than others. Do no expect to see a huge difference in performance. The <a href="http://dev.mysql.com/doc/mysql/en/optimize-table.html">MySQL manual</a> states: <q>it is not likely that you need to do this more than once a week or month</q>.',
    'last_optimization' => 'Last optimization',
    'optimization_patience' => 'Note: Optimization may take some time - please be patient.',
    'optimize_success' => 'Successfully optimized database tables.'
);

###############################################################################

$LANG_BUTTONS = array(
    1 => 'Home',
    2 => 'Contact',
    3 => 'Publica',
    4 => '',
    5 => '',
    6 => '',
    7 => 'Statistici',
    8 => 'Personalizeaza',
    9 => 'Cauta',
    10 => 'cautare avansata',
    11 => 'Directory'
);

###############################################################################
# 404.php

$LANG_404 = array(
    1 => 'Eroare 404',
    2 => 'Oh, nu! Ne-am uitat peste tot, dar n-am gasit <b>%s</b>.',
    3 => "<p>Ne pare rau, dar pagina care o cautati nu exista. Va rugam, verificati <a href=\"{$_CONF['site_url']}\">pagina principala</a> sau <a href=\"{$_CONF['site_url']}/search.php\">pagina de cautare</a> sa vedeti daca gasiti ceea ce cautati.",
    4 => "<p>We're sorry, but the page you have requested does not exist. We recommend going back to this <a href=\"%s\">related page</a>, or you may want to check the <a href=\"{$_CONF['site_url']}/\">home page</a>, or the <a href=\"{$_CONF['site_url']}/search.php\">search page</a> to see if you can find what you lost."
);

###############################################################################
# login form

$LANG_LOGIN = array(
    1 => 'Inregistrare necesara',
    2 => 'Ne pare rau, pentru a avea acces la aceasta zona trebuie sa fiti membru/utilizator inregistrat.',
    3 => 'Inregistrare',
    4 => 'Membru Nou'
);

###############################################################################
# trackback.php

$LANG_TRB = array(
    'trackback' => 'Trackback',
    'from' => 'from',
    'tracked_on' => 'Tracked on',
    'read_more' => '[read more]',
    'intro_text' => 'Here\'s what others have to say about \'%s\':',
    'no_comments' => 'No trackback comments for this entry.',
    'this_trackback_url' => 'Trackback URL for this entry:',
    'num_comments' => '%d trackback comments',
    'send_trackback' => 'Send Pings',
    'preview' => 'Preview',
    'editor_title' => 'Send trackback comment',
    'trackback_url' => 'Trackback URL',
    'entry_url' => 'Entry URL',
    'entry_title' => 'Entry Title',
    'blog_name' => 'Site Name',
    'excerpt' => 'Excerpt',
    'truncate_warning' => 'Note: The receiving site may truncate your excerpt',
    'button_send' => 'Send',
    'button_preview' => 'Preview',
    'send_error' => 'Error',
    'send_error_details' => 'Error when sending trackback comment:',
    'url_missing' => 'No Entry URL',
    'url_required' => 'Please enter at least a URL for the entry.',
    'target_missing' => 'No Trackback URL',
    'target_required' => 'Please enter a trackback URL',
    'error_socket' => 'Could not open socket.',
    'error_response' => 'Response not understood.',
    'error_unspecified' => 'Unspecified error.',
    'select_url' => 'Select Trackback URL',
    'not_found' => 'Trackback URL not found',
    'autodetect_failed' => 'Geeklog could not detect the Trackback URL for the post you want to send your comment to. Please enter it manually below.',
    'trackback_explain' => 'From the links below, please select the URL you want to send your Trackback comment to. Geeklog will then try to determine the correct Trackback URL for that post. Or you can <a href="%s">enter it manually</a> if you know it already.',
    'no_links_trackback' => 'No links found. You can not send a Trackback comment for this entry.',
    'pingback' => 'Pingback',
    'pingback_results' => 'Pingback results',
    'send_pings' => 'Send Pings',
    'send_pings_for' => 'Send Pings for "%s"',
    'no_links_pingback' => 'No links found. No Pingbacks were sent for this entry.',
    'pingback_success' => 'Pingback sent.',
    'no_pingback_url' => 'No pingback URL found.',
    'resend' => 'Resend',
    'ping_all_explain' => 'You can now notify the sites you linked to (<a href="http://en.wikipedia.org/wiki/Pingback">Pingback</a>), advertise that your site has been updated by pinging weblog directory services, or send a <a href="http://en.wikipedia.org/wiki/Trackback">Trackback</a> comment in case you wrote about a post on someone else\'s site.',
    'pingback_button' => 'Send Pingback',
    'pingback_short' => 'Send Pingbacks to all sites linked from this entry.',
    'pingback_disabled' => '(Pingback disabled)',
    'ping_button' => 'Send Ping',
    'ping_short' => 'Ping weblog directory services.',
    'ping_disabled' => '(Ping disabled)',
    'trackback_button' => 'Send Trackback',
    'trackback_short' => 'Send a Trackback comment.',
    'trackback_disabled' => '(Trackback disabled)',
    'may_take_a_while' => 'Please note that sending Pingbacks and Pings may take a while.',
    'ping_results' => 'Ping results',
    'unknown_method' => 'Unknown ping method',
    'ping_success' => 'Ping sent.',
    'error_site_name' => 'Please enter the site\'s name.',
    'error_site_url' => 'Please enter the site\'s URL.',
    'error_ping_url' => 'Please enter a valid Ping URL.',
    'no_services' => 'No weblog directory services configured.',
    'services_headline' => 'Weblog Directory Services',
    'service_explain' => 'To modify or delete a weblog directory service, click on the edit icon of that service below. To add a new weblog directory service, click on "Create New" above.',
    'service' => 'Service',
    'ping_method' => 'Ping method',
    'service_website' => 'Website',
    'service_ping_url' => 'URL to ping',
    'ping_standard' => 'Standard Ping',
    'ping_extended' => 'Extended Ping',
    'ping_unknown' => '(unknown method)',
    'edit_service' => 'Edit Weblog Directory Service',
    'trackbacks' => 'Trackbacks',
    'editor_intro' => 'Prepare your trackback comment for <a href="%s">%s</a>.',
    'editor_intro_none' => 'Prepare your trackback comment.',
    'trackback_note' => 'To send a trackback comment for a story, go to the list of stories and click on "Send Ping" for the story. To send a trackback that is not related to a story, <a href="%s">click here</a>.',
    'pingback_explain' => 'Enter a URL to send the Pingback to. The pingback will point to your site\'s homepage.',
    'pingback_url' => 'Pingback URL',
    'site_url' => 'This site\'s URL',
    'pingback_note' => 'To send a pingback for a story, go to the list of stories and click on "Send Ping" for the story. To send a pingback that is not related to a story, <a href="%s">click here</a>.',
    'pbtarget_missing' => 'No Pingback URL',
    'pbtarget_required' => 'Please enter a pingback URL',
    'pb_error_details' => 'Error when sending the pingback:',
    'delete_trackback' => 'To delete this Trackback click: '
);

###############################################################################
# directory.php

$LANG_DIR = array(
    'title' => 'Article Directory',
    'title_year' => 'Article Directory for %d',
    'title_month_year' => 'Article Directory for %s %d',
    'nav_top' => 'Back to Article Directory',
    'no_articles' => 'No articles.'
);

###############################################################################
# admin/sectest.php

$LANG_SECTEST = array(
    'sectest' => 'Geeklog Security Check',
    'results' => 'Results of the Security Check',
    'okay' => 'Everything seems to be in order.',
    'please_fix' => 'Please fix the above issues before using your site!',
    'please_note' => 'Please note that no site is ever 100% secure. This script can only test for obvious security issues.',
    'stay_informed' => 'To stay informed about new Geeklog releases and possible security issues, we suggest that you subscribe to the (low-traffic) %s mailing list and/or use the %s option in your Admin menu from time to time to check for available updates.',
    'public_html' => '"public_html" should never be part of your site\'s URL.  Please read the part about public_html in the %s again and change your setup accordingly before you proceed.',
    'installation' => 'installation instructions',
    'directory' => 'directory',
    'failed_tmp' => 'Failed to create a temporary file in your %s directory. Check your directory permissions!',
    'fix_it' => 'This is a security risk and should be fixed!',
    'reachable' => 'Your %s is reachable from the web.',
    'not_reachable' => 'Good! Your %s is not reachable from the web.',
    'not_sure' => 'Got an HTTP result code %s when trying to test your %s. Not sure what to make of it ...',
    'remove_inst' => 'You should really remove the install directory %s once you have your site up and running without any errors.',
    'remove_inst2' => 'Keeping it around would allow malicious users the ability to destroy your current install, take over your site, or retrieve sensitive information.',
    'inst_removed' => 'Good! You seem to have removed the install directory already.',
    'fix_password' => 'You still have not changed the <strong>default password</strong> from "password" on %s Root user account(s).',
    'password_okay' => 'Good! You seem to have changed the default account password already.'
);

###############################################################################
# "What's New" Time Strings
# 
# For the first two strings, you can use the following placeholders.
# Order them so it makes sense in your language:
# %i    item, "Stories"
# %n    amount, "2", "20" etc.
# %t    time, "2" (weeks)
# %s    scale, "hrs", "weeks"

$LANG_WHATSNEW = array(
    'new_string' => '%n new %i in the last %t %s',
    'new_last' => 'last %t %s',
    'minutes' => 'minutes',
    'hours' => 'hours',
    'days' => 'days',
    'weeks' => 'weeks',
    'months' => 'months',
    'years' => 'years',
    'minute' => 'minute',
    'hour' => 'hour',
    'day' => 'day',
    'week' => 'week',
    'month' => 'month',
    'year' => 'year'
);

###############################################################################
# Month names

$LANG_MONTH = array(
    1 => 'Ianuarie',
    2 => 'Februarie',
    3 => 'Martie',
    4 => 'Aprilie',
    5 => 'Mai',
    6 => 'Iunie',
    7 => 'Iulie',
    8 => 'August',
    9 => 'Septembrie',
    10 => 'Octombrie',
    11 => 'Noiembrie',
    12 => 'Decembrie'
);

###############################################################################
# Weekdays

$LANG_WEEK = array(
    1 => 'Duminica',
    2 => 'Luni',
    3 => 'Marti',
    4 => 'Miercuri',
    5 => 'Joi',
    6 => 'Vineri',
    7 => 'Sambata'
);

###############################################################################
# Admin - Strings
# 
# These are some standard strings used by core functions as well as plugins to
# display administration lists and edit pages

$LANG_ADMIN = array(
    'search' => 'Search',
    'limit_results' => 'Limit Results',
    'submit' => 'Submit',
    'edit' => 'Edit',
    'edit_adv' => 'Adv. Edit',
    'admin_home' => 'Admin Home',
    'create_new' => 'Create New',
    'create_new_adv' => 'Create New (Adv.)',
    'enabled' => 'Enabled',
    'disabled' => 'Disabled',
    'title' => 'Title',
    'page_title' => 'Page Title',
    'type' => 'Type',
    'topic' => 'Topic',
    'info' => 'Info',
    'help_url' => 'Help File URL',
    'save' => 'Save',
    'cancel' => 'Cancel',
    'install' => 'Install',
    'delete' => 'Delete',
    'deleteitem' => 'Delete',
    'delete_sel' => 'Delete selected',
    'copy' => 'Copy',
    'no_results' => '- No entries found -',
    'data_error' => 'There was an error processing the subscription data. Please check the data source.',
    'preview' => 'Preview',
    'records_found' => 'Records found',
    'addchild' => 'Add child',
    'list' => 'list',
    'list_all' => 'List all',
    'meta_description' => 'Meta Description',
    'meta_keywords' => 'Meta Keywords',
    'na' => 'N/A',
    'unavailable' => 'N/A',
    'warning' => '!!!',
    'token_expiry' => 'You have until %s to make changes. After that time, the security token embedded into this page will expire and you will lose your changes.',
    'token_expired' => 'The security token for this operation has expired. Please authenticate again to continue.',
    'reauth_msg' => 'The security token for this operation has expired. If you want to continue with this operation, then please authenticate again below. This will ensure that the changes you just made will not be lost.',
    'authenticate' => 'Authenticate'
);

# Localisation of the texts for the various drop-down menus that are actually
# stored in the database. If these exist, they override the texts from the
# database.

$LANG_commentcodes = array(
    0 => 'Comments Enabled',
    -1 => 'Comments Disabled',
    1 => 'Comments Closed'
);

$LANG_commentmodes = array(
    'flat' => 'Flat',
    'nested' => 'Nested',
    'threaded' => 'Threaded',
    'nocomment' => 'No Comments'
);

$LANG_cookiecodes = array(
    0 => '(don\'t)',
    3600 => '1 Hour',
    7200 => '2 Hours',
    10800 => '3 Hours',
    28800 => '8 Hours',
    86400 => '1 Day',
    604800 => '1 Week',
    2678400 => '1 Month'
);

$LANG_dateformats = array(
    0 => 'System Default'
);

$LANG_featurecodes = array(
    0 => 'Not Featured',
    1 => 'Featured'
);

$LANG_frontpagecodes = array(
    0 => 'Show Only in Topic',
    1 => 'Show on Front Page'
);

$LANG_postmodes = array(
    'plaintext' => 'Plain Old Text',
    'html' => 'HTML Formatted',
    'wikitext' => 'Wiki-style format'
);

$LANG_sortcodes = array(
    'ASC' => 'Oldest First',
    'DESC' => 'Newest First'
);

$LANG_trackbackcodes = array(
    0 => 'Trackback Enabled',
    -1 => 'Trackback Disabled'
);

###############################################################################
# Localization of the Admin Configuration UI

$LANG_CONFIG = array(
    'home' => 'Home',
    'admin_home' => 'Site Administration',
    'sections' => 'Configuration Sections',
    'restore' => 'Restore',
    'add_element' => 'Add Element',
    'save_changes' => 'Save Changes',
    'reset_form' => 'Reset Form',
    'changes_made' => 'Changes were successfully made to',
    'title' => 'Configuration Manager',
    'disable' => 'Click to disable this option',
    'enable' => 'Enable',
    'default_tab_name' => 'Main',
    'search_configuration_label' => 'Search Configuration',
    'error_validation_occurs' => 'There are invalid configuration values. Please correct these fields (just click the config variable to point you to the error field)'
);

$LANG_configsections['Core'] = array(
    'label' => 'Geeklog',
    'title' => 'Geeklog Configuration'
);

$LANG_confignames['Core'] = array(
    'path_html' => 'HTML Path',
    'site_url' => 'Site URL',
    'site_admin_url' => 'Admin URL',
    'site_mail' => 'Site E-Mail',
    'noreply_mail' => 'No-Reply E-Mail',
    'mail_cc_enabled' => 'Allow to Send Carbon Copies',
    'mail_cc_default' => '"Carbon Copy" on by Default',
    'site_name' => 'Site Name',
    'site_slogan' => 'Slogan',
    'owner_name' => 'Owner Name',
    'microsummary_short' => 'Microsummary',
    'path_log' => 'Log',
    'path_language' => 'Language',
    'backup_path' => 'Backup',
    'path_data' => 'Data',
    'path_images' => 'Images',
    'path_editors' => 'Advanced Editors',
    'path_pear' => 'Path Pear',
    'have_pear' => 'Have Pear?',
    'mail_settings' => 'Mail Settings',
    'allow_mysqldump' => 'Allow MySQL Dump',
    'mysqldump_path' => 'Path of Executable',
    'mysqldump_options' => 'MySQL Dump Options',
    'mysqldump_filename_mask' => 'Backup File Name Mask',
    'theme' => 'Theme',
    'doctype' => 'DOCTYPE Declaration',
    'menu_elements' => 'Menu Elements',
    'path_themes' => 'Themes Path',
    'cache_templates' => 'Cache Templates?',
    'disable_new_user_registration' => 'Disable New Registrations',
    'allow_user_themes' => 'Allow User Themes',
    'allow_user_language' => 'Allow User Language',
    'allow_user_photo' => 'Allow User Photo',
    'allow_username_change' => 'Allow Username Changes',
    'allow_account_delete' => 'Allow Account Deletion',
    'hide_author_exclusion' => 'Allow Hide Author',
    'show_fullname' => 'Show Fullname',
    'show_servicename' => 'Show Service Name',
    'custom_registration' => 'Enable Custom Registration',
    'user_login_method' => 'User Login Method',
    'facebook_login' => 'Enable OAuth Login Method Facebook',
    'facebook_consumer_key' => 'Facebook OAuth Application ID',
    'facebook_consumer_secret' => 'Facebook OAuth Application Secret',
    'linkedin_login' => 'Enable OAuth Login Method LinkedIn',
    'linkedin_consumer_key' => 'LinkedIn OAuth API Key',
    'linkedin_consumer_secret' => 'LinkedIn OAuth Secret Key',
    'twitter_login' => 'Enable OAuth Login Method Twitter',
    'twitter_consumer_key' => 'Twitter OAuth Consumer Key',
    'twitter_consumer_secret' => 'Twitter OAuth Consumer Secret',
    'google_login' => 'Enable OAuth Login Method Google',
    'google_consumer_key' => 'Google OAuth Consumer Key',
    'google_consumer_secret' => 'Google OAuth Consumer Secret',
    'microsoft_login' => 'Enable OAuth Login Method Microsoft',
    'microsoft_consumer_key' => 'Microsoft OAuth Consumer Key',
    'microsoft_consumer_secret' => 'Microsoft OAuth Consumer Secret',
    'yahoo_login' => 'Enable OAuth Login Method Yahoo',
    'yahoo_consumer_key' => 'Yahoo OAuth Consumer Key',
    'yahoo_consumer_secret' => 'Yahoo OAuth Consumer Secret',
    'spamx' => 'Spam-X Actions',
    'sort_admin' => 'Sort Links',
    'language' => 'Language',
    'locale' => 'Locale',
    'date' => 'Date Format',
    'daytime' => 'Daytime Format',
    'shortdate' => 'Short Date Format',
    'dateonly' => 'Date Only Format',
    'timeonly' => 'Time Only Format',
    'week_start' => 'Week Start',
    'hour_mode' => 'Hour Mode',
    'thousand_separator' => 'Thousands Separator',
    'decimal_separator' => 'Decimal Separator',
    'decimal_count' => 'Decimal Count',
    'language_files' => 'Language Files',
    'languages' => 'Languages',
    'timezone' => 'Timezone',
    'site_disabled_msg' => 'Site Disabled Message or URL',
    'rootdebug' => 'Root Debugging',
    'cookie_session' => 'Session Cookie Name',
    'cookie_name' => 'Permanent Cookie Name',
    'cookie_password' => 'Password Cookie Name',
    'cookie_theme' => 'Theme Cookie Name',
    'cookie_language' => 'Language Cookie Name',
    'cookie_tzid' => 'Timezone Cookie Name',
    'cookie_anon_name' => 'Anon. Username Cookie Name',
    'cookie_ip' => 'Cookies embed IP?',
    'default_perm_cookie_timeout' => 'Permanent Timeout',
    'session_cookie_timeout' => 'Session Timeout',
    'cookie_path' => 'Cookie Path',
    'cookiedomain' => 'Cookie Domain',
    'cookiesecure' => 'Cookie Secure',
    'lastlogin' => 'Record Last Login?',
    'num_search_results' => 'Number of Search Results',
    'loginrequired' => 'Login Required?',
    'submitloginrequired' => 'Submit Login Required?',
    'commentsloginrequired' => 'Comment Login Required?',
    'statsloginrequired' => 'Stats Login Required?',
    'searchloginrequired' => 'Search Login Required?',
    'profileloginrequired' => 'Profile Login Required?',
    'emailuserloginrequired' => 'E-Mail User Login Required?',
    'emailstoryloginrequired' => 'E-Mail Story Login Required?',
    'directoryloginrequired' => 'Directory Login Required?',
    'storysubmission' => 'Story Submission Queue?',
    'usersubmission' => 'User Submission Queue?',
    'listdraftstories' => 'List Draft Stories?',
    'notification' => 'Notifications',
    'postmode' => 'Default Post Mode',
    'speedlimit' => 'Post Speed Limit',
    'skip_preview' => 'Skip Preview in Posts',
    'advanced_editor' => 'Advanced Editor?',
    'advanced_editor_name' => 'Advanced Editor Name?',
    'wikitext_editor' => 'Wikitext Editor?',
    'cron_schedule_interval' => 'Cron Schedule Interval',
    'sortmethod' => 'Sort Topics',
    'showstorycount' => 'Show Story Count?',
    'showsubmissioncount' => 'Show Submission Count?',
    'hide_home_link' => 'Hide Home Link?',
    'whosonline_threshold' => 'Session Threshold',
    'whosonline_anonymous' => 'Hide Names from Guests?',
    'whosonline_photo' => 'Display Thumbnail Photo?',
    'emailstories' => 'Daily Digest Enabled?',
    'emailstorieslength' => 'Length of Stories',
    'emailstoriesperdefault' => 'Enable for New Users?',
    'allow_domains' => 'Automatic Allow Domains',
    'disallow_domains' => 'Automatic Disallow Domains',
    'newstoriesinterval' => 'New Stories Interval',
    'newcommentsinterval' => 'New Comments Interval',
    'newtrackbackinterval' => 'New Trackbacks Interval',
    'hidenewstories' => 'Hide New Stories',
    'hidenewcomments' => 'Hide New Comments',
    'hidenewtrackbacks' => 'Hide New Trackbacks',
    'hidenewplugins' => 'Hide New Plugin Entries',
    'title_trim_length' => 'Title Trim Length',
    'whatsnew_cache_time' => 'Max Cache Time',
    'trackback_enabled' => 'Trackback Enabled?',
    'pingback_enabled' => 'Pingback Enabled?',
    'ping_enabled' => 'Ping Enabled?',
    'trackback_code' => 'Trackback Default',
    'multiple_trackbacks' => 'Multiple Trackbacks',
    'trackbackspeedlimit' => 'Trackback Speed Limit',
    'check_trackback_link' => 'Check Trackbacks',
    'pingback_self' => 'Pingback Self?',
    'pingback_excerpt' => 'Create Pingback Excerpt?',
    'link_documentation' => 'Link to Documentation?',
    'link_versionchecker' => 'Link to Version Checker?',
    'maximagesperarticle' => 'Max Images per Article',
    'limitnews' => 'Stories per Page',
    'minnews' => 'Min. Stories per Page',
    'contributedbyline' => 'Show "Contributed By"?"',
    'hideviewscount' => 'Hide Views Count?',
    'hideemailicon' => 'Hide E-Mail Icon?',
    'hideprintericon' => 'Hide Print Icon?',
    'allow_page_breaks' => 'Allow Page Breaks?',
    'page_break_comments' => 'Comments on Multi-Page Articles',
    'article_image_align' => 'Topic Icon Alignment',
    'show_topic_icon' => 'Show Topic Icon?',
    'draft_flag' => 'Draft Flag Default',
    'frontpage' => 'Frontpage Default',
    'hide_no_news_msg' => 'Hide "No News" Message?',
    'hide_main_page_navigation' => 'Hide Main Page Navigation?',
    'onlyrootfeatures' => 'Only Root can Feature?',
    'aftersave_story' => 'After Saving Story',
    'related_topics' => 'Related Topics',
    'related_topics_max' => 'Max Related Topics to Display',
    'whats_related' => 'What\'s Related',
    'whats_related_max' => 'Max What\'s Related to Display',
    'whats_related_trim' => 'What\'s Related Title Length',
    'default_cache_time_article' => 'Default Article Cache Time',
    'aftersave_user' => 'After Saving User',
    'show_right_blocks' => 'Always Show Right Blocks?',
    'showfirstasfeatured' => 'Show First Story as Featured?',
    'template_comments' => 'Template Comments in Output?',
    'backend' => 'Enable Feeds?',
    'rdf_file' => 'Syndication Output Folder',
    'rdf_limit' => 'Feed Limit',
    'rdf_storytext' => 'Length of Stories in Feed',
    'rdf_language' => 'Feed Language',
    'syndication_max_headlines' => 'Max. Number of Headlines (portal blocks)',
    'comment_feeds_article_tag' => 'Article Tag',
    'comment_feeds_article_tag_position' => 'Article Tag Position',
    'comment_feeds_article_author_tag' => 'Article Author Tag',
    'comment_feeds_comment_author_tag' => 'Comment Author Tag',
    'copyrightyear' => 'Copyright Year',
    'image_lib' => 'Image Library',
    'path_to_mogrify' => 'Path to Mogrify',
    'path_to_netpbm' => 'Path to Netpbm',
    'debug_image_upload' => 'Debug Image Uploading?',
    'keep_unscaled_image' => 'Keep Unscaled Image?',
    'allow_user_scaling' => 'Allow User Scaling?',
    'jpeg_quality' => 'JPEG Quality?',
    'max_image_width' => 'Max Image Width?',
    'max_image_height' => 'Max Image Height?',
    'max_image_size' => 'Max Image Size?',
    'max_topicicon_width' => 'Max Topic Icon Width?',
    'max_topicicon_height' => 'Max Topic Icon Height?',
    'max_topicicon_size' => 'Max Topic Icon Size?',
    'max_photo_width' => 'Max Photo Width?',
    'max_photo_height' => 'Max Photo Height?',
    'max_photo_size' => 'Max Photo Size?',
    'use_gravatar' => 'Use Gravatar?',
    'gravatar_rating' => 'Gravatar Rating',
    'force_photo_width' => 'Force Photo Width',
    'default_photo' => 'Default Photo',
    'commentspeedlimit' => 'Comment Speed Limit',
    'comment_limit' => 'Comment Limit',
    'comment_mode' => 'Comment Mode',
    'comment_order' => 'Comment Order',
    'comment_code' => 'Comment Default',
    'comment_edit' => 'Allow Comment Edit?',
    'comment_edittime' => 'Comment Edit Time (seconds)',
    'commentsubmission' => 'Queue Comment Submissions',
    'passwordspeedlimit' => 'Password Speed Limit',
    'login_attempts' => 'Max. Login Attempts',
    'login_speedlimit' => 'Login Speed Limit',
    'pass_alg' => 'Password Hash Algorithm',
    'pass_stretch' => 'Hash Stretch Count',
    'user_html' => 'User HTML',
    'admin_html' => 'Admin HTML',
    'advanced_html' => 'Additional HTML for Adv. Editor',
    'skip_html_filter_for_root' => 'Skip HTML Filter for Root?',
    'allowed_protocols' => 'Allowed Protocols',
    'disable_autolinks' => 'Disable Autotags?',
    'clickable_links' => 'Make URLs clickable?',
    'linktext_maxlen' => 'Max Link Text Length',
    'compressed_output' => 'Send compressed output?',
    'frame_options' => 'Protection against "clickjacking"',
    'page_navigation_max_pages' => 'Max Pages for Navigation',
    'default_cache_time_block' => 'Default Block Cache Time',
    'titletoid' => 'Enable Title To Id?',
    'censormode' => 'Censor Mode?',
    'censorreplace' => 'Censor Replace Text',
    'censorlist' => 'Censor List',
    'ip_lookup' => 'IP Lookup',
    'url_rewrite' => 'Enable URL Rewrite',
    'cdn_hosted' => 'Use CDN-hosted copy of jQuery',
    'meta_tags' => 'Meta Tags',
    'meta_description' => 'Default Meta Description',
    'meta_keywords' => 'Default Meta Keywords',
    'default_permissions_block' => 'Block Default Permissions',
    'default_permissions_story' => 'Story Default Permissions',
    'default_permissions_topic' => 'Topic Default Permissions',
    'atom_max_stories' => 'Max. Stories in Webservices Feed',
    'disable_webservices' => 'Disable Webservices?',
    'restrict_webservices' => 'Restrict Webservices?',
    'article_comment_close_enabled' => 'Automatically close comments (default)',
    'article_comment_close_days' => 'Days to close comments (default)',
    'comment_close_rec_stories' => 'Number of most recent stories enabled for comments',
    'allow_reply_notifications' => 'Allow comment reply notifications?',
    'comment_on_same_page' => 'Comment on Same Page?',
    'show_comments_at_replying' => 'Show Comments at Replying?',
    'search_style' => 'Results List Style',
    'search_limits' => 'Page Limits',
    'search_show_num' => 'Show Result Number?',
    'search_show_type' => 'Show Result Type?',
    'search_show_sort' => 'Allow User to Sort Results?',
    'search_show_limit' => 'Show Page Limits?',
    'search_separator' => 'Group Separator',
    'search_def_keytype' => 'Default Search Method',
    'search_def_sort' => 'Default Sort Order',
    'autotag_permissions_story' => '[story: ] Permissions',
    'autotag_permissions_user' => '[user: ] Permissions',
    'autotag_permissions_topic' => '[topic: ] Permissions',
    'autotag_permissions_related_topics' => '[related_topics: ] Permissions',
    'autotag_permissions_related_items' => '[related_items: ] Permissions',
    'multiple_breadcrumbs' => 'Multiple Breadcrumbs',
    'disable_breadcrumbs_topics' => 'Disable Topic Breadcrumbs',
    'disable_breadcrumbs_articles' => 'Disable Article Breadcrumbs',
    'disable_breadcrumbs_plugins' => 'Disable Plugins Breadcrumbs',
    'breadcrumb_root_site_name' => 'Site Name as Breadcrumb Root?',
    'filemanager_disabled' => 'Disable Filemanager?',
    'filemanager_browse_only' => 'Browse only mode?',
    'filemanager_default_view_mode' => 'Default view mode',
    'filemanager_show_confirmation' => 'Show confirmation?',
    'filemanager_search_box' => 'Show search box?',
    'filemanager_file_sorting' => 'File sorting',
    'filemanager_chars_only_latin' => 'Allow only latin chars?',
    'filemanager_date_format' => 'Date time format',
    'filemanager_logger' => 'Enable logger?',
    'filemanager_show_thumbs' => 'Show thumbnails?',
    'filemanager_generate_thumbnails' => 'Generate thumbnails?',
    'filemanager_upload_restrictions' => 'Allowed file extensions',
    'filemanager_upload_overwrite' => 'Overwrite existing file?',
    'filemanager_upload_images_only' => 'Upload images only?',
    'filemanager_upload_file_size_limit' => 'Upload file size limit (MiB)',
    'filemanager_unallowed_files' => 'Unallowed files',
    'filemanager_unallowed_dirs' => 'Unallowed directories',
    'filemanager_unallowed_files_regexp' => 'Regular expression for unallowed files',
    'filemanager_unallowed_dirs_regexp' => 'Regular expression for unallowed directories',
    'filemanager_images_ext' => 'Image file extensions',
    'filemanager_show_video_player' => 'Show video player?',
    'filemanager_videos_ext' => 'Video file extensions',
    'filemanager_videos_player_width' => 'Video player width (px)',
    'filemanager_videos_player_height' => 'Video player height (px)',
    'filemanager_show_audio_player' => 'Show audio player?',
    'filemanager_audios_ext' => 'Audio file extensions'
);

$LANG_configsubgroups['Core'] = array(
    'sg_site' => 'Site',
    'sg_stories' => 'Stories and Trackback',
    'sg_theme' => 'Theme',
    'sg_blocks' => 'Blocks',
    'sg_users' => 'Users and Submissions',
    'sg_images' => 'Images',
    'sg_locale' => 'Languages and Locale',
    'sg_misc' => 'Miscellaneous',
    'sg_filemanager' => 'Filemanager'
);

$LANG_fs['Core'] = array(
    'fs_site' => 'Site',
    'fs_paths' => 'Paths',
    'fs_theme' => 'Theme',
    'fs_mail' => 'Mail',
    'fs_pear' => 'Pear',
    'fs_mysql' => 'MySQL',
    'fs_users' => 'Users',
    'fs_misc' => 'Miscellaneous',
    'fs_spamx' => 'Spam-X',
    'fs_admin_block' => 'Admin Block',
    'fs_locale' => 'Locale',
    'fs_language' => 'Language',
    'fs_multilanguage' => 'Multi-Language Content',
    'fs_debug' => 'Debug',
    'fs_cookies' => 'Cookies',
    'fs_login' => 'Login Settings',
    'fs_search' => 'Search',
    'fs_user_submission' => 'User Submission',
    'fs_submission' => 'Submission Settings',
    'fs_topics_block' => 'Topics Block',
    'fs_whosonline_block' => 'Who\'s Online Block',
    'fs_daily_digest' => 'Daily Digest',
    'fs_whatsnew_block' => 'What\'s New Block',
    'fs_trackback' => 'Trackback',
    'fs_pingback' => 'Pingback',
    'fs_story' => 'Story',
    'fs_theme_advanced' => 'Advanced Settings',
    'fs_syndication' => 'Syndication',
    'fs_syndication_comment' => 'Comment Syndication',
    'fs_imagelib' => 'Image Library',
    'fs_upload' => 'Upload',
    'fs_articleimg' => 'Images in Articles',
    'fs_topicicon' => 'Topic Icons',
    'fs_userphoto' => 'Photos',
    'fs_gravatar' => 'Gravatar',
    'fs_comments' => 'Comments',
    'fs_htmlfilter' => 'HTML Filtering',
    'fs_censoring' => 'Censoring',
    'fs_iplookup' => 'IP Lookup',
    'fs_perm_story' => 'Story Default Permission',
    'fs_perm_topic' => 'Topic Default Permission',
    'fs_perm_block' => 'Block Default Permission',
    'fs_webservices' => 'Webservices',
    'fs_autotag_permissions' => 'Autotag Usage Permissions',
    'fs_breadcrumbs' => 'Breadcrumbs',
    'fs_pass' => 'Password Settings',
    'fs_filemanager_general' => 'General Settings',
    'fs_filemanager_upload' => 'Upload',
    'fs_filemanager_images' => 'Images',
    'fs_filemanager_videos' => 'Videos',
    'fs_filemanager_audios' => 'Audios'
);

$LANG_tab['Core'] = array(
    'tab_site' => 'Site',
    'tab_paths' => 'Paths',
    'tab_theme' => 'Theme',
    'tab_mail' => 'Mail',
    'tab_pear' => 'Pear',
    'tab_mysql' => 'MySQL',
    'tab_users' => 'Users',
    'tab_misc' => 'Miscellaneous',
    'tab_spamx' => 'Spam-X',
    'tab_admin_block' => 'Admin Block',
    'tab_locale' => 'Locale',
    'tab_language' => 'Language',
    'tab_debug' => 'Debug',
    'tab_cookies' => 'Cookies',
    'tab_login' => 'Login Settings',
    'tab_search' => 'Search',
    'tab_user_submission' => 'User Submission',
    'tab_submission' => 'Submission Settings',
    'tab_topics_block' => 'Topics Block',
    'tab_whosonline_block' => 'Who\'s Online Block',
    'tab_daily_digest' => 'Daily Digest',
    'tab_whatsnew_block' => 'What\'s New Block',
    'tab_trackback' => 'Trackback',
    'tab_pingback' => 'Pingback',
    'tab_story' => 'Story',
    'tab_theme_advanced' => 'Advanced Settings',
    'tab_syndication' => 'Syndication',
    'tab_imagelib' => 'Image Library',
    'tab_upload' => 'Upload',
    'tab_articleimg' => 'Images in Articles',
    'tab_topicicon' => 'Topic Icons',
    'tab_userphoto' => 'Photos',
    'tab_gravatar' => 'Gravatar',
    'tab_comments' => 'Comments',
    'tab_htmlfilter' => 'HTML Filtering',
    'tab_censoring' => 'Censoring',
    'tab_iplookup' => 'IP Lookup',
    'tab_permissions' => 'Permissions',
    'tab_webservices' => 'Webservices',
    'tab_topics' => 'Topics',
    'tab_filemanager_general' => 'General Settings',
    'tab_filemanager_upload' => 'Upload',
    'tab_filemanager_images' => 'Images',
    'tab_filemanager_videos' => 'Videos',
    'tab_filemanager_audios' => 'Audios'
);

$LANG_configselects['Core'] = array(
    0 => array('True' => 1, 'False' => 0),
    1 => array('True' => true, 'False' => false),
    2 => array('Reject' => 0, 'Only Keep Latest' => 1, 'Allow Multiple Posts' => 2),
    3 => array('Trackback Enabled' => 0, 'Trackback Disabled' => -1),
    4 => array('Don\'t Check Anything' => 0, 'Check against Site URL' => 1, 'Check full URL' => 2, 'Check against Site URL and full URL' => 3, 'Check IP against Site IP' => 4, 'Check IP and Site URL' => 5, 'Check IP and Full URL' => 6, 'Check IP, Full URL, and Site URL' => 7),
    5 => array('Plain Old Text' => 'plaintext', 'HTML Formatted' => 'html', 'Wiki-style Format' => 'wikitext'),
    6 => array('12' => 12, '24' => 24),
    7 => array('Last Page' => 'last', 'First Page' => 'first', 'Every Page' => 'all'),
    8 => array('Right' => 'right', 'Left' => 'left'),
    9 => array('Forward to page' => 'item', 'Display List' => 'list', 'Display Home' => 'home', 'Display Admin' => 'admin'),
    10 => array('None' => '', 'Netpbm' => 'netpbm', 'ImageMagick' => 'imagemagick', 'gdLib' => 'gdlib'),
    11 => array('Flat' => 'flat', 'Nested' => 'nested', 'Threaded' => 'threaded', 'No Comments' => 'nocomment'),
    12 => array('No access' => 0, 'Read-Only' => 2, 'Read-Write' => 3),
    13 => array('Skip' => 0, 'Allow, with speedlimit' => 1, 'Allow, no speedlimit' => 2),
    14 => array('Sunday' => 'Sun', 'Monday' => 'Mon'),
    15 => array('By Number' => 'sortnum', 'Alphabetically' => 'alpha'),
    16 => array('No Login required' => 0, 'Advanced Search only' => 1, 'Simple + Advanced Search' => 2),
    17 => array('Comments Enabled' => 0, 'Comments Disabled' => -1),
    18 => array('Disabled' => 0, 'Enabled (Exact Match)' => 1, 'Enabled (Word Beginning)' => 2, 'Enabled (Word Fragment)' => 3),
    19 => array('Google' => 'google', 'Table' => 'table'),
    20 => array('Exact Phrase' => 'phrase', 'All of The Words' => 'all', 'Any of The Words' => 'any'),
    21 => array('HTML 4.01 Transitional' => 'html401transitional', 'HTML 4.01 Strict' => 'html401strict', 'XHTML 1.0 Transitional' => 'xhtml10transitional', 'XHTML 1.0 Strict' => 'xhtml10strict', 'HTML5' => 'html5', 'HTML5 with XHTML syntax' => 'xhtml5'),
    22 => array('Strict' => 'DENY', 'Same Origin' => 'SAMEORIGIN', '(disabled)' => ''),
    23 => array('Disabled' => 0, 'Enabled' => 1, 'Enabled (Default for Homepage only)' => 2),
    24 => array('Contribute' => 'contribute', 'Home' => 'home', 'Advanced Search' => 'search', 'Directory' => 'directory', 'Login' => 'login', 'My Account' => 'prefs', 'Plugin Entries' => 'plugins', 'Custom Entries' => 'custom', 'Site Statistics' => 'stats'),
    25 => array('New Stories' => 'story', 'New Comments' => 'comment', 'New Trackbacks' => 'trackback', 'New Pingbacks' => 'pingback', 'New Users' => 'user'),
    26 => array('G (General Audiences)' => 'G', 'PG (Parental Guidance)' => 'PG', 'R (Restricted)' => 'R', 'X (Explicit)' => 'X'),
    27 => array('Hits (asc)' => 'hits|asc', 'Hits (desc)' => 'hits|desc', 'Date (asc)' => 'date|asc', 'Date (desc)' => 'date|desc', 'Title (asc)' => 'title|asc', 'Title (desc)' => 'title|desc', 'Author (asc)' => 'uid|asc', 'Author (desc)' => 'uid|desc'),
    28 => array('No access' => 0, 'Use' => 2),
    29 => array('md5' => 0, 'sha1' => 1, 'sha256' => 2, 'sha512' => 3, 'blowfish' => 4),
    30 => array('Start' => 'start', 'End' => 'end', 'None' => 'none'),
    31 => array('Newest First' => 'DESC', 'Oldest First' => 'ASC'),
    32 => array('Disabled' => 0, 'Just Article Pages' => 1, 'Articles and Topics' => 2),
    33 => array('Disabled' => 0, 'Enabled' => 1, 'Enabled (No Links)' => 2, 'Enabled (No Outbound Links)' => 3),
    34 => array('grid' => 'grid', 'list' => 'list'),
    35 => array('default' => 'default', 'Name (asc)' => 'NAME_ASC', 'Name (desc)' => 'NAME_DESC', 'Type (asc)' => 'TYPE_ASC', 'Type (desc)' => 'TYPE_DESC', 'Modified (asc)' => 'MODIFIED_ASC', 'Modified (desc)' => 'MODIFIED_DESC')
);

###############################################################################
# Localization of validation error messages

$LANG_VALIDATION = array(
    'default' => 'This field contains an invalid value',
    'notEmpty' => 'This field cannot be empty',
    'alphaNumeric' => 'This field must be in alpha numeric',
    'between' => 'This field must be in specified range',
    'blank' => 'This field must be blank',
    'comparison' => 'This field does not match the comparison operation',
    'date' => 'This field must be in date format',
    'year' => 'This field must be in year format such as 2010',
    'yearOrRange' => 'This field must be in a year format such as 2010 or range like 2010 - 2012',
    'time' => 'This field must be in time format',
    'datetime' => 'This field must be in datetime format',
    'boolean' => 'This field must be in boolean',
    'decimal' => 'This field must be in decimal',
    'email' => 'This field must contains valid email address',
    'equalTo' => 'This field does not equal',
    'extension' => 'This field only accept allowable file extension',
    'ip' => 'This field must be in valid IP format',
    'minLength' => 'This field is too short',
    'maxLength' => 'This field is too long',
    'numeric' => 'This field must be a numeric',
    'phone' => 'This field must contains valid phone number',
    'range' => 'This field must be in specified range',
    'url' => 'This field must contains valid URL',
    'inList' => 'This field must contain specified list',
    'mail_settings_backend' => 'This field must be one of \'smtp\', \'sendmail\', or \'mail\'',
    'mail_settings_sendmail_path' => 'This field must contains valid path to sendmail binary',
    'mail_settings_host' => 'This field must contain valid hostname',
    'mail_settings_port' => 'This field must be between 0 - 65535',
    'rdf_limit' => 'This field must in numeric or hour such as 24h',
    'path' => 'Path does not exist',
    'file' => 'File does not exist',
    'search_limits' => 'This field must be numeric separated with a comma',
    'num_search_results' => 'This field must be numeric and from \'search_limits\' above',
    'theme' => 'Theme directory does not exist',
    'path_themes' => 'Theme path must be in absolute path and make sure the last character contains directory separator',
    'path_to_mogrify' => 'You must set image library to imagemagick and fill this field with complete path to the mogrify executable',
    'path_to_netpbm' => 'You must set image library to netpbm and fill this field with directory where the binaries from the Netpbm package are kept',
    'language' => 'Language file does not exist',
    'timezone' => 'Invalid timezone',
    'single_char' => 'This field must be a single character',
    'page_navigation_max_pages' => 'This field must be between 2 - 21',
    'hash' => 'This field must be a hash function supported by your version of PHP'
);


?>
