<?php

// +---------------------------------------------------------------------------+
// | Japanese Mail Plugin for Geeklog - The Ultimate Weblog                    |
// +---------------------------------------------------------------------------+
// | admin/index.php                                                           |
// +---------------------------------------------------------------------------+
// | Copyright (C) 2007 mystral-kk - geeklog AT mystral-k DOT net              |
// | Constructed with the Universal Plugin                                     |
// +---------------------------------------------------------------------------+
// |                                                                           |
// | This program is free software; you can redistribute it and/or             |
// | modify it under the terms of the GNU General Public License               |
// | as published by the Free Software Foundation; either version 2            |
// | of the License, or (at your option) any later version.                    |
// |                                                                           |
// | This program is distributed in the hope that it will be useful,           |
// | but WITHOUT ANY WARRANTY; without even the implied warranty of            |
// | MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the             |
// | GNU General Public License for more details.                              |
// |                                                                           |
// | You should have received a copy of the GNU General Public License         |
// | along with this program; if not, write to the Free Software Foundation,   |
// | Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.           |
// |                                                                           |
// +---------------------------------------------------------------------------+
//

require_once '../../../lib-common.php';
require_once $_CONF['path_system'] . 'lib-admin.php';

// Only let admin users access this page
if ( !SEC_hasRights( 'jpmail.admin' ) ) {
    // Someone is trying to illegally access this page
    COM_errorLog( "Someone has tried to illegally access the jpmail Admin page.  User id: {$_USER['uid']}, Username: {$_USER['username']}, IP: {$_SERVER['REMOTE_ADDR']}", 1 );
    $display  = COM_siteHeader();
    $display .= COM_startBlock( $LANG_JPML['access_denied'] );
    $display .= $LANG_JPML['access_denied_msg'];
    $display .= COM_endBlock();
    $display .= COM_siteFooter( true );
    echo $display;
    exit;
}

//=========================================================
//  Functions
//=========================================================

function JPML_fieldfunction( $fieldname, $fieldvalue, $data, $icon_arr ) {
	global $_CONF, $LANG_JPML;
	
	if ( $fieldname == 'id' ) {
		$id = $fieldvalue;
		$base_url = $_CONF['site_admin_url'] . '/plugins/jpmail';
		$edit = "<a href=\"{$base_url}/edit.php?id={$id}\">{$icon_arr['edit']}</a>";
		$up   = "<a href=\"{$base_url}/index.php?id={$id}&amp;dir=up\">"
			. "<img src=\"{$base_url}/images/up.gif\" alt=\"{$LANG_JPML['help_up']}\"  title=\"{$LANG_JPML['help_up']}\">" . '</a>';
		$down = "<a href=\"{$base_url}/index.php?id={$id}&amp;dir=down\">"
			. "<img src=\"{$base_url}/images/down.gif\" alt=\"{$LANG_JPML['help_down']}\" title=\"{$LANG_JPML['help_down']}\">" . '</a>';
		$fieldvalue = $edit . ' ' . $up . ' ' . $down;
	} else if ( $fieldname == 'header_encoding' || $fieldname == 'body_encoding' ) {
		switch ( $fieldvalue ) {
			case 'B':
				$fieldvalue = 'Base64';
				break;
			case 'Q':
				$fieldvalue = 'QP';
				break;
			case '':
				$fieldvalue = $LANG_JPML['no_encoding'];
				break;
		}
	}
	
	return $fieldvalue;
}

// Changes order if necessary

function JPML_changeOrder( $id, $dir ) {
	global $_TABLES;
	
	if ( $dir == 'up' ) {
		$sql = "SELECT id FROM {$_TABLES['jpml_rules']} WHERE (id < '{$id}') ORDER BY id DESC LIMIT 1";
	} else {
		$sql = "SELECT id FROM {$_TABLES['jpml_rules']} WHERE (id > '{$id}') ORDER BY id ASC LIMIT 1";
	}
	$result = DB_query( $sql );
	if ( !DB_error() && ( DB_numRows( $result ) == 1 ) ) {
		$data = DB_fetchArray( $result );
		$new_id = $data['id'];
		$sql = "SELECT MAX(id) AS temp_id FROM {$_TABLES['jpml_rules']}";
		$result = DB_query( $sql );
		$A = DB_fetchArray( $result );
		$temp_id = $A['temp_id'] + 1000;
		$sql = "UPDATE {$_TABLES['jpml_rules']} SET id = {$temp_id} WHERE (id = '{$id}')";
		$result = DB_query( $sql );
		$sql = "UPDATE {$_TABLES['jpml_rules']} SET id = {$id} WHERE (id = '{$new_id}')";
		$result = DB_query( $sql );
		$sql = "UPDATE {$_TABLES['jpml_rules']} SET id = {$new_id} WHERE (id = '{$temp_id}')";
		$result = DB_query( $sql );
	}
}

//=========================================================
//  Main
//=========================================================

if ( get_magic_quotes_gpc() ) {
	$_GET    = array_map( 'stripslashes', $_GET );
	$_POST   = array_map( 'stripslashes', $_POST );
	$_COOKIE = array_map( 'stripslashes', $_COOKIE );
}

if ( isset( $_GET['msg' ] ) ) {
	$msg = COM_applyFilter( $_GET['msg'], true );
	if ( $msg < 1 || $msg > 6 ) {
		unset( $msg );
	}
}

// Changes orders

if ( isset( $_GET['id'] ) && isset( $_GET['dir'] ) ) {
	$id  = COM_applyFilter( $_GET['id'], true );
	$dir = COM_applyFilter( $_GET['dir'] );
	JPML_changeOrder( $id, $dir );
}

// Prepares params for ADMIN_simpleList()

$fieldfunction = 'JPML_fieldfunction';
$header_arr = array (
	array (
		'field' => 'id',
		'text'  => $LANG_JPML['hdr_edit'],
	),
	array (
		'field' => 'rule',
		'text'  => $LANG_JPML['hdr_rule'],
	),
	array (
		'field' => 'header_charset',
		'text'  => $LANG_JPML['hdr_header_charset'],
	),
	array (
		'field' => 'header_encoding',
		'text'  => $LANG_JPML['hdr_header_encoding'],
	),
	array (
		'field' => 'body_charset',
		'text'  => $LANG_JPML['hdr_body_charset'],
	),
	array (
		'field' => 'body_encoding',
		'text'  => $LANG_JPML['hdr_body_encoding'],
	),
);

$lang_instructions = sprintf(
	$LANG_JPML['instructions'],
	$_JPML_CONF['default_rule']['header_charset'],
	$_JPML_CONF['default_rule']['header_encoding'] == '' ? $LANG_JPML['no_encoding'] : $_JPML_CONF['default_rule']['header_encoding'],
	$_JPML_CONF['default_rule']['body_charset'],
	$_JPML_CONF['default_rule']['body_encoding'] == '' ? $LANG_JPML['no_encoding'] : $_JPML_CONF['default_rule']['body_encoding']
);

$text_arr   = array (
	'title'        => $LANG_JPML['title'],
//	'icon'         => $_CONF['site_admin_url'] . '/plugins/jpmail/images/jpmail.gif',
	'no_data'      => $LANG_JPML['no_data'],
	'has_menu'     => true,
	'instructions' => $lang_instructions,
	'form_url'     => $_CONF['site_admin_url'] . '/plugins/jpmail/index.php',
);
if ( isset( $msg ) ) {
	$text_arr['instructions'] = '<b>' . $LANG_JPML["msg{$msg}"] . '</b>' . $text_arr['instructions'];
}

$data_arr = array ();
$sql = "SELECT * FROM {$_TABLES['jpml_rules']} ORDER BY id";
$result = DB_query( $sql );

while ( ( $A = DB_fetchArray( $result ) ) !== false ) {
	$data_arr[] = $A;
}

$menu_arr = array (
	array (
		'url' => $_CONF['site_admin_url'] . '/plugins/jpmail/edit.php',
		'text' => $LANG_ADMIN['create_new'],
	),
	array (
		'url' => $_CONF['site_admin_url'],
		'text' => $LANG_ADMIN['admin_home'],
	)
);
$options = array ();

// Populates the template for display

$display = COM_siteHeader();
$T = new Template( $_CONF['path'] . 'plugins/jpmail/templates' );
$T->set_file( 'admin', 'admin.thtml' );
$T->set_var( 'site_admin_url', $_CONF['site_admin_url'] );
$T->set_var( 'lang_rule_desc', $LANG_JPML['rule_desc'] );
$T->set_var( 'lang_err_no_data', $err_str );
$T->set_var( 'lang_title', $title );
$T->set_var( 'lang_header_rule', $LANG_JPML['header_rule'] );
$T->set_var( 'lang_header_charset', $LANG_JPML['header_charset'] );

$rule_list = ADMIN_simpleList( $fieldfunction, $header_arr, $text_arr, $data_arr, $menu_arr, $options );
$T->set_var( 'rule_list', $rule_list );
$T->parse('output','admin');
$display .= $T->finish($T->get_var('output'));

$display .= COM_siteFooter( true );

echo $display;

?>