/*
 * Decompiled with CFR 0.152.
 */
package dareka;

import dareka.Server;
import dareka.common.CloseUtil;
import dareka.common.Config;
import dareka.common.Logger;
import dareka.dht.DHTManager;
import dareka.processor.impl.Cache;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.Arrays;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.lang.RandomStringUtils;
import ow.routing.RoutingException;

public class Main {
    public static final String VER_STRING = "Genkidama 0.03";
    private static Server server;

    public static String getVersion() {
        return VER_STRING;
    }

    public static void stop() throws RoutingException {
        Logger.warning("Shutting down");
        if (server != null) {
            server.stop();
        }
        if (DHTManager.getInstance().isConnected()) {
            DHTManager.getInstance().disconnect();
        }
    }

    public static void main(String[] args) {
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                try {
                    Main.stop();
                }
                catch (RoutingException e) {
                    e.printStackTrace();
                }
            }
        });
        try {
            Main.mainBody();
        }
        catch (Exception e) {
            Logger.debug(e);
        }
    }

    private static void mainBody() throws Exception {
        File defFile;
        File configFile = new File("config.ini");
        if (!configFile.exists()) {
            configFile = new File("config.properties");
        }
        if (!configFile.exists() && (defFile = new File("config.properties.default")).exists()) {
            defFile.renameTo(configFile);
        }
        Config config = Main.configure(configFile);
        Logger.info(VER_STRING);
        Logger.info("port=" + Integer.getInteger("listenPort"));
        if (System.getProperty("proxyHost").equals("")) {
            Logger.info("direct mode (no secondary proxy)");
        } else {
            Logger.info("proxy host=" + System.getProperty("proxyHost"));
            Logger.info("proxy port=" + Integer.getInteger("proxyPort"));
        }
        Logger.info("title=" + Boolean.getBoolean("title"));
        if (Boolean.getBoolean("resumeDownload")) {
            Logger.info("Resume suspended download On");
        }
        if (Boolean.getBoolean("touchCache")) {
            Logger.info("Touch Cache File On");
        }
        if (Boolean.getBoolean("dareka.debug")) {
            Logger.info("debug mode");
        }
        DHTManager.getInstance().connect();
        Cache.init();
        Logger.info("total cache size=%,dbytes\n", Cache.size());
        server = new Server(config);
        server.start();
    }

    private static Config configure(File configFile) throws IOException {
        Properties p = new Properties();
        Main.setDefaults(p);
        Config config = new Config();
        if (configFile.exists()) {
            Main.loadFrom(configFile, p);
            String v = p.getProperty("listenPort");
            if (v != null) {
                config.setListenPort(Integer.parseInt(v));
            }
            if ((v = p.getProperty("proxyHost")) != null) {
                config.setProxyHost(v);
            }
            if ((v = p.getProperty("proxyPort")) != null) {
                config.setProxyPort(Integer.parseInt(v));
            }
            if ((v = p.getProperty("title")) != null) {
                config.setTitle(Boolean.parseBoolean(v));
            }
        } else {
            p.setProperty("dhtSecret", RandomStringUtils.randomAlphanumeric(40));
            FileOutputStream out = new FileOutputStream(configFile);
            try {
                p.store(out, "NicoCache config file");
            }
            finally {
                CloseUtil.close(out);
            }
        }
        for (Map.Entry<Object, Object> entry : p.entrySet()) {
            String key = (String)entry.getKey();
            String value = (String)entry.getValue();
            System.setProperty(key, value.trim());
        }
        return config;
    }

    private static void loadFrom(File configFile, Properties p) throws FileNotFoundException, IOException {
        FileInputStream in = new FileInputStream(configFile);
        try {
            p.load(in);
        }
        finally {
            CloseUtil.close(in);
        }
    }

    private static void setDefaults(Properties p) {
        try {
            Main.setDefaultsFromFiles(p);
            if (p.size() > 0) {
                return;
            }
        }
        catch (IOException e) {
            Logger.debug(e);
        }
        p.setProperty("listenPort", "8080");
        p.setProperty("proxyHost", "");
        p.setProperty("proxyPort", "8081");
        p.setProperty("title", "true");
        p.setProperty("touchCache", "true");
    }

    private static void setDefaultsFromFiles(Properties p) throws IOException {
        File defaultsDir = new File("defaults");
        Object[] files = defaultsDir.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.endsWith(".properties");
            }
        });
        if (files == null) {
            throw new IOException("failed to read: " + defaultsDir);
        }
        Arrays.sort(files);
        Object[] objectArray = files;
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            Object f = objectArray[n2];
            Main.loadFrom((File)f, p);
            ++n2;
        }
    }
}

