/*
 * Decompiled with CFR 0.152.
 */
package dareka.dht;

import dareka.common.Config;
import dareka.common.Logger;
import dareka.dht.DataServer;
import dareka.dht.LocalAddressLocator;
import dareka.dht.XmlRpcInvoker;
import dareka.processor.HttpResponseHeader;
import dareka.processor.URLResource;
import dareka.processor.impl.NicoApiUtil;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import net.sbbi.upnp.impls.InternetGatewayDevice;
import ow.dht.ByteArray;
import ow.dht.DHT;
import ow.dht.DHTConfiguration;
import ow.dht.DHTFactory;
import ow.dht.ValueInfo;
import ow.id.ID;
import ow.routing.RoutingException;

public class DHTManager {
    public static final short APPLICATION_ID = 2748;
    public static final short APPLICATION_VERSION = 3;
    private boolean connected;
    DHT<String> dht;
    private static DHTManager instance = new DHTManager();
    String externalAddress;
    ByteArray hashedSecret;
    private int ringPort;
    private int dataPort;
    private DataServer dataServer;
    private Map<ID, String> distributedMap = new HashMap<ID, String>();
    private InternetGatewayDevice igd;

    private DHTManager() {
    }

    public static DHTManager getInstance() {
        return instance;
    }

    public int getRingPort() {
        return this.ringPort;
    }

    public void connect() throws Exception {
        Object[] onlineUsers;
        this.ringPort = Config.getInteger("dhtRingPort", 9899);
        this.dataPort = Config.getInteger("dhtDataPort", 9900);
        assert (this.ringPort != this.dataPort);
        String secret = Config.getString("dhtSecret", null);
        assert (secret != null);
        this.hashedSecret = new ByteArray(secret.getBytes("UTF-8")).hashWithSHA1();
        if (Config.getBoolean("dhtUPnP", true)) {
            InternetGatewayDevice[] IGDs = InternetGatewayDevice.getDevices(5000);
            assert (IGDs != null);
            this.igd = IGDs[0];
            LocalAddressLocator locator = new LocalAddressLocator(this.igd, Config.getString("dhtNetmask", "255.255.255.0"));
            String internalAddress = locator.locate().getHostAddress();
            assert (this.igd.addPortMapping("Genkidama ringPort", null, this.ringPort, this.ringPort, internalAddress, 0, "TCP"));
            assert (this.igd.addPortMapping("Genkidama dataPort", null, this.dataPort, this.dataPort, internalAddress, 0, "TCP"));
            this.externalAddress = (String)XmlRpcInvoker.invoke("globalIp.probe", null);
        }
        DHTConfiguration config = DHTFactory.getDefaultConfiguration();
        config.setMessagingTransport("TCP");
        config.setRoutingAlgorithm("Kademlia");
        config.setRoutingStyle("Iterative");
        config.setDoUPnPNATTraversal(false);
        config.setSelfPort(this.ringPort);
        config.setSelfAddress(this.externalAddress);
        this.dht = DHTFactory.getDHT((short)2748, (short)3, config, null);
        Object[] objectArray = onlineUsers = (Object[])XmlRpcInvoker.invoke("onlineUsers.fetch", null);
        int n = onlineUsers.length;
        int n2 = 0;
        while (n2 < n) {
            Object u = objectArray[n2];
            HashMap user = (HashMap)u;
            String address = (String)user.get("address");
            Integer port = (Integer)user.get("port");
            if (!address.equals(this.externalAddress) || port != this.ringPort) {
                String url = String.valueOf(address) + ":" + port;
                System.out.println("DHT network joining to " + url);
                try {
                    this.dht.joinOverlay(url);
                    System.out.println("DHT network joined via " + url);
                    break;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            ++n2;
        }
        ArrayList<Integer> params = new ArrayList<Integer>();
        params.add(this.ringPort);
        params.add(3);
        XmlRpcInvoker.invoke("onlineUsers.register", params);
        this.dataServer = new DataServer();
        this.dataServer.bind(this.dataPort);
        this.connected = true;
    }

    public String getNicoCache(String id) throws RoutingException {
        if (!DHTManager.checkDeleted(id)) {
            ID key = ID.getSHA1BasedID(("nc:" + id).getBytes());
            Set<ValueInfo<String>> uriList = this.dht.get(key);
            for (ValueInfo<String> v : uriList) {
                String uri = v.getValue();
                try {
                    URL url = new URL(uri);
                    if (url.getHost().equals(this.externalAddress)) continue;
                    HttpURLConnection conn = (HttpURLConnection)url.openConnection();
                    conn.setRequestMethod("HEAD");
                    conn.setConnectTimeout(Config.getInteger("dhtTimeout", 1000));
                    conn.connect();
                    conn.disconnect();
                    Logger.info("DHT get: nc:" + id + " success");
                    return uri;
                }
                catch (Exception e) {
                    Logger.debug(e);
                }
            }
        }
        Logger.info("DHT get: nc:" + id + " failed");
        return null;
    }

    public void putNicoCache(String id) {
        if (!DHTManager.checkDeleted(id)) {
            ID key = ID.getSHA1BasedID(("nc:" + id).getBytes());
            Logger.info("DHT put: nc:" + id);
            String uri = "http://" + this.externalAddress + ":" + this.dataPort + "/nc/" + id;
            this.dht.setHashedSecretForPut(this.hashedSecret);
            this.distributedMap.put(key, uri);
            ArrayList<Object> params = new ArrayList<Object>();
            params.add(this.ringPort);
            params.add(3);
            params.add(key.toString());
            try {
                XmlRpcInvoker.invoke("onlineData.register", params);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static boolean checkDeleted(String id) {
        id = id.replaceAll("low$", "");
        String title = null;
        try {
            String url = NicoApiUtil.getThumbURL(id);
            URLResource r = new URLResource(url);
            r.setFollowRedirects(true);
            ByteArrayOutputStream bout = new ByteArrayOutputStream();
            r.transferTo(null, bout, null, null);
            ByteArrayInputStream bin = new ByteArrayInputStream(bout.toByteArray());
            new HttpResponseHeader(bin);
            title = NicoApiUtil.getThumbTitle(bin);
            bout.close();
            bin.close();
        }
        catch (Exception e) {
            Logger.error(e);
            e.printStackTrace();
        }
        if (title == null) {
            Logger.info("DHT cacheDeleted: " + id + " -> true");
            return true;
        }
        Logger.info("DHT cacheDeleted: " + id + " -> false");
        return false;
    }

    public void disconnect() throws RoutingException {
        for (Map.Entry<ID, String> entry : this.distributedMap.entrySet()) {
            Logger.info("DHT remove: " + entry.getValue());
            ArrayList<Object> params = new ArrayList<Object>();
            params.add(this.ringPort);
            params.add(3);
            params.add(entry.getKey().toString());
            try {
                XmlRpcInvoker.invoke("onlineData.unregister", params);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            this.dht.remove(entry.getKey(), this.hashedSecret);
        }
        ArrayList<Integer> params = new ArrayList<Integer>();
        params.add(this.ringPort);
        params.add(3);
        try {
            XmlRpcInvoker.invoke("onlineUsers.unregister", params);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.dht.stop();
        Logger.info("DHT network disconnected");
        this.connected = false;
    }

    public boolean isConnected() {
        return this.connected;
    }
}

