/*
 * Decompiled with CFR 0.152.
 */
package dareka.dht;

import dareka.dht.LocalAddressLocator;
import dareka.dht.XmlRpcInvoker;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.InputStreamReader;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Properties;
import net.sbbi.upnp.impls.InternetGatewayDevice;
import ow.dht.ByteArray;
import ow.dht.DHT;
import ow.dht.DHTConfiguration;
import ow.dht.DHTFactory;
import ow.id.ID;

public class DHTTest {
    private static final String STATS_URL = "http://genkidama.sourceforge.jp/cgi-bin/stats.rb";
    public static Properties properties = new Properties();
    public static DHT<String> dht = null;
    public static ByteArray hashedSecret;
    public static int ringPort;
    static InternetGatewayDevice igd;

    public static void main(String[] args) throws Exception {
        String line;
        properties.load(new FileInputStream("dhttest.properties"));
        ringPort = Integer.parseInt(properties.getProperty("ringPort"));
        if (properties.getProperty("upnp").equals("true")) {
            int discoveryTimeout = 5000;
            InternetGatewayDevice[] IGDs = InternetGatewayDevice.getDevices(discoveryTimeout);
            assert (IGDs != null);
            igd = IGDs[0];
            System.out.println("Found device " + igd.getIGDRootDevice().getModelName());
            LocalAddressLocator locator = new LocalAddressLocator(igd, InetAddress.getByName("255.255.0.0"));
            String localHostIP = locator.locate().getHostAddress();
            assert (igd.addPortMapping("Genkidama ringPort", null, ringPort, ringPort, localHostIP, 0, "TCP"));
            System.out.println("UPnP port " + ringPort + " mapped to " + localHostIP);
        }
        String secret = properties.getProperty("secret");
        hashedSecret = new ByteArray(secret.getBytes("UTF-8")).hashWithSHA1();
        String globalIp = (String)XmlRpcInvoker.invoke(STATS_URL, "globalIp.probe", null);
        DHTConfiguration config = DHTFactory.getDefaultConfiguration();
        config.setMessagingTransport("TCP");
        config.setRoutingAlgorithm("Kademlia");
        config.setRoutingStyle("Iterative");
        config.setDoUPnPNATTraversal(false);
        config.setSelfPort(ringPort);
        config.setSelfAddress(globalIp);
        dht = DHTFactory.getDHT((short)1, (short)1, config, null);
        Object[] onlineUsers = (Object[])XmlRpcInvoker.invoke(STATS_URL, "onlineUsers.fetch", new ArrayList());
        if (onlineUsers.length > 0) {
            boolean connected = false;
            Object[] objectArray = onlineUsers;
            int n = onlineUsers.length;
            int n2 = 0;
            while (n2 < n) {
                Object u = objectArray[n2];
                HashMap user = (HashMap)u;
                String address = (String)user.get("address");
                Integer port = (Integer)user.get("port");
                if (!address.equals(globalIp) || port != ringPort) {
                    String url = String.valueOf(address) + ":" + port;
                    System.out.println("DHT network joining to " + url);
                    try {
                        dht.joinOverlay(url);
                        System.out.println("DHT network joined via " + url);
                        connected = true;
                        break;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                ++n2;
            }
            assert (connected);
        }
        ArrayList<Object> params = new ArrayList<Object>();
        params.add(ringPort);
        params.add(3);
        params.add(0);
        XmlRpcInvoker.invoke(STATS_URL, "onlineUsers.register", params);
        ID key = ID.getSHA1BasedID("test1".getBytes());
        dht.setHashedSecretForPut(hashedSecret);
        dht.put(key, "value1");
        params = new ArrayList();
        params.add(ringPort);
        params.add(3);
        params.add("test1");
        XmlRpcInvoker.invoke(STATS_URL, "onlineData.register", params);
        params = new ArrayList();
        params.add(ringPort);
        params.add(3);
        params.add("test1");
        params.add("dht");
        params.add("http://hogehoge/cache");
        XmlRpcInvoker.invoke(STATS_URL, "nicoVideoAccessLog.append", params);
        key = ID.getSHA1BasedID("test2".getBytes());
        dht.setHashedSecretForPut(hashedSecret);
        dht.put(key, "value2");
        params = new ArrayList();
        params.add(ringPort);
        params.add(3);
        params.add("test2");
        XmlRpcInvoker.invoke(STATS_URL, "onlineData.register", params);
        params = new ArrayList();
        params.add(ringPort);
        params.add(3);
        params.add("test2");
        params.add("dht");
        params.add("http://hogehoge/cache");
        XmlRpcInvoker.invoke(STATS_URL, "nicoVideoAccessLog.append", params);
        key = ID.getSHA1BasedID("test3".getBytes());
        dht.setHashedSecretForPut(hashedSecret);
        dht.put(key, "value3");
        params = new ArrayList();
        params.add(ringPort);
        params.add(3);
        params.add("test3");
        XmlRpcInvoker.invoke(STATS_URL, "onlineData.register", params);
        params = new ArrayList();
        params.add(ringPort);
        params.add(3);
        params.add("test3");
        params.add("dht");
        params.add("http://hogehoge/cache");
        XmlRpcInvoker.invoke(STATS_URL, "nicoVideoAccessLog.append", params);
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                try {
                    System.out.println("shutdown hooked");
                    ID key = ID.getSHA1BasedID("test1".getBytes());
                    dht.remove(key, hashedSecret);
                    ArrayList<Object> params = new ArrayList<Object>();
                    params.add(ringPort);
                    params.add(3);
                    params.add("test1");
                    XmlRpcInvoker.invoke(DHTTest.STATS_URL, "onlineData.unregister", params);
                    key = ID.getSHA1BasedID("test2".getBytes());
                    dht.remove(key, hashedSecret);
                    params = new ArrayList();
                    params.add(ringPort);
                    params.add(3);
                    params.add("test2");
                    XmlRpcInvoker.invoke(DHTTest.STATS_URL, "onlineData.unregister", params);
                    key = ID.getSHA1BasedID("test3".getBytes());
                    dht.remove(key, hashedSecret);
                    params = new ArrayList();
                    params.add(ringPort);
                    params.add(3);
                    params.add("test3");
                    XmlRpcInvoker.invoke(DHTTest.STATS_URL, "onlineData.unregister", params);
                    params = new ArrayList();
                    params.add(ringPort);
                    params.add(3);
                    params.add(0);
                    XmlRpcInvoker.invoke(DHTTest.STATS_URL, "onlineUsers.unregister", params);
                    dht.stop();
                    if (properties.getProperty("upnp").equals("true")) {
                        if (!$assertionsDisabled && !igd.deletePortMapping(null, ringPort, "TCP")) {
                            throw new AssertionError();
                        }
                        System.err.println("UPnP port " + ringPort + " unmapped");
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
        BufferedReader stdin = new BufferedReader(new InputStreamReader(System.in));
        while (!(line = stdin.readLine()).equals("q")) {
        }
    }
}

