/*
 * Decompiled with CFR 0.152.
 */
package dareka.dht;

import com.sun.net.httpserver.HttpExchange;
import com.sun.net.httpserver.HttpHandler;
import com.sun.net.httpserver.HttpServer;
import dareka.common.CloseUtil;
import dareka.common.Logger;
import dareka.dht.DHTManager;
import dareka.processor.HttpUtil;
import dareka.processor.impl.Cache;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;

public class DataServer {
    public void bind(int port) throws IOException {
        HttpHandler handler = new HttpHandler(){

            @Override
            public void handle(HttpExchange he) throws IOException {
                String cacheid = he.getRequestURI().getPath().replaceFirst("^/nc/", "");
                Cache cache = new Cache(cacheid, null);
                Logger.info("cache requested: " + cacheid);
                if (cache.exists() && !DHTManager.checkDeleted(cache.getId())) {
                    Logger.info("publishing cache: " + cache.getCacheFileName());
                    he.getResponseHeaders().set("Content-Type", "video/flv");
                    he.sendResponseHeaders(200, cache.length());
                    OutputStream out = he.getResponseBody();
                    InputStream in = cache.getInputStream();
                    try {
                        HttpUtil.sendBody(out, in, cache.length());
                    }
                    finally {
                        CloseUtil.close(out);
                        CloseUtil.close(in);
                    }
                } else {
                    he.sendResponseHeaders(404, 0L);
                    he.getRequestBody().close();
                }
            }
        };
        HttpServer server = HttpServer.create(new InetSocketAddress(port), 0);
        server.createContext("/nc/", handler);
        server.start();
    }
}

