/*
 * Decompiled with CFR 0.152.
 */
package dareka.dht;

import dareka.dht.UnableToLocateLocalAddressException;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.Enumeration;
import net.sbbi.upnp.impls.InternetGatewayDevice;
import orca.cod.Util;

public class LocalAddressLocator {
    InternetGatewayDevice igd;
    private InetAddress netmask;

    public LocalAddressLocator(InternetGatewayDevice igd, InetAddress netmask) {
        this.igd = igd;
        this.netmask = netmask;
    }

    public LocalAddressLocator(InternetGatewayDevice igd, String netmask) throws UnknownHostException {
        this(igd, InetAddress.getByName(netmask));
    }

    public InetAddress locate() throws Exception {
        InetAddress addr = InetAddress.getLocalHost();
        if (this.isDefaultRouteAddr(addr, this.netmask)) {
            return addr;
        }
        Enumeration<NetworkInterface> netIfEnum = NetworkInterface.getNetworkInterfaces();
        while (netIfEnum.hasMoreElements()) {
            NetworkInterface netIf = netIfEnum.nextElement();
            Enumeration<InetAddress> ifAddrEnum = netIf.getInetAddresses();
            while (ifAddrEnum.hasMoreElements()) {
                InetAddress ifAddr = ifAddrEnum.nextElement();
                if (!this.isDefaultRouteAddr(ifAddr, this.netmask)) continue;
                return ifAddr;
            }
        }
        throw new UnableToLocateLocalAddressException();
    }

    private boolean isDefaultRouteAddr(InetAddress ifAddr, InetAddress mask) throws Exception {
        System.out.println("ifAddr:" + ifAddr + " mask:" + mask);
        URL url = this.igd.getIGDRootDevice().getPresentationURL();
        System.out.println("presentationURL:" + url);
        System.out.println("host:" + url.getHost());
        InetAddress routerAddr = InetAddress.getByName(url.getHost());
        return Util.sameSubnet(routerAddr, ifAddr, mask);
    }
}

