/*
 * Decompiled with CFR 0.152.
 */
package dareka.processor.impl;

import dareka.common.CloseUtil;
import dareka.common.Logger;
import dareka.dht.DHTManager;
import dareka.dht.XmlRpcInvoker;
import dareka.processor.HttpRequestHeader;
import dareka.processor.Processor;
import dareka.processor.Resource;
import dareka.processor.impl.Cache;
import dareka.processor.impl.NicoCachingListener;
import dareka.processor.impl.NicoCachingTitleRetriever;
import dareka.processor.impl.NicoIdInfoCache;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.concurrent.Executor;
import java.util.concurrent.FutureTask;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.xmlrpc.XmlRpcException;

public class NicoCachingProcessor
implements Processor {
    private static final String[] SUPPORTED_METHODS = new String[]{"GET"};
    private static final Pattern SM_FLV_PATTERN = Pattern.compile("^http://[^/]+(?:smilevideo|nicovideo)\\.jp/smile\\?(\\w)=([^.]+)\\.\\d+(low)?$");
    private Executor executor;

    public NicoCachingProcessor(Executor executor) {
        this.executor = executor;
    }

    @Override
    public String[] getSupportedMethods() {
        return SUPPORTED_METHODS;
    }

    @Override
    public Pattern getSupportedURLAsPattern() {
        return SM_FLV_PATTERN;
    }

    @Override
    public String getSupportedURLAsString() {
        return null;
    }

    @Override
    public Resource onRequest(HttpRequestHeader requestHeader) throws IOException {
        Resource r;
        Matcher m = SM_FLV_PATTERN.matcher(requestHeader.getURI());
        if (!m.find()) {
            return Resource.get(Resource.Type.URL, requestHeader.getURI());
        }
        MovieData data = new MovieData(m);
        if (data.getCache().exists()) {
            ArrayList<Object> params = new ArrayList<Object>();
            params.add(DHTManager.getInstance().getRingPort());
            params.add(3);
            params.add(data.getCache().getId());
            params.add("local");
            params.add("");
            try {
                XmlRpcInvoker.invoke("nicoVideoAccessLog.append", params);
            }
            catch (XmlRpcException e) {
                e.printStackTrace();
            }
            Logger.info("using cache: " + data.getCache().getCacheFileName());
            if (Boolean.getBoolean("touchCache")) {
                data.getCache().touch();
            }
            Resource r2 = Resource.get(Resource.Type.URL, data.getCache().getURLString());
            r2.setResponseHeader("Content-Type", "video/flv");
            return r2;
        }
        FutureTask<String> retrieveTitlteTask = null;
        if (Boolean.getBoolean("title") && (data.getIdInfo() == null || !data.getIdInfo().isTitleValid())) {
            retrieveTitlteTask = new FutureTask<String>(new NicoCachingTitleRetriever(data.getType(), data.getId()));
            this.executor.execute(retrieveTitlteTask);
        }
        Logger.info("no cache found: " + data.getCache().getCacheFileName());
        requestHeader.removeMessageHeader("Range");
        requestHeader.removeMessageHeader("If-Range");
        long tmpSize = data.getCache().tmpLength();
        BufferedInputStream cacheInput = null;
        boolean dupconnect = Cache.getDLFlag(data.getCache().getId());
        if (tmpSize != 0L && (dupconnect || Boolean.getBoolean("resumeDownload"))) {
            tmpSize = data.getCache().tmpLength();
            requestHeader.setMessageHeader("Range", "bytes=" + tmpSize + "-");
            cacheInput = new BufferedInputStream(data.getCache().getTmpInputStream());
        }
        try {
            Cache.setDLFlag(data.getCache().getId(), Integer.MAX_VALUE);
            String dhtUri = null;
            if (!data.getCache().getId().matches("low$")) {
                dhtUri = DHTManager.getInstance().getNicoCache(data.getCache().getId().replaceAll("low$", ""));
            }
            if (dhtUri == null) {
                dhtUri = DHTManager.getInstance().getNicoCache(data.getCache().getId());
            }
            if (dhtUri != null) {
                ArrayList<Object> params = new ArrayList<Object>();
                params.add(DHTManager.getInstance().getRingPort());
                params.add(3);
                params.add(data.getCache().getId());
                params.add("dht");
                params.add(dhtUri);
                try {
                    XmlRpcInvoker.invoke("nicoVideoAccessLog.append", params);
                }
                catch (XmlRpcException e) {
                    e.printStackTrace();
                }
                Logger.info("getting cache via dht: " + dhtUri);
                r = Resource.get(Resource.Type.URL, dhtUri);
            } else {
                ArrayList<Object> params = new ArrayList<Object>();
                params.add(DHTManager.getInstance().getRingPort());
                params.add(3);
                params.add(data.getCache().getId());
                params.add("nicovideo");
                params.add("");
                try {
                    XmlRpcInvoker.invoke("nicoVideoAccessLog.append", params);
                }
                catch (XmlRpcException e) {
                    e.printStackTrace();
                }
                r = Resource.get(Resource.Type.URL, requestHeader.getURI());
            }
            r.addTransferListener(new NicoCachingListener(data.getCache(), retrieveTitlteTask, cacheInput, dupconnect));
        }
        catch (RuntimeException e) {
            Logger.error(e);
            CloseUtil.close(cacheInput);
            Cache.setDLFlag(data.getCache().getId(), -1);
            throw e;
        }
        return r;
    }

    static class MovieData {
        private String format;
        private String id;
        private String suffix;
        private NicoIdInfoCache.Entry idInfo;
        private String postfix;
        private String type;
        private Cache cache;

        MovieData(Matcher m) {
            this.initializeFormatIdSuffix(m);
            this.initializeIdInfo(this.getId());
            this.initializePostfix(this.format);
            this.initializeTypeCache(this.getIdInfo(), this.format);
            this.useAlternateCacheIfNecessary();
        }

        private void initializeFormatIdSuffix(Matcher m) {
            this.format = m.group(1);
            this.id = m.group(2);
            this.suffix = m.group(3);
        }

        private void initializeIdInfo(String id) {
            this.idInfo = Boolean.getBoolean("title") ? NicoIdInfoCache.getInstance().get(id) : null;
        }

        private void initializePostfix(String format) {
            this.postfix = format.equals("v") ? ".flv" : (format.equals("m") ? ".mp4" : (format.equals("s") ? ".swf" : ".unknown"));
        }

        private void initializeTypeCache(NicoIdInfoCache.Entry idInfo, String format) {
            if (idInfo == null) {
                this.type = format.endsWith("s") ? "nm" : "sm";
                this.cache = new Cache(String.valueOf(this.type) + this.id, this.postfix);
            } else {
                this.type = idInfo.getType();
                this.cache = new Cache(String.valueOf(this.type) + this.id, this.postfix, idInfo.getTitle());
            }
        }

        private void useAlternateCacheIfNecessary() {
            if (!this.getCache().exists() && this.suffix != null) {
                this.cache = this.idInfo == null ? new Cache(String.valueOf(this.type) + this.id + this.suffix, this.postfix) : new Cache(String.valueOf(this.type) + this.id + this.suffix, this.postfix, this.idInfo.getTitle());
            }
        }

        public Cache getCache() {
            return this.cache;
        }

        public NicoIdInfoCache.Entry getIdInfo() {
            return this.idInfo;
        }

        public String getType() {
            return this.type;
        }

        public String getId() {
            return this.id;
        }
    }
}

