/*
 * Decompiled with CFR 0.152.
 */
package ow.dht;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import ow.dht.DHT;
import ow.dht.DHTConfiguration;
import ow.dht.impl.BasicDHTProvider;
import ow.dht.impl.CHTProvider;
import ow.dht.impl.ChurnTolerantDHTProvider;
import ow.dht.impl.DHTProvider;
import ow.dht.memcached.impl.MemcachedProvider;
import ow.id.ID;
import ow.messaging.Signature;
import ow.routing.RoutingService;

public class DHTFactory {
    private static final Logger logger = Logger.getLogger("dht");
    private static final Class[] PROVIDERS = new Class[]{ChurnTolerantDHTProvider.class, BasicDHTProvider.class, CHTProvider.class, MemcachedProvider.class};
    private static final Map<String, DHTProvider> providerTable = new HashMap<String, DHTProvider>();
    private static final Map<String, Integer> idTable = new HashMap<String, Integer>();

    static {
        int id = 1;
        Class[] classArray = PROVIDERS;
        int n = PROVIDERS.length;
        int n2 = 0;
        while (n2 < n) {
            block5: {
                Object o;
                Class clazz = classArray[n2];
                try {
                    o = clazz.newInstance();
                }
                catch (Exception e) {
                    logger.log(Level.WARNING, "Could not instantiate an object of the class: " + clazz, e);
                    break block5;
                }
                if (o instanceof DHTProvider) {
                    DHTProvider provider = (DHTProvider)o;
                    String[] stringArray = provider.getNames();
                    int n3 = stringArray.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        String dhtName = stringArray[n4];
                        providerTable.put(dhtName, provider);
                        idTable.put(dhtName, id);
                        ++n4;
                    }
                    ++id;
                }
            }
            ++n2;
        }
    }

    public static DHTConfiguration getDefaultConfiguration() {
        return new DHTConfiguration();
    }

    public static <V extends Serializable> DHT<V> getDHT(DHTConfiguration config) throws Exception {
        DHTProvider provider = providerTable.get(config.getImplementationName());
        return provider.getDHT(Signature.getAllAcceptingApplicationID(), Signature.getAllAcceptingApplicationVersion(), config, null);
    }

    public static <V extends Serializable> DHT<V> getDHT(DHTConfiguration config, ID selfID) throws Exception {
        DHTProvider provider = providerTable.get(config.getImplementationName());
        return provider.getDHT(Signature.getAllAcceptingApplicationID(), Signature.getAllAcceptingApplicationVersion(), config, selfID);
    }

    public static <V extends Serializable> DHT<V> getDHT(short applicationID, short applicationVersion, DHTConfiguration config) throws Exception {
        DHTProvider provider = providerTable.get(config.getImplementationName());
        return provider.getDHT(applicationID, applicationVersion, config, null);
    }

    public static <V extends Serializable> DHT<V> getDHT(short applicationID, short applicationVersion, DHTConfiguration config, ID selfID) throws Exception {
        DHTProvider provider = providerTable.get(config.getImplementationName());
        return provider.getDHT(applicationID, applicationVersion, config, selfID);
    }

    public static <V extends Serializable> DHT<V> getDHT(DHTConfiguration config, RoutingService routingSvc) throws Exception {
        DHTProvider provider = providerTable.get(config.getImplementationName());
        return provider.getDHT(config, routingSvc);
    }
}

