/*
 * Decompiled with CFR 0.152.
 */
package ow.dht;

import java.io.Serializable;
import ow.dht.ByteArray;
import ow.directory.expiration.Expirable;

public final class ValueInfo<V extends Serializable>
implements Expirable,
Serializable {
    private final V value;
    private final Attributes attr;

    public ValueInfo(V value, int ttl, ByteArray hashedSecret) {
        this.value = value;
        this.attr = new Attributes(ttl, hashedSecret);
    }

    public ValueInfo(V value, Attributes attr) {
        this.value = value;
        this.attr = attr;
    }

    public Attributes getAttributes() {
        return this.attr;
    }

    public V getValue() {
        return this.value;
    }

    @Override
    public int setTTL(int ttl) {
        int old = this.attr.ttl;
        this.attr.ttl = ttl;
        return old;
    }

    @Override
    public int getTTL() {
        return this.attr.ttl;
    }

    public ByteArray getHashedSecret() {
        return this.attr.hashedSecret;
    }

    public int hashCode() {
        int h = this.value.hashCode();
        if (this.attr.hashedSecret != null) {
            h ^= this.attr.hashedSecret.hashCode();
        }
        return h;
    }

    public boolean equals(Object o) {
        ValueInfo other;
        if (o == null) {
            return false;
        }
        try {
            other = (ValueInfo)o;
        }
        catch (ClassCastException e) {
            return false;
        }
        if (!this.value.equals(other.value)) {
            return false;
        }
        return !(this.attr.hashedSecret == null ? other.attr.hashedSecret != null : !this.attr.hashedSecret.equals(other.attr.hashedSecret));
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        sb.append(this.value);
        sb.append(",");
        sb.append((long)this.attr.ttl / 1000L);
        sb.append(",");
        sb.append(this.attr.hashedSecret);
        sb.append("}");
        return sb.toString();
    }

    public static final class Attributes
    implements Serializable {
        private int ttl;
        private ByteArray hashedSecret;

        public Attributes(int ttl, ByteArray hashedSecret) {
            this.ttl = ttl;
            this.hashedSecret = hashedSecret;
        }

        public int getTTL() {
            return this.ttl;
        }

        public ByteArray getHashedSecret() {
            return this.hashedSecret;
        }

        public int hashCode() {
            int ret = this.ttl ^ this.ttl >>> 32;
            if (this.hashedSecret != null) {
                ret ^= this.hashedSecret.hashCode();
            }
            return ret;
        }

        public boolean equals(Object o) {
            if (o == null) {
                return false;
            }
            Attributes other = null;
            try {
                other = (Attributes)o;
            }
            catch (ClassCastException e) {
                return false;
            }
            if (this.ttl != other.ttl) {
                return false;
            }
            return !(this.hashedSecret == null ? other.hashedSecret != null : !this.hashedSecret.equals(other.hashedSecret));
        }
    }
}

