/*
 * Decompiled with CFR 0.152.
 */
package ow.dht.impl;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.net.UnknownHostException;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import ow.dht.ByteArray;
import ow.dht.DHT;
import ow.dht.DHTConfiguration;
import ow.dht.ValueInfo;
import ow.dht.impl.DHTMessageFactory;
import ow.directory.DirectoryConfiguration;
import ow.directory.DirectoryFactory;
import ow.directory.DirectoryProvider;
import ow.directory.MultiValueAdapterForSingleValueDirectory;
import ow.directory.MultiValueDirectory;
import ow.directory.SingleValueDirectory;
import ow.id.ID;
import ow.id.IDAddressPair;
import ow.messaging.Message;
import ow.messaging.MessageHandler;
import ow.messaging.MessageReceiver;
import ow.messaging.MessageSender;
import ow.messaging.MessagingAddress;
import ow.messaging.MessagingConfiguration;
import ow.messaging.MessagingFactory;
import ow.messaging.MessagingProvider;
import ow.messaging.Signature;
import ow.messaging.Tag;
import ow.routing.CallbackOnRoute;
import ow.routing.CallbackResultFilter;
import ow.routing.RoutingAlgorithmConfiguration;
import ow.routing.RoutingAlgorithmFactory;
import ow.routing.RoutingAlgorithmProvider;
import ow.routing.RoutingException;
import ow.routing.RoutingResult;
import ow.routing.RoutingService;
import ow.routing.RoutingServiceFactory;
import ow.routing.RoutingServiceProvider;

public class BasicDHTImpl<V extends Serializable>
implements DHT<V> {
    static final Logger logger = Logger.getLogger("dht");
    private static final String GLOBAL_DB_NAME = "global";
    protected DHTConfiguration config;
    private RoutingAlgorithmConfiguration algoConfig;
    protected RoutingService routingSvc;
    protected MessageSender sender;
    protected boolean stopped = false;
    protected boolean suspended = false;
    protected MultiValueDirectory<ID, ValueInfo<V>> globalDir;
    protected ByteArray hashedSecretForPut;
    protected int ttlForPut;
    private ID[] lastKeys = null;
    private RoutingResult[] lastRoutingResults = null;

    public BasicDHTImpl(short applicationID, short applicationVersion, DHTConfiguration config, ID selfID) throws Exception {
        byte[] messageSignature = Signature.getSignature(RoutingServiceFactory.getRoutingStyleID(config.getRoutingStyle()), RoutingAlgorithmFactory.getAlgorithmID(config.getRoutingAlgorithm()), applicationID, applicationVersion);
        MessagingProvider msgProvider = MessagingFactory.getProvider(config.getMessagingTransport(), messageSignature);
        if (config.getSelfAddress() != null) {
            msgProvider.setSelfAddress(config.getSelfAddress());
        }
        MessagingConfiguration msgConfig = msgProvider.getDefaultConfiguration();
        msgConfig.setDoUPnPNATTraversal(config.getDoUPnPNATTraversal());
        MessageReceiver receiver = msgProvider.getReceiver(msgConfig, config.getSelfPort(), config.getSelfPortRange());
        config.setSelfPort(receiver.getPort());
        RoutingAlgorithmProvider algoProvider = RoutingAlgorithmFactory.getProvider(config.getRoutingAlgorithm());
        this.algoConfig = algoProvider.getDefaultConfiguration();
        RoutingServiceProvider svcProvider = RoutingServiceFactory.getProvider(config.getRoutingStyle());
        RoutingService routingSvc = svcProvider.getService(svcProvider.getDefaultConfiguration(), msgProvider, receiver, algoProvider, this.algoConfig, selfID);
        algoProvider.initializeAlgorithmInstance(this.algoConfig, routingSvc);
        this.init(config, routingSvc);
    }

    public BasicDHTImpl(DHTConfiguration config, RoutingService routingSvc) throws Exception {
        this.init(config, routingSvc);
    }

    protected void init(DHTConfiguration config, RoutingService routingSvc) throws Exception {
        this.config = config;
        this.routingSvc = routingSvc;
        this.sender = this.routingSvc.getMessageSender();
        this.hashedSecretForPut = null;
        this.ttlForPut = config.getDefaultTTL();
        File workingDirFile = new File(config.getWorkingDirectory());
        workingDirFile.mkdirs();
        DirectoryProvider dirProvider = DirectoryFactory.getProvider(config.getDirectoryType());
        DirectoryConfiguration dirConfig = DirectoryConfiguration.getDefaultConfiguration();
        if (config.getDoExpire()) {
            dirConfig.setExpirationTime(config.getDefaultTTL());
        } else {
            dirConfig.setExpirationTime(-1);
        }
        if (config.getMultipleValuesForASingleKey()) {
            this.globalDir = dirProvider.openMultiValueDirectory(ID.class, config.getValueClass(), config.getWorkingDirectory(), GLOBAL_DB_NAME, dirConfig);
        } else {
            SingleValueDirectory singleValueDir = dirProvider.openSingleValueDirectory(ID.class, config.getValueClass(), config.getWorkingDirectory(), GLOBAL_DB_NAME, dirConfig);
            this.globalDir = new MultiValueAdapterForSingleValueDirectory<ID, ValueInfo<V>>(singleValueDir);
        }
        this.prepareHandlers(this.routingSvc);
        this.prepareCallbacks(this.routingSvc);
    }

    @Override
    public MessagingAddress joinOverlay(String hostAndPort, int defaultPort) throws UnknownHostException, RoutingException {
        MessagingAddress addr = this.routingSvc.getMessagingProvider().getMessagingAddress(hostAndPort, defaultPort);
        this.joinOverlay(addr);
        return addr;
    }

    @Override
    public MessagingAddress joinOverlay(String hostAndPort) throws UnknownHostException, RoutingException {
        MessagingAddress addr = this.routingSvc.getMessagingProvider().getMessagingAddress(hostAndPort);
        this.joinOverlay(addr);
        return addr;
    }

    private void joinOverlay(MessagingAddress addr) throws RoutingException {
        logger.log(Level.INFO, "DHTImpl#joinOverlay: " + addr);
        IDAddressPair selfIDAddress = this.getSelfIDAddressPair();
        RoutingResult routingRes = this.routingSvc.join(addr);
        this.lastKeys = new ID[1];
        this.lastKeys[0] = selfIDAddress.getID();
        this.lastRoutingResults = new RoutingResult[1];
        this.lastRoutingResults[0] = routingRes.stripRoutingContext();
        int nodeCount = this.config.getNumNodesAskedToTransfer();
        IDAddressPair[] rootCands = routingRes.getRootCandidates();
        if (nodeCount > 0 && rootCands != null) {
            int i = 0;
            while (nodeCount > 0 && i < rootCands.length) {
                IDAddressPair transferringNode = rootCands[i++];
                if (this.getSelfIDAddressPair().equals(transferringNode)) continue;
                Message request = DHTMessageFactory.getReqTransferMessage(selfIDAddress);
                try {
                    this.sender.send(transferringNode.getAddress(), request);
                }
                catch (IOException e) {
                    logger.log(Level.WARNING, "failed to send: " + transferringNode.getAddress());
                }
                --nodeCount;
            }
        }
    }

    @Override
    public void clearRoutingTable() {
        this.routingSvc.leave();
        this.lastKeys = null;
        this.lastRoutingResults = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearDHTState() {
        MultiValueDirectory<ID, ValueInfo<V>> multiValueDirectory = this.globalDir;
        synchronized (multiValueDirectory) {
            this.globalDir.clear();
        }
    }

    @Override
    public Set<ValueInfo<V>> get(ID key) throws RoutingException {
        ID[] keys = new ID[]{key};
        Set[] results = new Set[keys.length];
        RoutingResult[] routingRes = this.getRemotely(keys, results);
        if (routingRes[0] == null) {
            throw new RoutingException();
        }
        return results[0];
    }

    @Override
    public Set<ValueInfo<V>>[] get(ID[] keys) {
        Set[] results = new Set[keys.length];
        RoutingResult[] routingRes = this.getRemotely(keys, results);
        return results;
    }

    protected RoutingResult[] getRemotely(ID[] keys, Set<ValueInfo<V>>[] results) {
        Serializable[][] args = new Serializable[keys.length][1];
        int i = 0;
        while (i < keys.length) {
            args[i][0] = keys[i];
            ++i;
        }
        Serializable[][] callbackResultContainer = new Serializable[keys.length][1];
        RoutingResult[] routingRes = this.routingSvc.invokeCallbacksOnRoute(keys, this.config.getNumTimesGets() + this.config.getNumSpareRootCandidates(), callbackResultContainer, null, -1, args);
        this.preserveRoute(keys, routingRes);
        int i2 = 0;
        while (i2 < keys.length) {
            if (routingRes[i2] != null) {
                if (callbackResultContainer[i2] != null) {
                    results[i2] = (Set)((Object)callbackResultContainer[i2][0]);
                }
                if (results[i2] == null) {
                    results[i2] = new HashSet<ValueInfo<V>>();
                }
            }
            ++i2;
        }
        return routingRes;
    }

    @Override
    public Set<ValueInfo<V>> put(ID key, V value) throws IOException {
        Serializable[] values = new Serializable[]{value};
        return this.put(key, (V)values);
    }

    @Override
    public Set<ValueInfo<V>> put(ID key, V[] values) throws IOException {
        DHT.PutRequest[] req = new DHT.PutRequest[]{new DHT.PutRequest<V>(key, values)};
        Set<ValueInfo<V>>[] ret = this.putOrRemoveRemotely(req, false, this.ttlForPut, this.hashedSecretForPut, true);
        if (req[0] == null) {
            throw new RoutingException();
        }
        return ret[0];
    }

    @Override
    public Set<ValueInfo<V>>[] put(DHT.PutRequest<V>[] requests) throws IOException {
        return this.putOrRemoveRemotely(requests, false, this.ttlForPut, this.hashedSecretForPut, true);
    }

    @Override
    public Set<ValueInfo<V>> remove(ID key, V[] values, ByteArray hashedSecret) throws RoutingException {
        return this.remove(key, (Serializable[])values, null, hashedSecret);
    }

    @Override
    public Set<ValueInfo<V>> remove(ID key, ID[] valueHash, ByteArray hashedSecret) throws RoutingException {
        return this.remove(key, null, valueHash, hashedSecret);
    }

    private Set<ValueInfo<V>> remove(ID key, V[] values, ID[] valueHash, ByteArray hashedSecret) throws RoutingException {
        DHT.RemoveRequest[] req = new DHT.RemoveRequest[]{values != null ? new DHT.RemoveRequest<V>(key, values) : new DHT.RemoveRequest(key, valueHash)};
        Set<ValueInfo<V>>[] ret = this.remove(req, hashedSecret);
        if (req[0] == null) {
            throw new RoutingException();
        }
        return ret[0];
    }

    @Override
    public Set<ValueInfo<V>> remove(ID key, ByteArray hashedSecret) throws RoutingException {
        DHT.RemoveRequest[] req = new DHT.RemoveRequest[]{new DHT.RemoveRequest(key)};
        Set<ValueInfo<V>>[] ret = this.remove(req, hashedSecret);
        if (req[0] == null) {
            throw new RoutingException();
        }
        return ret[0];
    }

    @Override
    public Set<ValueInfo<V>>[] remove(DHT.RemoveRequest<V>[] requests, ByteArray hashedSecret) {
        return this.putOrRemoveRemotely(requests, true, 0, hashedSecret, true);
    }

    private Set<ValueInfo<V>>[] putOrRemoveRemotely(DHT.PutRequest<V>[] requests, boolean doesRemove, int ttl, ByteArray hashedSecret, boolean toPreserveRoute) {
        return this.putOrRemoveRemotely(requests, doesRemove, ttl, hashedSecret, toPreserveRoute, 1, 1, false);
    }

    /*
     * Exception decompiling
     */
    protected Set<ValueInfo<V>>[] putOrRemoveRemotely(DHT.PutRequest<V>[] requests, boolean doesRemove, int ttl, ByteArray hashedSecret, boolean toPreserveRoute, int numReplica, int repeat, boolean excludeSelf) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [5[UNCONDITIONALDOLOOP]], but top level block is 12[UNCONDITIONALDOLOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private Message requestPutOrRemove(MessagingAddress target, Message request) throws IOException {
        Message reply = null;
        try {
            reply = this.sender.sendAndReceive(target, request);
            if (reply.getTag() == Tag.DHT_REPLY.getNumber()) {
                logger.log(Level.INFO, "put/remove succeeded on " + target);
            } else {
                reply = null;
            }
        }
        catch (IOException e) {
            logger.log(Level.WARNING, "Failed to send a put/remove message to " + target, e);
            throw e;
        }
        return reply;
    }

    private void preserveRoute(ID[] keys, RoutingResult[] routingRes) {
        this.lastKeys = keys;
        this.lastRoutingResults = routingRes;
    }

    @Override
    public ByteArray setHashedSecretForPut(ByteArray hashedSecret) {
        ByteArray old = this.hashedSecretForPut;
        this.hashedSecretForPut = hashedSecret;
        return old;
    }

    @Override
    public int setTTLForPut(int ttl) {
        int old = this.ttlForPut;
        this.ttlForPut = ttl;
        return old;
    }

    @Override
    public synchronized void stop() {
        logger.log(Level.INFO, "DHT#stop() called.");
        this.stopped = true;
        if (this.routingSvc != null) {
            this.routingSvc.stop();
            this.routingSvc = null;
        }
        if (this.globalDir != null) {
            this.globalDir.close();
            this.globalDir = null;
        }
    }

    @Override
    public synchronized void suspend() {
        this.suspended = true;
        this.routingSvc.suspend();
    }

    @Override
    public synchronized void resume() {
        this.suspended = false;
        this.routingSvc.resume();
    }

    @Override
    public Set<ID> getLocalKeys() {
        return null;
    }

    @Override
    public Set<ValueInfo<V>> getLocalValues(ID key) {
        return null;
    }

    @Override
    public Set<ID> getGlobalKeys() {
        return this.globalDir.keySet();
    }

    @Override
    public Set<ValueInfo<V>> getGlobalValues(ID key) {
        Set<ValueInfo<V>> ret = null;
        try {
            ret = this.globalDir.get(key);
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "An Exception thrown when retrieve from the globalDir.", e);
        }
        return ret;
    }

    @Override
    public RoutingService getRoutingService() {
        return this.routingSvc;
    }

    @Override
    public DHTConfiguration getConfiguration() {
        return this.config;
    }

    @Override
    public RoutingAlgorithmConfiguration getRoutingAlgorithmConfiguration() {
        return this.algoConfig;
    }

    @Override
    public IDAddressPair getSelfIDAddressPair() {
        return this.routingSvc.getSelfIDAddressPair();
    }

    @Override
    public void setStatCollectorAddress(String host, int port) throws UnknownHostException {
        MessagingAddress addr = this.routingSvc.getMessagingProvider().getMessagingAddress(host, port);
        this.routingSvc.setStatCollectorAddress(addr);
    }

    @Override
    public ID[] getLastKeys() {
        return this.lastKeys;
    }

    @Override
    public RoutingResult[] getLastRoutingResults() {
        return this.lastRoutingResults;
    }

    @Override
    public String getRoutingTableString(int verboseLevel) {
        return this.routingSvc.getRoutingAlgorithm().getRoutingTableString(verboseLevel);
    }

    protected void prepareHandlers(RoutingService routingSvc) {
        this.prepareHandlers0(routingSvc);
        MessageHandler handler = new PutMessageHandler();
        routingSvc.addMessageHandler(Tag.PUT.getNumber(), handler);
        handler = new RemoveMessageHandler();
        routingSvc.addMessageHandler(Tag.REMOVE.getNumber(), handler);
    }

    protected void prepareHandlers0(RoutingService routingSvc) {
        MessageHandler handler = new MessageHandler(){

            @Override
            public Message process(Message msg) {
                Serializable[] contents = msg.getContents();
                ID[] keys = (ID[])contents[0];
                Set[] valueSets = new Set[keys.length];
                int i = 0;
                while (i < keys.length) {
                    valueSets[i] = BasicDHTImpl.this.getValueLocally(keys[i], BasicDHTImpl.this.globalDir);
                    ++i;
                }
                return DHTMessageFactory.getDHTReplyMessage(BasicDHTImpl.this.getSelfIDAddressPair(), valueSets);
            }
        };
        routingSvc.addMessageHandler(Tag.GET.getNumber(), handler);
    }

    private void prepareCallbacks(RoutingService routingSvc) {
        routingSvc.addCallbackOnRoute(new CallbackOnRoute(){

            @Override
            public Serializable process(ID target, int tag, Serializable[] args, CallbackResultFilter filter, IDAddressPair lastHop, boolean onRootNode) {
                logger.log(Level.INFO, "A callback invoked: " + (ID)args[0]);
                ID key = (ID)args[0];
                return (Serializable)((Object)BasicDHTImpl.this.getValueLocally(key, BasicDHTImpl.this.globalDir));
            }
        });
    }

    protected Set<ValueInfo<V>> getValueLocally(ID key, MultiValueDirectory<ID, ValueInfo<V>> dir) {
        Set<ValueInfo<V>> returnedValues = null;
        try {
            returnedValues = dir.get(key);
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "An Exception thrown by Directory#get().", e);
            return null;
        }
        return returnedValues;
    }

    protected class PutMessageHandler
    implements MessageHandler {
        protected PutMessageHandler() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Message process(Message msg) {
            Serializable[] contents = msg.getContents();
            IDAddressPair selfIDAddress = BasicDHTImpl.this.getSelfIDAddressPair();
            DHT.PutRequest[] requests = (DHT.PutRequest[])contents[0];
            int ttl = (Integer)contents[1];
            ByteArray hashedSecret = (ByteArray)contents[2];
            logger.log(Level.INFO, "A PUT message received" + (requests[0] == null ? "(null)" : requests[0].getKey()));
            if (ttl > BasicDHTImpl.this.config.getMaximumTTL()) {
                ttl = BasicDHTImpl.this.config.getMaximumTTL();
            } else if (ttl <= 0) {
                ttl = 0;
            }
            Set[] ret = new Set[requests.length];
            try {
                ValueInfo.Attributes attr = new ValueInfo.Attributes(ttl, hashedSecret);
                int i = 0;
                while (i < requests.length) {
                    if (requests[i] != null) {
                        ret[i] = new HashSet();
                        Serializable[] serializableArray = (Serializable[])requests[i].getValues();
                        int n = serializableArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            Serializable v = serializableArray[n2];
                            if (v != null) {
                                ValueInfo<Serializable> old = null;
                                MultiValueDirectory multiValueDirectory = BasicDHTImpl.this.globalDir;
                                synchronized (multiValueDirectory) {
                                    old = BasicDHTImpl.this.globalDir.put(requests[i].getKey(), new ValueInfo<Serializable>(v, attr), ttl);
                                }
                                if (old != null) {
                                    ret[i].add(old);
                                }
                            }
                            ++n2;
                        }
                    }
                    ++i;
                }
            }
            catch (Exception e) {
                logger.log(Level.WARNING, "An Exception thrown by Directory#put().", e);
            }
            return DHTMessageFactory.getDHTReplyMessage(selfIDAddress, ret);
        }
    }

    protected class RemoveMessageHandler
    implements MessageHandler {
        protected RemoveMessageHandler() {
        }

        /*
         * Exception decompiling
         */
        @Override
        public Message process(Message msg) {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [3[MONITOR]], but top level block is 0[TRYBLOCK]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }
    }
}

