/*
 * Decompiled with CFR 0.152.
 */
package ow.dht.memcached;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public final class Item
implements Externalizable {
    private static MessageDigest md = null;
    private static final String mdAlgoName = "SHA1";
    private byte[] data;
    private long flag;
    private volatile int cachedHashCode;

    static {
        try {
            md = MessageDigest.getInstance(mdAlgoName);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            // empty catch block
        }
    }

    public Item(byte[] data, long flag) {
        this.data = data;
        this.flag = flag;
        this.init();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init() {
        byte[] hash;
        MessageDigest messageDigest = md;
        synchronized (messageDigest) {
            md.update(this.data);
            int i = 56;
            while (i >= 0) {
                md.update((byte)(this.flag >>> i));
                i -= 8;
            }
            hash = md.digest();
        }
        int hashCode = 0;
        int index = 24;
        int i = 0;
        while (i < hash.length) {
            hashCode ^= hash[i] << index;
            if ((index -= 8) < 0) {
                index = 24;
            }
            ++i;
        }
        this.cachedHashCode = hashCode;
    }

    public byte[] getData() {
        return this.data;
    }

    public long getFlag() {
        return this.flag;
    }

    public long getCasUnique() {
        long uniq = this.hashCode();
        if (uniq < 0L) {
            uniq += 0x100000000L;
        }
        return uniq;
    }

    public int hashCode() {
        return this.cachedHashCode;
    }

    public boolean equals(Object o) {
        byte[] d1;
        Item other;
        try {
            other = (Item)o;
        }
        catch (ClassCastException e) {
            return false;
        }
        if (this.hashCode() != other.hashCode()) {
            return false;
        }
        byte[] d0 = this.getData();
        if (d0.length != (d1 = other.getData()).length) {
            return false;
        }
        int i = 0;
        while (i < d0.length) {
            if (d0[i] != d1[i]) {
                return false;
            }
            ++i;
        }
        return this.getFlag() == other.getFlag();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        try {
            sb.append("{ data: ").append(new String(this.data, "UTF-8"));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        sb.append(", flag:").append(this.flag);
        sb.append(" }");
        return sb.toString();
    }

    public Item() {
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(this.data.length);
        out.write(this.data);
        out.writeLong(this.flag);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        int len = in.readInt();
        this.data = new byte[len];
        in.read(this.data);
        this.flag = in.readLong();
        this.init();
    }
}

