/*
 * Decompiled with CFR 0.152.
 */
package ow.dht.memcached.impl;

import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import ow.dht.ByteArray;
import ow.dht.DHTConfiguration;
import ow.dht.ValueInfo;
import ow.dht.impl.ChurnTolerantDHTImpl;
import ow.dht.memcached.Item;
import ow.dht.memcached.Memcached;
import ow.id.ID;
import ow.messaging.Message;
import ow.messaging.Tag;
import ow.routing.RoutingException;
import ow.routing.RoutingService;

public final class MemcachedImpl
extends ChurnTolerantDHTImpl<Item>
implements Memcached {
    private ByteArray hashedSecret;

    public MemcachedImpl(short applicationID, short applicationVersion, DHTConfiguration config, ID selfID) throws Exception {
        super(applicationID, applicationVersion, config, selfID);
        this.init();
    }

    public MemcachedImpl(DHTConfiguration config, RoutingService routingSvc) throws Exception {
        super(config, routingSvc);
        this.init();
    }

    private void init() {
        this.hashedSecret = new ByteArray(new byte[0]).hashWithSHA1();
        super.setHashedSecretForPut(this.hashedSecret);
    }

    @Override
    protected void prepareHandlers(RoutingService routingSvc) {
        super.prepareHandlers(routingSvc);
        PutOnConditionMessageHandler handler = new PutOnConditionMessageHandler();
        routingSvc.addMessageHandler(Tag.PUT_ON_CONDITION.getNumber(), handler);
    }

    @Override
    public Set<ValueInfo<Item>> put(ID key, Item value, Memcached.Condition cond) throws Exception {
        return this.put(key, value, cond, 0);
    }

    @Override
    public Set<ValueInfo<Item>> put(ID key, Item value, int casUnique) throws Exception {
        return this.put(key, value, Memcached.Condition.CAS, casUnique);
    }

    private Set<ValueInfo<Item>> put(ID key, Item value, Memcached.Condition cond, int casUnique) throws Exception {
        if (cond == null || cond.equals((Object)Memcached.Condition.NONE)) {
            return this.put(key, value);
        }
        Item[] values = new Item[]{value};
        Memcached.PutRequest[] requests = new Memcached.PutRequest[]{new Memcached.PutRequest(key, values, cond, casUnique)};
        Set<ValueInfo<V>>[] ret = this.put(requests);
        if (requests[0] == null) {
            throw new RoutingException();
        }
        return ret[0];
    }

    @Override
    public Set<ValueInfo<Item>> remove(ID key) throws RoutingException {
        return super.remove(key, this.hashedSecret);
    }

    private class PutOnConditionMessageHandler
    extends ChurnTolerantDHTImpl.PutMessageHandler {
        private PutOnConditionMessageHandler() {
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public Message process(Message msg) {
            Memcached.Condition cond;
            Serializable[] contents = msg.getContents();
            Memcached.PutRequest[] requests = (Memcached.PutRequest[])contents[0];
            int size = requests.length;
            boolean[] adopted = new boolean[size];
            int numAdopted = 0;
            Item[] incrOrDecrResults = null;
            Set[] existedValues = new Set[size];
            int i = 0;
            while (i < size) {
                Set<ValueInfo<Item>> existedValue = null;
                try {
                    existedValues[i] = existedValue = MemcachedImpl.this.globalDir.get(requests[i].getKey());
                }
                catch (Exception exception) {
                    // empty catch block
                }
                cond = requests[i].getCondition();
                switch (cond) {
                    case NOT_EXIST: {
                        if (existedValue != null) break;
                        adopted[i] = true;
                        ++numAdopted;
                        break;
                    }
                    case EXIST: {
                        if (existedValue == null) break;
                        adopted[i] = true;
                        ++numAdopted;
                        break;
                    }
                    case APPEND: {
                        byte[] newarray;
                        Object old;
                        if (existedValue == null) break;
                        adopted[i] = true;
                        ++numAdopted;
                        Item[] values = (Item[])requests[i].getValues();
                        for (ValueInfo valueInfo : existedValue) {
                            old = ((Item)valueInfo.getValue()).getData();
                            byte[] appended = values[0].getData();
                            newarray = new byte[((Object)old).length + appended.length];
                            System.arraycopy(old, 0, newarray, 0, ((Object)old).length);
                            System.arraycopy(appended, 0, newarray, ((Object)old).length, appended.length);
                            values[0] = new Item(newarray, ((Item)valueInfo.getValue()).getFlag());
                        }
                        break;
                    }
                    case PREPEND: {
                        byte[] newarray;
                        Object old;
                        if (existedValue == null) break;
                        adopted[i] = true;
                        ++numAdopted;
                        Item[] values = (Item[])requests[i].getValues();
                        for (ValueInfo valueInfo : existedValue) {
                            old = ((Item)valueInfo.getValue()).getData();
                            byte[] prepended = values[0].getData();
                            newarray = new byte[prepended.length + ((Object)old).length];
                            System.arraycopy(prepended, 0, newarray, 0, prepended.length);
                            System.arraycopy(old, 0, newarray, prepended.length, ((Object)old).length);
                            values[0] = new Item(newarray, ((Item)valueInfo.getValue()).getFlag());
                        }
                        break;
                    }
                    case CAS: {
                        Object old;
                        if (existedValue == null) break;
                        for (ValueInfo valueInfo : existedValue) {
                            old = (Item)valueInfo.getValue();
                            if (requests[i].getCasUnique() != ((Item)old).hashCode()) continue;
                            adopted[i] = true;
                            ++numAdopted;
                        }
                        break;
                    }
                    case INCREMENT: {
                        if (existedValue == null) break;
                        adopted[i] = true;
                        ++numAdopted;
                        Item[] values = (Item[])requests[i].getValues();
                        if (incrOrDecrResults == null) {
                            incrOrDecrResults = new Item[size];
                        }
                        incrOrDecrResults[i] = this.incrementOrDecrement(true, existedValue, values);
                        break;
                    }
                    case DECREMENT: {
                        if (existedValue == null) break;
                        adopted[i] = true;
                        ++numAdopted;
                        Item[] values = (Item[])requests[i].getValues();
                        if (incrOrDecrResults == null) {
                            incrOrDecrResults = new Item[size];
                        }
                        incrOrDecrResults[i] = this.incrementOrDecrement(false, existedValue, values);
                    }
                }
                ++i;
            }
            if (numAdopted < size) {
                Memcached.PutRequest[] copiedRequests = new Memcached.PutRequest[size];
                int i2 = 0;
                while (i2 < size) {
                    if (adopted[i2]) {
                        copiedRequests[i2] = requests[i2];
                    }
                    ++i2;
                }
                msg.setContents(0, (Serializable)copiedRequests);
            }
            Message ret = super.process(msg);
            Set[] retValues = (Set[])ret.getContents()[0];
            int i3 = 0;
            while (i3 < size) {
                cond = requests[i3].getCondition();
                switch (cond) {
                    case CAS: {
                        if (adopted[i3] || existedValues[i3] == null) break;
                        retValues[i3] = new HashSet();
                        break;
                    }
                    case INCREMENT: 
                    case DECREMENT: {
                        void var13_27;
                        if (!adopted[i3]) break;
                        Object var13_25 = null;
                        Iterator iterator = retValues[i3].iterator();
                        if (iterator.hasNext()) {
                            ValueInfo returnedVI;
                            ValueInfo valueInfo = returnedVI = (ValueInfo)iterator.next();
                        }
                        ValueInfo<Item> valueInfo = new ValueInfo<Item>(incrOrDecrResults[i3], var13_27.getAttributes());
                        retValues[i3].clear();
                        retValues[i3].add(valueInfo);
                    }
                }
                ++i3;
            }
            return ret;
        }

        private Item incrementOrDecrement(boolean increment, Set<ValueInfo<Item>> existedValues, Item[] values) {
            Item ret = null;
            String valueStr = null;
            try {
                valueStr = new String(values[0].getData(), "UTF-8");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
            BigInteger value = BigInteger.ZERO;
            try {
                value = new BigInteger(valueStr);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            for (ValueInfo<Item> v : existedValues) {
                String existedValueStr = null;
                byte[] b = v.getValue().getData();
                int existedValueSize = b.length;
                int len = 0;
                while (len < existedValueSize) {
                    if (b[len] == 0) break;
                    ++len;
                }
                try {
                    existedValueStr = new String(b, 0, len, "UTF-8");
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    // empty catch block
                }
                BigInteger existedValue = BigInteger.ZERO;
                try {
                    existedValue = new BigInteger(existedValueStr);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                if (increment) {
                    existedValue = existedValue.add(value);
                    while (existedValue.compareTo(Memcached.UINT64_MAX) > 0) {
                        existedValue = existedValue.subtract(Memcached.UINT64_MAX);
                    }
                } else if ((existedValue = existedValue.subtract(value)).compareTo(BigInteger.ZERO) < 0) {
                    existedValue = BigInteger.ZERO;
                }
                byte[] newValue = null;
                try {
                    newValue = existedValue.toString().getBytes("UTF-8");
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    // empty catch block
                }
                if (newValue.length < existedValueSize) {
                    b = new byte[existedValueSize];
                    System.arraycopy(newValue, 0, b, 0, newValue.length);
                    newValue = b;
                }
                values[0] = ret = new Item(newValue, v.getValue().getFlag());
            }
            return ret;
        }
    }
}

