/*
 * Decompiled with CFR 0.152.
 */
package ow.directory.expiration;

import java.io.Serializable;

public class ExpiringValue<V>
implements Serializable {
    private long expire;
    private V value;

    ExpiringValue(V value, long ttl) {
        this.value = value;
        this.expire = ttl >= 0L ? System.currentTimeMillis() + ttl : Long.MAX_VALUE;
    }

    public long getExpiringTime() {
        return this.expire;
    }

    public V getValue() {
        return this.value;
    }

    public int hashCode() {
        return this.value.hashCode();
    }

    public boolean equals(Object o) {
        try {
            ExpiringValue other = (ExpiringValue)o;
            return this.value.equals(other.value);
        }
        catch (ClassCastException e) {
            return false;
        }
    }

    public String toString() {
        return "{expire=" + this.expire + ", value=" + this.value + "}";
    }
}

