/*
 * Decompiled with CFR 0.152.
 */
package ow.directory.inmemory;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import ow.directory.DirectoryConfiguration;
import ow.directory.OutOfHeapException;
import ow.directory.SingleValueDirectory;

public final class SingleValueHashDirectory<K, V>
implements SingleValueDirectory<K, V> {
    private static final Logger logger = Logger.getLogger("directory");
    private final String dbName;
    private final String dbNameOld;
    private long syncInterval;
    private HashMap<K, V> rawMap;
    private DirectoryConfiguration config;
    private Map<K, V> map;
    private boolean changed = false;
    private Synchronizer synchronizer;

    protected SingleValueHashDirectory(Class typeK, Class typeV, String workingDir, String dbName, String dbNameOld, DirectoryConfiguration config, long syncInterval) throws Exception {
        this.dbName = dbName;
        this.dbNameOld = dbNameOld;
        this.syncInterval = syncInterval;
        this.config = config != null ? config : DirectoryConfiguration.getDefaultConfiguration();
        boolean loaded = false;
        if (syncInterval > 0L) {
            File dbFile;
            if (!workingDir.endsWith(File.separator)) {
                workingDir = String.valueOf(workingDir) + File.separator;
            }
            if ((dbFile = new File(String.valueOf(workingDir) + this.dbName)).exists()) {
                ObjectInputStream ois = new ObjectInputStream(new FileInputStream(dbFile));
                this.config = (DirectoryConfiguration)ois.readObject();
                this.rawMap = (HashMap)ois.readObject();
                ois.close();
                loaded = true;
            }
        }
        if (!loaded) {
            this.rawMap = config.heapOverflowAction == DirectoryConfiguration.HeapOverflowAction.LRU ? new LinkedHashMap<K, V>(){

                @Override
                protected boolean removeEldestEntry(Map.Entry eldest) {
                    Runtime r = Runtime.getRuntime();
                    if (r.freeMemory() < SingleValueHashDirectory.this.config.getRequiredFreeHeapToPut()) {
                        System.gc();
                        if (r.freeMemory() < SingleValueHashDirectory.this.config.getRequiredFreeHeapToPut()) {
                            return true;
                        }
                    }
                    return false;
                }
            } : new HashMap();
        }
        this.map = Collections.synchronizedMap(this.rawMap);
        if (this.syncInterval > 0L) {
            this.synchronizer = new Synchronizer(this.syncInterval, String.valueOf(workingDir) + this.dbName, String.valueOf(workingDir) + this.dbNameOld);
            Thread t = new Thread(this.synchronizer);
            t.setDaemon(true);
            t.setName("Map synchronizer");
            t.start();
        }
    }

    @Override
    public V get(K key) {
        return this.map.get(key);
    }

    @Override
    public V put(K key, V value) throws OutOfHeapException {
        Runtime r;
        DirectoryConfiguration.HeapOverflowAction a = this.config.getHeapOverflowAction();
        if ((a == DirectoryConfiguration.HeapOverflowAction.IGNORE || a == DirectoryConfiguration.HeapOverflowAction.THROW_AN_OUT_OF_HEAP_EXCEPTION) && (r = Runtime.getRuntime()).freeMemory() < this.config.getRequiredFreeHeapToPut()) {
            System.gc();
            if (r.freeMemory() < this.config.getRequiredFreeHeapToPut()) {
                if (a == DirectoryConfiguration.HeapOverflowAction.THROW_AN_OUT_OF_HEAP_EXCEPTION) {
                    throw new OutOfHeapException("Remaining heap: " + Runtime.getRuntime().freeMemory() + "key: " + key);
                }
                return null;
            }
        }
        V ret = this.map.put(key, value);
        this.changed = true;
        return ret;
    }

    @Override
    public V put(K key, V value, int ttl) throws OutOfHeapException {
        return this.put(key, value);
    }

    @Override
    public V remove(K key) {
        V ret = this.map.remove(key);
        this.changed = true;
        return ret;
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public Set<K> keySet() {
        return this.map.keySet();
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return this.map.entrySet();
    }

    @Override
    public void clear() {
        this.map.clear();
        this.changed = true;
    }

    @Override
    public void close() {
        if (this.synchronizer != null) {
            this.synchronizer.sync();
        }
    }

    @Override
    public Iterator<Map.Entry<K, V>> iterator() {
        return this.map.entrySet().iterator();
    }

    private class Synchronizer
    implements Runnable {
        private long syncInterval;
        private File file;
        private File oldfile;
        private File tmpfile;

        Synchronizer(long syncInterval, String filename, String oldfilename) {
            this.syncInterval = syncInterval;
            this.file = new File(filename);
            this.oldfile = new File(oldfilename);
            this.tmpfile = new File(String.valueOf(filename) + ".tmp");
        }

        @Override
        public void run() {
            while (true) {
                try {
                    Thread.sleep(this.syncInterval);
                }
                catch (InterruptedException e) {
                    logger.log(Level.INFO, "A Synchronized interrupted.", e);
                }
                this.sync();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private synchronized void sync() {
            if (SingleValueHashDirectory.this.changed) {
                ObjectOutputStream oos = null;
                try {
                    try {
                        oos = new ObjectOutputStream(new FileOutputStream(this.tmpfile));
                        Map map = SingleValueHashDirectory.this.map;
                        synchronized (map) {
                            oos.writeObject(SingleValueHashDirectory.this.config);
                            oos.writeObject(SingleValueHashDirectory.this.rawMap);
                            oos.close();
                        }
                        this.file.renameTo(this.oldfile);
                        this.tmpfile.renameTo(this.file);
                        SingleValueHashDirectory.this.changed = false;
                    }
                    catch (IOException e) {
                        logger.log(Level.WARNING, "Could not open, write or rename.", e);
                        try {
                            if (oos != null) {
                                oos.close();
                            }
                        }
                        catch (IOException e2) {
                            logger.log(Level.WARNING, "Could not close file streams.", e2);
                        }
                    }
                }
                finally {
                    try {
                        if (oos != null) {
                            oos.close();
                        }
                    }
                    catch (IOException e) {
                        logger.log(Level.WARNING, "Could not close file streams.", e);
                    }
                }
            }
        }
    }
}

