/*
 * Decompiled with CFR 0.152.
 */
package ow.id;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Random;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class ID
implements Externalizable,
Comparable<ID> {
    public static final boolean USE_INT_ARRAY = false;
    private static final Logger logger = Logger.getLogger("id");
    private static final int MAX_SIZE = 127;
    private static MessageDigest md = null;
    private static final String mdAlgoName = "SHA1";
    private int size;
    private byte[] value;
    private volatile BigInteger bigInteger;
    private volatile int hashCode;
    private static Random rnd;

    static {
        try {
            md = MessageDigest.getInstance(mdAlgoName);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            // empty catch block
        }
        rnd = new Random();
    }

    private ID(byte[] id, int size) {
        if (size > 127) {
            logger.log(Level.WARNING, "size set as 127 even though the give size is " + size + ".");
            size = 127;
        }
        this.size = size;
        this.value = new byte[size];
        int idLength = Math.min(id.length, size);
        System.arraycopy(id, 0, this.value, size - idLength, idLength);
        this.init();
    }

    private void init() {
        this.bigInteger = new BigInteger(1, this.value);
        int hashedvalue = 0;
        int pos = 24;
        int i = 0;
        while (i < this.size) {
            hashedvalue ^= this.value[i] << pos;
            pos = pos <= 0 ? 24 : (pos -= 8);
            ++i;
        }
        this.hashCode = hashedvalue;
    }

    private static ID canonicalize(ID obj) {
        return obj;
    }

    public ID copy(int newSize) {
        return ID.canonicalize(new ID(this.value, newSize));
    }

    public static ID getID(byte[] id, int size) {
        byte[] value = new byte[size];
        int copyLen = Math.min(id.length, size);
        int fromIdx = id.length - 1;
        int toIdx = size - 1;
        int i = 0;
        while (i < copyLen) {
            value[toIdx--] = id[fromIdx--];
            ++i;
        }
        return ID.canonicalize(new ID(value, size));
    }

    public static ID getID(BigInteger id, int size) {
        if (id.compareTo(BigInteger.ZERO) < 0) {
            id = id.add(BigInteger.ONE.shiftLeft(size * 8));
        }
        byte[] value = id.toByteArray();
        return ID.getID(value, size);
    }

    public static ID getID(String hexString, int size) {
        if (hexString.length() < size * 2) {
            throw new IllegalArgumentException("Given ID is too short: " + hexString);
        }
        byte[] id = new byte[size];
        int i = 0;
        int idx = (size - 1) * 2;
        while (i < size) {
            int b = Integer.parseInt(hexString.substring(idx, idx + 2), 16);
            id[size - 1 - i] = (byte)(b & 0xFF);
            ++i;
            idx -= 2;
        }
        return ID.canonicalize(new ID(id, size));
    }

    public static ID getRandomID(int size) {
        byte[] value = new byte[size];
        rnd.nextBytes(value);
        return ID.canonicalize(new ID(value, size));
    }

    public static ID getSHA1BasedID(byte[] bytes) {
        return ID.getSHA1BasedID(bytes, 20);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ID getSHA1BasedID(byte[] bytes, int sizeInByte) {
        byte[] value;
        MessageDigest messageDigest = md;
        synchronized (messageDigest) {
            value = md.digest(bytes);
        }
        if (sizeInByte > value.length) {
            throw new IllegalArgumentException("size is too large: " + sizeInByte + " > " + value.length);
        }
        return ID.canonicalize(new ID(value, sizeInByte));
    }

    public static ID getHashcodeBasedID(Object obj, int sizeInByte) {
        int hashcode = obj.hashCode();
        byte[] bytes = new byte[4];
        int i = 0;
        while (i < 4) {
            bytes[i] = (byte)(hashcode >>> (3 - i) * 8 & 0xFF);
            ++i;
        }
        return ID.getSHA1BasedID(bytes, sizeInByte);
    }

    public int getSize() {
        return this.size;
    }

    public byte[] getValue() {
        return this.value;
    }

    public int getBits(int from, int len) {
        int result = 0;
        int i = 0;
        while (i < len) {
            int index = from + i;
            if (index >= 0 && this.bigInteger.testBit(from + i)) {
                result |= 1 << i;
            }
            ++i;
        }
        return result;
    }

    public ID shiftLeft(int n) {
        return ID.getID(this.toBigInteger().shiftLeft(n), this.size);
    }

    public ID shiftRight(int n) {
        return ID.getID(this.toBigInteger().shiftRight(n), this.size);
    }

    public ID setBit(int n) {
        return ID.getID(this.toBigInteger().setBit(n), this.size);
    }

    public ID clearBit(int n) {
        return ID.getID(this.toBigInteger().clearBit(n), this.size);
    }

    public static int matchLengthFromMSB(ID a, ID b) {
        int v;
        int aRemainingSize = a.getSize();
        int bRemainingSize = b.getSize();
        int aIndex = 0;
        int bIndex = 0;
        int matchBytes = 0;
        int matchBits = 8;
        while (aRemainingSize > bRemainingSize) {
            v = 0xFF & a.value[aIndex];
            if (v != 0) {
                while (v != 0) {
                    v >>>= 1;
                    --matchBits;
                }
                return matchBytes * 8 + matchBits;
            }
            ++matchBytes;
            ++aIndex;
            --aRemainingSize;
        }
        while (bRemainingSize > aRemainingSize) {
            v = 0xFF & b.value[bIndex];
            if (v != 0) {
                while (v != 0) {
                    v >>>= 1;
                    --matchBits;
                }
                return matchBytes * 8 + matchBits;
            }
            ++matchBytes;
            ++bIndex;
            --bRemainingSize;
        }
        int i = 0;
        while (i < aRemainingSize) {
            int va = 0xFF & a.value[aIndex];
            int vb = 0xFF & b.value[bIndex];
            if (va != vb) {
                int xored = va ^ vb;
                while (xored != 0) {
                    xored >>>= 1;
                    --matchBits;
                }
                return matchBytes * 8 + matchBits;
            }
            ++matchBytes;
            ++aIndex;
            ++bIndex;
            ++i;
        }
        return matchBytes * 8;
    }

    public BigInteger toBigInteger() {
        return this.bigInteger;
    }

    public boolean equals(Object obj) {
        ID other;
        if (obj == null) {
            return false;
        }
        try {
            other = (ID)obj;
        }
        catch (ClassCastException e) {
            return false;
        }
        if (this.size != other.size) {
            return false;
        }
        int i = 0;
        while (i < this.size) {
            if (this.value[i] != other.value[i]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public int hashCode() {
        return this.hashCode;
    }

    public String toString() {
        return this.toString(0);
    }

    public String toString(int verboseLevel) {
        int numOfDigits = verboseLevel < 0 ? Math.min(2, this.size) : this.size;
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < this.size) {
            int b = 0xFF & this.value[i];
            if (b < 16) {
                sb.append("0");
            }
            sb.append(Integer.toHexString(b));
            if (--numOfDigits <= 0) break;
            ++i;
        }
        return sb.toString();
    }

    public ID() {
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeByte(this.size);
        out.write(this.value, 0, this.size);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.size = in.readByte();
        this.value = new byte[this.size];
        in.read(this.value, 0, this.size);
        this.init();
    }

    @Override
    public int compareTo(ID other) {
        return this.toBigInteger().compareTo(other.toBigInteger());
    }
}

