/*
 * Decompiled with CFR 0.152.
 */
package ow.id;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Random;
import java.util.logging.Level;
import java.util.logging.Logger;
import ow.id.ID;

public final class IDLittleEndian
implements Externalizable,
Comparable<ID> {
    public static final boolean USE_INT_ARRAY = false;
    private static final Logger logger = Logger.getLogger("id");
    private static final int MAX_SIZE = 127;
    private static MessageDigest md = null;
    private static final String mdAlgoName = "SHA1";
    private int size;
    private byte[] value;
    private volatile BigInteger bigInteger;
    private volatile int hashCode;
    private static Random rnd;

    static {
        try {
            md = MessageDigest.getInstance(mdAlgoName);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            // empty catch block
        }
        rnd = new Random();
    }

    private IDLittleEndian(byte[] id, int size) {
        if (size > 127) {
            logger.log(Level.WARNING, "size set as 127 even though the give size is " + size + ".");
            size = 127;
        }
        this.size = size;
        this.value = new byte[size];
        int idLength = Math.min(id.length, size);
        System.arraycopy(id, 0, this.value, 0, idLength);
        this.init();
    }

    private void init() {
        byte[] reverseBytes = new byte[this.value.length];
        int i = 0;
        while (i < this.value.length) {
            reverseBytes[this.value.length - 1 - i] = this.value[i];
            ++i;
        }
        this.bigInteger = new BigInteger(1, reverseBytes);
        int hashedvalue = 0;
        int pos = 0;
        int i2 = 0;
        while (i2 < this.size) {
            hashedvalue ^= this.value[i2] << pos;
            pos = pos >= 24 ? 0 : (pos += 8);
            ++i2;
        }
        this.hashCode = hashedvalue;
    }

    private static IDLittleEndian canonicalize(IDLittleEndian obj) {
        return obj;
    }

    public synchronized IDLittleEndian copy(int newSize) {
        return IDLittleEndian.canonicalize(new IDLittleEndian(this.value, newSize));
    }

    public static IDLittleEndian getID(byte[] id, int size) {
        byte[] value = new byte[size];
        int copyLen = Math.min(id.length, size);
        int i = 0;
        while (i < copyLen) {
            value[i] = id[i];
            ++i;
        }
        return new IDLittleEndian(value, size);
    }

    public static IDLittleEndian getID(BigInteger id, int size) {
        if (id.compareTo(BigInteger.ZERO) < 0) {
            id = id.add(BigInteger.ONE.shiftLeft(size * 8));
        }
        byte[] bigEndianValue = id.toByteArray();
        byte[] littleEndianValue = new byte[bigEndianValue.length];
        int i = 0;
        while (i < bigEndianValue.length) {
            littleEndianValue[bigEndianValue.length - 1 - i] = bigEndianValue[i];
            ++i;
        }
        return IDLittleEndian.getID(littleEndianValue, size);
    }

    public static IDLittleEndian getID(String hexString, int size) {
        if (hexString.length() < size * 2) {
            throw new IllegalArgumentException("Given ID is too short: " + hexString);
        }
        byte[] id = new byte[size];
        int i = 0;
        int idx = (size - 1) * 2;
        while (i < size) {
            int b = Integer.parseInt(hexString.substring(idx, idx + 2), 16);
            id[i] = (byte)(b & 0xFF);
            ++i;
            idx -= 2;
        }
        return IDLittleEndian.canonicalize(new IDLittleEndian(id, size));
    }

    public static IDLittleEndian getRandomID(int size) {
        byte[] value = new byte[size];
        rnd.nextBytes(value);
        return IDLittleEndian.canonicalize(new IDLittleEndian(value, size));
    }

    public static IDLittleEndian getSHA1BasedID(byte[] bytes) {
        return IDLittleEndian.getSHA1BasedID(bytes, 20);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IDLittleEndian getSHA1BasedID(byte[] message, int sizeInByte) {
        byte[] value;
        MessageDigest messageDigest = md;
        synchronized (messageDigest) {
            value = md.digest(message);
        }
        if (sizeInByte > value.length) {
            throw new IllegalArgumentException("size is too large: " + sizeInByte + " > " + value.length);
        }
        return IDLittleEndian.canonicalize(new IDLittleEndian(value, sizeInByte));
    }

    public static IDLittleEndian getHashcodeBasedID(Object obj, int sizeInByte) {
        int hashcode = obj.hashCode();
        byte[] bytes = new byte[4];
        int i = 0;
        while (i < 4) {
            bytes[i] = (byte)(hashcode >>> (3 - i) * 8 & 0xFF);
            ++i;
        }
        return IDLittleEndian.getSHA1BasedID(bytes, sizeInByte);
    }

    public int getSize() {
        return this.size;
    }

    public byte[] getValue() {
        return this.value;
    }

    public BigInteger toBigInteger() {
        return this.bigInteger;
    }

    public int getBits(int from, int len) {
        int result = 0;
        int i = 0;
        while (i < len) {
            int index = from + i;
            if (index >= 0 && this.bigInteger.testBit(from + i)) {
                result |= 1 << i;
            }
            ++i;
        }
        return result;
    }

    public IDLittleEndian shiftLeft(int n) {
        return IDLittleEndian.getID(this.toBigInteger().shiftLeft(n), this.size);
    }

    public IDLittleEndian shiftRight(int n) {
        return IDLittleEndian.getID(this.toBigInteger().shiftRight(n), this.size);
    }

    public IDLittleEndian setBit(int n) {
        return IDLittleEndian.getID(this.toBigInteger().setBit(n), this.size);
    }

    public IDLittleEndian clearBit(int n) {
        return IDLittleEndian.getID(this.toBigInteger().clearBit(n), this.size);
    }

    public static int matchLengthFromMSB(IDLittleEndian a, IDLittleEndian b) {
        int v;
        int aRemainingSize = a.getSize();
        int bRemainingSize = b.getSize();
        int aIndex = a.getSize() - 1;
        int bIndex = b.getSize() - 1;
        int matchBytes = 0;
        int matchBits = 8;
        while (aRemainingSize > bRemainingSize) {
            v = 0xFF & a.value[aIndex];
            if (v != 0) {
                while (v != 0) {
                    v >>>= 1;
                    --matchBits;
                }
                return matchBytes * 8 + matchBits;
            }
            ++matchBytes;
            --aIndex;
            --aRemainingSize;
        }
        while (bRemainingSize > aRemainingSize) {
            v = 0xFF & b.value[bIndex];
            if (v != 0) {
                while (v != 0) {
                    v >>>= 1;
                    --matchBits;
                }
                return matchBytes * 8 + matchBits;
            }
            ++matchBytes;
            --bIndex;
            --bRemainingSize;
        }
        int i = 0;
        while (i < aRemainingSize) {
            int va = 0xFF & a.value[aIndex];
            int vb = 0xFF & b.value[bIndex];
            if (va != vb) {
                int xored = va ^ vb;
                while (xored != 0) {
                    xored >>>= 1;
                    --matchBits;
                }
                return matchBytes * 8 + matchBits;
            }
            ++matchBytes;
            --aIndex;
            --bIndex;
            ++i;
        }
        return matchBytes * 8;
    }

    public boolean equals(Object obj) {
        IDLittleEndian other;
        if (obj == null) {
            return false;
        }
        try {
            other = (IDLittleEndian)obj;
        }
        catch (ClassCastException e) {
            return false;
        }
        if (this.size != other.size) {
            return false;
        }
        int i = 0;
        while (i < this.size) {
            if (this.value[i] != other.value[i]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public int hashCode() {
        return this.hashCode;
    }

    public String toString() {
        return this.toString(0);
    }

    public String toString(int verboseLevel) {
        int numOfDigits = verboseLevel < 0 ? Math.min(2, this.size) : this.size;
        StringBuilder sb = new StringBuilder();
        int i = this.size - 1;
        while (i >= 0) {
            int b = 0xFF & this.value[i];
            if (b < 16) {
                sb.append("0");
            }
            sb.append(Integer.toHexString(b));
            if (--numOfDigits <= 0) break;
            --i;
        }
        return sb.toString();
    }

    public IDLittleEndian() {
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.size = in.readByte();
        this.value = new byte[this.size];
        in.read(this.value, 0, this.size);
        this.init();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeByte(this.size);
        out.write(this.value, 0, this.size);
    }

    @Override
    public int compareTo(ID other) {
        return this.toBigInteger().compareTo(other.toBigInteger());
    }
}

