/*
 * Decompiled with CFR 0.152.
 */
package ow.ipmulticast;

import java.io.IOException;
import java.net.Inet4Address;
import java.net.UnknownHostException;
import java.util.logging.Level;
import java.util.logging.Logger;
import ow.ipmulticast.IGMPHandler;
import ow.ipmulticast.Native;
import ow.ipmulticast.Utilities;
import ow.ipmulticast.VirtualInterface;

public final class IGMP {
    private static final Logger logger = Logger.getLogger("ipmulticast");
    public static int DEFAULT_IGMP_VERSION = 3;
    public static Inet4Address ALL_HOSTS_GROUP;
    public static Inet4Address ALL_ROUTERS_GROUP;
    public static final int IGMP_MEMBERSHIP_QUERY = 17;
    public static final int IGMP_V1_MEMBERSHIP_REPORT = 18;
    public static final int IGMP_V2_MEMBERSHIP_REPORT = 22;
    public static final int IGMP_V3_MEMBERSHIP_REPORT = 34;
    public static final int IGMP_V2_LEAVE_GROUP = 23;
    public static final int IGMP_DVMRP = 19;
    public static final int IGMP_PIM = 20;
    public static final int IGMP_TRACE = 21;
    public static final int IGMP_MTRACE_RESP = 30;
    public static final int IGMP_MTRACE = 31;
    private static String[] TYPE_STRINGS;
    private static IGMP instance;
    private Thread receiverThread = null;
    private boolean working = false;
    private boolean suspended = false;

    static {
        TYPE_STRINGS = new String[]{"", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "IGMP_MEMBERSHIP_QUERY", "IGMP_V1_MEMBERSHIP_REPORT", "IGMP_DVMRP", "IGMP_PIM", "IGMP_TRACE", "IGMP_V2_MEMBERSHIP_REPORT", "IGMP_V2_LEAVE_GROUP", "", "", "", "", "", "", "IGMP_MTRACE_RESP", "IGMP_MTRACE"};
        instance = null;
        byte[] addr = new byte[]{-32, 0, 0, 1};
        try {
            ALL_HOSTS_GROUP = (Inet4Address)Inet4Address.getByAddress(addr);
        }
        catch (UnknownHostException e) {
            e.printStackTrace();
        }
        addr[0] = -32;
        addr[1] = 0;
        addr[2] = 0;
        addr[3] = 2;
        try {
            ALL_ROUTERS_GROUP = (Inet4Address)Inet4Address.getByAddress(addr);
        }
        catch (UnknownHostException e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IGMP getInstance() throws IOException {
        Class<IGMP> clazz = IGMP.class;
        synchronized (IGMP.class) {
            if (instance == null) {
                instance = new IGMP();
                Native.initialize();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    private IGMP() {
    }

    public synchronized void start(IGMPHandler handler) {
        if (this.working) {
            return;
        }
        Runnable r = new Runnable(){
            IGMPMessage container = new IGMPMessage();
            Inet4Address src;
            Inet4Address dest;
            Inet4Address group;

            @Override
            public void run() {
                try {
                    while (!Thread.interrupted()) {
                        try {
                            Native.receiveIGMP(this.container);
                        }
                        catch (IOException e) {
                            logger.log(Level.WARNING, "Native#receiveIGMP() throws an IOException.", e);
                            break;
                        }
                        this.src = Utilities.intToInet4Address(this.container.src);
                        this.dest = Utilities.intToInet4Address(this.container.dest);
                        this.group = Utilities.intToInet4Address(this.container.group);
                        VirtualInterface vif = VirtualInterface.findVirtualInterface(this.src);
                        handler.process(this.src, this.dest, this.container.type, this.container.code, this.group, this.container.data, vif);
                    }
                }
                catch (InterruptedException e) {
                    logger.log(Level.WARNING, "IGMP receiving daemon interrupted and die.", e);
                }
                Native.stop();
                IGMP.this.working = false;
            }
        };
        this.receiverThread = new Thread(r);
        this.receiverThread.setName("IGMP receiving daemon");
        this.receiverThread.setDaemon(true);
        this.receiverThread.start();
        this.working = true;
    }

    public synchronized void stop() {
        if (this.receiverThread != null) {
            this.receiverThread.interrupt();
            this.receiverThread = null;
        }
        Native.stop();
        this.working = false;
    }

    public synchronized void suspend() {
        this.suspended = true;
    }

    public synchronized void resume() {
        this.suspended = false;
        this.notifyAll();
    }

    public synchronized void send(Inet4Address src, Inet4Address dest, int type, int code, Inet4Address group, byte[] data) {
        Native.sendIGMP(Utilities.Inet4AddressToInt(src), Utilities.Inet4AddressToInt(dest), type, code, Utilities.Inet4AddressToInt(group), data);
    }

    public static String typeString(int type) {
        String str;
        try {
            str = TYPE_STRINGS[type];
        }
        catch (ArrayIndexOutOfBoundsException e) {
            str = "";
        }
        return str;
    }

    static class IGMPMessage {
        int src;
        int dest;
        int type;
        int code;
        int group;
        byte[] data;

        IGMPMessage() {
        }
    }
}

