/*
 * Decompiled with CFR 0.152.
 */
package ow.ipmulticast;

import java.io.IOException;
import java.net.Inet4Address;
import java.util.HashSet;
import java.util.Set;
import ow.ipmulticast.GroupSet;
import ow.ipmulticast.Native;
import ow.ipmulticast.QuerierSet;
import ow.ipmulticast.Utilities;

public final class VirtualInterface {
    private static Set<VirtualInterface> vifs = null;
    private final boolean isRegisterVIF;
    private final Inet4Address localAddress;
    private final int localAddressAsInt;
    private final int netmask;
    private final int subnet;
    private final int subnetBroadcast;
    private final String name;
    private final int ifIndex;
    private boolean isQuerier;
    private QuerierSet querierSet;
    private GroupSet groupSet;

    public static synchronized Set<VirtualInterface> getVirtualInterfaces() throws IOException {
        if (vifs == null) {
            Native.initialize();
            vifs = new HashSet<VirtualInterface>();
            int nVifs = Native.numberOfVIFs();
            if (nVifs > 0) {
                NativeVIF[] nativeVIFs = new NativeVIF[nVifs];
                int i = 0;
                while (i < nVifs) {
                    nativeVIFs[i] = new NativeVIF();
                    ++i;
                }
                Native.fillVIFs(nativeVIFs);
                i = 0;
                while (i < nVifs) {
                    NativeVIF v = nativeVIFs[i];
                    VirtualInterface vif = new VirtualInterface(v.isRegisterVIF, v.localAddress, v.netmask, v.name, v.ifIndex);
                    vifs.add(vif);
                    ++i;
                }
            }
        }
        return vifs;
    }

    private VirtualInterface(boolean isRegisterVIF, int localadr, int netmask, String name, int ifIndex) {
        this.isRegisterVIF = isRegisterVIF;
        this.localAddress = Utilities.intToInet4Address(localadr);
        this.localAddressAsInt = localadr;
        this.netmask = netmask;
        this.subnet = localadr & netmask;
        this.subnetBroadcast = this.subnet | ~netmask;
        this.name = name;
        this.ifIndex = ifIndex;
        this.isQuerier = true;
        this.querierSet = new QuerierSet();
        this.groupSet = new GroupSet(this);
    }

    public boolean isRegisterVIF() {
        return this.isRegisterVIF;
    }

    public Inet4Address getLocalAddress() {
        return this.localAddress;
    }

    public int getLocalAddressAsInt() {
        return this.localAddressAsInt;
    }

    public int getNetmask() {
        return this.netmask;
    }

    public int getSubnet() {
        return this.subnet;
    }

    public int getSubnetBroadcast() {
        return this.subnetBroadcast;
    }

    public String getName() {
        return this.name;
    }

    public int getIfIndex() {
        return this.ifIndex;
    }

    public boolean isQuerier() {
        return this.isQuerier;
    }

    public boolean setQuerier(boolean flag) {
        boolean old = this.isQuerier;
        this.isQuerier = flag;
        return old;
    }

    public QuerierSet getQuerierSet() {
        return this.querierSet;
    }

    public GroupSet getGroupSet() {
        return this.groupSet;
    }

    public static VirtualInterface findVirtualInterface(Inet4Address src) {
        int srcAddressInt = Utilities.Inet4AddressToInt(src);
        for (VirtualInterface vif : vifs) {
            int netmask;
            if (vif.isRegisterVIF() || (srcAddressInt & (netmask = vif.getNetmask())) != vif.getSubnet() || netmask != -1 && srcAddressInt == vif.getSubnetBroadcast()) continue;
            return vif;
        }
        return null;
    }

    public String toString() {
        return this.toString("");
    }

    public String toString(String indent) {
        StringBuilder sb = new StringBuilder();
        boolean firstFlag = true;
        String netmaskStr = Integer.toHexString(this.netmask);
        netmaskStr = String.valueOf("00000000".substring(0, 8 - netmaskStr.length())) + netmaskStr;
        sb.append(indent);
        sb.append(this.ifIndex);
        sb.append(":");
        sb.append(this.name);
        sb.append(":");
        sb.append(this.localAddress);
        sb.append("/");
        sb.append(netmaskStr);
        sb.append("(");
        if (this.isRegisterVIF) {
            if (firstFlag) {
                firstFlag = false;
            } else {
                sb.append(",");
            }
            sb.append("reg_vif");
        }
        if (this.isQuerier) {
            if (firstFlag) {
                firstFlag = false;
            } else {
                sb.append(",");
            }
            sb.append("querier");
        }
        sb.append(")");
        sb.append("\n");
        sb.append(indent);
        sb.append(this.querierSet.toString(indent));
        sb.append("\n");
        sb.append(indent);
        sb.append(this.groupSet.toString(indent));
        return sb.toString();
    }

    static class NativeVIF {
        boolean isRegisterVIF;
        int localAddress;
        int netmask;
        String name;
        int ifIndex;

        NativeVIF() {
        }
    }
}

