/*
 * Decompiled with CFR 0.152.
 */
package ow.ipmulticast.igmpd;

import java.io.IOException;
import java.io.PrintStream;
import java.net.Inet4Address;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import ow.ipmulticast.FilterMode;
import ow.ipmulticast.Group;
import ow.ipmulticast.GroupSet;
import ow.ipmulticast.Host;
import ow.ipmulticast.IGMP;
import ow.ipmulticast.IGMPHandler;
import ow.ipmulticast.QuerierSet;
import ow.ipmulticast.Utilities;
import ow.ipmulticast.VirtualInterface;
import ow.ipmulticast.igmpd.GroupChangeCallback;
import ow.ipmulticast.igmpd.IGMPDaemonConfiguration;

public final class IGMPDaemon {
    private static final Logger logger = Logger.getLogger("ipmulticast");
    public static final int TIMER_SCALE = 10;
    public static final int MAX_HOST_REPORT_DELAY = 100;
    private int robustnessVariable;
    private int queryInterval;
    private IGMPDaemonConfiguration config;
    private IGMP igmp;
    private Set<VirtualInterface> vifSet;
    private Thread updatingDaemonThread = null;
    private long lastQueryTime = 0L;
    private GroupChangeCallback callback;
    private boolean suspended = false;

    public IGMPDaemon(IGMPDaemonConfiguration config) throws IOException {
        this.config = config;
        this.robustnessVariable = config.getInitialRobustnessVariable();
        this.queryInterval = config.getInitialQueryInterval();
        this.igmp = IGMP.getInstance();
        this.vifSet = VirtualInterface.getVirtualInterfaces();
    }

    public void start(GroupChangeCallback callback) {
        this.callback = callback;
        HashSet<Group> s = new HashSet<Group>();
        for (VirtualInterface vif : this.vifSet) {
            s.clear();
            GroupSet groupSet = vif.getGroupSet();
            for (Group group : groupSet.getGroups()) {
                s.add(group);
            }
            callback.included(s, vif);
        }
        s = null;
        this.igmp.start(new Handler());
        Runnable r = new Runnable(){

            @Override
            public void run() {
                int i = 0;
                while (i < IGMPDaemon.this.robustnessVariable) {
                    IGMPDaemon.this.queryGroups();
                    try {
                        Thread.sleep(IGMPDaemon.this.queryInterval * 1000 / 4);
                    }
                    catch (InterruptedException e) {
                        logger.log(Level.WARNING, "A thread sending startup queries has been interrupted.", e);
                        break;
                    }
                    ++i;
                }
            }
        };
        Thread th = new Thread(r);
        th.setName("Startup Query Issuer");
        th.setDaemon(true);
        th.start();
        r = new UpdatingDaemon();
        th = new Thread(r);
        th.setName("Updating Daemon");
        th.setDaemon(true);
        th.start();
        this.updatingDaemonThread = th;
    }

    public synchronized void stop() {
        this.igmp.stop();
        if (this.updatingDaemonThread != null) {
            this.updatingDaemonThread.interrupt();
        }
    }

    public synchronized void suspend() {
        this.igmp.suspend();
        this.suspended = true;
    }

    public synchronized void resume() {
        this.igmp.resume();
        this.suspended = false;
        this.notifyAll();
    }

    public long getGroupMembershipInterval() {
        return this.robustnessVariable * (this.queryInterval * 1000) + this.config.getQueryResponseInterval() * 100;
    }

    private static int decodeMaxRespAndQQIC(byte qqic) {
        int qqi;
        if (qqic < 128) {
            qqi = qqic;
        } else {
            int mant = qqic & 0xF | 0x10;
            int exp = qqic >>> 4 & 3;
            qqi = mant << exp + 3;
        }
        return qqi;
    }

    private static byte encodeMaxRespAndQQIC(int qqi) {
        byte qqic;
        if (qqi < 128) {
            qqic = (byte)qqi;
        } else {
            int exp = 3;
            int mant = qqi >>> 3;
            while ((mant & 0xFFFFFFE0) != 0) {
                mant >>>= 1;
                ++exp;
            }
            if ((exp -= 3) > 7) {
                exp = 7;
                mant = 15;
            }
            qqic = (byte)(0x80 | exp << 4 | mant & 0xF);
        }
        return qqic;
    }

    public void queryGroups() {
        byte[] data = new byte[4];
        byte code = IGMPDaemon.encodeMaxRespAndQQIC(this.config.getQueryResponseInterval());
        int qrv = this.robustnessVariable;
        if (qrv > 7) {
            qrv = 7;
        }
        data[0] = (byte)(data[0] | qrv);
        data[1] = IGMPDaemon.encodeMaxRespAndQQIC(this.queryInterval);
        for (VirtualInterface vif : this.vifSet) {
            if (vif.isRegisterVIF()) continue;
            int igmpVersion = vif.getGroupSet().getLowestIGMPVersion();
            boolean sent = false;
            switch (igmpVersion) {
                case 1: {
                    this.igmp.send(vif.getLocalAddress(), IGMP.ALL_HOSTS_GROUP, 17, 0, null, null);
                    sent = true;
                    break;
                }
                case 2: {
                    this.igmp.send(vif.getLocalAddress(), IGMP.ALL_HOSTS_GROUP, 17, code, null, null);
                    sent = true;
                    break;
                }
                case 3: {
                    this.igmp.send(vif.getLocalAddress(), IGMP.ALL_HOSTS_GROUP, 17, code, null, data);
                    sent = true;
                    break;
                }
                default: {
                    logger.log(Level.WARNING, "Invalid IGMP version number in queryGroups():" + igmpVersion);
                }
            }
            if (!sent) continue;
            logger.log(Level.INFO, "A v" + igmpVersion + " membership query sent. ifname: " + vif.getName() + ", src addr: " + vif.getLocalAddress() + ".");
        }
        this.lastQueryTime = System.currentTimeMillis();
    }

    public Set<VirtualInterface> getVirtualInterfaceSet() {
        return this.vifSet;
    }

    public void printStatus(PrintStream out) {
        for (VirtualInterface vif : this.vifSet) {
            out.println(vif);
        }
    }

    private class Handler
    implements IGMPHandler {
        private Handler() {
        }

        @Override
        public void process(Inet4Address src, Inet4Address dest, int type, int code, Inet4Address groupAddress, byte[] data, VirtualInterface vif) {
            boolean added = false;
            if (vif == null) {
                return;
            }
            switch (type) {
                case 17: {
                    if (vif == null) break;
                    int igmpVersion = data.length >= 12 ? 3 : (code != 0 ? 2 : 1);
                    boolean suppressRouterProcessing = false;
                    if (igmpVersion >= 3) {
                        suppressRouterProcessing = (data[8] & 8) != 0;
                    }
                    logger.log(Level.INFO, "A membership query received: IGMPv" + igmpVersion + " (data.length:" + data.length + ") from " + src + " to " + groupAddress + ".");
                    if (suppressRouterProcessing) break;
                    IGMPDaemon.this.lastQueryTime = System.currentTimeMillis();
                    QuerierSet querierSet = vif.getQuerierSet();
                    querierSet.registerQuerier(src, igmpVersion);
                    if (!IGMPDaemon.this.config.getKeepBeingQuerier()) {
                        long localAddressLong = (long)vif.getLocalAddressAsInt() & 0xFFFFFFFFFFFFFFFFL;
                        long srcAddressLong = Utilities.Inet4AddressToLong(src);
                        if (srcAddressLong < localAddressLong) {
                            vif.setQuerier(false);
                            logger.log(Level.INFO, "Current querier: " + src);
                        }
                    }
                    if (igmpVersion < 3) break;
                    int qrv = data[8] & 7;
                    int oldRobustnessVariable = IGMPDaemon.this.robustnessVariable;
                    if (qrv != 0) {
                        IGMPDaemon.this.robustnessVariable = qrv;
                    } else {
                        IGMPDaemon.this.robustnessVariable = IGMPDaemon.this.config.getInitialRobustnessVariable();
                    }
                    if (IGMPDaemon.this.robustnessVariable != oldRobustnessVariable) {
                        logger.log(Level.INFO, "Robustness variable: " + IGMPDaemon.this.robustnessVariable);
                    }
                    int qqic = data[9] & 0xFF;
                    int oldQueryInterval = IGMPDaemon.this.queryInterval;
                    int qqi = qqic != 0 ? IGMPDaemon.decodeMaxRespAndQQIC((byte)qqic) : IGMPDaemon.this.config.getInitialQueryInterval();
                    IGMPDaemon.this.queryInterval = qqi;
                    if (IGMPDaemon.this.queryInterval == oldQueryInterval) break;
                    logger.log(Level.INFO, "Querier's Query Interval: " + IGMPDaemon.this.queryInterval + " (code: 0x" + Integer.toHexString(qqic) + ").");
                    break;
                }
                case 18: {
                    if (vif == null) break;
                    int igmpVersion = 1;
                    GroupSet groupSet = vif.getGroupSet();
                    if (groupSet.getGroup(groupAddress) == null) {
                        added = true;
                    }
                    Group group = groupSet.registerGroup(groupAddress);
                    group.registerHost(src, igmpVersion);
                    if (added) {
                        HashSet<Group> s = new HashSet<Group>();
                        s.add(group);
                        IGMPDaemon.this.callback.included(s, vif);
                    }
                    logger.log(Level.INFO, "A v1 membership report received from " + src + " to " + groupAddress + ".");
                    break;
                }
                case 22: {
                    if (vif == null) break;
                    int igmpVersion = 2;
                    GroupSet groupSet = vif.getGroupSet();
                    if (groupSet.getGroup(groupAddress) == null) {
                        added = true;
                    }
                    Group group = groupSet.registerGroup(groupAddress);
                    group.registerHost(src, igmpVersion);
                    if (added) {
                        HashSet<Group> s = new HashSet<Group>();
                        s.add(group);
                        IGMPDaemon.this.callback.included(s, vif);
                    }
                    logger.log(Level.INFO, "A v2 membership report received from " + src + " to " + groupAddress + ".");
                    break;
                }
                case 34: {
                    if (vif == null) break;
                    int igmpVersion = 3;
                    GroupSet groupSet = vif.getGroupSet();
                    if (data.length < 8) {
                        logger.log(Level.WARNING, "Size of an IGMPv3 membership report message is less than 8: " + data.length);
                        break;
                    }
                    int numOfGroupRecords = Utilities.byteArrayToInt(data, 6, 2);
                    HashSet<Inet4Address> sourceSet = new HashSet<Inet4Address>();
                    HashSet<Group> updatedGroupSet = new HashSet<Group>();
                    HashSet<Group> addedGroupSet = new HashSet<Group>();
                    logger.log(Level.INFO, "A v3 membership report received (# of group records: " + numOfGroupRecords + ") from " + src + " to " + groupAddress + ".");
                    int index = 8;
                    int i = 0;
                    while (i < numOfGroupRecords) {
                        sourceSet.clear();
                        int recordType = Utilities.byteArrayToInt(data, index, 1);
                        int auxDataLen = Utilities.byteArrayToInt(data, index + 1, 1);
                        int numOfSources = Utilities.byteArrayToInt(data, index + 2, 2);
                        int mcastAddressInt = Utilities.byteArrayToInt(data, index + 4, 4);
                        Inet4Address mcastAddress = Utilities.intToInet4Address(mcastAddressInt);
                        logger.log(Level.INFO, "A group record in a v3 membership report: record type: " + recordType + ", # of sources: " + numOfSources + ", mcast address: " + mcastAddress);
                        if (groupSet.getGroup(mcastAddress) == null) {
                            added = true;
                        }
                        Group group = groupSet.registerGroup(mcastAddress);
                        Host host = group.registerHost(src, 3);
                        updatedGroupSet.add(group);
                        if (added) {
                            addedGroupSet.add(group);
                        }
                        int j = 0;
                        while (j < numOfSources) {
                            int srcAddressInt = Utilities.byteArrayToInt(data, index + 8 + 8 * j, 4);
                            Inet4Address srcAddress = Utilities.intToInet4Address(srcAddressInt);
                            sourceSet.add(srcAddress);
                            logger.log(Level.INFO, "In a group record, src address: " + srcAddress);
                            ++j;
                        }
                        switch (recordType) {
                            case 1: 
                            case 3: {
                                host.setFilterMode(FilterMode.INCLUDE);
                                host.setSourceSet(sourceSet);
                                break;
                            }
                            case 2: 
                            case 4: {
                                host.setFilterMode(FilterMode.EXCLUDE);
                                host.setSourceSet(sourceSet);
                                break;
                            }
                            case 5: {
                                if (host.getFilterMode() == FilterMode.EXCLUDE) {
                                    host.removeSourceSet(sourceSet);
                                    break;
                                }
                                host.addSourceSet(sourceSet);
                                break;
                            }
                            case 6: {
                                if (host.getFilterMode() == FilterMode.EXCLUDE) {
                                    host.addSourceSet(sourceSet);
                                    break;
                                }
                                host.removeSourceSet(sourceSet);
                                break;
                            }
                            default: {
                                logger.log(Level.INFO, "Invalid record type: " + recordType);
                            }
                        }
                        index += (numOfSources + auxDataLen) * 4;
                        ++i;
                    }
                    for (Group g : updatedGroupSet) {
                        g.updateFilter();
                    }
                    if (addedGroupSet.size() <= 0) break;
                    IGMPDaemon.this.callback.included(addedGroupSet, vif);
                    break;
                }
                case 23: {
                    if (vif == null) break;
                    GroupSet groupSet = vif.getGroupSet();
                    Set<Group> removedGroupSet = groupSet.unregisterHost(groupAddress, src);
                    if (removedGroupSet.size() > 0) {
                        IGMPDaemon.this.callback.excluded(removedGroupSet, vif);
                    }
                    logger.log(Level.INFO, "A v2 leave group message received.");
                    break;
                }
                default: {
                    logger.log(Level.INFO, "Invalid IGMP message type: " + type);
                }
            }
        }
    }

    private class UpdatingDaemon
    implements Runnable {
        private UpdatingDaemon() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                block5: while (true) {
                    Thread.sleep(IGMPDaemon.this.config.getUpdateInterval());
                    IGMPDaemon iGMPDaemon = IGMPDaemon.this;
                    synchronized (iGMPDaemon) {
                        while (IGMPDaemon.this.suspended) {
                            IGMPDaemon.this.wait();
                        }
                    }
                    long now = System.currentTimeMillis();
                    Iterator iterator = IGMPDaemon.this.vifSet.iterator();
                    while (true) {
                        if (!iterator.hasNext()) continue block5;
                        VirtualInterface vif = (VirtualInterface)iterator.next();
                        if (vif.isRegisterVIF()) continue;
                        long groupMambershipInterval = IGMPDaemon.this.getGroupMembershipInterval();
                        GroupSet groupSet = vif.getGroupSet();
                        Set<Group> removedGroupSet = groupSet.expire(groupMambershipInterval);
                        if (removedGroupSet.size() > 0) {
                            IGMPDaemon.this.callback.excluded(removedGroupSet, vif);
                        }
                        if (now <= IGMPDaemon.this.lastQueryTime + (long)(IGMPDaemon.this.queryInterval * 1000)) continue;
                        IGMPDaemon.this.queryGroups();
                    }
                    break;
                }
            }
            catch (InterruptedException e) {
                logger.log(Level.WARNING, "UpdatingDaemon interrupted and die.", e);
                return;
            }
        }
    }
}

