/*
 * Decompiled with CFR 0.152.
 */
package ow.mcast.impl;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import ow.id.ID;
import ow.id.IDAddressPair;
import ow.mcast.impl.McastImpl;
import ow.mcast.impl.Neighbor;
import ow.messaging.MessageReceiver;

class NeighborTable {
    private final Map<ID, Neighbor> parentMap = Collections.synchronizedMap(new HashMap());
    private final Map<ID, Set<Neighbor>> childrenMap = Collections.synchronizedMap(new HashMap());
    private final Map<ID, IDAddressPair[]> cachedChildrenMap = Collections.synchronizedMap(new HashMap());
    private final McastImpl mcast;
    private final MessageReceiver receiver;
    private final long expiration;

    NeighborTable(McastImpl mcast, MessageReceiver receiver, long expiration) {
        this.mcast = mcast;
        this.receiver = receiver;
        this.expiration = expiration;
    }

    public Set<ID> getGroupsWithSpanningTree() {
        HashSet<ID> result = new HashSet<ID>();
        result.addAll(this.parentMap.keySet());
        result.addAll(this.childrenMap.keySet());
        return result;
    }

    public IDAddressPair getParent(ID groupID) {
        Neighbor parent = this.parentMap.get(groupID);
        if (parent != null) {
            return parent.getIDAddressPair();
        }
        return null;
    }

    public IDAddressPair[] getChildren(ID groupID) {
        return this.cachedChildrenMap.get(groupID);
    }

    public boolean hasParent(ID groupID) {
        return this.parentMap.containsKey(groupID);
    }

    public boolean hasChild(ID groupID) {
        Set<Neighbor> childrenSet = this.childrenMap.get(groupID);
        return childrenSet != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean registerParent(ID groupID, IDAddressPair parent) {
        boolean parentChanged = true;
        NeighborTable neighborTable = this;
        synchronized (neighborTable) {
            Neighbor oldParent = this.parentMap.remove(groupID);
            if (oldParent != null && parent.equals(oldParent.getIDAddressPair())) {
                parentChanged = false;
            }
            Neighbor neighbor = new Neighbor(parent);
            this.parentMap.remove(groupID);
            this.parentMap.put(groupID, neighbor);
        }
        return parentChanged;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean registerChild(ID groupID, IDAddressPair child) {
        boolean added = false;
        NeighborTable neighborTable = this;
        synchronized (neighborTable) {
            Neighbor neighbor;
            Set<Neighbor> childrenSet = this.childrenMap.get(groupID);
            if (childrenSet == null) {
                childrenSet = new HashSet<Neighbor>();
                this.childrenMap.put(groupID, childrenSet);
            }
            added = !childrenSet.remove(neighbor = new Neighbor(child));
            childrenSet.add(neighbor);
            IDAddressPair[] cachedChildren = new IDAddressPair[childrenSet.size()];
            int i = 0;
            for (Neighbor n : childrenSet) {
                cachedChildren[i++] = n.getIDAddressPair();
            }
            this.cachedChildrenMap.put(groupID, cachedChildren);
        }
        return added;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeParent(ID groupID, IDAddressPair parent) {
        NeighborTable neighborTable = this;
        synchronized (neighborTable) {
            IDAddressPair currentParent;
            Neighbor currentNeighbor = this.parentMap.get(groupID);
            if (currentNeighbor != null && parent.equals(currentParent = currentNeighbor.getIDAddressPair())) {
                this.parentMap.remove(groupID);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<ID> removeParent(IDAddressPair parent) {
        HashSet<ID> changedGroups = new HashSet<ID>();
        NeighborTable neighborTable = this;
        synchronized (neighborTable) {
            Set<ID> keySet = this.parentMap.keySet();
            ID[] keySetArray = new ID[keySet.size()];
            keySet.toArray(keySetArray);
            ID[] iDArray = keySetArray;
            int n = keySetArray.length;
            int n2 = 0;
            while (n2 < n) {
                ID groupID = iDArray[n2];
                Neighbor neighbor = this.parentMap.get(groupID);
                if (parent.equals(neighbor.getIDAddressPair())) {
                    this.parentMap.remove(groupID);
                    changedGroups.add(groupID);
                }
                ++n2;
            }
        }
        return changedGroups;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeChild(ID groupID, IDAddressPair child) {
        boolean removed = false;
        boolean noChild = false;
        NeighborTable neighborTable = this;
        synchronized (neighborTable) {
            Set<Neighbor> childrenSet = this.childrenMap.get(groupID);
            if (childrenSet != null) {
                childrenSet.remove(new Neighbor(child));
                removed = true;
                if (childrenSet.isEmpty()) {
                    this.childrenMap.remove(groupID);
                    noChild = true;
                    this.cachedChildrenMap.remove(groupID);
                } else {
                    IDAddressPair[] cachedChildren = new IDAddressPair[childrenSet.size()];
                    int i = 0;
                    for (Neighbor n : childrenSet) {
                        cachedChildren[i++] = n.getIDAddressPair();
                    }
                    this.cachedChildrenMap.put(groupID, cachedChildren);
                }
            }
            if (noChild && !this.mcast.joinedGroupSet.contains(groupID)) {
                this.mcast.disconnectParent(groupID);
            }
        }
        return removed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<ID> removeChild(IDAddressPair child) {
        HashSet<ID> noChildGroupSet = new HashSet<ID>();
        HashSet<ID> changedGroups = new HashSet<ID>();
        NeighborTable neighborTable = this;
        synchronized (neighborTable) {
            for (ID groupID : this.childrenMap.keySet()) {
                Set<Neighbor> childrenSet = this.childrenMap.get(groupID);
                if (childrenSet.remove(new Neighbor(child))) {
                    changedGroups.add(groupID);
                }
                if (childrenSet.isEmpty()) {
                    noChildGroupSet.add(groupID);
                    this.cachedChildrenMap.remove(groupID);
                    continue;
                }
                IDAddressPair[] cachedChildren = new IDAddressPair[childrenSet.size()];
                int i = 0;
                for (Neighbor n : childrenSet) {
                    cachedChildren[i++] = n.getIDAddressPair();
                }
                this.cachedChildrenMap.put(groupID, cachedChildren);
            }
            for (ID noChildGroup : noChildGroupSet) {
                this.childrenMap.remove(noChildGroup);
                if (this.mcast.joinedGroupSet.contains(noChildGroup)) continue;
                this.mcast.disconnectParent(noChildGroup);
            }
        }
        return changedGroups;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        NeighborTable neighborTable = this;
        synchronized (neighborTable) {
            this.parentMap.clear();
            this.childrenMap.clear();
            this.cachedChildrenMap.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Set<ID> expire() {
        long threshold = System.currentTimeMillis() - this.expiration;
        HashSet<ID> changedGroups = new HashSet<ID>();
        HashSet<ID> noChildGroupSet = new HashSet<ID>();
        NeighborTable neighborTable = this;
        synchronized (neighborTable) {
            for (ID groupID : this.childrenMap.keySet()) {
                int nChildren;
                Set<Neighbor> childrenSet = this.childrenMap.get(groupID);
                boolean cacheToBeUpdated = false;
                HashSet<Neighbor> expiredChildrenSet = new HashSet<Neighbor>();
                for (Neighbor child : childrenSet) {
                    if (threshold < child.getUpdatedTime()) continue;
                    expiredChildrenSet.add(child);
                    changedGroups.add(groupID);
                    cacheToBeUpdated = true;
                    this.receiver.getMessagingReporter().notifyStatCollectorOfDisconnectNodes(this.mcast.getSelfIDAddressPair(), child.getIDAddressPair().getID(), this.mcast.getSelfIDAddressPair().getID(), groupID.hashCode());
                }
                childrenSet.removeAll(expiredChildrenSet);
                if (childrenSet.isEmpty()) {
                    noChildGroupSet.add(groupID);
                    continue;
                }
                if (!cacheToBeUpdated || (nChildren = childrenSet.size()) <= 0) continue;
                IDAddressPair[] cachedChildren = new IDAddressPair[nChildren];
                int i = 0;
                for (Neighbor n : childrenSet) {
                    cachedChildren[i++] = n.getIDAddressPair();
                }
                this.cachedChildrenMap.put(groupID, cachedChildren);
            }
            for (ID noChildGroup : noChildGroupSet) {
                this.childrenMap.remove(noChildGroup);
                this.cachedChildrenMap.remove(noChildGroup);
                this.mcast.disconnectParent(noChildGroup);
            }
        }
        neighborTable = this;
        synchronized (neighborTable) {
            Set<ID> keySet = this.parentMap.keySet();
            ID[] keySetArray = new ID[keySet.size()];
            keySet.toArray(keySetArray);
            ID[] iDArray = keySetArray;
            int n = keySetArray.length;
            int n2 = 0;
            while (n2 < n) {
                ID groupID = iDArray[n2];
                Neighbor parent = this.parentMap.get(groupID);
                if (parent != null && threshold >= parent.getUpdatedTime()) {
                    this.mcast.disconnectParent(groupID, parent.getIDAddressPair());
                }
                ++n2;
            }
        }
        return changedGroups;
    }
}

