/*
 * Decompiled with CFR 0.152.
 */
package ow.messaging;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.channels.ByteChannel;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import ow.id.IDAddressPair;
import ow.messaging.Signature;
import ow.messaging.Tag;

public class Message
implements Serializable,
Cloneable {
    private static final Logger logger = Logger.getLogger("messaging");
    public static final boolean GZIP_MESSAGE = true;
    private byte[] signature;
    private final int tag;
    private IDAddressPair src;
    private final Serializable[] contents;

    public Message(IDAddressPair src, int tag, Serializable ... contents) {
        this(null, src, tag, contents);
    }

    private Message(byte[] signature, IDAddressPair src, int tag, Serializable ... contents) {
        this.signature = signature;
        this.src = src;
        this.tag = tag;
        this.contents = new Serializable[contents.length];
        System.arraycopy(contents, 0, this.contents, 0, contents.length);
    }

    protected Message() {
        this.tag = -1;
        this.contents = null;
    }

    public IDAddressPair getSource() {
        return this.src;
    }

    public IDAddressPair setSource(IDAddressPair src) {
        IDAddressPair old = this.src;
        this.src = src;
        return old;
    }

    public byte[] setSignature(byte[] sig) {
        byte[] old = this.signature;
        this.signature = sig;
        return old;
    }

    public byte[] getSignature() {
        return this.signature;
    }

    public int getTag() {
        return this.tag;
    }

    public Serializable[] getContents() {
        return this.contents;
    }

    public void setContents(int i, Serializable c) {
        this.contents[i] = c;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Message {src:");
        sb.append(this.src);
        sb.append(",tag:");
        sb.append(Tag.getNameByNumber(this.tag));
        sb.append(",#contents:");
        sb.append(this.contents.length);
        sb.append("}");
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ByteBuffer encode(ByteChannel out, Message msg) throws IOException {
        logger.log(Level.INFO, "tag:" + Tag.getNameByNumber(msg.tag) + " # of contents:" + msg.contents.length);
        ByteBuffer buf = Message.encode(msg);
        try {
            ByteChannel byteChannel = out;
            synchronized (byteChannel) {
                do {
                    out.write(buf);
                } while (buf.hasRemaining());
            }
        }
        catch (IOException e) {
            logger.log(Level.WARNING, "Could not write a message.");
            throw e;
        }
        buf.rewind();
        return buf;
    }

    public static ByteBuffer encode(Message msg) {
        ByteArrayOutputStream bos;
        OutputStream os = bos = new ByteArrayOutputStream();
        try {
            os = new GZIPOutputStream(os);
            ObjectOutputStream oos = new ObjectOutputStream(os);
            oos.writeObject(msg.src);
            Serializable[] serializableArray = msg.contents;
            int n = msg.contents.length;
            int n2 = 0;
            while (n2 < n) {
                Serializable c = serializableArray[n2];
                oos.writeObject(c);
                ++n2;
            }
            oos.flush();
            oos.close();
        }
        catch (IOException e) {
            logger.log(Level.SEVERE, "Serialization failed: " + Tag.getNameByNumber(msg.getTag()));
        }
        byte[] srcAndContents = bos.toByteArray();
        int signatureLen = Signature.getSignatureLength();
        ByteBuffer buf = ByteBuffer.allocate(signatureLen + 6 + srcAndContents.length);
        if (msg.signature != null) {
            buf.put(msg.signature, 0, signatureLen);
        } else {
            buf.put(new byte[signatureLen]);
        }
        buf.put((byte)msg.tag);
        buf.putInt(srcAndContents.length);
        buf.put((byte)msg.contents.length);
        buf.put(srcAndContents);
        buf.rewind();
        return buf;
    }

    public static Message decode(ByteChannel in) throws IOException {
        int signatureLen = Signature.getSignatureLength();
        int toBeRead = signatureLen + 6;
        ByteBuffer buf = ByteBuffer.allocate(toBeRead);
        Message.readIntoBuffer(in, buf);
        byte[] signature = new byte[signatureLen];
        buf.get(signature, 0, signatureLen);
        int tag = buf.get() & 0xFF;
        int len = buf.getInt();
        int argCount = buf.get() & 0xFF;
        buf = ByteBuffer.allocate(len);
        Message.readIntoBuffer(in, buf);
        byte[] srcAndContent = new byte[len];
        buf.get(srcAndContent);
        InputStream is = new ByteArrayInputStream(srcAndContent);
        is = new GZIPInputStream(is);
        ObjectInputStream ois = new ObjectInputStream(is);
        IDAddressPair src = null;
        Serializable[] contents = new Serializable[argCount];
        try {
            src = (IDAddressPair)ois.readObject();
            int i = 0;
            while (i < argCount) {
                contents[i] = (Serializable)ois.readObject();
                ++i;
            }
        }
        catch (ClassNotFoundException e) {
            logger.log(Level.SEVERE, "Class not found: " + e);
            throw new IOException("Class not found: " + e);
        }
        ois.close();
        return new Message(signature, src, tag, contents);
    }

    private static void readIntoBuffer(ByteChannel in, ByteBuffer buf) throws IOException {
        int len = buf.capacity();
        try {
            int r;
            do {
                if ((r = in.read(buf)) >= 0) continue;
                logger.log(Level.INFO, "Reached end-of-stream.");
                throw new IOException("End-of-stream.");
            } while ((len -= r) > 0);
            buf.rewind();
        }
        catch (IOException e) {
            logger.log(Level.WARNING, "Could not read a message.");
            throw e;
        }
    }

    public static Message decode(ByteBuffer buf) throws IOException {
        buf.mark();
        int signatureLen = Signature.getSignatureLength();
        byte[] signature = new byte[signatureLen];
        buf.get(signature, 0, signatureLen);
        int tag = buf.get() & 0xFF;
        int len = buf.getInt();
        int argCount = buf.get() & 0xFF;
        byte[] srcAndContent = new byte[len];
        buf.get(srcAndContent);
        buf.reset();
        IDAddressPair src = null;
        Serializable[] contents = new Serializable[argCount];
        InputStream is = new ByteArrayInputStream(srcAndContent);
        try {
            is = new GZIPInputStream(is);
            ObjectInputStream ois = new ObjectInputStream(is);
            src = (IDAddressPair)ois.readObject();
            int i = 0;
            while (i < argCount) {
                contents[i] = (Serializable)ois.readObject();
                ++i;
            }
            ois.close();
        }
        catch (IOException e) {
            logger.log(Level.SEVERE, "An IOException thrown.", e);
            throw e;
        }
        catch (ClassNotFoundException e) {
            logger.log(Level.SEVERE, "Class not found.", e);
            throw new IOException("Class not found: " + e);
        }
        return new Message(signature, src, tag, contents);
    }

    public static Message decodeFromByteArray(byte[] data) throws IOException {
        ByteBuffer buf = ByteBuffer.allocate(data.length);
        buf.put(data);
        buf.rewind();
        return Message.decode(buf);
    }
}

