/*
 * Decompiled with CFR 0.152.
 */
package ow.messaging;

import java.security.NoSuchProviderException;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import ow.messaging.MessagingProvider;
import ow.messaging.distemulator.DEmuMessagingProvider;
import ow.messaging.emulator.EmuMessagingProvider;
import ow.messaging.tcp.TCPMessagingProvider;
import ow.messaging.udp.UDPMessagingProvider;
import ow.tool.emulator.RemoteControlPipeTable;

public final class MessagingFactory {
    private static final Logger logger = Logger.getLogger("messaging");
    private static final Class[] PROVIDERS = new Class[]{UDPMessagingProvider.class, TCPMessagingProvider.class, EmuMessagingProvider.class, DEmuMessagingProvider.class};
    public static final String EMULATOR_PROVIDER_NAME = "Emulator";
    public static final String DISTRIBUTED_EMULATOR_PROVIDER_NAME = "DistributedEmulator";
    private static boolean FORCE_EMULATOR = false;
    private static boolean FORCE_DISTRIBUTED_EMULATOR = false;
    public static int INITIAL_EMULATOR_HOST_ID = 0;
    public static RemoteControlPipeTable HOST_TABLE_FOR_DIST_EMULATOR = null;
    private static HashMap<String, MessagingProvider> providerTable = new HashMap();

    static {
        Class[] classArray = PROVIDERS;
        int n = PROVIDERS.length;
        int n2 = 0;
        while (n2 < n) {
            block4: {
                Object o;
                Class clazz = classArray[n2];
                try {
                    o = clazz.newInstance();
                }
                catch (Exception e) {
                    logger.log(Level.WARNING, "Could not instantiate an object of the class: " + clazz, e);
                    break block4;
                }
                if (o instanceof MessagingProvider) {
                    MessagingProvider provider = (MessagingProvider)o;
                    providerTable.put(provider.getName(), provider);
                }
            }
            ++n2;
        }
    }

    public static MessagingProvider getProvider(String messagingType, byte[] messageSignature) throws NoSuchProviderException {
        return MessagingFactory.getProvider(messagingType, messageSignature, false);
    }

    public static MessagingProvider getProvider(String messagingType, byte[] messageSignature, boolean notForced) throws NoSuchProviderException {
        MessagingProvider provider;
        if (!notForced) {
            if (FORCE_DISTRIBUTED_EMULATOR) {
                messagingType = DISTRIBUTED_EMULATOR_PROVIDER_NAME;
            } else if (FORCE_EMULATOR) {
                messagingType = EMULATOR_PROVIDER_NAME;
            }
        }
        if ((provider = providerTable.get(messagingType)) == null) {
            throw new NoSuchProviderException("No such provider: " + messagingType);
        }
        MessagingProvider substitutedProvider = provider.substitute();
        if (substitutedProvider != null) {
            provider = substitutedProvider;
        }
        if (messageSignature != null) {
            provider.setMessageSignature(messageSignature);
        }
        return provider;
    }

    public static void forceEmulator(int initialEmulatorHostID) {
        FORCE_EMULATOR = true;
        INITIAL_EMULATOR_HOST_ID = initialEmulatorHostID;
    }

    public static void forceDistributedEmulator(int initialEmulatorHostID, RemoteControlPipeTable hostTable) {
        FORCE_DISTRIBUTED_EMULATOR = true;
        INITIAL_EMULATOR_HOST_ID = initialEmulatorHostID;
        HOST_TABLE_FOR_DIST_EMULATOR = hostTable;
    }
}

