/*
 * Decompiled with CFR 0.152.
 */
package ow.messaging.emulator;

import java.io.IOException;
import java.util.Random;
import java.util.logging.Level;
import java.util.logging.Logger;
import ow.messaging.Message;
import ow.messaging.MessageSender;
import ow.messaging.MessagingAddress;
import ow.messaging.emulator.EmuMessageReceiver;
import ow.stat.MessagingReporter;

public final class EmuMessageSender
implements MessageSender {
    private static final Logger logger = Logger.getLogger("messaging");
    private static final Random random = new Random();
    private final EmuMessageReceiver receiver;

    protected EmuMessageSender(EmuMessageReceiver receiver) {
        this.receiver = receiver;
    }

    @Override
    public void send(MessagingAddress dest, Message msg) throws IOException {
        this.send0(dest, msg, false);
    }

    @Override
    public Message sendAndReceive(MessagingAddress dest, Message msg) throws IOException {
        return this.send0(dest, msg, true);
    }

    private Message send0(MessagingAddress dest, Message msg, boolean doReceive) throws IOException {
        EmuMessageReceiver receiver = EmuMessageReceiver.getReceiver(dest);
        if (receiver == null) {
            logger.log(Level.WARNING, "No such node: " + dest);
            MessagingReporter msgReporter = this.receiver.getMessagingReporter();
            if (msgReporter != null) {
                msgReporter.notifyStatCollectorOfDeletedNode(msg.getSource(), dest, msg.getTag());
            }
            throw new IOException("No such node: " + dest);
        }
        if (receiver.communicationCanFail && random.nextDouble() < receiver.config.getCommunicationFailureRate()) {
            if (doReceive) {
                try {
                    Thread.sleep(receiver.config.getStaticTimeout());
                }
                catch (InterruptedException msgReporter) {
                    // empty catch block
                }
                throw new IOException("failed to send to " + dest);
            }
            return null;
        }
        Message ret = receiver.processAMessage(msg);
        if (receiver.communicationCanFail && doReceive && random.nextDouble() < receiver.config.getCommunicationFailureRate()) {
            try {
                Thread.sleep(receiver.config.getStaticTimeout());
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            throw new IOException("failed to receive from " + dest);
        }
        MessagingReporter msgReporter = this.receiver.getMessagingReporter();
        if (msgReporter != null && !this.receiver.getSelfAddress().equals(dest)) {
            msgReporter.notifyStatCollectorOfMessageSent(dest, msg, 0);
        }
        return ret;
    }
}

