/*
 * Decompiled with CFR 0.152.
 */
package ow.messaging.emulator;

import ow.messaging.MessagingAddress;
import ow.messaging.emulator.EmuHostID;

public final class EmuMessagingAddress
implements MessagingAddress {
    private final EmuHostID host;
    private final int port;
    private final int hashCode;

    EmuMessagingAddress(EmuHostID host, int port) {
        this.host = host;
        this.port = port;
        this.hashCode = this.host.hashCode() ^ this.port;
    }

    @Override
    public String getHostAddress() {
        return this.host.toString();
    }

    @Override
    public String getHostname() {
        return this.host.toString();
    }

    @Override
    public String getHostnameOrHostAddress() {
        return this.host.toString();
    }

    @Override
    public int getPort() {
        return this.port;
    }

    public EmuHostID getEmuHostID() {
        return this.host;
    }

    public int hashCode() {
        return this.hashCode;
    }

    public boolean equals(Object o) {
        if (o instanceof EmuMessagingAddress) {
            EmuMessagingAddress other = (EmuMessagingAddress)o;
            if (this.host.equals(other.host) && this.port == other.port) {
                return true;
            }
        }
        return false;
    }

    public String toString() {
        return this.toString(0);
    }

    @Override
    public String toString(int verboseLevel) {
        StringBuilder sb = new StringBuilder();
        sb.append(this.host.toString());
        if (verboseLevel >= 0) {
            sb.append(":");
            sb.append(this.port);
        }
        return sb.toString();
    }
}

