/*
 * Decompiled with CFR 0.152.
 */
package ow.messaging.upnp;

public final class Mapping {
    private final int externalPort;
    private final String internalAddress;
    private final int internalPort;
    private final Protocol protocol;
    private final String description;

    public Mapping(int externalPort, String internalAddress, int internalPort, Protocol protocol, String description) {
        this.externalPort = externalPort;
        this.internalAddress = internalAddress;
        this.internalPort = internalPort;
        this.protocol = protocol;
        this.description = description;
    }

    public int getExternalPort() {
        return this.externalPort;
    }

    public String getInternalAddress() {
        return this.internalAddress;
    }

    public int getInternalPort() {
        return this.internalPort;
    }

    public Protocol getProtocol() {
        return this.protocol;
    }

    public String getDescription() {
        return this.description;
    }

    public int hashCode() {
        return (this.protocol.ordinal() << 16) + this.internalPort;
    }

    public boolean equals(Object o) {
        if (!(o instanceof Mapping)) {
            return false;
        }
        Mapping m = (Mapping)o;
        return m.hashCode() == this.hashCode();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{external port:").append(this.externalPort);
        sb.append(", internal port:").append(this.internalPort);
        sb.append(", internal addr:").append(this.internalAddress);
        sb.append(", protocol:").append((Object)this.protocol);
        if (this.description != null) {
            sb.append(", desc:").append(this.description);
        }
        sb.append("}");
        return sb.toString();
    }

    public static enum Protocol {
        UDP,
        TCP;

    }
}

