/*
 * Decompiled with CFR 0.152.
 */
package ow.messaging.util;

import java.io.BufferedReader;
import java.io.CharArrayReader;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;

public class AccessController {
    private List<AccessControlEntry> aclist = new ArrayList<AccessControlEntry>();

    public AccessController(String filename) throws IOException {
        this.parse(filename);
    }

    public AccessController(Reader in) throws IOException {
        this.parse(in);
    }

    public AccessController(char[] acList) throws IOException {
        this(new CharArrayReader(acList));
    }

    public AccessController() {
    }

    public void parse(String filename) throws IOException {
        FileReader in = new FileReader(filename);
        this.parse(in);
    }

    public void parse(Reader rawIn) throws IOException {
        String line;
        BufferedReader in = new BufferedReader(rawIn);
        while ((line = in.readLine()) != null) {
            boolean allow;
            StringTokenizer st;
            int nTokens;
            if (line.startsWith("#") || line.startsWith(";") || line.startsWith("//") || (nTokens = (st = new StringTokenizer(line, " ,\t\n\r")).countTokens()) <= 0) continue;
            String[] args = new String[nTokens];
            int i = 0;
            while (st.hasMoreTokens()) {
                args[i++] = st.nextToken();
            }
            if ("allow".equalsIgnoreCase(args[0])) {
                allow = true;
            } else if ("deny".equalsIgnoreCase(args[0])) {
                allow = false;
            } else {
                throw new IOException("1st arg of a line has to be \"allow\" or \"deny\": " + args[0]);
            }
            InetAddress address = null;
            int netmask = -1;
            if (args.length >= 2) {
                String host = args[1];
                int slashIndex = host.indexOf(47);
                if (slashIndex >= 0) {
                    netmask = Integer.parseInt(host.substring(slashIndex + 1));
                    host = host.substring(0, slashIndex);
                }
                address = InetAddress.getByName(host);
            }
            AccessControlEntry entry = new AccessControlEntry(allow, address, netmask);
            this.aclist.add(entry);
        }
    }

    public boolean allow(InetAddress remoteAddress) {
        for (AccessControlEntry entry : this.aclist) {
            if (!entry.match(remoteAddress)) continue;
            return entry.allow();
        }
        return false;
    }

    private static class AccessControlEntry {
        private boolean allow;
        private InetAddress address;
        private byte[] addressBytes;
        private int netmask;

        AccessControlEntry(boolean allow, InetAddress address, int netmask) {
            this.allow = allow;
            this.address = address;
            this.netmask = netmask;
            if (address != null) {
                this.addressBytes = address.getAddress();
                int maskMaxLen = this.addressBytes.length << 3;
                if (this.netmask > maskMaxLen || this.netmask < 0) {
                    this.netmask = maskMaxLen;
                }
            }
        }

        AccessControlEntry(boolean allow, InetAddress address) {
            this(allow, address, -1);
            this.netmask = this.addressBytes.length << 3;
        }

        AccessControlEntry(boolean allow) {
            this(allow, null, -1);
        }

        public boolean match(InetAddress remoteAddress) {
            if (this.address == null) {
                return true;
            }
            int maskByteLen = this.netmask >> 3;
            int maskBitLen = this.netmask & 7;
            byte[] sourceBytes = remoteAddress.getAddress();
            int i = 0;
            while (i < maskByteLen) {
                if (this.addressBytes[i] != sourceBytes[i]) {
                    return false;
                }
                ++i;
            }
            return maskBitLen <= 0 || (this.addressBytes[i] & 0xFF) >>> 8 - maskBitLen == (sourceBytes[i] & 0xFF) >>> 8 - maskBitLen;
        }

        public boolean allow() {
            return this.allow;
        }
    }
}

