/*
 * Decompiled with CFR 0.152.
 */
package ow.messaging.util;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;

public class MessagingUtility {
    public static HostAndPort parseHostnameAndPort(String hostAndPort) {
        return MessagingUtility.parseHostnameAndPort(hostAndPort, -1);
    }

    public static HostAndPort parseHostnameAndPort(String hostAndPort, int defaultPort) {
        String host;
        int port;
        int index = hostAndPort.indexOf(58);
        if (index < 0) {
            index = hostAndPort.indexOf(47);
        }
        if (index >= 0) {
            try {
                port = Integer.parseInt(hostAndPort.substring(index + 1, hostAndPort.length()));
            }
            catch (NumberFormatException e) {
                port = defaultPort;
            }
            host = index > 0 ? hostAndPort.substring(0, index) : null;
        } else {
            try {
                port = Integer.parseInt(hostAndPort);
                host = null;
            }
            catch (NumberFormatException e) {
                host = hostAndPort;
                port = defaultPort;
            }
        }
        if (port < 0 || port > 65535) {
            throw new IllegalArgumentException("port number is not specified or invalid: " + hostAndPort + ", " + port);
        }
        return new HostAndPort(host, port);
    }

    public static class HostAndPort {
        String hostname;
        int port;
        InetAddress cachedHostAddress = null;

        public HostAndPort(String hostname, int port) {
            this.hostname = hostname;
            this.port = port;
        }

        public String getHostName() {
            return this.hostname;
        }

        public int getPort() {
            return this.port;
        }

        public synchronized InetAddress getHostAddress() throws UnknownHostException {
            if (this.cachedHostAddress == null) {
                this.cachedHostAddress = this.hostname == null ? InetAddress.getLocalHost() : InetAddress.getByName(this.hostname);
            }
            return this.cachedHostAddress;
        }

        public InetSocketAddress getInetSocketAddress() throws UnknownHostException {
            return new InetSocketAddress(this.getHostAddress(), this.port);
        }

        public int hashCode() {
            return this.hostname.hashCode() ^ this.port;
        }

        public boolean equals(Object o) {
            if (o instanceof HostAndPort) {
                HostAndPort hp = (HostAndPort)o;
                if (this.hostname.equals(hp.hostname) && this.port == hp.port) {
                    return true;
                }
            }
            return false;
        }

        public String toString() {
            return String.valueOf(this.hostname) + ":" + this.port;
        }
    }
}

