/*
 * Decompiled with CFR 0.152.
 */
package ow.oasis;

import java.io.IOException;
import java.io.OutputStream;
import java.net.ServerSocket;
import java.net.Socket;
import ow.messaging.util.AccessControlledServerSocket;
import ow.messaging.util.AccessController;

public final class OASISResponder
implements Runnable {
    public static final byte[] SERVICE_ID = new byte[]{79, 87, 86, 82};
    public static final int LOAD = 1;
    public static final int CAPACITY = 10;
    private static final byte[] RESPONSE = new byte[12];
    public static final boolean DO_ACCESS_CONTROL = false;
    public static final String ACCESS_CONTROL_LIST = "allow 127.0.0.1\ndeny\n";
    public static final AccessController ac;
    private final ServerSocket servSock;

    static {
        System.arraycopy(SERVICE_ID, 0, RESPONSE, 0, SERVICE_ID.length);
        int i = 0;
        while (i < 4) {
            OASISResponder.RESPONSE[4 + i] = (byte)(1 >>> (3 - i << 3));
            OASISResponder.RESPONSE[8 + i] = (byte)(10 >>> (3 - i << 3));
            ++i;
        }
        ac = null;
    }

    public OASISResponder(int port) throws IOException {
        this.servSock = new AccessControlledServerSocket(ac, port);
    }

    @Override
    public void run() {
        try {
            while (true) {
                Socket sock = this.servSock.accept();
                OutputStream out = sock.getOutputStream();
                out.write(RESPONSE);
                out.flush();
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                sock.close();
            }
        }
        catch (IOException e) {
            try {
                if (this.servSock != null) {
                    this.servSock.close();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return;
        }
    }

    public static void main(String[] args) throws IOException {
        OASISResponder s = new OASISResponder(10000);
        Thread t = new Thread(s);
        t.start();
    }
}

