/*
 * Decompiled with CFR 0.152.
 */
package ow.routing.impl;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.logging.Level;
import ow.id.ID;
import ow.id.IDAddressPair;
import ow.messaging.Message;
import ow.messaging.MessageHandler;
import ow.messaging.MessageReceiver;
import ow.messaging.MessagingAddress;
import ow.messaging.MessagingProvider;
import ow.messaging.Tag;
import ow.routing.CallbackResultFilter;
import ow.routing.RoutingAlgorithmConfiguration;
import ow.routing.RoutingAlgorithmProvider;
import ow.routing.RoutingContext;
import ow.routing.RoutingException;
import ow.routing.RoutingHop;
import ow.routing.RoutingResult;
import ow.routing.RoutingServiceConfiguration;
import ow.routing.impl.AbstractRoutingDriver;
import ow.routing.impl.ContactList;
import ow.routing.impl.InsertedOrderContactList;
import ow.routing.impl.RoutingDriverMessageFactory;
import ow.routing.impl.SortedContactList;
import ow.stat.MessagingReporter;
import ow.util.concurrent.GlobalThreadPoolExecutors;

public final class IterativeRoutingDriver
extends AbstractRoutingDriver {
    protected IterativeRoutingDriver(RoutingServiceConfiguration conf, MessagingProvider provider, MessageReceiver receiver, RoutingAlgorithmProvider algoProvider, RoutingAlgorithmConfiguration algoConf, ID selfID) throws IOException {
        super(conf, provider, receiver, algoProvider, algoConf, selfID);
        this.prepareHandlers();
    }

    @Override
    public RoutingResult[] routeToRootNode(ID[] target, int numRootCandidates) {
        return this.route(this.adjustLastHop, Tag.ITE_ROUTE_NONE, target, numRootCandidates, null, null, -1, null, null);
    }

    @Override
    public RoutingResult[] routeToClosestNode(ID[] target, int numRootCandidates) {
        return this.route(false, Tag.ITE_ROUTE_NONE, target, numRootCandidates, null, null, -1, null, null);
    }

    @Override
    public RoutingResult[] invokeCallbacksOnRoute(ID[] target, int numRootCandidates, Serializable[][] returnedValue, CallbackResultFilter filter, int tag, Serializable[][] args) {
        return this.route(this.adjustLastHop, Tag.ITE_ROUTE_INVOKE, target, numRootCandidates, filter, returnedValue, tag, args, null);
    }

    @Override
    public RoutingResult join(MessagingAddress initialContact) throws RoutingException {
        ID[] tgts = new ID[]{this.getSelfIDAddressPair().getID()};
        RoutingResult[] res = this.route(this.adjustLastHop, Tag.ITE_ROUTE_JOIN, tgts, this.config.getNumOfRootCandidatesRequestedWhenJoining(), null, null, -1, null, initialContact);
        if (res == null || res[0] == null) {
            throw new RoutingException();
        }
        this.algorithm.join(res[0].getRootCandidates());
        return res[0];
    }

    private RoutingResult[] route(boolean adjustLastHop, Tag msgType, ID[] target, int numRootCandidates, CallbackResultFilter filter, Serializable[][] resultingCallbackResult, int callbackTag, Serializable[][] callbackArgs, MessagingAddress joinInitialContact) {
        if (numRootCandidates < 1) {
            numRootCandidates = 1;
        }
        int queryConcurrency = this.config.getQueryConcurrency();
        if (!this.queryToAllContacts || msgType == Tag.ITE_ROUTE_JOIN || queryConcurrency <= 0) {
            queryConcurrency = 1;
        }
        List[] route = new List[target.length];
        int i = 0;
        while (i < target.length) {
            route[i] = new ArrayList();
            if (queryConcurrency > 2) {
                route[i] = Collections.synchronizedList(route[i]);
            }
            route[i].add(RoutingHop.newInstance(this.getSelfIDAddressPair()));
            ++i;
        }
        Set<MessagingAddress> blackList = Collections.synchronizedSet(new HashSet());
        if (msgType != Tag.ITE_ROUTE_JOIN) {
            MessagingReporter msgReporter = this.receiver.getMessagingReporter();
            msgReporter.notifyStatCollectorOfEmphasizeNode(this.getSelfIDAddressPair(), this.getSelfIDAddressPair().getID());
            msgReporter.notifyStatCollectorOfMarkedID(this.getSelfIDAddressPair(), target, 0);
        }
        ContactList[] contactList = new ContactList[target.length];
        int i2 = 0;
        while (i2 < target.length) {
            contactList[i2] = this.queryToAllContacts ? new SortedContactList(target[i2], this.algorithm, this.config.getNumOfNodesMaintained()) : new InsertedOrderContactList();
            ++i2;
        }
        if (msgType == Tag.ITE_ROUTE_JOIN) {
            contactList[0].add(IDAddressPair.getIDAddressPair(null, joinInitialContact));
        } else {
            i2 = 0;
            while (i2 < target.length) {
                IDAddressPair[] closestNodes;
                RoutingContext initialRoutingContext = this.algorithm.initialRoutingContext(target[i2]);
                IDAddressPair[] iDAddressPairArray = closestNodes = this.algorithm.closestTo(target[i2], this.config.getNumOfClosestNodesRequested(), initialRoutingContext);
                int n = closestNodes.length;
                int n2 = 0;
                while (n2 < n) {
                    IDAddressPair elem = iDAddressPairArray[n2];
                    if (elem != null) {
                        contactList[i2].add(elem);
                    }
                    ++n2;
                }
                ++i2;
            }
        }
        RoutingResultTable<IDAddressPair[]> rootCandidateTable = new RoutingResultTable<IDAddressPair[]>();
        RoutingResultTable<Serializable> callbackResultTable = null;
        if (msgType == Tag.ITE_ROUTE_INVOKE) {
            callbackResultTable = new RoutingResultTable<Serializable>();
        }
        Querier querier = new Querier(target, numRootCandidates, this.config.getTTL(), msgType, adjustLastHop, route, contactList, null, blackList, joinInitialContact, callbackTag, callbackArgs, filter, rootCandidateTable, callbackResultTable);
        Future<Boolean> f = null;
        Thread t = null;
        boolean timeout = false;
        try {
            if (this.config.getUseThreadPool()) {
                ExecutorService ex = GlobalThreadPoolExecutors.getThreadPool(false, false, Thread.currentThread().isDaemon());
                f = ex.submit(querier);
                f.get(this.config.getRoutingTimeout(), TimeUnit.MILLISECONDS);
            } else {
                t = new Thread(querier);
                t.setName("Querier");
                t.setDaemon(Thread.currentThread().isDaemon());
                t.start();
                t.join(this.config.getRoutingTimeout());
                if (t.isAlive()) {
                    timeout = true;
                }
            }
        }
        catch (ExecutionException e) {
            Throwable cause = e.getCause();
            logger.log(Level.WARNING, "A Querier threw an Exception.", cause != null ? cause : e);
        }
        catch (InterruptedException e) {
            logger.log(Level.WARNING, "Querier#call() interrupted on " + this.getSelfIDAddressPair().getAddress());
        }
        catch (TimeoutException e) {
            logger.log(Level.WARNING, "Routing timeout on " + this.getSelfIDAddressPair().getAddress());
            timeout = true;
        }
        catch (OutOfMemoryError e) {
            logger.log(Level.SEVERE, "# of threads: " + Thread.activeCount(), e);
            throw e;
        }
        if (timeout) {
            if (f != null) {
                f.cancel(true);
            } else if (t != null) {
                t.interrupt();
            }
            rootCandidateTable.clear();
        }
        int i3 = 0;
        while (i3 < target.length) {
            IDAddressPair contact = contactList[i3].first();
            if (msgType == Tag.ITE_ROUTE_JOIN) {
                while (contact != null && this.getSelfIDAddressPair().equals(contact)) {
                    contactList[i3].remove(contact);
                    contact = contactList[i3].first();
                }
            }
            ++i3;
        }
        RoutingResult[] ret = new RoutingResult[target.length];
        int i4 = 0;
        while (i4 < target.length) {
            IDAddressPair goal = this.queryToAllContacts ? contactList[i4].first() : ((RoutingHop)route[i4].get(route[i4].size() - 1)).getIDAddressPair().getIDAddressPair();
            boolean isRootNode = this.getSelfIDAddressPair().equals(goal);
            if (msgType == Tag.ITE_ROUTE_INVOKE) {
                Serializable res = this.invokeCallbacks(target[i4], callbackTag, callbackArgs[i4], filter, null, isRootNode);
                callbackResultTable.put(target[i4], this.getSelfIDAddressPair(), res);
            } else if (msgType == Tag.ITE_ROUTE_JOIN) {
                this.algorithm.join(this.getSelfIDAddressPair(), null, isRootNode);
            }
            IDAddressPair[] rootCandidates = rootCandidateTable.get(target[i4], goal);
            if (rootCandidates != null) {
                RoutingHop[] routeArray = new RoutingHop[route[i4].size()];
                route[i4].toArray(routeArray);
                ret[i4] = new RoutingResult(routeArray, rootCandidates);
                if (callbackResultTable != null && resultingCallbackResult != null && resultingCallbackResult[i4] != null) {
                    resultingCallbackResult[i4][0] = callbackResultTable.get(target[i4], goal);
                }
            }
            ++i4;
        }
        return ret;
    }

    private boolean ttlCheck(int ttl, ID[] target, List<RoutingHop> route) {
        if (ttl <= 0) {
            StringBuilder sb = new StringBuilder();
            sb.append("TTL expired (target");
            ID[] iDArray = target;
            int n = target.length;
            int n2 = 0;
            while (n2 < n) {
                ID t = iDArray[n2];
                sb.append(" ").append(t.toString().substring(0, 6));
                ++n2;
            }
            sb.append("):");
            for (RoutingHop n3 : route) {
                sb.append(" ");
                sb.append(n3.getIDAddressPair().getAddress().getHostname());
            }
            logger.log(Level.WARNING, sb.toString(), new Throwable());
            return true;
        }
        return false;
    }

    private void prepareHandlers() {
        MessageHandler handler = new MessageHandler(){

            @Override
            public Message process(Message msg) {
                boolean routing;
                ID[] target;
                int numClosestNodes = 1;
                int numRootCandidates = 1;
                RoutingContext[] routingContext = null;
                CallbackResultFilter filter = null;
                int tag = -1;
                Serializable[][] args = null;
                IDAddressPair[] lastHop = null;
                IDAddressPair joiningNode = null;
                Serializable[] contents = msg.getContents();
                if (msg.getTag() == Tag.ITE_ROUTE_NONE.getNumber()) {
                    target = (ID[])contents[0];
                    numClosestNodes = (Integer)contents[1];
                    numRootCandidates = (Integer)contents[2];
                    routingContext = (RoutingContext[])contents[3];
                    routing = true;
                } else if (msg.getTag() == Tag.ITE_ROUTE_INVOKE.getNumber()) {
                    target = (ID[])contents[0];
                    numClosestNodes = (Integer)contents[1];
                    numRootCandidates = (Integer)contents[2];
                    routingContext = (RoutingContext[])contents[3];
                    filter = (CallbackResultFilter)contents[4];
                    tag = (Integer)contents[5];
                    args = (Serializable[][])contents[6];
                    lastHop = (IDAddressPair[])contents[7];
                    routing = true;
                } else if (msg.getTag() == Tag.ITE_ROUTE_JOIN.getNumber()) {
                    joiningNode = (IDAddressPair)contents[0];
                    target = new ID[]{joiningNode.getID()};
                    numClosestNodes = (Integer)contents[1];
                    numRootCandidates = (Integer)contents[2];
                    routingContext = (RoutingContext[])contents[3];
                    lastHop = (IDAddressPair[])contents[4];
                    routing = true;
                } else if (msg.getTag() == Tag.ITE_TERMINATE_NONE.getNumber()) {
                    target = (ID[])contents[0];
                    numRootCandidates = (Integer)contents[1];
                    routing = false;
                } else if (msg.getTag() == Tag.ITE_TERMINATE_INVOKE.getNumber()) {
                    target = (ID[])contents[0];
                    numRootCandidates = (Integer)contents[1];
                    filter = (CallbackResultFilter)contents[2];
                    tag = (Integer)contents[3];
                    args = (Serializable[][])contents[4];
                    lastHop = (IDAddressPair[])contents[5];
                    routing = false;
                } else {
                    joiningNode = (IDAddressPair)contents[0];
                    target = new ID[]{joiningNode.getID()};
                    numRootCandidates = (Integer)contents[1];
                    lastHop = (IDAddressPair[])contents[2];
                    routing = false;
                }
                boolean[] isRootNode = new boolean[target.length];
                IDAddressPair[][] closestNodes = new IDAddressPair[target.length][];
                IDAddressPair[][] adjustedLastHops = new IDAddressPair[target.length][];
                if (routingContext == null) {
                    routingContext = new RoutingContext[target.length];
                }
                int i = 0;
                while (i < target.length) {
                    if (routing) {
                        if (routingContext[i] == null) {
                            routingContext[i] = IterativeRoutingDriver.this.algorithm.initialRoutingContext(target[i]);
                        }
                        closestNodes[i] = IterativeRoutingDriver.this.algorithm.closestTo(target[i], numClosestNodes, routingContext[i]);
                        boolean bl = isRootNode[i] = closestNodes[i][0] != null && closestNodes[i][0].equals(IterativeRoutingDriver.this.getSelfIDAddressPair());
                        if (isRootNode[i]) {
                            adjustedLastHops[i] = IterativeRoutingDriver.this.algorithm.adjustRoot(target[i]);
                            if (adjustedLastHops[i] != null) {
                                isRootNode[i] = adjustedLastHops[i][0].equals(IterativeRoutingDriver.this.getSelfIDAddressPair());
                            }
                        }
                    } else {
                        isRootNode[i] = true;
                    }
                    ++i;
                }
                IterativeRoutingDriver.this.algorithm.touch(msg.getSource());
                if (lastHop != null) {
                    IDAddressPair[] iDAddressPairArray = lastHop;
                    int n = lastHop.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IDAddressPair p = iDAddressPairArray[n2];
                        if (p != null && !p.equals(IterativeRoutingDriver.this.getSelfIDAddressPair())) {
                            IterativeRoutingDriver.this.algorithm.touch(p);
                        }
                        ++n2;
                    }
                }
                Serializable[] callbackResult = new Serializable[target.length];
                if (msg.getTag() == Tag.ITE_ROUTE_INVOKE.getNumber() || msg.getTag() == Tag.ITE_TERMINATE_INVOKE.getNumber()) {
                    int i2 = 0;
                    while (i2 < target.length) {
                        callbackResult[i2] = IterativeRoutingDriver.this.invokeCallbacks(target[i2], tag, args[i2], filter, lastHop[i2], isRootNode[i2]);
                        if (callbackResult[i2] != null) {
                            logger.log(Level.INFO, "A callback returned non-null object: " + callbackResult);
                        }
                        ++i2;
                    }
                } else if (msg.getTag() == Tag.ITE_ROUTE_JOIN.getNumber() || msg.getTag() == Tag.ITE_TERMINATE_JOIN.getNumber()) {
                    final IDAddressPair copiedJoiningNode = joiningNode;
                    final IDAddressPair[] copiedLastHop = new IDAddressPair[lastHop.length];
                    System.arraycopy(lastHop, 0, copiedLastHop, 0, lastHop.length);
                    final boolean[] copiedIsRootNode = isRootNode;
                    Runnable r = new Runnable(){

                        @Override
                        public void run() {
                            int i = 0;
                            while (i < copiedLastHop.length) {
                                (this).IterativeRoutingDriver.this.algorithm.join(copiedJoiningNode, copiedLastHop[i], copiedIsRootNode[i]);
                                ++i;
                            }
                        }
                    };
                    try {
                        if (IterativeRoutingDriver.this.config.getUseThreadPool()) {
                            ExecutorService ex = GlobalThreadPoolExecutors.getThreadPool(false, false, Thread.currentThread().isDaemon());
                            ex.submit(r);
                        }
                        Thread t = new Thread(r);
                        t.setName("Message type specific processes");
                        t.setDaemon(Thread.currentThread().isDaemon());
                        t.start();
                    }
                    catch (OutOfMemoryError e) {
                        logger.log(Level.SEVERE, "# of threads: " + Thread.activeCount(), e);
                        throw e;
                    }
                }
                IDAddressPair[][] rootCandidates = new IDAddressPair[target.length][];
                int i3 = 0;
                while (i3 < target.length) {
                    rootCandidates[i3] = IterativeRoutingDriver.this.algorithm.rootCandidates(target[i3], numRootCandidates);
                    ++i3;
                }
                return RoutingDriverMessageFactory.getIteReplyMessage(IterativeRoutingDriver.this.getSelfIDAddressPair(), closestNodes, rootCandidates, callbackResult);
            }
        };
        this.addMessageHandler(Tag.ITE_ROUTE_NONE.getNumber(), handler);
        this.addMessageHandler(Tag.ITE_ROUTE_INVOKE.getNumber(), handler);
        this.addMessageHandler(Tag.ITE_ROUTE_JOIN.getNumber(), handler);
        this.addMessageHandler(Tag.ITE_TERMINATE_NONE.getNumber(), handler);
        this.addMessageHandler(Tag.ITE_TERMINATE_INVOKE.getNumber(), handler);
        this.addMessageHandler(Tag.ITE_TERMINATE_JOIN.getNumber(), handler);
        handler = new MessageHandler(){

            @Override
            public Message process(Message msg) {
                Serializable[] contents = msg.getContents();
                ID[] target = (ID[])contents[0];
                IDAddressPair[][] adjustedLastHops = new IDAddressPair[target.length][];
                int i = 0;
                while (i < target.length) {
                    adjustedLastHops[i] = IterativeRoutingDriver.this.algorithm.adjustRoot(target[i]);
                    ++i;
                }
                Message repMsg = RoutingDriverMessageFactory.getIteAdjustLastHopRep(IterativeRoutingDriver.this.getSelfIDAddressPair(), adjustedLastHops);
                return repMsg;
            }
        };
        this.addMessageHandler(Tag.ITE_ADJUST_LAST_HOP_REQ.getNumber(), handler);
    }

    static /* synthetic */ boolean access$0(IterativeRoutingDriver iterativeRoutingDriver, int n, ID[] iDArray, List list) {
        return iterativeRoutingDriver.ttlCheck(n, iDArray, list);
    }

    static /* synthetic */ void access$1(IterativeRoutingDriver iterativeRoutingDriver, IDAddressPair iDAddressPair) {
        super.fail(iDAddressPair);
    }

    private final class Querier
    implements Runnable,
    Callable<Boolean> {
        private ID[] target;
        private final int numRootCandidates;
        private int ttl;
        private final Tag msgType;
        private final boolean adjustLastHop;
        private final List<RoutingHop>[] route;
        private ContactList[] contactList;
        private IDAddressPair[] lastContact;
        private final Set<MessagingAddress> blackList;
        private final MessagingAddress joinInitialContact;
        private final int callbackTag;
        private final Serializable[][] callbackArgs;
        private final CallbackResultFilter filter;
        private final RoutingResultTable<IDAddressPair[]> rootCandidateTable;
        private final RoutingResultTable<Serializable> callbackResultTable;

        Querier(ID[] target, int numRootCandidates, int ttl, Tag msgType, boolean adjustLastHop, List<RoutingHop>[] route, ContactList[] contactList, IDAddressPair[] lastContact, Set<MessagingAddress> blackList, MessagingAddress joinInitialContact, int callbackTag, Serializable[][] callbackArgs, CallbackResultFilter filter, RoutingResultTable<IDAddressPair[]> rootCandidateTable, RoutingResultTable<Serializable> callbackResultTable) {
            this.target = target;
            this.numRootCandidates = numRootCandidates;
            this.ttl = ttl;
            this.msgType = msgType;
            this.adjustLastHop = adjustLastHop;
            this.route = route;
            this.contactList = contactList;
            this.lastContact = lastContact;
            this.blackList = blackList;
            this.joinInitialContact = joinInitialContact;
            this.callbackTag = callbackTag;
            this.callbackArgs = callbackArgs;
            this.filter = filter;
            this.rootCandidateTable = rootCandidateTable;
            this.callbackResultTable = callbackResultTable;
        }

        @Override
        public void run() {
            try {
                this.call();
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "A Querier threw an exception.", e);
            }
        }

        /*
         * Exception decompiling
         */
        @Override
        public Boolean call() {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [53[UNCONDITIONALDOLOOP]], but top level block is 56[WHILELOOP]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }
    }

    private static final class RoutingResultTable<V> {
        private Map<Entry, V> table = new HashMap<Entry, V>();

        private RoutingResultTable() {
        }

        public synchronized void put(ID target, IDAddressPair node, V v) {
            this.table.put(new Entry(target, node), v);
        }

        public synchronized V get(ID target, IDAddressPair node) {
            return this.table.get(new Entry(target, node));
        }

        public synchronized void clear(ID target) {
            Set<Entry> keySet = this.table.keySet();
            Entry[] keyArray = new Entry[keySet.size()];
            this.table.keySet().toArray(keyArray);
            Entry[] entryArray = keyArray;
            int n = keyArray.length;
            int n2 = 0;
            while (n2 < n) {
                Entry e = entryArray[n2];
                if (target.equals(e.target)) {
                    this.table.remove(e);
                }
                ++n2;
            }
        }

        public synchronized void clear() {
            this.table.clear();
        }

        private final class Entry {
            private final ID target;
            private final IDAddressPair node;

            Entry(ID target, IDAddressPair node) {
                this.target = target;
                this.node = node.getIDAddressPair();
            }

            public int hashCode() {
                return this.target.hashCode() ^ this.node.hashCode();
            }

            public boolean equals(Object o) {
                Entry ent;
                try {
                    ent = (Entry)o;
                }
                catch (ClassCastException e) {
                    return false;
                }
                return this.target.equals(ent.target) && this.node.equals(ent.node);
            }
        }
    }
}

