/*
 * Decompiled with CFR 0.152.
 */
package ow.routing.impl;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.logging.Level;
import ow.id.ID;
import ow.id.IDAddressPair;
import ow.id.IDAddressRoutingContextTriplet;
import ow.messaging.Message;
import ow.messaging.MessageHandler;
import ow.messaging.MessageReceiver;
import ow.messaging.MessagingAddress;
import ow.messaging.MessagingProvider;
import ow.messaging.Tag;
import ow.routing.CallbackResultFilter;
import ow.routing.RoutingAlgorithmConfiguration;
import ow.routing.RoutingAlgorithmProvider;
import ow.routing.RoutingContext;
import ow.routing.RoutingException;
import ow.routing.RoutingHop;
import ow.routing.RoutingResult;
import ow.routing.RoutingServiceConfiguration;
import ow.routing.impl.AbstractRoutingDriver;
import ow.routing.impl.RoutingDriverMessageFactory;
import ow.util.concurrent.GlobalThreadPoolExecutors;

public final class RecursiveRoutingDriver
extends AbstractRoutingDriver {
    private final Message recAckMessage;
    private static final int TAG_NULL = -1;
    private Map<ID, Message> routeResultMsgTable = new HashMap<ID, Message>();

    protected RecursiveRoutingDriver(RoutingServiceConfiguration conf, MessagingProvider provider, MessageReceiver receiver, RoutingAlgorithmProvider algoProvider, RoutingAlgorithmConfiguration algoConf, ID selfID) throws IOException {
        super(conf, provider, receiver, algoProvider, algoConf, selfID);
        this.recAckMessage = RoutingDriverMessageFactory.getRecAckMessage(this.getSelfIDAddressPair());
        this.prepareHandlers();
    }

    @Override
    public RoutingResult[] routeToRootNode(ID[] target, int numRootCandidates) {
        return this.route(this.adjustLastHop, Tag.REC_ROUTE_NONE, target, numRootCandidates, null, null, -1, null, null);
    }

    @Override
    public RoutingResult[] routeToClosestNode(ID[] target, int numRootCandidates) {
        return this.route(false, Tag.REC_ROUTE_NONE, target, numRootCandidates, null, null, -1, null, null);
    }

    @Override
    public RoutingResult[] invokeCallbacksOnRoute(ID[] target, int numRootCandidates, Serializable[][] returnedValueContainer, CallbackResultFilter filter, int tag, Serializable[][] args) {
        return this.route(this.adjustLastHop, Tag.REC_ROUTE_INVOKE, target, numRootCandidates, filter, returnedValueContainer, tag, args, null);
    }

    @Override
    public RoutingResult join(MessagingAddress initialContact) throws RoutingException {
        ID[] tgts = new ID[]{this.getSelfIDAddressPair().getID()};
        RoutingResult[] res = this.route(this.adjustLastHop, Tag.REC_ROUTE_JOIN, tgts, this.config.getNumOfRootCandidatesRequestedWhenJoining(), null, null, -1, null, initialContact);
        if (res == null || res[0] == null) {
            throw new RoutingException();
        }
        this.algorithm.join(res[0].getRootCandidates());
        return res[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private RoutingResult[] route(boolean adjustLastHop, Tag msgType, ID[] target, int numRootCandidates, CallbackResultFilter filter, Serializable[][] resultingCallbackResult, int callbackTag, Serializable[][] callbackArgs, MessagingAddress joinInitialContact) {
        block39: {
            block38: {
                closestNodes = new List[target.length];
                blackList = null;
                if (numRootCandidates < 1) {
                    numRootCandidates = 1;
                }
                if (msgType != Tag.REC_ROUTE_JOIN) {
                    msgReporter = this.receiver.getMessagingReporter();
                    msgReporter.notifyStatCollectorOfEmphasizeNode(this.getSelfIDAddressPair(), this.getSelfIDAddressPair().getID());
                    msgReporter.notifyStatCollectorOfMarkedID(this.getSelfIDAddressPair(), target, 0);
                }
                initialRoute = new RoutingHop[]{RoutingHop.newInstance(this.getSelfIDAddressPair())};
                initialRoutingContext = new RoutingContext[target.length];
                if (msgType != Tag.REC_ROUTE_JOIN) break block38;
                initialRoutingContext = null;
                i = 0;
                if (true) ** GOTO lbl23
            }
            i = 0;
            if (true) ** GOTO lbl38
            do {
                closestNodes[i] = new ArrayList<E>();
                closestNodes[i].add(IDAddressPair.getIDAddressPair(null, joinInitialContact));
                ++i;
lbl23:
                // 2 sources

            } while (i < target.length);
            break block39;
            do {
                initialRoutingContext[i] = this.algorithm.initialRoutingContext(target[i]);
                closestNodes[i] = new ArrayList<E>();
                var19_23 /* !! */  = nodes = this.algorithm.closestTo(target[i], this.config.getNumOfClosestNodesRequested(), initialRoutingContext[i]);
                var18_21 = nodes.length;
                var17_20 = 0;
                while (var17_20 < var18_21) {
                    p = var19_23 /* !! */ [var17_20];
                    closestNodes[i].add(p);
                    ++var17_20;
                }
                ++i;
lbl38:
                // 2 sources

            } while (i < target.length);
        }
        i = this.routeResultMsgTable;
        synchronized (i) {
            nullMsg = new Message(null, -1, new Serializable[0]);
            i = 0;
            while (true) {
                if (i >= target.length) {
                    break;
                }
                this.routeResultMsgTable.put(target[i], nullMsg);
                ++i;
            }
        }
        this.forwardOrReturnResult(adjustLastHop, false, msgType.getNumber(), null, closestNodes, initialRoutingContext, target, numRootCandidates, this.getSelfIDAddressPair(), this.config.getTTL(), filter, callbackTag, callbackArgs, initialRoute, blackList);
        ret = new RoutingResult[target.length];
        failedIndexSet = new HashSet<Integer>();
        sleepLimit = System.currentTimeMillis() + this.config.getRoutingTimeout();
        do {
            block37: {
                resultMsg = null;
                var19_23 /* !! */  = this.routeResultMsgTable;
                synchronized (var19_23 /* !! */ ) {
                    while (true) {
                        i = 0;
                        while (true) {
                            block40: {
                                if (i < target.length) break block40;
                                sleepPeriod = sleepLimit - System.currentTimeMillis();
                                if (sleepPeriod > 0L) break;
                                var25_40 = target;
                                var24_36 = target.length;
                                var23_35 = 0;
                                if (true) ** GOTO lbl108
                            }
                            if (ret[i] == null) {
                                resultMsg = this.routeResultMsgTable.get(target[i]);
                            }
                            if (resultMsg != null && resultMsg.getTag() != -1) {
                                this.routeResultMsgTable.remove(target[i]);
                                break block37;
                            }
                            resultMsg = null;
                            ++i;
                        }
                        try {
                            this.routeResultMsgTable.wait(sleepPeriod);
                        }
                        catch (InterruptedException e) {
                            sleepLimit = System.currentTimeMillis();
                        }
                    }
                }
            }
            contents = resultMsg.getContents();
            succeed = (Boolean)contents[1];
            tgt = (ID[])contents[2];
            result = (RoutingResult[])contents[3];
            callbackResult = (Serializable[])contents[4];
            var27_42 = result;
            var26_41 = result.length;
            var25_39 = 0;
            if (true) ** GOTO lbl125
            {
                do {
                    id = var25_40[var23_35];
                    this.routeResultMsgTable.remove(id);
                    ++var23_35;
lbl108:
                    // 2 sources

                } while (var23_35 < var24_36);
                break;
            }
            do {
                res = var27_42[var25_39];
                route = res.getRoute();
                selfIDAddress = this.getSelfIDAddressPair();
                var33_48 = route;
                var32_47 = route.length;
                var31_46 = 0;
                while (var31_46 < var32_47) {
                    h = var33_48[var31_46];
                    p = h.getIDAddressPair();
                    if (p == null || selfIDAddress.equals(p)) break;
                    this.algorithm.touch(p);
                    ++var31_46;
                }
                ++var25_39;
lbl125:
                // 2 sources

            } while (var25_39 < var26_41);
            i = 0;
            while (i < tgt.length) {
                match = false;
                j = 0;
                while (j < target.length) {
                    if (tgt[i].equals(target[j])) {
                        match = true;
                        ret[j] = result[i];
                        if (!succeed) {
                            failedIndexSet.add(j);
                        }
                        if (resultingCallbackResult != null && resultingCallbackResult[j] != null) {
                            resultingCallbackResult[j][0] = callbackResult[i];
                        }
                    }
                    ++j;
                }
                if (!match) {
                    RecursiveRoutingDriver.logger.log(Level.WARNING, "Received REC_RESULT message is not for an expected target: " + tgt[i]);
                }
                ++i;
            }
            filled = true;
            i = 0;
            while (i < target.length) {
                if (ret[i] == null) {
                    filled = false;
                }
                ++i;
            }
        } while (!filled);
        noResultTarget = new HashSet<ID>();
        i = 0;
        while (i < target.length) {
            if (ret[i] == null) {
                noResultTarget.add(target[i]);
            }
            ++i;
        }
        if (!noResultTarget.isEmpty()) {
            sb = new StringBuilder();
            for (ID id : noResultTarget) {
                sb.append(" ").append(id);
            }
            RecursiveRoutingDriver.logger.log(Level.WARNING, "Could not receive a REC_RESULT message for the target" + sb.toString());
        }
        var20_30 = failedIndexSet.iterator();
        while (var20_30.hasNext()) {
            index = (Integer)var20_30.next();
            ret[index] = null;
        }
        return ret;
    }

    private void prepareHandlers() {
        MessageHandler handler = new MessageHandler(){

            @Override
            public Message process(Message msg) {
                boolean terminate;
                RoutingHop[] route;
                IDAddressPair initiator;
                ID[] target;
                IDAddressPair[] blackList;
                Message ret = RecursiveRoutingDriver.this.recAckMessage;
                int numRootCandidates = 1;
                RoutingContext[] routingContext = null;
                int ttl = -1;
                boolean adjustLastHop = false;
                CallbackResultFilter filter = null;
                int callbackTag = -1;
                Serializable[][] callbackArgs = null;
                Serializable[] contents = msg.getContents();
                if (msg.getTag() == Tag.REC_ROUTE_NONE.getNumber()) {
                    blackList = (IDAddressPair[])contents[0];
                    target = (ID[])contents[1];
                    numRootCandidates = (Integer)contents[2];
                    routingContext = (RoutingContext[])contents[3];
                    initiator = (IDAddressPair)contents[4];
                    ttl = (Integer)contents[5];
                    adjustLastHop = (Boolean)contents[6];
                    route = (RoutingHop[])contents[7];
                    terminate = false;
                } else if (msg.getTag() == Tag.REC_ROUTE_INVOKE.getNumber()) {
                    blackList = (IDAddressPair[])contents[0];
                    target = (ID[])contents[1];
                    numRootCandidates = (Integer)contents[2];
                    routingContext = (RoutingContext[])contents[3];
                    initiator = (IDAddressPair)contents[4];
                    ttl = (Integer)contents[5];
                    adjustLastHop = (Boolean)contents[6];
                    filter = (CallbackResultFilter)contents[7];
                    callbackTag = (Integer)contents[8];
                    callbackArgs = (Serializable[][])contents[9];
                    route = (RoutingHop[])contents[10];
                    terminate = false;
                } else if (msg.getTag() == Tag.REC_ROUTE_JOIN.getNumber()) {
                    blackList = (IDAddressPair[])contents[0];
                    initiator = (IDAddressPair)contents[1];
                    target = new ID[]{initiator.getID()};
                    numRootCandidates = (Integer)contents[2];
                    routingContext = (RoutingContext[])contents[3];
                    ttl = (Integer)contents[4];
                    adjustLastHop = (Boolean)contents[5];
                    route = (RoutingHop[])contents[6];
                    terminate = false;
                } else if (msg.getTag() == Tag.REC_TERMINATE_NONE.getNumber()) {
                    blackList = (IDAddressPair[])contents[0];
                    target = (ID[])contents[1];
                    numRootCandidates = (Integer)contents[2];
                    initiator = (IDAddressPair)contents[3];
                    ttl = (Integer)contents[4];
                    route = (RoutingHop[])contents[5];
                    terminate = true;
                } else if (msg.getTag() == Tag.REC_TERMINATE_INVOKE.getNumber()) {
                    blackList = (IDAddressPair[])contents[0];
                    target = (ID[])contents[1];
                    numRootCandidates = (Integer)contents[2];
                    initiator = (IDAddressPair)contents[3];
                    ttl = (Integer)contents[4];
                    filter = (CallbackResultFilter)contents[5];
                    callbackTag = (Integer)contents[6];
                    callbackArgs = (Serializable[][])contents[7];
                    route = (RoutingHop[])contents[8];
                    terminate = true;
                } else if (msg.getTag() == Tag.REC_TERMINATE_JOIN.getNumber()) {
                    blackList = (IDAddressPair[])contents[0];
                    initiator = (IDAddressPair)contents[1];
                    target = new ID[]{initiator.getID()};
                    numRootCandidates = (Integer)contents[2];
                    ttl = (Integer)contents[3];
                    route = (RoutingHop[])contents[4];
                    terminate = true;
                } else {
                    logger.log(Level.WARNING, "Unexpected type of message: " + Tag.getNameByNumber(msg.getTag()));
                    return ret;
                }
                RoutingHop[] lastRoute = route;
                route = new RoutingHop[lastRoute.length + 1];
                System.arraycopy(lastRoute, 0, route, 0, lastRoute.length);
                route[route.length - 1] = RoutingHop.newInstance(RecursiveRoutingDriver.this.getSelfIDAddressPair());
                if (blackList != null) {
                    IDAddressPair[] iDAddressPairArray = blackList;
                    int n = blackList.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IDAddressPair p = iDAddressPairArray[n2];
                        logger.log(Level.INFO, "REC_*calls fail: " + p.getAddress() + " on " + RecursiveRoutingDriver.this.getSelfIDAddressPair().getAddress());
                        RecursiveRoutingDriver.this.fail(p);
                        ++n2;
                    }
                }
                if (routingContext == null) {
                    routingContext = new RoutingContext[target.length];
                }
                int i = 0;
                while (i < target.length) {
                    if (routingContext[i] == null) {
                        routingContext[i] = RecursiveRoutingDriver.this.algorithm.initialRoutingContext(target[i]);
                    }
                    ++i;
                }
                List[] closestNodes = null;
                if (!terminate) {
                    closestNodes = new List[target.length];
                    int i2 = 0;
                    while (i2 < target.length) {
                        IDAddressPair[] nodes;
                        closestNodes[i2] = new ArrayList();
                        IDAddressPair[] iDAddressPairArray = nodes = RecursiveRoutingDriver.this.algorithm.closestTo(target[i2], RecursiveRoutingDriver.this.config.getNumOfClosestNodesRequested(), routingContext[i2]);
                        int n = nodes.length;
                        int n3 = 0;
                        while (n3 < n) {
                            IDAddressPair p = iDAddressPairArray[n3];
                            closestNodes[i2].add(p);
                            ++n3;
                        }
                        ++i2;
                    }
                }
                Forwarder f = new Forwarder(adjustLastHop, terminate, msg.getTag(), msg.getSource(), closestNodes, routingContext, target, numRootCandidates, initiator, ttl, filter, callbackTag, callbackArgs, route, blackList);
                if (RecursiveRoutingDriver.this.config.getUseThreadPool()) {
                    ExecutorService ex = GlobalThreadPoolExecutors.getThreadPool(false, false, Thread.currentThread().isDaemon());
                    ex.submit(f);
                } else {
                    Thread t = new Thread(f);
                    t.setName("Forwarder");
                    t.setDaemon(Thread.currentThread().isDaemon());
                    t.start();
                }
                return ret;
            }
        };
        this.addMessageHandler(Tag.REC_ROUTE_NONE.getNumber(), handler);
        this.addMessageHandler(Tag.REC_ROUTE_INVOKE.getNumber(), handler);
        this.addMessageHandler(Tag.REC_ROUTE_JOIN.getNumber(), handler);
        this.addMessageHandler(Tag.REC_TERMINATE_NONE.getNumber(), handler);
        this.addMessageHandler(Tag.REC_TERMINATE_INVOKE.getNumber(), handler);
        this.addMessageHandler(Tag.REC_TERMINATE_JOIN.getNumber(), handler);
        handler = new MessageHandler(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Message process(Message msg) {
                int n;
                Serializable[] contents = msg.getContents();
                IDAddressPair[] blackList = (IDAddressPair[])contents[0];
                ID[] target = (ID[])contents[2];
                Map map = RecursiveRoutingDriver.this.routeResultMsgTable;
                synchronized (map) {
                    if (target != null && target.length > 0) {
                        ID[] iDArray = target;
                        int n2 = target.length;
                        n = 0;
                        while (n < n2) {
                            ID id = iDArray[n];
                            Message nullMsg = (Message)RecursiveRoutingDriver.this.routeResultMsgTable.get(id);
                            if (nullMsg != null && nullMsg.getTag() == -1) {
                                RecursiveRoutingDriver.this.routeResultMsgTable.put(id, msg);
                            }
                            ++n;
                        }
                        RecursiveRoutingDriver.this.routeResultMsgTable.notifyAll();
                    }
                }
                if (blackList != null) {
                    IDAddressPair[] iDAddressPairArray = blackList;
                    n = blackList.length;
                    int n3 = 0;
                    while (n3 < n) {
                        IDAddressPair p = iDAddressPairArray[n3];
                        logger.log(Level.INFO, "REC_RESULT calls fail: " + p.getAddress() + " on " + RecursiveRoutingDriver.this.getSelfIDAddressPair().getAddress());
                        RecursiveRoutingDriver.this.fail(p);
                        ++n3;
                    }
                }
                return null;
            }
        };
        this.addMessageHandler(Tag.REC_RESULT.getNumber(), handler);
    }

    /*
     * Could not resolve type clashes
     * Unable to fully structure code
     */
    private boolean forwardOrReturnResult(boolean adjustLastHop, boolean terminate, int oldMsgTag, IDAddressPair lastHop, List<IDAddressPair>[] closestNodes, RoutingContext[] routingContext, ID[] target, int numRootCandidates, IDAddressPair initiator, int ttl, CallbackResultFilter filter, int callbackTag, Serializable[][] callbackArgs, RoutingHop[] route, IDAddressPair[] blackList) {
        blackListSet = new HashSet<IDAddressPair>();
        if (blackList != null) {
            var20_17 = blackList;
            var19_18 = blackList.length;
            var18_21 = 0;
            while (var18_21 < var19_18) {
                a = var20_17[var18_21];
                blackListSet.add(a);
                ++var18_21;
            }
        }
        terminates = new boolean[target.length];
        i = 0;
        while (i < target.length) {
            terminates[i] = terminate;
            ++i;
        }
        succeed = true;
        forwarded = new boolean[target.length];
        i = 0;
        while (i < forwarded.length) {
            forwarded[i] = false;
            ++i;
        }
        rootCandidates = null;
        if (terminate) {
            rootCandidates = new IDAddressPair[target.length][];
            i = 0;
            while (i < target.length) {
                rootCandidates[i] = this.algorithm.rootCandidates(target[i], numRootCandidates);
                ++i;
            }
            i = 0;
            while (i < target.length) {
                if (!this.getSelfIDAddressPair().equals(rootCandidates[i][0].getIDAddressPair())) {
                    adjustLastHop = true;
                    terminates[i] = false;
                    RecursiveRoutingDriver.logger.log(Level.WARNING, "This node is not responsible node for " + target[i].toString(-1) + "... adjusted from " + this.getSelfIDAddressPair().getAddress() + " (" + this.getSelfIDAddressPair().getID().toString(-1) + ") to " + rootCandidates[i][0].getAddress() + " (" + rootCandidates[i][0].getID().toString(-1) + ").");
                } else {
                    rootCandidates[i] = null;
                }
                ++i;
            }
        }
        if (!terminate && ttl < 0) {
            sb = new StringBuilder();
            sb.append("TTL expired (target ");
            var26_28 = target;
            var25_37 = target.length;
            var24_44 = 0;
            while (var24_44 < var25_37) {
                t = var26_28[var24_44];
                sb.append(" ").append(t.toString().substring(0, 6));
                ++var24_44;
            }
            sb.append("):");
            var26_28 = route;
            var25_37 = route.length;
            var24_44 = 0;
            while (var24_44 < var25_37) {
                h = var26_28[var24_44];
                if (h == null) break;
                sb.append(" ");
                sb.append(h.getIDAddressPair().getAddress().getHostname());
                ++var24_44;
            }
            RecursiveRoutingDriver.logger.log(Level.WARNING, sb.toString(), new Throwable());
            terminate = true;
            succeed = false;
        }
        nextHops = new IDAddressPair[target.length];
        while (!terminate) {
            contactSet = new HashSet<IDAddressPair>();
            allContactsAreNull = true;
            aContactIsNull = false;
            i = 0;
            while (i < target.length) {
                block107: {
                    block106: {
                        block105: {
                            if (closestNodes[i] != null && closestNodes[i].size() > 0) break block105;
                            nextHops[i] = null;
                            ** GOTO lbl-1000
                        }
                        nextHops[i] = closestNodes[i].get(0);
                        cxt = null;
                        try {
                            cxt = ((IDAddressRoutingContextTriplet)nextHops[i]).getRoutingContext();
                        }
                        catch (ClassCastException var28_62) {
                            // empty catch block
                        }
                        if (!nextHops[i].getAddress().equals(this.getSelfIDAddressPair().getAddress())) break block106;
                        if (cxt == null || routingContext != null && cxt.equals(routingContext[i])) {
                            nextHops[i] = null;
                        }
                        ** GOTO lbl-1000
                    }
                    if (!nextHops[i].getAddress().equals(initiator.getAddress())) break block107;
                    if (cxt != null) ** GOTO lbl-1000
                    nextHops[i] = null;
                    if (oldMsgTag != Tag.REC_ROUTE_JOIN.getNumber() && oldMsgTag != Tag.REC_TERMINATE_JOIN.getNumber()) ** GOTO lbl-1000
                    RecursiveRoutingDriver.logger.log(Level.WARNING, "Next hop is the joining node " + initiator.getAddress() + ". RoutingAlgorithm#touch() has been called too early?");
                    ** GOTO lbl-1000
                }
                if (blackListSet.contains(nextHops[i].getAddress())) {
                    closestNodes[i].remove(0);
                } else if (nextHops[i] != null) {
                    contactSet.add(nextHops[i].getIDAddressPair());
                    allContactsAreNull = false;
                } else {
                    contactSet.add(null);
                    aContactIsNull = true;
                }
                ++i;
            }
            if (allContactsAreNull) break;
            if (contactSet.size() > 1 || aContactIsNull) {
                forkedForwarder = new HashSet<Forwarder>();
                contactIndexList = new ArrayList<Integer>();
                for (IDAddressPair c : contactSet) {
                    contactIndexList.clear();
                    if (c == null) {
                        i = 0;
                        while (i < target.length) {
                            if (nextHops[i] == null) {
                                contactIndexList.add(i);
                            }
                            ++i;
                        }
                    } else {
                        i = 0;
                        while (i < target.length) {
                            if (c.equals(nextHops[i])) {
                                contactIndexList.add(i);
                            }
                            ++i;
                        }
                    }
                    nTgts = contactIndexList.size();
                    forkedTarget = new ID[nTgts];
                    forkedClosestNodes = new List[nTgts];
                    i = 0;
                    while (i < nTgts) {
                        index = (Integer)contactIndexList.get(i);
                        forkedTarget[i] = target[index];
                        forkedClosestNodes[i] = closestNodes[index];
                        ++i;
                    }
                    forkedCallbackArgs = null;
                    if (callbackArgs != null) {
                        forkedCallbackArgs = new Serializable[nTgts][];
                        i = 0;
                        while (i < nTgts) {
                            index = (Integer)contactIndexList.get(i);
                            forkedCallbackArgs[i] = callbackArgs[index];
                            ++i;
                        }
                    }
                    f = new Forwarder(adjustLastHop, terminate, oldMsgTag, lastHop, forkedClosestNodes, routingContext, forkedTarget, numRootCandidates, initiator, ttl, filter, callbackTag, forkedCallbackArgs, route, blackList);
                    forkedForwarder.add(f);
                }
                ret = true;
                if (this.config.getUseThreadPool()) {
                    fSet = new HashSet<Future<T>>();
                    for (Callable forwarder : forkedForwarder) {
                        ex = GlobalThreadPoolExecutors.getThreadPool(false, false, Thread.currentThread().isDaemon());
                        f = ex.submit(forwarder);
                        fSet.add(f);
                    }
                    for (Future f : fSet) {
                        try {
                            ret &= ((Boolean)f.get()).booleanValue();
                        }
                        catch (Exception ex) {
                            // empty catch block
                        }
                    }
                } else {
                    tSet = new HashSet<Thread>();
                    for (Runnable r : forkedForwarder) {
                        t = new Thread(r);
                        t.setName("Forwarder");
                        t.setDaemon(Thread.currentThread().isDaemon());
                        tSet.add(t);
                        t.start();
                    }
                    for (Thread t : tSet) {
                        try {
                            t.join();
                        }
                        catch (InterruptedException var32_98) {
                            // empty catch block
                        }
                    }
                    for (Forwarder f : forkedForwarder) {
                        ret &= f.getResult();
                    }
                }
                return ret;
            }
            nextContext = new RoutingContext[target.length];
            try {
                i = 0;
                while (i < target.length) {
                    nextContext[i] = ((IDAddressRoutingContextTriplet)nextHops[i]).getRoutingContext();
                    ++i;
                }
            }
            catch (ClassCastException e) {
                nextContext = null;
            }
            nextHop = nextHops[0].getIDAddressPair();
            if (!((oldMsgTag == Tag.REC_ROUTE_JOIN.getNumber() || oldMsgTag == Tag.REC_TERMINATE_JOIN.getNumber()) && target[0].equals(nextHop.getID()) || nextHop.getID() != null && blackListSet.contains(nextHop.getIDAddressPair()))) {
                newMsg = oldMsgTag == Tag.REC_ROUTE_NONE.getNumber() ? RoutingDriverMessageFactory.getRecRouteNoneMessage(this.getSelfIDAddressPair(), target, numRootCandidates, nextContext, initiator, ttl - 1, adjustLastHop, route) : (oldMsgTag == Tag.REC_ROUTE_INVOKE.getNumber() ? RoutingDriverMessageFactory.getRecRouteInvokeMessage(this.getSelfIDAddressPair(), target, numRootCandidates, nextContext, initiator, ttl - 1, adjustLastHop, filter, callbackTag, callbackArgs, route) : RoutingDriverMessageFactory.getRecRouteJoinMessage(this.getSelfIDAddressPair(), initiator, numRootCandidates, nextContext, ttl - 1, adjustLastHop, route));
                RoutingDriverMessageFactory.setBlackList(newMsg, blackList);
                try {
                    ack = this.sender.sendAndReceive(nextHop.getAddress(), newMsg);
                    if (nextHop.getID() == null) {
                        nextHop.setID(ack.getSource().getID());
                    }
                    i = 0;
                    while (i < target.length) {
                        if (nextHops[i].getID() == null) {
                            nextHops[i].setID(ack.getSource().getID());
                        }
                        ++i;
                    }
                    if (this.algorithm != null) {
                        this.algorithm.touch(ack.getSource());
                    }
                    if (ack.getTag() == Tag.REC_ACK.getNumber()) {
                        i = 0;
                        while (i < forwarded.length) {
                            forwarded[i] = true;
                            ++i;
                        }
                        break;
                    }
                    RecursiveRoutingDriver.logger.log(Level.SEVERE, "Received message is not REC_ACK.");
                }
                catch (IOException e) {
                    RecursiveRoutingDriver.logger.log(Level.WARNING, "Failed to forward a request to " + nextHop.getAddress() + " on " + this.getSelfIDAddressPair().getAddress(), e);
                }
                if (nextHop.getID() != null) {
                    super.fail(nextHop);
                    if (blackList != null) {
                        oldBlackList = blackList;
                        blackList = new IDAddressPair[oldBlackList.length + 1];
                        System.arraycopy(oldBlackList, 0, blackList, 0, oldBlackList.length);
                    } else {
                        blackList = new IDAddressPair[1];
                    }
                    blackList[blackList.length - 1] = nextHop;
                    blackListSet.add(nextHop);
                    RecursiveRoutingDriver.logger.log(Level.INFO, nextHop.getAddress() + " is added to blacklist on " + this.getSelfIDAddressPair().getAddress());
                }
            }
            i = 0;
            while (i < target.length) {
                if (closestNodes[i] != null) {
                    if (closestNodes[i].size() <= 1) {
                        closestNodes[i] = null;
                    } else {
                        closestNodes[i].remove(0);
                    }
                }
                ++i;
            }
        }
        if (!forwarded[0] && adjustLastHop) {
            adjustedLastHops = new List[target.length];
            i = 0;
            while (i < target.length) {
                if (terminates[i]) {
                    adjustedLastHops[i] = null;
                } else {
                    adjustedLastHops[i] = new LinkedList<E>();
                    l = rootCandidates != null && rootCandidates[i] != null ? rootCandidates[i] : this.algorithm.adjustRoot(target[i]);
                    i = l;
                    oldBlackList = l.length;
                    nextHop = 0;
                    while (nextHop < oldBlackList) {
                        p = i[nextHop];
                        if (p != null) {
                            adjustedLastHops[i].add(p);
                        }
                        ++nextHop;
                    }
                }
                ++i;
            }
            nextHopSet = new HashSet<IDAddressPair>();
            nextHopIndexList = new ArrayList<Integer>();
            block43: while (true) {
                nextHops = new IDAddressPair[target.length];
                nextHopSet.clear();
                i = 0;
                while (i < target.length) {
                    if (adjustedLastHops[i] != null && !adjustedLastHops[i].isEmpty() && !forwarded[i]) {
                        do {
                            try {
                                nextHops[i] = (IDAddressPair)adjustedLastHops[i].remove(0);
                            }
                            catch (IndexOutOfBoundsException nextHop) {
                                // empty catch block
                            }
                        } while (nextHops[i] != null && (blackListSet.contains(nextHops[i].getIDAddressPair()) || oldMsgTag == Tag.ITE_ROUTE_JOIN.getNumber() && this.getSelfIDAddressPair().equals(nextHops[i])));
                        if (nextHops[i] != null) {
                            nextHopSet.add(nextHops[i].getIDAddressPair());
                        }
                    }
                    ++i;
                }
                if (nextHopSet.isEmpty()) break;
                nextHop = nextHopSet.iterator();
                block46: while (true) {
                    if (!nextHop.hasNext()) continue block43;
                    nextHop = (IDAddressPair)nextHop.next();
                    nextHopIndexList.clear();
                    i = 0;
                    while (i < target.length) {
                        if (nextHop.equals(nextHops[i])) {
                            nextHopIndexList.add(i);
                        }
                        ++i;
                    }
                    forkedTarget = new ID[nextHopIndexList.size()];
                    i = 0;
                    while (i < nextHopIndexList.size()) {
                        forkedTarget[i] = target[(Integer)nextHopIndexList.get(i)];
                        ++i;
                    }
                    newMsg = oldMsgTag == Tag.REC_ROUTE_NONE.getNumber() || oldMsgTag == Tag.REC_TERMINATE_NONE.getNumber() ? RoutingDriverMessageFactory.getRecTerminateNoneMessage(this.getSelfIDAddressPair(), forkedTarget, numRootCandidates, initiator, ttl - 1, route) : (oldMsgTag == Tag.REC_ROUTE_INVOKE.getNumber() || oldMsgTag == Tag.REC_TERMINATE_INVOKE.getNumber() ? RoutingDriverMessageFactory.getRecTerminateInvokeMessage(this.getSelfIDAddressPair(), forkedTarget, numRootCandidates, initiator, ttl - 1, filter, callbackTag, callbackArgs, route) : RoutingDriverMessageFactory.getRecTerminateJoinMessage(this.getSelfIDAddressPair(), initiator, numRootCandidates, ttl - 1, route));
                    RoutingDriverMessageFactory.setBlackList(newMsg, blackList);
                    try {
                        ack = this.sender.sendAndReceive(nextHop.getAddress(), newMsg);
                        this.algorithm.touch(ack.getSource());
                        var31_95 = nextHopIndexList.iterator();
                        while (var31_95.hasNext()) {
                            i = (Integer)var31_95.next();
                            adjustedLastHops[i] = null;
                        }
                        if (ack.getTag() == Tag.REC_ACK.getNumber()) {
                            var31_95 = nextHopIndexList.iterator();
                            while (true) {
                                if (!var31_95.hasNext()) continue block46;
                                i = (Integer)var31_95.next();
                                forwarded[i] = true;
                            }
                        }
                        RecursiveRoutingDriver.logger.log(Level.SEVERE, "Received message is not REC_ACK.");
                    }
                    catch (IOException e) {
                        RecursiveRoutingDriver.logger.log(Level.WARNING, "Failed to forward a request to " + nextHop.getAddress() + " on " + this.getSelfIDAddressPair().getAddress(), e);
                    }
                    super.fail(nextHop);
                    if (blackList != null) {
                        oldBlackList = blackList;
                        blackList = new IDAddressPair[oldBlackList.length + 1];
                        System.arraycopy(oldBlackList, 0, blackList, 0, oldBlackList.length);
                    } else {
                        blackList = new IDAddressPair[1];
                    }
                    blackList[blackList.length - 1] = nextHop;
                    succeed = false;
                }
                break;
            }
        }
        if (lastHop != null) {
            this.algorithm.touch(lastHop);
        }
        if (!this.getSelfIDAddressPair().equals(initiator)) {
            this.algorithm.touch(initiator);
        }
        callbackResult = new Serializable[target.length];
        if (oldMsgTag == Tag.REC_ROUTE_INVOKE.getNumber() || oldMsgTag == Tag.REC_TERMINATE_INVOKE.getNumber()) {
            i = 0;
            while (i < target.length) {
                callbackResult[i] = this.invokeCallbacks(target[i], callbackTag, callbackArgs[i], filter, lastHop, forwarded[i] == false);
                if (callbackResult[i] != null) {
                    RecursiveRoutingDriver.logger.log(Level.INFO, "A callback returned non-null object: " + callbackResult[i]);
                }
                ++i;
            }
        } else if (oldMsgTag == Tag.REC_ROUTE_JOIN.getNumber() || oldMsgTag == Tag.REC_TERMINATE_JOIN.getNumber()) {
            copiedJoiningNode = initiator;
            copiedLastHop = lastHop;
            copiedForwarded = new boolean[forwarded.length];
            System.arraycopy(forwarded, 0, copiedForwarded, 0, copiedForwarded.length);
            r = new Runnable(){

                @Override
                public void run() {
                    int i = 0;
                    while (i < target.length) {
                        RecursiveRoutingDriver.this.algorithm.join(copiedJoiningNode, copiedLastHop, !copiedForwarded[i]);
                        ++i;
                    }
                }
            };
            try {
                if (this.config.getUseThreadPool()) {
                    ex = GlobalThreadPoolExecutors.getThreadPool(false, false, Thread.currentThread().isDaemon());
                    ex.submit(r);
                }
                t = new Thread(r);
                t.setName("Message type specific processes");
                t.setDaemon(Thread.currentThread().isDaemon());
                t.start();
            }
            catch (OutOfMemoryError e) {
                RecursiveRoutingDriver.logger.log(Level.SEVERE, "# of threads: " + Thread.activeCount(), e);
                throw e;
            }
        }
        notForwardedIndexList = new ArrayList<Integer>();
        i = 0;
        while (i < target.length) {
            if (!forwarded[i]) {
                notForwardedIndexList.add(i);
            }
            ++i;
        }
        if (!notForwardedIndexList.isEmpty()) {
            partOfTarget = new ID[notForwardedIndexList.size()];
            partOfResult = new RoutingResult[notForwardedIndexList.size()];
            partOfCallbackResult = new Serializable[notForwardedIndexList.size()];
            i = 0;
            while (i < notForwardedIndexList.size()) {
                partOfTarget[i] = target[(Integer)notForwardedIndexList.get(i)];
                rootCands = this.algorithm.rootCandidates(partOfTarget[i], numRootCandidates);
                if ((oldMsgTag == Tag.REC_ROUTE_JOIN.getNumber() || oldMsgTag == Tag.REC_TERMINATE_JOIN.getNumber()) && initiator.equals(rootCands[0])) {
                    orig = rootCands;
                    rootCands = new IDAddressPair[rootCands.length - 1];
                    System.arraycopy(orig, 1, rootCands, 0, rootCands.length);
                }
                partOfResult[i] = new RoutingResult(route, rootCands);
                partOfCallbackResult[i] = callbackResult[(Integer)notForwardedIndexList.get(i)];
                ++i;
            }
            repMsg = RoutingDriverMessageFactory.getRecResultMessage(this.getSelfIDAddressPair(), succeed, partOfTarget, partOfResult, partOfCallbackResult);
            RoutingDriverMessageFactory.setBlackList(repMsg, blackList);
            try {
                this.sender.send(initiator.getAddress(), repMsg);
                var30_93 = notForwardedIndexList.iterator();
                while (var30_93.hasNext()) {
                    i = (Integer)var30_93.next();
                    forwarded[i] = true;
                }
            }
            catch (IOException e) {
                RecursiveRoutingDriver.logger.log(Level.WARNING, "Failed to report to the initiator: " + initiator.getAddress() + " on " + this.getSelfIDAddressPair().getAddress());
                super.fail(initiator);
            }
        }
        ret = true;
        var29_83 = forwarded;
        var28_73 = forwarded.length;
        var27_60 = 0;
        while (var27_60 < var28_73) {
            b = var29_83[var27_60];
            ret &= b;
            ++var27_60;
        }
        return ret;
    }

    private final class Forwarder
    implements Callable<Boolean>,
    Runnable {
        private final boolean adjustLastHop;
        private final boolean terminate;
        private final int msgTag;
        private final IDAddressPair lastHop;
        private final List<IDAddressPair>[] closestNodes;
        private final RoutingContext[] routingContext;
        private final ID[] target;
        private final int numRootCandidates;
        private final IDAddressPair initiator;
        private int ttl;
        private final CallbackResultFilter filter;
        private final int callbackTag;
        private final Serializable[][] callbackArgs;
        private final RoutingHop[] route;
        private final IDAddressPair[] blackList;
        private boolean result;

        Forwarder(boolean adjustLastHop, boolean terminate, int msgTag, IDAddressPair lastHop, List<IDAddressPair>[] closestNodes, RoutingContext[] routingContext, ID[] target, int numRootCandidates, IDAddressPair initiator, int ttl, CallbackResultFilter filter, int callbackTag, Serializable[][] callbackArgs, RoutingHop[] route, IDAddressPair[] blackList) {
            this.adjustLastHop = adjustLastHop;
            this.terminate = terminate;
            this.msgTag = msgTag;
            this.lastHop = lastHop;
            this.closestNodes = closestNodes;
            this.routingContext = routingContext;
            this.target = target;
            this.numRootCandidates = numRootCandidates;
            this.initiator = initiator;
            this.ttl = ttl;
            this.filter = filter;
            this.callbackTag = callbackTag;
            this.callbackArgs = callbackArgs;
            this.route = route;
            this.blackList = blackList;
        }

        @Override
        public void run() {
            try {
                this.call();
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "A Querier threw an exception.", e);
            }
        }

        @Override
        public Boolean call() throws Exception {
            this.result = RecursiveRoutingDriver.this.forwardOrReturnResult(this.adjustLastHop, this.terminate, this.msgTag, this.lastHop, this.closestNodes, this.routingContext, this.target, this.numRootCandidates, this.initiator, this.ttl, this.filter, this.callbackTag, this.callbackArgs, this.route, this.blackList);
            return this.result;
        }

        public boolean getResult() {
            return this.result;
        }
    }
}

