/*
 * Decompiled with CFR 0.152.
 */
package ow.routing.kademlia;

import java.io.IOException;
import java.math.BigInteger;
import java.security.InvalidAlgorithmParameterException;
import java.util.Comparator;
import java.util.logging.Level;
import ow.id.ID;
import ow.id.IDAddressPair;
import ow.id.comparator.AlgoBasedTowardTargetIDAddrComparator;
import ow.routing.RoutingAlgorithmConfiguration;
import ow.routing.RoutingContext;
import ow.routing.RoutingService;
import ow.routing.impl.AbstractRoutingAlgorithm;
import ow.routing.kademlia.KBucket;
import ow.routing.kademlia.KademliaConfiguration;
import ow.util.HTMLUtil;

public final class Kademlia
extends AbstractRoutingAlgorithm {
    private final KademliaConfiguration config;
    private final int numKBuckets;
    private final KBucket[] kBuckets;
    final int kBucketLength;

    protected Kademlia(RoutingAlgorithmConfiguration config, RoutingService routingSvc) throws InvalidAlgorithmParameterException {
        super(config, routingSvc);
        try {
            this.config = (KademliaConfiguration)config;
        }
        catch (ClassCastException e) {
            throw new InvalidAlgorithmParameterException("The given config is not KademliaConfiguration.");
        }
        this.numKBuckets = this.config.getIDSizeInByte() * 8;
        this.kBucketLength = this.config.getKBucketLength();
        this.kBuckets = new KBucket[this.numKBuckets];
    }

    @Override
    public synchronized void reset() {
        int i = 0;
        while (i < this.numKBuckets) {
            this.kBuckets[i] = null;
            ++i;
        }
    }

    @Override
    public void stop() {
    }

    @Override
    public synchronized void suspend() {
    }

    @Override
    public synchronized void resume() {
    }

    @Override
    public BigInteger distance(ID to, ID from) {
        BigInteger toInt = to.toBigInteger();
        BigInteger fromInt = from.toBigInteger();
        return fromInt.xor(toInt);
    }

    @Override
    public IDAddressPair[] closestTo(ID targetID, int maxNum, RoutingContext cxt) {
        int i;
        KBucket kb;
        IDAddressPair[] results = new IDAddressPair[maxNum];
        BigInteger distance = this.distance(targetID, this.selfIDAddress.getID());
        int highestSetBit = distance.bitLength() - 1;
        AlgoBasedTowardTargetIDAddrComparator comparator = new AlgoBasedTowardTargetIDAddrComparator(this, targetID);
        int index = 0;
        if (highestSetBit >= 0) {
            kb = this.kBuckets[highestSetBit];
            if (kb != null && (index = this.pickNodes(index, results, kb, comparator)) >= results.length) {
                return results;
            }
            i = highestSetBit - 1;
            while (i >= 0) {
                if (distance.testBit(i) && (kb = this.kBuckets[i]) != null && (index = this.pickNodes(index, results, kb, comparator)) >= results.length) {
                    return results;
                }
                --i;
            }
        }
        results[index++] = this.selfIDAddress;
        if (index >= results.length) {
            return results;
        }
        if (highestSetBit >= 0) {
            i = 0;
            while (i < highestSetBit) {
                if (!distance.testBit(i) && (kb = this.kBuckets[i]) != null && (index = this.pickNodes(index, results, kb, comparator)) >= results.length) {
                    return results;
                }
                ++i;
            }
        }
        i = highestSetBit + 1;
        while (i < this.numKBuckets) {
            kb = this.kBuckets[i];
            if (kb != null) {
                index = this.pickNodes(index, results, kb, comparator);
            }
            ++i;
        }
        IDAddressPair[] ret = new IDAddressPair[index];
        System.arraycopy(results, 0, ret, 0, index);
        return ret;
    }

    @Override
    public IDAddressPair[] rootCandidates(ID target, int maxNum) {
        return this.closestTo(target, maxNum, null);
    }

    private int pickNodes(int index, IDAddressPair[] dest, KBucket kb, Comparator<IDAddressPair> comparator) {
        IDAddressPair[] result = kb.toSortedArray(comparator);
        int resultLen = result.length;
        int destLen = dest.length;
        int copyLen = Math.min(destLen - index, resultLen);
        System.arraycopy(result, 0, dest, index, copyLen);
        return index + copyLen;
    }

    @Override
    public IDAddressPair[] adjustRoot(ID rootCandidate) {
        return null;
    }

    @Override
    public boolean toReplace(IDAddressPair existingEntry, IDAddressPair newEntry) {
        if (existingEntry.equals(newEntry)) {
            return false;
        }
        boolean pingSucceeded = false;
        try {
            pingSucceeded = this.runtime.ping(this.sender, existingEntry);
        }
        catch (IOException e) {
            logger.log(Level.WARNING, "An IOException thrown during ping() from " + this.selfIDAddress.getAddress() + " to " + existingEntry.getAddress());
        }
        return !pingSucceeded;
    }

    @Override
    public void join(IDAddressPair[] neighbors) {
    }

    @Override
    public void join(IDAddressPair joiningNode, IDAddressPair lastHop, boolean isFinalHop) {
        logger.log(Level.INFO, "On " + this.selfIDAddress.getAddress() + ", " + "Kademlia#join(" + joiningNode.getAddress() + ", " + (lastHop != null ? lastHop.getAddress() : "null") + ", " + isFinalHop + ") called.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void touch(IDAddressPair from) {
        BigInteger distance = this.distance(from.getID(), this.selfIDAddress.getID());
        int highestSetBit = distance.bitLength() - 1;
        if (highestSetBit < 0) {
            return;
        }
        KBucket[] kBucketArray = this.kBuckets;
        synchronized (this.kBuckets) {
            KBucket kb = this.kBuckets[highestSetBit];
            if (kb == null) {
                this.kBuckets[highestSetBit] = kb = new KBucket(this);
            }
            // ** MonitorExit[var5_4] (shouldn't be in output)
            kb.appendToTail(from);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void forget(IDAddressPair failedNode) {
        BigInteger distance = this.distance(failedNode.getID(), this.selfIDAddress.getID());
        int highestSetBit = distance.bitLength() - 1;
        if (highestSetBit < 0) {
            return;
        }
        KBucket[] kBucketArray = this.kBuckets;
        synchronized (this.kBuckets) {
            KBucket kb = this.kBuckets[highestSetBit];
            if (kb != null) {
                kb.remove(failedNode);
                if (kb.size() <= 0) {
                    this.kBuckets[highestSetBit] = null;
                }
            }
            // ** MonitorExit[var4_4] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getRoutingTableString(int verboseLevel) {
        StringBuilder sb = new StringBuilder();
        sb.append("[");
        int i = 0;
        while (i < this.numKBuckets) {
            KBucket kb = this.kBuckets[i];
            if (kb != null && kb.size() > 0) {
                sb.append("\n ").append(i).append(":");
                KBucket kBucket = kb;
                synchronized (kBucket) {
                    for (IDAddressPair pair : kb) {
                        sb.append("\n  ").append(pair.toString(verboseLevel));
                    }
                }
            }
            ++i;
        }
        sb.append("\n]");
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getRoutingTableHTMLString() {
        StringBuilder sb = new StringBuilder();
        sb.append("<table>\n");
        int i = 0;
        while (i < this.numKBuckets) {
            KBucket kb = this.kBuckets[i];
            if (kb != null && kb.size() > 0) {
                sb.append("<tr><td>" + HTMLUtil.stringInHTML(Integer.toString(i)) + "</td><td></td><td></td></tr>\n");
                KBucket kBucket = kb;
                synchronized (kBucket) {
                    for (IDAddressPair pair : kb) {
                        String url = HTMLUtil.convertMessagingAddressToURL(pair.getAddress());
                        sb.append("<tr><td></td><td><a href=\"" + url + "\">" + HTMLUtil.stringInHTML(url) + "</a></td><td>" + HTMLUtil.stringInHTML(pair.getID().toString()) + "</td></tr>\n");
                    }
                }
            }
            ++i;
        }
        sb.append("</table>\n");
        return sb.toString();
    }
}

