/*
 * Decompiled with CFR 0.152.
 */
package ow.routing.pastry;

import java.util.Comparator;
import java.util.HashSet;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import ow.id.ID;
import ow.id.IDAddressPair;
import ow.id.comparator.AlgoBasedTowardTargetIDAddrComparator;
import ow.id.comparator.ClockwiseFromSrcIDAddrComparator;
import ow.id.comparator.ClockwiseTowardTargetIDAddrComparator;
import ow.routing.RoutingAlgorithm;
import ow.util.HTMLUtil;

public final class LeafSet {
    private final int oneSideSize;
    private SortedSet<IDAddressPair> smallerSet;
    private SortedSet<IDAddressPair> largerSet;
    private volatile RoutingAlgorithm algorithm = null;
    private volatile IDAddressPair selfIDAddress = null;
    private volatile Comparator<IDAddressPair> smallerComparator = null;
    private volatile Comparator<IDAddressPair> largerComparator = null;

    public LeafSet(RoutingAlgorithm algorithm, int idSizeInBit, IDAddressPair self, int oneSideSize) {
        this.algorithm = algorithm;
        this.selfIDAddress = self;
        this.oneSideSize = oneSideSize;
        this.smallerComparator = new ClockwiseTowardTargetIDAddrComparator(idSizeInBit, this.selfIDAddress.getID());
        this.largerComparator = new ClockwiseFromSrcIDAddrComparator(idSizeInBit, this.selfIDAddress.getID());
        this.clear();
    }

    synchronized void clear() {
        this.smallerSet = new TreeSet<IDAddressPair>(this.smallerComparator);
        this.largerSet = new TreeSet<IDAddressPair>(this.largerComparator);
    }

    public void add(IDAddressPair elem) {
        if (elem.equals(this.selfIDAddress)) {
            return;
        }
        this.addToSortedSet(this.smallerSet, elem);
        this.addToSortedSet(this.largerSet, elem);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addToSortedSet(SortedSet<IDAddressPair> set, IDAddressPair elem) {
        SortedSet<IDAddressPair> sortedSet = set;
        synchronized (sortedSet) {
            set.add(elem);
            while (set.size() > this.oneSideSize) {
                IDAddressPair lastElem = set.last();
                set.remove(lastElem);
            }
        }
    }

    public void merge(IDAddressPair[] leafSet) {
        if (leafSet != null) {
            this.mergeToSortedSet(this.smallerSet, leafSet);
            this.mergeToSortedSet(this.largerSet, leafSet);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private void mergeToSortedSet(SortedSet<IDAddressPair> set, IDAddressPair[] oneSideLeafSet) {
        var3_3 = set;
        synchronized (var3_3) {
            var4_4 = oneSideLeafSet;
            synchronized (oneSideLeafSet) {
                var8_5 = oneSideLeafSet;
                var7_6 = oneSideLeafSet.length;
                var6_7 = 0;
                while (var6_7 < var7_6) {
                    p = var8_5[var6_7];
                    if (p != null && !p.equals(this.selfIDAddress)) {
                        set.add(p);
                    }
                    ++var6_7;
                }
                // ** MonitorExit[var4_4] (shouldn't be in output)
                if (true) ** GOTO lbl26
                do {
                    lastElem = set.last();
                    set.remove(lastElem);
lbl26:
                    // 2 sources

                } while (set.size() > this.oneSideSize);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(IDAddressPair elem) {
        SortedSet<IDAddressPair> sortedSet = this.smallerSet;
        synchronized (sortedSet) {
            this.smallerSet.remove(elem);
        }
        sortedSet = this.largerSet;
        synchronized (sortedSet) {
            this.largerSet.remove(elem);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean coversWithSmallerSet(IDAddressPair elem) {
        try {
            IDAddressPair smallest;
            SortedSet<IDAddressPair> sortedSet = this.smallerSet;
            synchronized (sortedSet) {
                smallest = this.smallerSet.last();
            }
            if (this.smallerComparator.compare(elem, smallest) <= 0 && !elem.equals(this.selfIDAddress)) {
                return true;
            }
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean coversWithLargerSet(IDAddressPair elem) {
        try {
            IDAddressPair largest;
            SortedSet<IDAddressPair> sortedSet = this.largerSet;
            synchronized (sortedSet) {
                largest = this.largerSet.last();
            }
            if (this.largerComparator.compare(elem, largest) <= 0 && !elem.equals(this.selfIDAddress)) {
                return true;
            }
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean coversEntireRing() {
        SortedSet<IDAddressPair> sortedSet;
        IDAddressPair largest;
        block9: {
            IDAddressPair smallest = null;
            largest = null;
            try {
                sortedSet = this.smallerSet;
                synchronized (sortedSet) {
                    smallest = this.smallerSet.last();
                }
                if (!this.largerSet.contains(smallest)) break block9;
                return true;
            }
            catch (NoSuchElementException e) {
                return true;
            }
        }
        sortedSet = this.largerSet;
        synchronized (sortedSet) {
            largest = this.largerSet.last();
        }
        return this.smallerSet.contains(largest);
    }

    public int getOneSideSize() {
        return this.oneSideSize;
    }

    public int getNumberOfSmallerNodes() {
        return this.getSizeOfSortedSet(this.smallerSet);
    }

    public int getNumberOfLargerNodes() {
        return this.getSizeOfSortedSet(this.largerSet);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getSizeOfSortedSet(SortedSet<IDAddressPair> set) {
        SortedSet<IDAddressPair> sortedSet = set;
        synchronized (sortedSet) {
            return set.size();
        }
    }

    public IDAddressPair getSmallestNode() {
        return this.getLastElement(this.smallerSet);
    }

    public IDAddressPair getLargestNode() {
        return this.getLastElement(this.largerSet);
    }

    private IDAddressPair getLastElement(SortedSet<IDAddressPair> set) {
        IDAddressPair ret = null;
        try {
            ret = set.last();
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public SortedSet<IDAddressPair> closestNodes(ID target, int maxNum) {
        towardTargetComparator = new AlgoBasedTowardTargetIDAddrComparator(this.algorithm, target);
        result = new TreeSet<IDAddressPair>(towardTargetComparator);
        result.add(this.selfIDAddress);
        var5_5 = this.smallerSet;
        synchronized (var5_5) {
            result.addAll(this.smallerSet);
        }
        var5_5 = this.largerSet;
        synchronized (var5_5) {
            result.addAll(this.largerSet);
            // MONITOREXIT @DISABLED, blocks:[1, 3] lbl20 : MonitorExitStatement: MONITOREXIT : var5_5
            if (true) ** GOTO lbl26
        }
        do {
            lastElem = (IDAddressPair)result.last();
            result.remove(lastElem);
lbl26:
            // 2 sources

        } while (result.size() > maxNum);
        return result;
    }

    public IDAddressPair[] getArrayOfSmallerSet() {
        return this.getArrayOfSmallerSet(null);
    }

    public IDAddressPair[] getArrayOfSmallerSet(IDAddressPair toBeExcluded) {
        return LeafSet.getArrayOfSet(this.smallerSet, toBeExcluded);
    }

    public IDAddressPair[] getArrayOfLargerSet() {
        return this.getArrayOfLargerSet(null);
    }

    public IDAddressPair[] getArrayOfLargerSet(IDAddressPair toBeExcluded) {
        return LeafSet.getArrayOfSet(this.largerSet, toBeExcluded);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static IDAddressPair[] getArrayOfSet(Set<IDAddressPair> set, IDAddressPair exclude) {
        IDAddressPair[] ret;
        HashSet<IDAddressPair> retSet = new HashSet<IDAddressPair>();
        Set<IDAddressPair> set2 = set;
        synchronized (set2) {
            for (IDAddressPair p : set) {
                if (p.equals(exclude)) continue;
                retSet.add(p);
            }
            ret = new IDAddressPair[retSet.size()];
            retSet.toArray(ret);
        }
        return ret;
    }

    public String toString() {
        return this.toString(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString(int verboseLevel) {
        StringBuilder sb = new StringBuilder();
        sb.append("[");
        SortedSet<IDAddressPair> sortedSet = this.smallerSet;
        synchronized (sortedSet) {
            for (IDAddressPair p : this.smallerSet) {
                sb.append(" ");
                sb.append(p.getAddress().toString(verboseLevel));
            }
        }
        sb.append(" |");
        sortedSet = this.largerSet;
        synchronized (sortedSet) {
            for (IDAddressPair p : this.largerSet) {
                sb.append(" ");
                sb.append(p.getAddress().toString(verboseLevel));
            }
        }
        sb.append(" ]");
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toHTMLString() {
        String url;
        StringBuilder sb = new StringBuilder();
        SortedSet<IDAddressPair> sortedSet = this.smallerSet;
        synchronized (sortedSet) {
            for (IDAddressPair p : this.smallerSet) {
                url = HTMLUtil.convertMessagingAddressToURL(p.getAddress());
                sb.append("<a href=\"" + url + "\">" + HTMLUtil.stringInHTML(url) + "</a><br>\n");
            }
        }
        url = HTMLUtil.convertMessagingAddressToURL(this.selfIDAddress.getAddress());
        sb.append("<a href=\"" + url + "\">" + HTMLUtil.stringInHTML(url) + "</a> (self)<br>\n");
        sortedSet = this.largerSet;
        synchronized (sortedSet) {
            for (IDAddressPair p : this.largerSet) {
                url = HTMLUtil.convertMessagingAddressToURL(p.getAddress());
                sb.append("<a href=\"" + url + "\">" + HTMLUtil.stringInHTML(url) + "</a><br>\n");
            }
        }
        return sb.toString();
    }
}

