/*
 * Decompiled with CFR 0.152.
 */
package ow.routing.plaxton;

import java.io.Serializable;
import java.util.HashSet;
import java.util.Set;
import ow.id.IDAddressPair;
import ow.routing.plaxton.Plaxton;
import ow.routing.plaxton.RoutingTable;
import ow.util.HTMLUtil;

public final class RoutingTableRow
implements Serializable {
    private transient RoutingTable routingTable;
    private final int selfDigit;
    private IDAddressPair[] entries = null;

    protected RoutingTableRow(RoutingTable routingTable, int selfDigit) {
        this.routingTable = routingTable;
        this.selfDigit = selfDigit;
    }

    public RoutingTableRow(RoutingTableRow row) {
        this.routingTable = row.routingTable;
        this.selfDigit = row.selfDigit;
        this.prepareBody();
        System.arraycopy(row.entries, 0, this.entries, 0, row.entries.length);
    }

    void setRoutingTable(RoutingTable routingTable) {
        this.routingTable = routingTable;
    }

    public int size() {
        return this.routingTable.colSize;
    }

    public boolean isEmpty() {
        return this.entries == null;
    }

    private boolean checkEmptyOrNot() {
        if (this.entries == null) {
            return true;
        }
        int i = 0;
        while (i < this.entries.length) {
            if (i != this.selfDigit && this.entries[i] != null) {
                return false;
            }
            ++i;
        }
        this.entries = null;
        return true;
    }

    private synchronized void prepareBody() {
        if (this.entries == null) {
            this.entries = new IDAddressPair[this.routingTable.colSize];
            this.entries[this.selfDigit] = this.routingTable.selfIDAddress;
        }
    }

    public IDAddressPair get(int col) {
        if (col == this.selfDigit) {
            return this.routingTable.selfIDAddress;
        }
        if (this.entries == null) {
            return null;
        }
        return this.entries[col];
    }

    protected synchronized IDAddressPair set(int col, IDAddressPair entry) {
        if (col == this.selfDigit) {
            return null;
        }
        if (entry == null) {
            return null;
        }
        this.prepareBody();
        IDAddressPair old = this.entries[col];
        this.entries[col] = entry;
        return old;
    }

    protected synchronized IDAddressPair merge(int col, IDAddressPair entry, Plaxton algo) {
        IDAddressPair existingEntry = this.get(col);
        if (existingEntry == null || algo.toReplace(existingEntry, entry)) {
            return this.set(col, entry);
        }
        return null;
    }

    protected synchronized IDAddressPair remove(int col) {
        IDAddressPair old = this.get(col);
        if (this.entries != null) {
            this.entries[col] = null;
            this.checkEmptyOrNot();
        }
        return old;
    }

    public synchronized Set<IDAddressPair> getAllNodes() {
        HashSet<IDAddressPair> set = new HashSet<IDAddressPair>();
        if (this.entries != null) {
            int i = 0;
            while (i < this.entries.length) {
                IDAddressPair p = this.entries[i];
                if (p != null) {
                    set.add(p);
                }
                ++i;
            }
        } else {
            set.add(this.routingTable.selfIDAddress);
        }
        return set;
    }

    public String toString() {
        return this.toString(false, 0);
    }

    public String toString(boolean onlyAddress, int verboseLevel) {
        if (this.entries == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        boolean firstEntry = true;
        int i = 0;
        while (i < this.entries.length) {
            IDAddressPair entry;
            if (i != this.selfDigit && (entry = this.entries[i]) != null) {
                if (firstEntry) {
                    firstEntry = false;
                } else {
                    sb.append(" ");
                }
                sb.append(Integer.toHexString(i));
                sb.append(":");
                if (onlyAddress) {
                    sb.append(entry.getAddress().toString(verboseLevel));
                } else {
                    sb.append(entry.toString(verboseLevel));
                }
            }
            ++i;
        }
        return sb.toString();
    }

    public String toHTMLString() {
        if (this.entries == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < this.entries.length) {
            IDAddressPair entry;
            if (i != this.selfDigit && (entry = this.entries[i]) != null) {
                String url = HTMLUtil.convertMessagingAddressToURL(entry.getAddress());
                sb.append("<tr><td></td><td>" + HTMLUtil.stringInHTML(Integer.toHexString(i)) + "</td>" + "<td><a href=\"" + url + "\">" + HTMLUtil.stringInHTML(url) + "</a></td></tr>\n");
            }
            ++i;
        }
        return sb.toString();
    }
}

