/*
 * Decompiled with CFR 0.152.
 */
package ow.stat.impl;

import java.io.IOException;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Random;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import ow.id.IDAddressPair;
import ow.messaging.Message;
import ow.messaging.MessageReceiver;
import ow.messaging.MessageSender;
import ow.messaging.MessagingAddress;
import ow.messaging.MessagingProvider;
import ow.stat.NodeCollector;
import ow.stat.NodeCollectorCallback;
import ow.stat.StatConfiguration;
import ow.stat.StatFactory;
import ow.stat.impl.StatMessageFactory;
import ow.util.concurrent.GlobalThreadPoolExecutors;

public class NodeCollectorImpl
implements NodeCollector {
    private static final Logger logger = Logger.getLogger("statcollector");
    private NodeCollectorCallback callback;
    private IDAddressPair self;
    private MessageSender sender;
    private StatConfiguration config;
    private int numOfCollectionThread;
    private Set<IDAddressPair> contactNodes;
    private Set<IDAddressPair> processedNodes;
    private Set<IDAddressPair> runningNodes;
    private Set<IDAddressPair> failedNodes;
    private int threadCount = 1;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NodeCollectorImpl(MessagingAddress initialContact, NodeCollectorCallback cb, StatConfiguration config, MessageReceiver receiver) throws Exception {
        this.callback = cb;
        this.config = config != null ? config : StatFactory.getDefaultConfiguration();
        if (receiver == null) {
            MessagingProvider msgProvider = this.config.deriveMessagingProvider();
            receiver = this.config.deriveMessageReceiver(msgProvider);
        }
        this.self = IDAddressPair.getIDAddressPair(null, receiver.getSelfAddress());
        this.sender = receiver.getSender();
        this.numOfCollectionThread = 0;
        this.contactNodes = new HashSet<IDAddressPair>();
        this.processedNodes = new HashSet<IDAddressPair>();
        this.runningNodes = new HashSet<IDAddressPair>();
        this.failedNodes = new HashSet<IDAddressPair>();
        IDAddressPair[] neighbors = this.requestNeighbors(initialContact, this.config.getNumOfNodesNodeCollectorRequests());
        if (neighbors != null) {
            Set<IDAddressPair> set = this.contactNodes;
            synchronized (set) {
                IDAddressPair[] iDAddressPairArray = neighbors;
                int n = neighbors.length;
                int n2 = 0;
                while (n2 < n) {
                    IDAddressPair n3 = iDAddressPairArray[n2];
                    this.contactNodes.add(n3);
                    ++n2;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<IDAddressPair> investigate() {
        Set<IDAddressPair> set = this.runningNodes;
        synchronized (set) {
            Set<IDAddressPair> set2 = this.contactNodes;
            synchronized (set2) {
                this.contactNodes.addAll(this.runningNodes);
            }
        }
        this.investigate0();
        return this.runningNodes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void investigate0() {
        this.processedNodes.clear();
        this.failedNodes.clear();
        while (true) {
            IDAddressPair contact = null;
            Set<IDAddressPair> set = this.contactNodes;
            synchronized (set) {
                Iterator<IDAddressPair> iterator = this.contactNodes.iterator();
                if (iterator.hasNext()) {
                    IDAddressPair p;
                    contact = p = iterator.next();
                }
                if (contact != null) {
                    this.contactNodes.remove(contact);
                    this.processedNodes.add(contact);
                    ++this.numOfCollectionThread;
                    GlobalThreadPoolExecutors.getThreadPool(false, false, true).submit(new Collector(contact));
                } else {
                    if (this.numOfCollectionThread <= 0) {
                        break;
                    }
                    try {
                        this.contactNodes.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        block11: while (true) {
            this.investigate0();
            Random rnd = new Random();
            while (true) {
                IDAddressPair[] livNodeArray;
                int size;
                try {
                    Thread.sleep(this.config.getPeriodicCollectionInterval());
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                Set<IDAddressPair> set = this.runningNodes;
                synchronized (set) {
                    size = this.runningNodes.size();
                    livNodeArray = new IDAddressPair[size];
                    this.runningNodes.toArray(livNodeArray);
                }
                int index = rnd.nextInt(size);
                IDAddressPair contact = livNodeArray[index];
                IDAddressPair[] neighbors = this.requestNeighbors(contact.getAddress(), this.config.getNumOfNodesNodeCollectorRequests());
                Set<IDAddressPair> set2 = this.runningNodes;
                synchronized (set2) {
                    if (neighbors == null) {
                        this.runningNodes.remove(contact);
                        this.failedNodes.add(contact);
                        this.callback.removeNode(contact.getID());
                    }
                    Set<IDAddressPair> set3 = this.contactNodes;
                    synchronized (set3) {
                        if (neighbors != null) {
                            IDAddressPair[] iDAddressPairArray = neighbors;
                            int n = neighbors.length;
                            int n2 = 0;
                            while (n2 < n) {
                                IDAddressPair n3 = iDAddressPairArray[n2];
                                if (n3 != null && !this.processedNodes.contains(n3)) {
                                    this.contactNodes.add(n3);
                                }
                                ++n2;
                            }
                        } else {
                            this.processedNodes.remove(contact);
                        }
                        if (!this.contactNodes.isEmpty()) {
                            continue block11;
                        }
                    }
                }
            }
            break;
        }
    }

    private IDAddressPair[] requestNeighbors(MessagingAddress contact, int num) {
        IDAddressPair[] neighbors = null;
        Message req = StatMessageFactory.getReqNeighbors(this.self, num);
        try {
            Message rep = this.sender.sendAndReceive(contact, req);
            Serializable[] contents = rep.getContents();
            neighbors = (IDAddressPair[])contents[0];
        }
        catch (IOException e) {
            logger.log(Level.WARNING, "Failed to contact: " + contact);
        }
        return neighbors;
    }

    private class Collector
    implements Runnable {
        private final IDAddressPair contact;

        private Collector(IDAddressPair contact) {
            this.contact = contact;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Thread th = Thread.currentThread();
            String origName = th.getName();
            StringBuilder stringBuilder = new StringBuilder("NodeCollector-");
            NodeCollectorImpl nodeCollectorImpl = NodeCollectorImpl.this;
            int n = nodeCollectorImpl.threadCount;
            nodeCollectorImpl.threadCount = n + 1;
            th.setName(stringBuilder.append(n).toString());
            IDAddressPair[] neighbors = null;
            neighbors = NodeCollectorImpl.this.requestNeighbors(this.contact.getAddress(), NodeCollectorImpl.this.config.getNumOfNodesNodeCollectorRequests());
            Set set = NodeCollectorImpl.this.runningNodes;
            synchronized (set) {
                if (neighbors != null) {
                    NodeCollectorImpl.this.runningNodes.add(this.contact);
                    NodeCollectorImpl.this.callback.addNode(this.contact.getID(), this.contact.getAddress());
                } else {
                    NodeCollectorImpl.this.failedNodes.add(this.contact);
                    NodeCollectorImpl.this.callback.removeNode(this.contact.getID());
                }
                Set set2 = NodeCollectorImpl.this.contactNodes;
                synchronized (set2) {
                    if (neighbors != null) {
                        boolean added = false;
                        IDAddressPair[] iDAddressPairArray = neighbors;
                        int n2 = neighbors.length;
                        int n3 = 0;
                        while (n3 < n2) {
                            IDAddressPair n4 = iDAddressPairArray[n3];
                            if (n4 != null && !NodeCollectorImpl.this.processedNodes.contains(n4)) {
                                added |= NodeCollectorImpl.this.contactNodes.add(n4);
                            }
                            ++n3;
                        }
                        if (added) {
                            NodeCollectorImpl.this.contactNodes.notify();
                        }
                    }
                }
            }
            set = NodeCollectorImpl.this.contactNodes;
            synchronized (set) {
                NodeCollectorImpl nodeCollectorImpl2 = NodeCollectorImpl.this;
                nodeCollectorImpl2.numOfCollectionThread = nodeCollectorImpl2.numOfCollectionThread - 1;
                if (NodeCollectorImpl.this.numOfCollectionThread <= 0) {
                    NodeCollectorImpl.this.contactNodes.notify();
                }
            }
            th.setName(origName);
        }
    }
}

