/*
 * Decompiled with CFR 0.152.
 */
package ow.tool.dhtshell.commands;

import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import ow.dht.ByteArray;
import ow.dht.DHT;
import ow.dht.ValueInfo;
import ow.id.ID;
import ow.id.IDUtility;
import ow.tool.util.shellframework.Command;
import ow.tool.util.shellframework.CommandUtil;
import ow.tool.util.shellframework.ShellContext;

public final class RemoveCommand
implements Command<DHT<String>> {
    private static final String[] NAMES = new String[]{"remove", "delete"};

    @Override
    public String[] getNames() {
        return NAMES;
    }

    @Override
    public String getHelp() {
        return "remove|delete [-status] <secret> <key> [<value> ...] [- <key> [<value> ...] ...]";
    }

    @Override
    public boolean execute(ShellContext<DHT<String>> context) {
        DHT<String> dht = context.getOpaqueData();
        PrintStream out = context.getOutputStream();
        String[] args = context.getArguments();
        boolean showStatus = false;
        ConcurrentLinkedQueue requestQueue = new ConcurrentLinkedQueue();
        int argIndex = 0;
        if (argIndex < args.length && args[argIndex].startsWith("-")) {
            showStatus = true;
            ++argIndex;
        }
        if (args.length < argIndex + 2) {
            out.print("usage: " + this.getHelp() + "\r\n");
            out.flush();
            return false;
        }
        ByteArray secret = null;
        try {
            secret = ByteArray.valueOf(args[argIndex], "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        ++argIndex;
        secret = secret.hashWithSHA1();
        do {
            int nargs = args.length - argIndex;
            int j = 1;
            while (j < nargs) {
                if ("-".equals(args[argIndex + j])) {
                    nargs = j;
                }
                ++j;
            }
            ID key = IDUtility.parseID(args[argIndex], dht.getRoutingAlgorithmConfiguration().getIDSizeInByte());
            int nValue = nargs - 1;
            if (nValue > 0) {
                String[] values = new String[nValue];
                int j2 = 0;
                while (j2 < nValue) {
                    values[j2] = args[argIndex + 1 + j2];
                    ++j2;
                }
                requestQueue.offer(new DHT.RemoveRequest<String>(key, values));
            } else {
                requestQueue.offer(new DHT.RemoveRequest(key));
            }
            argIndex += nargs;
            while (argIndex < args.length && "-".equals(args[argIndex])) {
                ++argIndex;
            }
        } while (argIndex < args.length);
        DHT.RemoveRequest[] requests = new DHT.RemoveRequest[requestQueue.size()];
        argIndex = 0;
        while (argIndex < requests.length) {
            requests[argIndex] = (DHT.RemoveRequest)requestQueue.poll();
            ++argIndex;
        }
        Set<ValueInfo<String>>[] values = dht.remove(requests, secret);
        StringBuilder sb = new StringBuilder();
        argIndex = 0;
        while (argIndex < requests.length) {
            sb.append("key:   ").append(requests[argIndex].getKey()).append("\r\n");
            if (values[argIndex] != null) {
                for (ValueInfo<String> v : values[argIndex]) {
                    sb.append("value: ").append(v.getValue()).append(" ").append(v.getTTL() / 1000);
                    secret = v.getHashedSecret();
                    if (secret != null) {
                        sb.append(" ").append(secret);
                    }
                    sb.append("\r\n");
                }
            } else {
                sb.append("value:").append("\r\n");
            }
            ++argIndex;
        }
        if (showStatus) {
            sb.append((CharSequence)CommandUtil.buildStatusMessage(context.getOpaqueData(), -1));
        }
        out.print(sb);
        out.flush();
        return false;
    }
}

