/*
 * Decompiled with CFR 0.152.
 */
package ow.tool.emulator;

import java.io.PrintStream;
import java.io.Writer;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import ow.tool.emulator.ControlPipeTable;
import ow.tool.emulator.EmulatorMode;
import ow.tool.emulator.EmulatorTask;
import ow.tool.emulator.RemoteControlPipeTable;
import ow.util.Timer;

public class EmulatorContext {
    private PrintStream out;
    private EmulatorMode emulatorMode;
    private int nextID;
    private Timer timer;
    private long controlStartTime = 0L;
    private long lastScheduledTime = 0L;
    private ControlPipeTable controlPipeTable;
    private static final ThreadGroup threadGroup = new EmulatorThreadGroup("Emulator thread group");
    private static final ExecutorService threadPool = new ThreadPoolExecutor(0, Integer.MAX_VALUE, 5L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), new EmulatorThreadFactory());
    private boolean verboseInParsing = false;
    private Class currentClass;
    private Method currentMainMethod;
    private String[] currentArguments = new String[0];
    private String currentDirectory = null;
    private String currentJavaPath = null;
    private String currentJVMOption = null;
    private int currentRelativePriority = 0;
    private long currentTimeOffset = 0L;

    protected EmulatorContext(PrintStream out, int initialHostID, ControlPipeTable pipeTable, EmulatorMode mode) {
        this.out = out;
        this.nextID = initialHostID;
        this.controlPipeTable = pipeTable;
        this.emulatorMode = mode;
        this.timer = new Timer("A Timer in Emulator", false);
        this.controlStartTime = 0L;
    }

    public PrintStream getPrintStream() {
        return this.out;
    }

    public void establishControlPipes() {
        RemoteControlPipeTable workerTable;
        if (this.emulatorMode == EmulatorMode.MASTER && !(workerTable = (RemoteControlPipeTable)this.controlPipeTable).isPipeEstablished()) {
            workerTable.establishControlPipes(this.getRemoteDirectory(), this.getRemoteJavaPath(), this.getRemoteJVMOption(), System.out);
            try {
                Thread.sleep(10000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    public void waitForEmulationToFinish() {
        long sleepTimeLimit;
        long sleepPeriod;
        if (this.lastScheduledTime <= 0L) {
            return;
        }
        while ((sleepPeriod = (sleepTimeLimit = this.lastScheduledTime + this.timer.getDeferredTime()) - System.currentTimeMillis() + 5000L) > 0L) {
            try {
                Thread.sleep(sleepPeriod);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public EmulatorMode getEmulatorMode() {
        return this.emulatorMode;
    }

    public synchronized int getNextHostID() {
        return this.nextID++;
    }

    public int getMaxHostID() {
        return this.nextID - 1;
    }

    public void haltSchedulingTimer() {
        this.timer.stop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void scheduleTask(long time, long interval, int times, EmulatorTask task, boolean timeIsDifferential, boolean isDaemon) {
        EmulatorContext emulatorContext = this;
        synchronized (emulatorContext) {
            if (this.controlStartTime <= 0L) {
                this.controlStartTime = System.currentTimeMillis() + 2000L;
            }
        }
        long absoluteTime = timeIsDifferential ? this.lastScheduledTime + time : this.controlStartTime + this.currentTimeOffset + time;
        if (times <= 0 && interval >= 0L) {
            this.timer.scheduleAtFixedRate(task, absoluteTime, interval, isDaemon, task.executedConcurrently());
        } else if (times > 0) {
            absoluteTime -= interval;
            int i = 0;
            while (i < times) {
                this.timer.schedule(task, absoluteTime += interval, isDaemon, task.executedConcurrently());
                task = task.cloneTask();
                ++i;
            }
        }
        if (absoluteTime > this.lastScheduledTime) {
            this.lastScheduledTime = absoluteTime;
        }
    }

    public Writer getControlPipe(int hostID) {
        return this.controlPipeTable.get(hostID);
    }

    public void setControlPipe(int hostID, Writer out) {
        this.controlPipeTable.set(hostID, out);
    }

    public Collection<Writer> getAllControlPipes() {
        return this.controlPipeTable.getAllControlPipes();
    }

    public static ExecutorService getThreadPool() {
        return threadPool;
    }

    public boolean getVerboseInParsing() {
        return this.verboseInParsing;
    }

    public boolean setVerboseInParsing(boolean v) {
        boolean old = this.verboseInParsing;
        this.verboseInParsing = v;
        return old;
    }

    public Class getCurrentClass() {
        return this.currentClass;
    }

    public Class setCurrentClass(Class clazz) {
        Class old = this.currentClass;
        this.currentClass = clazz;
        return old;
    }

    public Method getCurrentMainMethod() {
        return this.currentMainMethod;
    }

    public Method setCurrentMainMethod(Method method) {
        Method old = this.currentMainMethod;
        this.currentMainMethod = method;
        return old;
    }

    public String[] getCurrentArguments() {
        return this.currentArguments;
    }

    public String[] setCurrentArguments(String[] args) {
        String[] old = this.currentArguments;
        this.currentArguments = args;
        return old;
    }

    public String getRemoteDirectory() {
        return this.currentDirectory;
    }

    public String setRemoteDirectory(String dir) {
        String old = this.currentDirectory;
        this.currentDirectory = dir;
        return old;
    }

    public String getRemoteJavaPath() {
        return this.currentJavaPath;
    }

    public String setRemoteJavaPath(String path) {
        String old = this.currentJavaPath;
        this.currentJavaPath = path;
        return old;
    }

    public String getRemoteJVMOption() {
        return this.currentJVMOption;
    }

    public String setRemoteJVMOption(String classpath) {
        String old = this.currentJVMOption;
        this.currentJVMOption = classpath;
        return old;
    }

    public int getCurrentRelativePriority() {
        return this.currentRelativePriority;
    }

    public int setCurrentRelativePriority(int prio) {
        int old = this.currentRelativePriority;
        this.currentRelativePriority = prio;
        return old;
    }

    public long getCurrentTimeOffset() {
        return this.currentTimeOffset;
    }

    public long setCurrentTimeOffset(long offset) {
        long old = this.currentTimeOffset;
        this.currentTimeOffset = offset;
        return old;
    }

    public long advanceCurrentTimeOffset(long offset) {
        long old = this.currentTimeOffset;
        this.currentTimeOffset = this.lastScheduledTime - this.controlStartTime + offset;
        return old;
    }

    private static final class EmulatorThreadFactory
    implements ThreadFactory {
        private EmulatorThreadFactory() {
        }

        @Override
        public Thread newThread(Runnable r) {
            Thread t = new Thread(threadGroup, r);
            t.setName("An Emulator thread");
            t.setDaemon(false);
            return t;
        }
    }

    private static final class EmulatorThreadGroup
    extends ThreadGroup {
        public EmulatorThreadGroup(String name) {
            super(name);
        }

        @Override
        public void uncaughtException(Thread t, Throwable e) {
            if (!(e instanceof ThreadDeath)) {
                System.err.print("Exception in thread " + t.getName() + ": ");
                e.printStackTrace(System.err);
            }
            if (e instanceof VirtualMachineError) {
                System.err.println("A VirtualMachineError thrown and exit.");
                System.exit(1);
            }
        }
    }
}

