/*
 * Decompiled with CFR 0.152.
 */
package ow.tool.emulator;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import ow.messaging.util.MessagingUtility;
import ow.tool.emulator.ControlPipeTable;
import ow.tool.emulator.Main;
import ow.tool.emulator.OutputRedirector;

public class RemoteControlPipeTable
implements ControlPipeTable {
    private SortedSet<WorkerEntry> entrySet = new TreeSet<WorkerEntry>();
    private Map<InetAddress, WorkerEntry> entryMap = new HashMap<InetAddress, WorkerEntry>();
    private Map<InetAddress, Writer> pipeMap = new HashMap<InetAddress, Writer>();
    private boolean pipeEstablished = false;
    private OutputRedirector outputRedirector;
    private WorkerEntry searchKey = new WorkerEntry(null, 0);

    private RemoteControlPipeTable() {
        this.outputRedirector = new OutputRedirector(System.out);
    }

    public static RemoteControlPipeTable readHostFile(String filename) throws IOException {
        String line;
        RemoteControlPipeTable table = new RemoteControlPipeTable();
        BufferedReader in = null;
        try {
            in = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(filename), "US-ASCII"));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        while ((line = in.readLine()) != null) {
            if (line.length() <= 0 || line.startsWith("#") || line.startsWith(";") || line.startsWith("//")) continue;
            String[] splitted = line.split("\\s+");
            MessagingUtility.HostAndPort hostPort = MessagingUtility.parseHostnameAndPort(splitted[0], 3997);
            int startHostID = Integer.parseInt(splitted[1]);
            WorkerEntry entry = new WorkerEntry(hostPort, startHostID);
            table.entrySet.add(entry);
            table.entryMap.put(hostPort.getHostAddress(), entry);
        }
        return table;
    }

    public static RemoteControlPipeTable parseString(String str) throws UnknownHostException {
        RemoteControlPipeTable table = new RemoteControlPipeTable();
        String[] splitted = str.split("\\s*,\\s*");
        try {
            int index = 0;
            while (true) {
                MessagingUtility.HostAndPort hostPort = MessagingUtility.parseHostnameAndPort(splitted[index], 3997);
                int startHostID = Integer.parseInt(splitted[index + 1]);
                WorkerEntry entry = new WorkerEntry(hostPort, startHostID);
                table.entrySet.add(entry);
                table.entryMap.put(hostPort.getHostAddress(), entry);
                index += 2;
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            return table;
        }
    }

    public String getStringRepresentation() {
        StringBuilder sb = new StringBuilder();
        boolean firstEntry = true;
        for (WorkerEntry w : this.entrySet) {
            if (firstEntry) {
                firstEntry = false;
            } else {
                sb.append(",");
            }
            sb.append(w.getHostAndPort());
            sb.append(",");
            sb.append(w.getStartHostID());
        }
        return sb.toString();
    }

    public synchronized MessagingUtility.HostAndPort getWorkerHostAndPort(int hostID) {
        this.searchKey.startHostID = hostID + 1;
        SortedSet<WorkerEntry> headSet = this.entrySet.headSet(this.searchKey);
        if (headSet == null) {
            return null;
        }
        MessagingUtility.HostAndPort addr = null;
        try {
            WorkerEntry target = headSet.last();
            addr = target.getHostAndPort();
        }
        catch (NoSuchElementException e) {
            addr = null;
        }
        return addr;
    }

    protected InetAddress getWorkerHostAddress(int hostID) {
        InetAddress ret = null;
        MessagingUtility.HostAndPort hostPort = this.getWorkerHostAndPort(hostID);
        if (hostPort != null) {
            try {
                ret = hostPort.getHostAddress();
            }
            catch (UnknownHostException e) {
                System.err.println("Could not resolve a hostname: " + hostPort.getHostName());
            }
        } else {
            ret = null;
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Writer get(int hostID) {
        InetAddress hostAddress = this.getWorkerHostAddress(hostID);
        Writer pipe = null;
        if (hostAddress != null) {
            Map<InetAddress, Writer> map = this.pipeMap;
            synchronized (map) {
                pipe = this.pipeMap.get(hostAddress);
            }
        }
        return pipe;
    }

    @Override
    public void set(int hostID, Writer out) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<Writer> getAllControlPipes() {
        Map<InetAddress, Writer> map = this.pipeMap;
        synchronized (map) {
            return this.pipeMap.values();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getStartHostID(InetAddress hostAddress) throws NoSuchElementException {
        WorkerEntry entry = null;
        Map<InetAddress, WorkerEntry> map = this.entryMap;
        synchronized (map) {
            entry = this.entryMap.get(hostAddress);
        }
        if (entry == null) {
            throw new NoSuchElementException("There is no entry: " + hostAddress.getHostName());
        }
        return entry.getStartHostID();
    }

    public boolean isPipeEstablished() {
        return this.pipeEstablished;
    }

    public Set<Thread> establishControlPipes(String dir, String javaPath, String jvmOption, PrintStream out) {
        if (this.pipeEstablished) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        if (dir != null) {
            sb.append("cd ");
            sb.append(dir);
            sb.append(" && ");
        }
        sb.append("exec ");
        if (javaPath != null) {
            sb.append(javaPath);
            if (!javaPath.endsWith(File.separator)) {
                sb.append(File.separator);
            }
        }
        sb.append("java");
        if (jvmOption != null) {
            sb.append(" ");
            sb.append(jvmOption);
        }
        sb.append(" ");
        sb.append(Main.class.getName());
        sb.append(" -w ");
        sb.append(this.getStringRepresentation());
        String remoteCommand = sb.toString();
        HashSet<Thread> threadSet = new HashSet<Thread>();
        for (WorkerEntry w : this.entrySet) {
            InetAddress hostAddress = null;
            try {
                hostAddress = w.getHostAndPort().getHostAddress();
            }
            catch (UnknownHostException e) {
                System.err.println("Could not resolve a hostname: " + w.getHostAndPort().getHostName());
                System.exit(1);
            }
            if (this.pipeMap.get(hostAddress) != null) continue;
            out.println("execute: ssh " + hostAddress.getHostName() + " " + remoteCommand);
            ProcessBuilder pb = new ProcessBuilder("ssh", hostAddress.getHostName(), remoteCommand);
            pb.redirectErrorStream(true);
            Process proc = null;
            try {
                proc = pb.start();
            }
            catch (IOException e) {
                System.err.println("Failed to start a remote shell:");
                e.printStackTrace(System.err);
                System.exit(1);
            }
            Thread t = this.outputRedirector.redirect(proc.getInputStream(), "Redirector for " + hostAddress.getHostAddress());
            threadSet.add(t);
            BufferedWriter controlPipe = null;
            try {
                controlPipe = new BufferedWriter(new OutputStreamWriter(proc.getOutputStream(), "US-ASCII"));
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
            this.pipeMap.put(hostAddress, controlPipe);
        }
        this.pipeEstablished = true;
        return threadSet;
    }

    private static class WorkerEntry
    implements Comparable<WorkerEntry> {
        private final MessagingUtility.HostAndPort hostPort;
        private int startHostID;

        WorkerEntry(MessagingUtility.HostAndPort hostPort, int startHostID) {
            this.hostPort = hostPort;
            this.startHostID = startHostID;
        }

        public MessagingUtility.HostAndPort getHostAndPort() {
            return this.hostPort;
        }

        public int getStartHostID() {
            return this.startHostID;
        }

        @Override
        public int compareTo(WorkerEntry o) {
            return Integer.signum(this.startHostID - o.startHostID);
        }

        public int hashCode() {
            return this.hostPort.hashCode() ^ this.startHostID;
        }

        public boolean equals(Object o) {
            if (o instanceof WorkerEntry) {
                WorkerEntry w = (WorkerEntry)o;
                if (this.startHostID == w.startHostID && this.hostPort.equals(w.hostPort)) {
                    return true;
                }
            }
            return false;
        }
    }
}

