/*
 * Decompiled with CFR 0.152.
 */
package ow.tool.emulator.commands;

import java.io.PrintStream;
import ow.tool.emulator.EmulatorContext;
import ow.tool.emulator.EmulatorMode;
import ow.tool.util.shellframework.Command;
import ow.tool.util.shellframework.ShellContext;

public final class ArgumentsCommand
implements Command<EmulatorContext> {
    private static final String[] NAMES = new String[]{"arguments"};

    @Override
    public String[] getNames() {
        return NAMES;
    }

    @Override
    public String getHelp() {
        return "arguments [<argument> ...]";
    }

    @Override
    public boolean execute(ShellContext<EmulatorContext> context) {
        EmulatorContext cxt = context.getOpaqueData();
        PrintStream out = context.getOutputStream();
        String[] args = context.getArguments();
        cxt.setCurrentArguments(args);
        if (cxt.getEmulatorMode() != EmulatorMode.WORKER && cxt.getVerboseInParsing()) {
            out.print("arguments:");
            String[] stringArray = args;
            int n = args.length;
            int n2 = 0;
            while (n2 < n) {
                String arg = stringArray[n2];
                out.print(" ");
                out.print(arg);
                ++n2;
            }
            out.println();
            out.flush();
        }
        return false;
    }
}

