/*
 * Decompiled with CFR 0.152.
 */
package ow.tool.emulator.commands;

import java.io.PrintStream;
import ow.tool.emulator.EmulatorContext;
import ow.tool.util.shellframework.Command;
import ow.tool.util.shellframework.ShellContext;

public final class TimeoffsetCommand
implements Command<EmulatorContext> {
    private static final String[] NAMES = new String[]{"timeoffset"};

    @Override
    public String[] getNames() {
        return NAMES;
    }

    @Override
    public String getHelp() {
        return "timeoffset [+]<offset>";
    }

    @Override
    public boolean execute(ShellContext<EmulatorContext> context) {
        EmulatorContext cxt = context.getOpaqueData();
        PrintStream out = context.getOutputStream();
        String[] args = context.getArguments();
        if (args.length < 1) {
            out.println("\"wait\" command needs an argument.");
            return !context.isInteractive();
        }
        boolean timeIsDifferential = false;
        String timeStr = args[0];
        if (timeStr.startsWith("+")) {
            timeIsDifferential = true;
            timeStr = timeStr.substring(1);
        }
        long time = Long.parseLong(timeStr);
        if (timeIsDifferential) {
            cxt.advanceCurrentTimeOffset(time);
        } else {
            cxt.setCurrentTimeOffset(time);
        }
        return false;
    }
}

