/*
 * Decompiled with CFR 0.152.
 */
package ow.tool.mcastshell.commands;

import java.io.PrintStream;
import ow.id.ID;
import ow.id.IDUtility;
import ow.mcast.Mcast;
import ow.tool.util.shellframework.Command;
import ow.tool.util.shellframework.ShellContext;

public final class LeaveCommand
implements Command<Mcast> {
    private static final String[] NAMES = new String[]{"leave"};

    @Override
    public String[] getNames() {
        return NAMES;
    }

    @Override
    public String getHelp() {
        return "leave <group name>";
    }

    @Override
    public boolean execute(ShellContext<Mcast> context) {
        Mcast mcast = context.getOpaqueData();
        PrintStream out = context.getOutputStream();
        String[] args = context.getArguments();
        if (args.length < 1) {
            out.print("usage: " + this.getHelp() + "\r\n");
            out.flush();
            return false;
        }
        ID groupID = IDUtility.parseID(args[0], mcast.getRoutingAlgorithmConfiguration().getIDSizeInByte());
        boolean joined = mcast.leaveGroup(groupID);
        if (joined) {
            out.print("left " + groupID + "\r\n");
        } else {
            out.print("not joined " + groupID + "\r\n");
        }
        out.flush();
        return false;
    }
}

