/*
 * Decompiled with CFR 0.152.
 */
package ow.tool.mcastshell.commands;

import java.io.PrintStream;
import ow.id.ID;
import ow.id.IDAddressPair;
import ow.mcast.Mcast;
import ow.tool.util.shellframework.Command;
import ow.tool.util.shellframework.ShellContext;

public final class NeighborsCommand
implements Command<Mcast> {
    private static final String[] NAMES = new String[]{"neighbors"};

    @Override
    public String[] getNames() {
        return NAMES;
    }

    @Override
    public String getHelp() {
        return "neighbors";
    }

    @Override
    public boolean execute(ShellContext<Mcast> context) {
        Mcast mcast = context.getOpaqueData();
        PrintStream out = context.getOutputStream();
        StringBuilder sb = new StringBuilder();
        ID[] groups = mcast.getGroupsWithSpanningTree();
        if (groups != null) {
            ID[] iDArray = groups;
            int n = groups.length;
            int n2 = 0;
            while (n2 < n) {
                ID groupID = iDArray[n2];
                IDAddressPair parent = mcast.getParent(groupID);
                IDAddressPair[] children = mcast.getChildren(groupID);
                sb.append("group ID: ");
                sb.append(groupID);
                sb.append("\r\n parent:");
                if (parent != null) {
                    sb.append(" ");
                    sb.append(parent.getAddress());
                }
                sb.append("\r\n children:");
                if (children != null) {
                    IDAddressPair[] iDAddressPairArray = children;
                    int n3 = children.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        IDAddressPair child = iDAddressPairArray[n4];
                        sb.append("\r\n  ");
                        sb.append(child.getAddress());
                        ++n4;
                    }
                }
                sb.append("\r\n");
                ++n2;
            }
        }
        out.print(sb);
        out.flush();
        return false;
    }
}

