/*
 * Decompiled with CFR 0.152.
 */
package ow.tool.memcached.commands;

import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.util.Set;
import ow.dht.ValueInfo;
import ow.dht.memcached.Item;
import ow.dht.memcached.Memcached;
import ow.id.ID;
import ow.id.IDUtility;
import ow.tool.util.shellframework.Command;
import ow.tool.util.shellframework.ShellContext;

abstract class AbstractIncrDecrCommand
implements Command<Memcached> {
    AbstractIncrDecrCommand() {
    }

    protected boolean incrOrDecr(ShellContext<Memcached> context, boolean increment) {
        BigInteger valueBigInteger;
        Memcached dht = context.getOpaqueData();
        PrintStream out = context.getOutputStream();
        String[] args = context.getArguments();
        if (args.length < 2 || args.length > 3) {
            out.print("ERROR\r\n");
            out.flush();
            return false;
        }
        ID key = IDUtility.parseID(args[0], dht.getRoutingAlgorithmConfiguration().getIDSizeInByte());
        String value = args[1];
        boolean noreply = false;
        if (args.length >= 3 && args[2].toLowerCase().equals("noreply")) {
            noreply = true;
        }
        if ((valueBigInteger = new BigInteger(args[1])).compareTo(BigInteger.ZERO) < 0) {
            valueBigInteger = valueBigInteger.negate();
            value = valueBigInteger.toString();
            boolean bl = increment = !increment;
        }
        if (valueBigInteger.compareTo(Memcached.UINT64_MAX) > 0) {
            out.print("CLIENT_ERROR bad command line format\r\n");
            out.flush();
            return false;
        }
        int exptime = dht.getConfiguration().getDefaultTTL();
        dht.setTTLForPut(exptime);
        byte[] b = null;
        try {
            b = value.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        Item item = new Item(b, 0L);
        Memcached.Condition cond = increment ? Memcached.Condition.INCREMENT : Memcached.Condition.DECREMENT;
        Set<ValueInfo<Item>> existedValue = null;
        try {
            existedValue = dht.put(key, item, cond);
        }
        catch (Exception e) {
            out.print("SERVER_ERROR put failed\r\n");
            out.flush();
            return false;
        }
        if (!noreply) {
            StringBuilder sb = new StringBuilder();
            if (existedValue != null) {
                for (ValueInfo<Item> v : existedValue) {
                    String str = null;
                    try {
                        str = new String(v.getValue().getData(), "UTF-8");
                    }
                    catch (UnsupportedEncodingException unsupportedEncodingException) {
                        // empty catch block
                    }
                    sb.append(str).append("\r\n");
                }
            } else {
                sb.append("NOT_FOUND").append("\r\n");
            }
            out.print(sb);
            out.flush();
        }
        return false;
    }
}

