/*
 * Decompiled with CFR 0.152.
 */
package ow.tool.memcached.commands;

import java.io.PrintStream;
import java.util.Set;
import ow.dht.ValueInfo;
import ow.dht.memcached.Item;
import ow.dht.memcached.Memcached;
import ow.id.ID;
import ow.id.IDUtility;
import ow.routing.RoutingException;
import ow.tool.util.shellframework.Command;
import ow.tool.util.shellframework.ShellContext;

public final class DeleteCommand
implements Command<Memcached> {
    private static final String[] NAMES = new String[]{"delete"};

    @Override
    public String[] getNames() {
        return NAMES;
    }

    @Override
    public String getHelp() {
        return "delete <key> [<time>] [noreply]";
    }

    @Override
    public boolean execute(ShellContext<Memcached> context) {
        Memcached dht = context.getOpaqueData();
        PrintStream out = context.getOutputStream();
        String[] args = context.getArguments();
        if (args.length < 1 || args.length > 3) {
            out.print("ERROR\r\n");
            out.flush();
            return false;
        }
        ID key = IDUtility.parseID(args[0], dht.getRoutingAlgorithmConfiguration().getIDSizeInByte());
        boolean noreply = false;
        if (args.length >= 3 && args[2].toLowerCase().equals("noreply")) {
            noreply = true;
        }
        Set<ValueInfo<Item>> existedValues = null;
        try {
            existedValues = dht.remove(key);
        }
        catch (RoutingException e) {
            out.print("SERVER_ERROR put failed\r\n");
            out.flush();
            return false;
        }
        if (!noreply) {
            if (existedValues != null) {
                out.print("DELETED\r\n");
            } else {
                out.print("NOT_FOUND\r\n");
            }
            out.flush();
        }
        return false;
    }
}

