/*
 * Decompiled with CFR 0.152.
 */
package ow.tool.mrouted;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.Inet4Address;
import java.util.logging.Level;
import java.util.logging.Logger;
import ow.id.ID;
import ow.ipmulticast.IPMulticastHandler;
import ow.ipmulticast.VirtualInterface;
import ow.tool.mrouted.ForwarderAddress;
import ow.tool.mrouted.GroupTable;
import ow.tool.mrouted.OverlayTrafficForwarder;
import ow.tool.mrouted.ProtocolOnOverlay;

final class MulticastTrafficForwarder
implements IPMulticastHandler {
    private static Logger logger = Logger.getLogger("mrouted");
    private DatagramSocket sockForOverlay;
    private int datagramBufSize;
    private int ttlOnOverlay;
    private GroupTable groupTable;
    private int idSizeInByte;
    private byte[] encoded;
    private DatagramPacket packet;

    MulticastTrafficForwarder(DatagramSocket sock, int datagramBufSize, int ttlOnOverlay, GroupTable groupTable, int idSizeInByte) {
        this.sockForOverlay = sock;
        this.datagramBufSize = datagramBufSize;
        this.ttlOnOverlay = ttlOnOverlay;
        this.groupTable = groupTable;
        this.idSizeInByte = idSizeInByte;
        int encodedLen = ProtocolOnOverlay.getHeaderLen() + this.datagramBufSize;
        this.encoded = new byte[encodedLen];
        this.packet = new DatagramPacket(this.encoded, this.encoded.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void process(Inet4Address srcAddr, int srcPort, Inet4Address destAddr, int destPort, int id, int ttl, byte[] payload) {
        if (--ttl <= 0) {
            return;
        }
        VirtualInterface vif = VirtualInterface.findVirtualInterface(srcAddr);
        if (vif == null) {
            return;
        }
        ID groupID = ID.getHashcodeBasedID(destAddr, this.idSizeInByte);
        OverlayTrafficForwarder forwarder = this.groupTable.getOverlayTrafficForwarder(groupID);
        if (srcAddr.equals(vif.getLocalAddress())) {
            forwarder.setLoopbackMessageReceivedTime(System.currentTimeMillis());
        }
        if (forwarder != null) {
            int encodedLen = ProtocolOnOverlay.encode(this.encoded, srcAddr, srcPort, destAddr, destPort, id, ttl, this.ttlOnOverlay, payload);
            OverlayTrafficForwarder overlayTrafficForwarder = forwarder;
            synchronized (overlayTrafficForwarder) {
                ForwarderAddress parent = forwarder.getParent();
                ForwarderAddress[] children = forwarder.getChildren();
                this.packet.setData(this.encoded, 0, encodedLen);
                if (parent != null) {
                    this.packet.setAddress(parent.getAddress());
                    this.packet.setPort(parent.getPort());
                    try {
                        this.sockForOverlay.send(this.packet);
                    }
                    catch (IOException e) {
                        logger.log(Level.WARNING, "Failed to forward to " + parent.getAddress() + ":" + parent.getPort() + ".", e);
                    }
                }
                if (children != null) {
                    ForwarderAddress[] forwarderAddressArray = children;
                    int n = children.length;
                    int n2 = 0;
                    while (n2 < n) {
                        ForwarderAddress addr = forwarderAddressArray[n2];
                        this.packet.setAddress(addr.getAddress());
                        this.packet.setPort(addr.getPort());
                        try {
                            this.sockForOverlay.send(this.packet);
                        }
                        catch (IOException e) {
                            logger.log(Level.WARNING, "Failed to forward to " + addr.getAddress() + ":" + addr.getPort() + ".", e);
                        }
                        ++n2;
                    }
                }
            }
        }
    }
}

