/*
 * Decompiled with CFR 0.152.
 */
package ow.tool.mrouted;

import java.net.UnknownHostException;
import java.util.logging.Level;
import java.util.logging.Logger;
import ow.id.ID;
import ow.id.IDAddressPair;
import ow.mcast.SpanningTreeChangedCallback;
import ow.messaging.MessagingAddress;
import ow.tool.mrouted.ApplicationLevelMulticastRouterConfiguration;
import ow.tool.mrouted.ForwarderAddress;
import ow.tool.mrouted.GroupTable;
import ow.tool.mrouted.OverlayTrafficForwarder;

final class OverlayGroupObserver
implements SpanningTreeChangedCallback {
    private static Logger logger = Logger.getLogger("mrouted");
    private final ApplicationLevelMulticastRouterConfiguration config;
    private final GroupTable groupTable;

    OverlayGroupObserver(ApplicationLevelMulticastRouterConfiguration config, GroupTable groupTable) {
        this.config = config;
        this.groupTable = groupTable;
    }

    @Override
    public void topologyChanged(ID groupID, IDAddressPair parent, IDAddressPair[] children) {
        if (parent == null && (children == null || children.length <= 0)) {
            OverlayTrafficForwarder forwarder = this.groupTable.unregisterOverlayTrafficForwarder(groupID);
        } else {
            MessagingAddress msgAddr;
            ForwarderAddress parentAddr = null;
            ForwarderAddress[] childrenAddr = null;
            if (parent != null) {
                msgAddr = parent.getAddress();
                try {
                    parentAddr = new ForwarderAddress(msgAddr.getHostAddress(), msgAddr.getPort() + this.config.getPortDiffFromMcast());
                }
                catch (UnknownHostException e) {
                    logger.log(Level.WARNING, "Could not resolve: " + msgAddr.getHostAddress(), e);
                }
            }
            if (children != null) {
                childrenAddr = new ForwarderAddress[children.length];
                int i = 0;
                while (i < children.length) {
                    msgAddr = children[i].getAddress();
                    try {
                        childrenAddr[i] = new ForwarderAddress(msgAddr.getHostAddress(), msgAddr.getPort() + this.config.getPortDiffFromMcast());
                    }
                    catch (UnknownHostException e) {
                        logger.log(Level.WARNING, "Could not resolve: " + msgAddr.getHostAddress(), e);
                    }
                    ++i;
                }
            }
            OverlayTrafficForwarder forwarder = this.groupTable.registerOverlayTrafficForwarder(groupID);
            forwarder.setParent(parentAddr);
            forwarder.setChildren(childrenAddr);
        }
    }
}

