/*
 * Decompiled with CFR 0.152.
 */
package ow.tool.scenariogen.commands;

import java.io.BufferedWriter;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.LinkedHashSet;
import java.util.Random;
import java.util.Set;
import ow.routing.RoutingAlgorithm;
import ow.tool.scenariogen.ScenarioGeneratorContext;
import ow.tool.scenariogen.commands.Entry;
import ow.tool.scenariogen.commands.IDClusteringAlgorithm;
import ow.tool.util.shellframework.Command;
import ow.tool.util.shellframework.ShellContext;

public final class MputgetCommand
implements Command<ScenarioGeneratorContext> {
    private static final String[] NAMES = new String[]{"mputget"};

    @Override
    public String[] getNames() {
        return NAMES;
    }

    @Override
    public String getHelp() {
        return "mputget <start time (ms)> <interval per a req (ms)> <# of put/gets in a req> <# of req> {raw,{{clustered,node} <algorithm name> <size of id (byte)>}}";
    }

    @Override
    public boolean execute(ShellContext<ScenarioGeneratorContext> context) {
        ScenarioGeneratorContext cxt = context.getOpaqueData();
        PrintStream out = context.getOutputStream();
        String[] args = context.getArguments();
        if (args.length < 5) {
            out.println("Usage: " + this.getHelp());
            return false;
        }
        Style style = args[4].startsWith("c") ? Style.CLUSTERED : (args[4].startsWith("n") ? Style.NODE : Style.RAW);
        if (style != Style.RAW && args.length < 7) {
            out.println("Usage: " + this.getHelp());
            return false;
        }
        long startTime = (long)Double.parseDouble(args[0]);
        long interval = (long)Double.parseDouble(args[1]);
        int clusterSize = Integer.parseInt(args[2]);
        int repeat = Integer.parseInt(args[3]);
        int numNodes = cxt.getNumberOfNodes();
        String algoName = null;
        int idSizeInByte = 0;
        if (style != Style.RAW) {
            algoName = args[5];
            idSizeInByte = Integer.parseInt(args[6]);
        }
        LinkedHashSet<Entry> kvPairSet = new LinkedHashSet<Entry>();
        LinkedHashSet<Set<Entry>> requestSet = new LinkedHashSet<Set<Entry>>();
        int nPairs = clusterSize * repeat;
        int i = 0;
        while (i < nPairs) {
            kvPairSet.add(new Entry("k" + i, "v" + i, idSizeInByte));
            ++i;
        }
        long clusteringTime = System.currentTimeMillis();
        if (style != Style.RAW) {
            RoutingAlgorithm algo = IDClusteringAlgorithm.getRoutingAlgorithm(out, algoName, idSizeInByte);
            if (algo == null) {
                return false;
            }
            if (style == Style.CLUSTERED) {
                IDClusteringAlgorithm.cluster(out, requestSet, kvPairSet, clusterSize, algo);
            } else {
                IDClusteringAlgorithm.alignWithNodes(out, requestSet, kvPairSet, clusterSize, algo, numNodes);
            }
        } else {
            IDClusteringAlgorithm.copy(out, requestSet, kvPairSet, clusterSize);
        }
        clusteringTime = System.currentTimeMillis() - clusteringTime;
        PrintWriter writer = cxt.getWriter();
        writer.println("# clustering time: " + (double)clusteringTime * 0.001 + " sec");
        long emulationTime = this.writePutsOrGets(true, writer, requestSet, numNodes, startTime, interval);
        String fname = null;
        try {
            fname = "scenario.1";
            writer = new PrintWriter(new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(fname), "UTF-8")));
        }
        catch (Exception e) {
            out.println("Could not open file: " + fname);
            return false;
        }
        writer.println("# clustering time: " + (double)clusteringTime * 0.001 + " sec");
        emulationTime = this.writePutsOrGets(false, writer, requestSet, numNodes, startTime, interval);
        out.println("finish at " + (double)emulationTime / 1000.0);
        return false;
    }

    private long writePutsOrGets(boolean writePuts, PrintWriter writer, Set<Set<Entry>> requestSet, int numNodes, long startTime, long interval) {
        Random rnd = new Random();
        long time = startTime;
        for (Set<Entry> s : requestSet) {
            StringBuilder sb = new StringBuilder();
            sb.append("schedule ");
            sb.append(time);
            sb.append(" control ");
            sb.append(rnd.nextInt(numNodes) + 1);
            if (writePuts) {
                sb.append(" put");
            } else {
                sb.append(" get");
            }
            boolean firstElem = true;
            for (Entry e : s) {
                if (writePuts) {
                    if (firstElem) {
                        firstElem = false;
                    } else {
                        sb.append(" -");
                    }
                }
                sb.append(" ");
                sb.append(e.getKey());
                if (!writePuts) continue;
                sb.append(" ");
                sb.append(e.getValue());
            }
            writer.println(sb.toString());
            time += interval * (long)s.size();
        }
        writer.flush();
        return time;
    }

    private static enum Style {
        RAW,
        CLUSTERED,
        NODE;

    }
}

