/*
 * Decompiled with CFR 0.152.
 */
package ow.tool.scenariogen.commands;

import java.io.BufferedWriter;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Writer;
import ow.tool.scenariogen.ScenarioGeneratorContext;
import ow.tool.util.shellframework.Command;
import ow.tool.util.shellframework.ShellContext;

public class OutCommand
implements Command<ScenarioGeneratorContext> {
    private static final String[] NAMES = new String[]{"out"};

    @Override
    public String[] getNames() {
        return NAMES;
    }

    @Override
    public String getHelp() {
        return "out <file name>";
    }

    @Override
    public boolean execute(ShellContext<ScenarioGeneratorContext> context) {
        ScenarioGeneratorContext cxt = context.getOpaqueData();
        PrintStream out = context.getOutputStream();
        String[] args = context.getArguments();
        if (args.length < 1) {
            out.println("Usage: " + this.getHelp());
            return false;
        }
        PrintWriter old = cxt.getWriter();
        String fileName = args[0];
        try {
            cxt.setWriter(new PrintWriter(new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(fileName), "UTF-8"))));
        }
        catch (IOException e) {
            out.println("Could not open: " + args[0]);
            return false;
        }
        try {
            ((Writer)old).close();
        }
        catch (IOException e) {
            out.println("Failed to close.");
        }
        return false;
    }
}

